/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.search.model.EAFMultipleFileSearchEngine;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.result.viewer.ContentMatch2TabDelimitedText;
import mpi.eudico.client.annotator.search.result.viewer.EAFMultipleFileResultViewer;
import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileUtilities;
import mpi.eudico.client.util.LinkButton;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.result.viewer.ContentMatchCounter;
import mpi.search.model.DefaultSearchController;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.model.SearchListener;
import mpi.search.query.model.Query;
import mpi.search.query.viewer.AbstractSimpleSearchPanel;
import mpi.search.query.viewer.StartStopPanel;
import org.xml.sax.SAXException;

public class EAFMultipleFileSearchPanel
extends AbstractSimpleSearchPanel {
    protected static final String LAST_DIR_KEY = "MultipleFileSearchLastDir";
    protected static final String PREFERENCES_DIRS_KEY = "MultipleFileSearchDirs";
    protected static final String PREFERENCES_PATHS_KEY = "MultipleFileSearchPaths";
    private final Action defineDomainAction;
    private ArrayList searchDirs;
    private ArrayList searchPaths;
    private final Box optionBox = new Box(1);
    private final Box searchCategoryBox = new Box(0);
    private final JCheckBox caseSensitiveCheckBox;
    private final JCheckBox regexCheckBox;
    private final JLabel copyrightLabel = new JLabel("\u00a9 MPI Nijmegen 2004 - 2011");
    private final JLabel googleLabel = new JLabel(SearchLocale.getString((String)"Action.Search"));
    private final JLabel infoLabel = new JLabel();
    private final JPanel centralPanel;
    private final JTextField googleField = new JTextField(18);
    private final LinkButton exportButton;
    private File[] searchFiles;

    public EAFMultipleFileSearchPanel() {
        this(null);
    }

    public EAFMultipleFileSearchPanel(ElanFrame2 elanFrame) {
        this.matchCounter = new ContentMatchCounter();
        this.defineDomainAction = new AbstractAction(SearchLocale.getString((String)"Action.DefineDomain")){

            public void actionPerformed(ActionEvent e) {
                MFDomainDialog mfDialog = null;
                Container w = EAFMultipleFileSearchPanel.this.getTopLevelAncestor();
                if (w instanceof Frame) {
                    mfDialog = new MFDomainDialog((Frame)w, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
                } else if (w instanceof Dialog) {
                    mfDialog = new MFDomainDialog((Dialog)w, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
                } else {
                    return;
                }
                mfDialog.setSearchDirs(EAFMultipleFileSearchPanel.this.searchDirs);
                mfDialog.setSearchPaths(EAFMultipleFileSearchPanel.this.searchPaths);
                mfDialog.setVisible(true);
                EAFMultipleFileSearchPanel.this.searchDirs = (ArrayList)mfDialog.getSearchDirs();
                EAFMultipleFileSearchPanel.this.searchPaths = (ArrayList)mfDialog.getSearchPaths();
                EAFMultipleFileSearchPanel.access$202(EAFMultipleFileSearchPanel.this, EAFMultipleFileUtilities.getUniqueEAFFilesIn(EAFMultipleFileSearchPanel.this.searchDirs, EAFMultipleFileSearchPanel.this.searchPaths));
            }
        };
        this.defineDomainAction.putValue("ShortDescription", SearchLocale.getString((String)"Action.Tooltip.DefineDomain"));
        KeyStroke ks = KeyStroke.getKeyStroke(68, 2);
        this.defineDomainAction.putValue("AcceleratorKey", ks);
        this.regexCheckBox = new JCheckBox(SearchLocale.getString((String)"Search.Constraint.RegularExpression"));
        this.caseSensitiveCheckBox = new JCheckBox(SearchLocale.getString((String)"Search.Constraint.CaseSensitive"));
        this.startStopPanel = new StartStopPanel(this.startAction, this.stopAction);
        this.resultViewer = new EAFMultipleFileResultViewer(elanFrame);
        this.exportButton = new LinkButton(this.exportAction);
        this.matchCounter.setHorizontalAlignment(4);
        this.centralPanel = new JPanel(new BorderLayout());
        this.setComponents();
        this.makeStartPanel();
        this.setVisible(true);
        this.googleField.addActionListener(this.startAction);
        this.searchDirs = Preferences.get(PREFERENCES_DIRS_KEY, null) != null ? (ArrayList)Preferences.get(PREFERENCES_DIRS_KEY, null) : new ArrayList();
        this.searchPaths = Preferences.get(PREFERENCES_PATHS_KEY, null) != null ? (ArrayList)Preferences.get(PREFERENCES_PATHS_KEY, null) : new ArrayList();
        this.searchEngine = new DefaultSearchController((SearchListener)this, (SearchEngine)new EAFMultipleFileSearchEngine((ProgressListener)this.progressViewer));
        this.searchEngine.setProgressListener((ProgressListener)this.progressViewer);
        this.searchFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(this.searchDirs, this.searchPaths);
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 480);
    }

    public File[] getSelectedFiles() {
        return this.searchFiles;
    }

    public List getSelectedNodes() {
        return new ArrayList();
    }

    public void executionStarted() {
        super.executionStarted();
        if (((JComponent)this.resultViewer).getWidth() == 0) {
            this.removeAll();
            this.makeSecondPanel();
            this.validate();
        }
        this.infoLabel.setText("");
    }

    public void executionStopped() {
        super.executionStopped();
        this.infoLabel.setText("in " + this.searchFiles.length + " files (" + (double)this.searchEngine.getSearchDuration() / 1000.0 + " seconds)");
    }

    public void handleException(Exception e) {
        if (e instanceof PatternSyntaxException) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), SearchLocale.getString((String)"Search.Exception.Formulation"), 0);
            this.searchEngine.stopExecution();
        } else if (e instanceof SAXException || e instanceof IOException) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), SearchLocale.getString((String)"Search.Exception.Parse"), 0);
        } else {
            super.handleException(e);
        }
    }

    protected Query getQuery() {
        AnchorConstraint ac = new AnchorConstraint("", this.googleField.getText(), this.regexCheckBox.isSelected(), this.caseSensitiveCheckBox.isSelected());
        return new ContentQuery(ac, (CorpusType)new EAFType(), this.searchFiles);
    }

    protected void export() {
        String lastDir = (String)Preferences.get(LAST_DIR_KEY, null);
        JFileChooser fc = new JFileChooser(lastDir);
        int retValue = fc.showSaveDialog((Component)((Object)this));
        if (retValue == 0) {
            try {
                ContentResult result = (ContentResult)this.searchEngine.getResult();
                ContentMatch2TabDelimitedText.exportMatches(result.getMatches(), fc.getSelectedFile());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), "Error during export", 0);
            }
        }
    }

    private void setComponents() {
        this.setBackground(Color.white);
        this.googleLabel.setFont(new Font("Serif", 0, 36));
        this.googleLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.googleLabel.setForeground(Color.BLUE);
        this.googleField.setFont(this.googleField.getFont().deriveFont(16.0f));
        this.regexCheckBox.setOpaque(false);
        this.regexCheckBox.setFont(this.regexCheckBox.getFont().deriveFont(10.0f));
        this.regexCheckBox.setBackground(this.getBackground());
        this.caseSensitiveCheckBox.setOpaque(false);
        this.caseSensitiveCheckBox.setFont(this.caseSensitiveCheckBox.getFont().deriveFont(10.0f));
        this.caseSensitiveCheckBox.setBackground(this.getBackground());
        this.startStopPanel.setOpaque(false);
        this.exportButton.setFont(this.googleField.getFont().deriveFont(10.0f));
        this.exportButton.setEnabled(false);
        this.progressViewer.setOpaque(false);
        this.progressViewer.setBorder((Border)new CompoundBorder(new EmptyBorder(3, 3, 3, 3), this.progressViewer.getBorder()));
        this.searchCategoryBox.setOpaque(false);
        this.searchCategoryBox.setBorder(new EmptyBorder(3, 0, 3, 0));
        this.copyrightLabel.setFont(this.copyrightLabel.getFont().deriveFont(9.0f));
        this.copyrightLabel.setBorder(new EmptyBorder(10, 10, 10, 10));
    }

    private void makeSecondPanel() {
        this.optionBox.add(this.exportButton);
        JPanel infoPanel = new JPanel(new FlowLayout());
        infoPanel.setOpaque(false);
        infoPanel.add((Component)this.matchCounter);
        infoPanel.add(this.infoLabel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setOpaque(false);
        statusPanel.add((Component)((EAFMultipleFileResultViewer)this.resultViewer).getControlPanel(), "West");
        statusPanel.add((Component)infoPanel, "East");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.anchor = 17;
        this.add(this.googleLabel, c);
        c.anchor = 10;
        this.add(this.centralPanel, c);
        this.add((Component)this.startStopPanel, c);
        this.add(this.optionBox, c);
        c.gridwidth = 0;
        c.anchor = 13;
        c.fill = 0;
        c.weightx = 0.0;
        this.add((Component)this.progressViewer, c);
        c.fill = 2;
        this.add(new JSeparator(0), c);
        c.insets = new Insets(0, 0, 0, 0);
        this.add(statusPanel, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((JComponent)this.resultViewer, c);
        ((EAFMultipleFileResultViewer)this.resultViewer).setColumnVisible("ColumnTriangle", false);
    }

    private void makeStartPanel() {
        this.setLayout(new GridBagLayout());
        LinkButton defineDomainButton = new LinkButton(this.defineDomainAction);
        defineDomainButton.setFont(this.googleField.getFont().deriveFont(10.0f));
        this.optionBox.add(new LinkButton(this.defineDomainAction));
        JPanel flagPanel = new JPanel(new GridLayout(1, 0));
        flagPanel.setOpaque(false);
        flagPanel.add(this.regexCheckBox);
        flagPanel.add(this.caseSensitiveCheckBox);
        this.searchCategoryBox.add(new JLabel("Annotations", 2));
        this.centralPanel.setOpaque(false);
        this.centralPanel.add((Component)this.searchCategoryBox, "North");
        this.centralPanel.add((Component)this.googleField, "Center");
        this.centralPanel.add((Component)flagPanel, "South");
        JComponent counterWeight = new JComponent(){

            public Dimension getPreferredSize() {
                return EAFMultipleFileSearchPanel.this.optionBox.getPreferredSize();
            }
        };
        JPanel panel = new JPanel(new FlowLayout());
        panel.setOpaque(false);
        panel.add(counterWeight);
        panel.add(this.centralPanel);
        panel.add(this.optionBox);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 10;
        this.add(this.googleLabel, c);
        this.add(panel, c);
        this.add((Component)this.startStopPanel, c);
        this.add(this.copyrightLabel, c);
    }

    static /* synthetic */ File[] access$202(EAFMultipleFileSearchPanel x0, File[] x1) {
        x0.searchFiles = x1;
        return x1;
    }
}

