/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import mpi.eudico.client.annotator.search.result.viewer.ElanResult2HTML;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.viewer.Query2HTML;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.result.viewer.ContentResult2HTML;

public class ElanQuery2HTML {
    private static final String bodyStyle = "body { background-color: #E6E6E6; }\n";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mmz");
    static final String css = "<style type=\"text/css\">\nbody { background-color: #E6E6E6; }\nbody { font-weight:normal; margin-top: 5px; }\n.constraint { border-width:1px; border-style:solid; border-color:gray; padding:10px;font-size:medium;}\n.pattern { background:#FFFFFF; white-space:pre; font-weight:bold;}\nul { list-style-type:none;}\n</style>\n";

    public static void exportQuery(ContentQuery query, File exportFile, boolean asTable, String transcriptionFilePath, String encoding) throws IOException {
        if (exportFile == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding));
        StringBuffer sb = new StringBuffer("<html>\n");
        sb.append("<head profile=\"http://dublincore.org/documents/dcq-html/\">\n");
        sb.append("<link rel=\"schema.DC\" href=\"http://purl.org/dc/elements/1.1/\">\n");
        sb.append("<link rel=\"schema.DCTERMS\" href=\"http://purl.org/dc/terms/\">\n");
        sb.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=\"" + encoding + "\">\n");
        sb.append("<meta name=\"DC.date\" content=\"" + dateFormat.format(query.getCreationDate()) + "\" scheme=\"DCTERMS.W3CDTF\">\n");
        sb.append("<meta name=\"DC.description\" content=\"Query performed by ELAN on file " + new File(transcriptionFilePath).getName() + "\">\n");
        sb.append(css);
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<H2>" + SearchLocale.getString((String)"SearchDialog.Query") + ":</H2>\n");
        Query2HTML.appendQuery((StringBuffer)sb, (ContentQuery)query);
        sb.append("<br>\n");
        String resultString = SearchLocale.getString((String)"Search.Result");
        resultString = resultString.substring(0, 1).toUpperCase() + resultString.substring(1);
        sb.append("<H2>" + resultString + ":</H2>\n");
        if (asTable) {
            ContentResult2HTML.appendResultAsTable((StringBuffer)sb, (ContentResult)((ContentResult)query.getResult()));
        } else {
            ElanResult2HTML.appendResultAsTree(sb, (ContentResult)query.getResult());
        }
        sb.append("</body>\n</html>");
        writer.write(sb.toString());
        writer.close();
    }
}

