/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.model.ElanSearchEngine;
import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.eudico.client.annotator.search.query.viewer.ElanQueryPanel;
import mpi.eudico.client.annotator.search.result.viewer.ElanResultViewer;
import mpi.eudico.client.annotator.search.viewer.ExportResultDialog;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.xml.Query2Xml;
import mpi.search.content.query.xml.Xml2Query;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.viewer.AbstractComplexSearchPanel;
import mpi.search.model.DefaultSearchController;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.model.SearchListener;
import mpi.search.query.model.Query;
import mpi.util.DefaultFileFilter;

public class ElanSearchPanel
extends AbstractComplexSearchPanel
implements ElanLocaleListener,
ACMEditListener {
    static final String LAST_DIR_KEY = "SearchLastDir";
    private static final String fileExtension = "eaq";
    private static final FileFilter resFileFilter = new DefaultFileFilter("eaq", "Elan annotation query (*.eaq)");
    protected final Action replaceAction;
    private final JLabel infoLabel = new JLabel();
    private final ViewerManager2 viewerManager;

    public ElanSearchPanel(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.queryPanel = new ElanQueryPanel(new ElanType(viewerManager.getTranscription()), this.startAction);
        this.resultViewer = viewerManager.createSearchResultViewer();
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnFileName", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnLeftContext", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnRightContext", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnTierName", false);
        this.saveAction.putValue("ShortDescription", SearchLocale.getString((String)"Action.Tooltip.Save"));
        this.readAction.putValue("ShortDescription", SearchLocale.getString((String)"Action.Tooltip.Open"));
        this.exportAction.putValue("ShortDescription", SearchLocale.getString((String)"Action.Tooltip.Export"));
        this.replaceAction = new AbstractAction(SearchLocale.getString((String)"Action.Replace")){

            public void actionPerformed(ActionEvent e) {
                ElanSearchPanel.this.replace();
            }
        };
        this.replaceAction.putValue("ShortDescription", SearchLocale.getString((String)"Action.Tooltip.Replace"));
        this.makeLayout();
        this.searchEngine = new DefaultSearchController((SearchListener)this, (SearchEngine)new ElanSearchEngine((SearchListener)this, viewerManager.getTranscription()));
        this.searchEngine.setProgressListener((ProgressListener)this.progressViewer);
        try {
            viewerManager.getTranscription().addACMEditListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ACMEdited(ACMEditEvent e) {
        if (this.queryManager.size() == 0) {
            return;
        }
        if (e.getOperation() == 6 || e.getOperation() == 1 || e.getOperation() == 8 || e.getOperation() == 14) {
            Object o = e.getModification() != null ? e.getModification() : e.getInvalidatedObject();
            String tierName = null;
            if (o instanceof TierImpl) {
                try {
                    tierName = ((TierImpl)o).getName();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            if (o instanceof AbstractAnnotation) {
                try {
                    tierName = ((AbstractAnnotation)o).getTier().getName();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            block4: for (int i = 1; i <= this.queryManager.size(); ++i) {
                ContentResult result = (ContentResult)this.queryManager.getQuery(i).getResult();
                if (tierName != null) {
                    System.out.println("Edited tier: " + tierName);
                    String[] tierNames = result.getTierNames();
                    for (int j = 0; j < tierNames.length; ++j) {
                        if (!tierName.equals(tierNames[j])) continue;
                        result.setStatus(2);
                        continue block4;
                    }
                    continue;
                }
                System.out.println("Edited tier not known");
                result.setStatus(2);
            }
            if (this.queryManager.getCurrentQuery().getResult() != null && this.queryManager.getCurrentQuery().getResult().getStatus() == 2) {
                this.startSearch();
            }
        }
    }

    public void executionStarted() {
        super.executionStarted();
        this.updateResultViewer();
        this.infoLabel.setText(" " + ElanLocale.getString("SearchDialog.FoundNone"));
    }

    public void executionStopped() {
        super.executionStopped();
        this.viewerManager.setControllersForViewer((AbstractViewer)this.resultViewer, ((ContentResult)this.searchEngine.getResult()).getTierNames());
    }

    public void handleException(Exception e) {
        if (e instanceof PatternSyntaxException) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), SearchLocale.getString((String)"Search.Exception.Formulation"), 0, null);
            this.searchEngine.stopExecution();
        } else {
            super.handleException(e);
        }
    }

    public void updateLocale() {
        this.repaint();
    }

    protected Query getQuery() {
        Query query = super.getQuery();
        if (query != null) {
            query.getResult().setPageSize(Integer.MAX_VALUE);
        }
        return query;
    }

    protected void close() {
        if (this.viewerManager != null) {
            this.viewerManager.destroyViewer((AbstractViewer)this.resultViewer);
        }
    }

    protected void export() {
        ExportResultDialog dialog = new ExportResultDialog((Frame)((JFrame)SwingUtilities.getRoot((Component)((Object)this))), true, this.viewerManager.getTranscription(), (ContentQuery)this.queryManager.getCurrentQuery());
        dialog.setVisible(true);
    }

    protected void read() {
        String lastDir = (String)Preferences.get(LAST_DIR_KEY, this.viewerManager.getTranscription());
        JFileChooser fc = new JFileChooser(lastDir);
        fc.setFileFilter(resFileFilter);
        int retValue = fc.showOpenDialog((Component)((Object)this));
        if (retValue == 0) {
            String selectedFile = fc.getSelectedFile().toString();
            if (!selectedFile.endsWith(fileExtension)) {
                selectedFile = selectedFile + ".eaq";
            }
            Preferences.set(LAST_DIR_KEY, fc.getCurrentDirectory().getAbsolutePath(), this.viewerManager.getTranscription());
            ContentQuery query = new ContentQuery(null, (CorpusType)new EAFType());
            try {
                Xml2Query.translate((String)selectedFile, (ContentQuery)query);
                this.addQuery(query);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), SearchLocale.getString((String)"Search.Exception.QueryReadError"), 0);
            }
        }
    }

    protected void save() {
        String lastDir = (String)Preferences.get(LAST_DIR_KEY, this.viewerManager.getTranscription());
        JFileChooser fc = new JFileChooser(lastDir);
        fc.setFileFilter(resFileFilter);
        int retValue = fc.showSaveDialog((Component)((Object)this));
        if (retValue == 0) {
            String selectedFile = fc.getSelectedFile().toString();
            if (!selectedFile.endsWith(fileExtension)) {
                selectedFile = selectedFile + ".eaq";
            }
            Preferences.set(LAST_DIR_KEY, fc.getCurrentDirectory().getAbsolutePath(), this.viewerManager.getTranscription());
            try {
                Query2Xml.translate((String)selectedFile, (ContentQuery)((ContentQuery)this.queryManager.getCurrentQuery()));
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), SearchLocale.getString((String)"Search.Exception.QuerySaveError"), 0);
            }
        }
    }

    protected void updateActions() {
        super.updateActions();
        this.replaceAction.setEnabled(this.exportAction.isEnabled());
    }

    protected void userQuit() {
        this.close();
        super.userQuit();
    }

    private void replace() {
        String replaceString = JOptionPane.showInputDialog((Component)((Object)this), SearchLocale.getString((String)"ReplaceDialog.Message"), SearchLocale.getString((String)"ReplaceDialog.Title"), -1);
        if (replaceString != null) {
            Command command = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "CommandActions.Replace");
            Object[] args = new Object[]{this.queryManager.getCurrentQuery().getResult(), replaceString};
            command.execute(this.viewerManager.getTranscription(), args);
        }
    }

    private void updateResultViewer() {
        if (this.queryManager.hasQuery()) {
            ContentQuery query = (ContentQuery)this.queryManager.getCurrentQuery();
            boolean multipleTiers = query.getAnchorConstraint().getTierNames().length > 1;
            ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnTierName", multipleTiers);
        }
    }
}

