/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.AbstractBasicExportDialog;
import mpi.eudico.client.annotator.search.result.viewer.ContentMatch2TabDelimitedText;
import mpi.eudico.client.annotator.search.viewer.ElanQuery2HTML;
import mpi.eudico.client.annotator.util.ElanFileFilter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.search.content.query.model.ContentQuery;

public class ExportResultDialog
extends AbstractBasicExportDialog
implements ActionListener {
    private final ButtonGroup fileTypeGroup = new ButtonGroup();
    private final ButtonGroup formatTypeGroup = new ButtonGroup();
    private final ContentQuery query;
    private final JLabel dataFormatLabel = new JLabel();
    private final JLabel fileFormatLabel = new JLabel();
    private final JRadioButton asTableButton = new JRadioButton();
    private final JRadioButton asTreeButton = new JRadioButton();
    private final JRadioButton htmlButton = new JRadioButton();
    private final JRadioButton tabButton = new JRadioButton();

    public ExportResultDialog(Frame parent, boolean modal, Transcription transcription, ContentQuery query) {
        super(parent, modal, transcription);
        this.query = query;
        this.makeLayout();
        this.updateLocale();
        this.postInit();
    }

    protected void makeLayout() {
        super.makeLayout();
        this.getContentPane().setLayout(new GridBagLayout());
        this.fileTypeGroup.add(this.tabButton);
        this.fileTypeGroup.add(this.htmlButton);
        this.formatTypeGroup.add(this.asTableButton);
        this.formatTypeGroup.add(this.asTreeButton);
        JPanel fileFormatPanel = new JPanel(new GridLayout(0, 1));
        fileFormatPanel.add(this.tabButton);
        fileFormatPanel.add(this.htmlButton);
        JPanel dataFormatPanel = new JPanel(new GridLayout(0, 1));
        dataFormatPanel.add(this.asTableButton);
        dataFormatPanel.add(this.asTreeButton);
        this.optionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.25;
        c.fill = 1;
        c.anchor = 17;
        c.insets = this.insets;
        this.optionsPanel.add((Component)this.fileFormatLabel, c);
        c.weighty = 0.5;
        this.optionsPanel.add((Component)fileFormatPanel, c);
        c.weighty = 0.0;
        this.optionsPanel.add((Component)new JSeparator(), c);
        c.weighty = 0.25;
        this.optionsPanel.add((Component)this.dataFormatLabel, c);
        c.weighty = 0.5;
        this.optionsPanel.add((Component)dataFormatPanel, c);
        c.anchor = 10;
        c.weighty = 0.0;
        this.getContentPane().add((Component)this.titleLabel, c);
        c.fill = 1;
        c.weighty = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, c);
        c.weighty = 0.0;
        c.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, c);
        this.asTreeButton.setVisible(this.query.getAnchorConstraint().getChildCount() > 0);
        this.asTreeButton.setEnabled(false);
        this.htmlButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ExportResultDialog.this.tabButton.isSelected()) {
                    ExportResultDialog.this.asTableButton.setSelected(true);
                }
                ExportResultDialog.this.asTreeButton.setEnabled(ExportResultDialog.this.htmlButton.isSelected());
            }
        });
        this.tabButton.setSelected(true);
        this.asTableButton.setSelected(true);
    }

    protected boolean startExport() throws IOException {
        File exportFile = null;
        exportFile = this.tabButton.isSelected() ? this.promptForFile(ElanLocale.getString("ExportResultDialog.Title"), FileExtension.TEXT_EXT, ElanFileFilter.createFileFilter(11), true) : this.promptForFile(ElanLocale.getString("ExportResultDialog.Title"), FileExtension.HTML_EXT, ElanFileFilter.createFileFilter(15), true);
        if (exportFile == null) {
            return false;
        }
        if (this.tabButton.isSelected()) {
            ContentMatch2TabDelimitedText.exportMatches(this.query.getResult().getMatches(), exportFile, this.encoding);
        } else {
            ElanQuery2HTML.exportQuery(this.query, exportFile, this.asTableButton.isSelected(), this.transcription.getName(), this.encoding);
        }
        return true;
    }

    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportResultDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportResultDialog.Title"));
        this.asTableButton.setText(ElanLocale.getString("ExportResultDialog.AsTable"));
        this.asTreeButton.setText(ElanLocale.getString("ExportResultDialog.AsTree"));
        this.htmlButton.setText(ElanLocale.getString("ExportDialog.FileDescription.Html"));
        this.tabButton.setText(ElanLocale.getString("ExportResultDialog.TabDelimitedText"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.fileFormatLabel.setText(ElanLocale.getString("ExportResultDialog.FileFormat"));
        this.dataFormatLabel.setText(ElanLocale.getString("ExportResultDialog.ExportMatches"));
    }
}

