/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.smfsearch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.util.FileUtility;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IMDISessionParser {
    public static final String EAF = "text/x-eaf+xml";
    private XMLReader reader;
    private List<String> files = new ArrayList<String>(5);

    public IMDISessionParser() throws SAXException {
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
        this.reader.setContentHandler(new SessionHandler());
    }

    public synchronized List<String> parse(String pathToImdiSession) throws IOException, SAXException {
        if (pathToImdiSession == null) {
            return null;
        }
        this.files.clear();
        this.reader.parse(pathToImdiSession);
        pathToImdiSession = pathToImdiSession.replace('\\', '/');
        ArrayList<String> retList = new ArrayList<String>(this.files.size());
        String path = null;
        for (int i = 0; i < this.files.size(); ++i) {
            path = this.files.get(i);
            if (path.startsWith("../") || path.startsWith("./")) {
                retList.add(FileUtility.getAbsolutePath(pathToImdiSession, path));
                continue;
            }
            retList.add(path);
        }
        return retList;
    }

    class SessionHandler
    implements ContentHandler {
        private final String WRITTEN_RES = "WrittenResource";
        private final String LINK = "ResourceLink";
        private final String TYPE = "Type";
        private final String FORMAT = "Format";
        private String curResLink;
        private String curContent;
        private String curFormat;
        private String curType;
        private boolean inWritten = false;

        SessionHandler() {
        }

        public void endDocument() throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = new String(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.inWritten) {
                if (localName.equals("Type")) {
                    this.curType = this.curContent;
                } else if (localName.equals("Format")) {
                    this.curFormat = this.curContent;
                } else if (localName.equals("ResourceLink")) {
                    this.curResLink = this.curContent;
                } else if (localName.equals("WrittenResource")) {
                    if (this.curFormat != null && this.curFormat.equalsIgnoreCase(IMDISessionParser.EAF)) {
                        if (this.curResLink != null) {
                            IMDISessionParser.this.files.add(this.urlToPath(this.curResLink));
                        }
                    } else if (this.curResLink != null && this.curResLink.toLowerCase().endsWith(".eaf")) {
                        IMDISessionParser.this.files.add(this.curResLink);
                    }
                    this.resetFields();
                    this.inWritten = false;
                }
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("WrittenResource")) {
                this.inWritten = true;
            }
        }

        void resetFields() {
            this.curResLink = null;
            this.curContent = null;
            this.curFormat = null;
            this.curType = null;
        }

        private String urlToPath(String url) {
            if (url == null) {
                return url;
            }
            try {
                int prevSl;
                URL u = new URL(url);
                String prot = u.getProtocol();
                if (prot != null) {
                    if (prot.equals("file")) {
                        int prevSl2;
                        String path = u.getPath();
                        int index = path.indexOf("/../");
                        if (index > 0 && (prevSl2 = path.lastIndexOf(47, index - 1)) > -1) {
                            path = path.substring(0, prevSl2) + path.substring(index + 3);
                        }
                        return path;
                    }
                    return url;
                }
                String path = url;
                int index = path.indexOf("/../");
                if (index > 0 && (prevSl = path.lastIndexOf(47, index - 1)) > -1) {
                    path = path.substring(0, prevSl) + path.substring(index + 3);
                }
                return path;
            }
            catch (MalformedURLException mue) {
                return url;
            }
        }
    }
}

