/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import com.sun.media.renderer.video.BasicVideoRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import mpi.eudico.client.annotator.svg.JMFSVGViewer;

public class JMFGraphicVideoRenderer
extends BasicVideoRenderer {
    public static final String name = "Graphic Video Renderer";
    protected RGBFormat inputFormat;
    protected RGBFormat supportedRGB;
    protected Format[] supportedFormats;
    protected MemoryImageSource sourceImage;
    protected Image inImage;
    protected Buffer lastBuffer = null;
    protected BufferedImage bufferedImage = null;
    protected Graphics2D g2d;
    protected BufferToImage bufToImg;
    protected long currentFrameTime = 0L;
    protected JMFSVGViewer viewer;

    public JMFGraphicVideoRenderer() {
        super(name);
        int rMask = 255;
        int gMask = 65280;
        int bMask = 0xFF0000;
        this.supportedRGB = new RGBFormat(null, -1, int[].class, -1.0f, 32, rMask, gMask, bMask, 1, -1, 0, -1);
        this.supportedFormats = new VideoFormat[1];
        this.supportedFormats[0] = this.supportedRGB;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Format setInputFormat(Format format) {
        if (format != null && format instanceof RGBFormat && format.matches((Format)this.supportedRGB)) {
            this.inputFormat = (RGBFormat)format;
            this.bufToImg = new BufferToImage((VideoFormat)this.inputFormat);
            Dimension size = this.inputFormat.getSize();
            this.inWidth = size.width;
            this.inHeight = size.height;
            this.bufferedImage = new BufferedImage(this.inWidth, this.inHeight, 1);
            return format;
        }
        return null;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
        this.sourceImage = null;
        this.inImage = null;
        this.lastBuffer = null;
    }

    public void reset() {
    }

    public void close() {
    }

    protected int doProcess(Buffer buffer) {
        Graphics g;
        if (this.component == null) {
            return 1;
        }
        Format inf = buffer.getFormat();
        if (inf == null) {
            return 1;
        }
        this.inImage = this.bufToImg.createImage(buffer);
        if (this.inImage != null) {
            this.g2d = this.bufferedImage.createGraphics();
            this.g2d.drawImage(this.inImage, 0, 0, null);
            if (this.viewer != null) {
                this.viewer.paintAnnotations(this.g2d);
            }
        }
        if ((g = this.component.getGraphics()) != null) {
            this.bounds = this.component.getBounds();
            this.bounds.x = 0;
            this.bounds.y = 0;
            g.drawImage(this.bufferedImage, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, this.inWidth, this.inHeight, this.component);
        }
        return 0;
    }

    public void connectViewer(JMFSVGViewer viewer) {
        this.viewer = viewer;
    }

    public void disconnectViewer() {
        this.viewer = null;
    }

    protected Dimension myPreferredSize() {
        return new Dimension(this.inWidth, this.inHeight);
    }

    protected void repaint() {
        if (this.component != null) {
            Graphics g;
            if (this.inImage != null) {
                this.g2d = this.bufferedImage.createGraphics();
                this.g2d.drawImage(this.inImage, 0, 0, null);
                if (this.viewer != null) {
                    this.viewer.paintAnnotations(this.g2d);
                }
            }
            if ((g = this.component.getGraphics()) != null) {
                this.bounds = this.component.getBounds();
                this.bounds.x = 0;
                this.bounds.y = 0;
                g.drawImage(this.bufferedImage, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, 0, 0, this.inWidth, this.inHeight, this.component);
            }
        }
    }
}

