/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVG10Factory {
    private final Document doc;

    public SVG10Factory() {
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        this.doc = domImpl.createDocument(svgNS, "svg", null);
    }

    public final Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    public final Document getDocument() {
        return this.doc;
    }

    public final Node appendChild(Node e) {
        return this.doc.appendChild(e);
    }

    public final Element newSVGElement() {
        Element el = this.doc.createElement("svg");
        return el;
    }

    public final Element newGroup(String id) {
        if (id == null) {
            throw new NullPointerException("No id");
        }
        Element el = this.doc.createElement("g");
        el.setAttribute("id", id);
        return el;
    }

    public final Element newRect(RectangularShape shape) {
        if (shape == null) {
            new NullPointerException("Rectangle");
        }
        Element el = this.doc.createElement("rect");
        el.setAttribute("x", String.valueOf(shape.getX()));
        el.setAttribute("y", String.valueOf(shape.getY()));
        el.setAttribute("width", String.valueOf(shape.getWidth()));
        el.setAttribute("height", String.valueOf(shape.getHeight()));
        return el;
    }

    public final Element newRect(RectangularShape shape, String id) {
        if (id == null) {
            throw new NullPointerException("No id");
        }
        Element el = this.newRect(shape);
        el.setAttribute("id", id);
        return el;
    }

    public final Element newEllipse(RectangularShape shape) {
        if (shape == null) {
            new NullPointerException("Ellipse");
        }
        Element el = this.doc.createElement("ellipse");
        el.setAttribute("cx", String.valueOf(shape.getCenterX()));
        el.setAttribute("cy", String.valueOf(shape.getCenterY()));
        el.setAttribute("rx", String.valueOf(shape.getWidth() / 2.0));
        el.setAttribute("ry", String.valueOf(shape.getHeight() / 2.0));
        return el;
    }

    public final Element newEllipse(RectangularShape shape, String id) {
        if (id == null) {
            throw new NullPointerException("No id");
        }
        Element el = this.newEllipse(shape);
        el.setAttribute("id", id);
        return el;
    }

    public final Element newLine(Line2D shape) {
        if (shape == null) {
            new NullPointerException("Line");
        }
        Element el = this.doc.createElement("line");
        el.setAttribute("x1", String.valueOf(shape.getX1()));
        el.setAttribute("y1", String.valueOf(shape.getY1()));
        el.setAttribute("x2", String.valueOf(shape.getX2()));
        el.setAttribute("y2", String.valueOf(shape.getY2()));
        return el;
    }

    public final Element newLine(Line2D shape, String id) {
        if (id == null) {
            throw new NullPointerException("No id");
        }
        Element el = this.newLine(shape);
        el.setAttribute("id", id);
        return el;
    }
}

