/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;
import mpi.eudico.client.annotator.svg.SVG10Factory;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.IoUtil;
import mpi.util.LogUtil;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.svg.SVGGraphicsElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMDefsElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMLineElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMSymbolElement;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGParserAndStore {
    private static Hashtable libraries = new Hashtable(4);
    private static Hashtable documents = new Hashtable(4);
    private static SVGParserAndStore parser = null;
    private static SVGOMDocument svgDoc = null;
    private static final Logger LOG = Logger.getLogger(SVGParserAndStore.class.getName());

    private SVGParserAndStore() {
    }

    public static SVGParserAndStore getInstance() {
        if (parser == null) {
            parser = new SVGParserAndStore();
        }
        return parser;
    }

    public static Object getLibrary(Transcription transcription) {
        return libraries.get(transcription);
    }

    public static synchronized void parse(Transcription transcription) {
        String svgFileString = null;
        if (transcription instanceof TranscriptionImpl && ((TranscriptionImpl)transcription).getSVGFile() != null) {
            svgFileString = ((TranscriptionImpl)transcription).getSVGFile();
            LOG.info("Parse SVG file: " + svgFileString);
        }
        if (svgFileString == null) {
            return;
        }
        UserAgentAdapter userAgent = new UserAgentAdapter();
        DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
        try {
            svgDoc = (SVGOMDocument)loader.loadDocument(svgFileString);
            documents.put(transcription, svgDoc);
        }
        catch (IOException ioe) {
            LOG.severe("Could not load the .svg file");
            return;
        }
        SVGParserAndStore.buildLibrary(transcription);
        SVGParserAndStore.createGraphicAnnotations(transcription);
    }

    private static void createGraphicAnnotations(Transcription transcription) {
        Shape shape = null;
        for (TierImpl tier : transcription.getTiers()) {
            if (tier.getLinguisticType() == null || !tier.getLinguisticType().hasGraphicReferences()) continue;
            for (SVGAlignableAnnotation ann : tier.getAnnotations()) {
                String id;
                SVGOMElement el;
                if (ann.getSVGElementID().length() <= 0 || (el = (SVGOMElement)svgDoc.getElementById(id = ann.getSVGElementID())) == null) continue;
                int elX = SVGParserAndStore.parseToInt(el.getAttribute("x"));
                int elY = SVGParserAndStore.parseToInt(el.getAttribute("y"));
                shape = el instanceof SVGOMUseElement ? SVGParserAndStore.createShapeFromUseElement((SVGOMUseElement)el, elX, elY) : SVGParserAndStore.createShapeFromElement(el, elX, elY);
                if (shape == null) continue;
                ann.insertShape(shape);
            }
        }
    }

    private static void buildLibrary(Transcription transcription) {
        SVGOMDocument svgDoc = (SVGOMDocument)documents.get(transcription);
        if (svgDoc == null) {
            return;
        }
        NodeList children = svgDoc.getRootElement().getChildNodes();
        SVGOMDefsElement defsEl = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!n.getNodeName().equals("defs")) continue;
            defsEl = (SVGOMDefsElement)n;
            break;
        }
        if (defsEl == null) {
            return;
        }
        Hashtable<String, Shape> symbols = new Hashtable<String, Shape>();
        children = defsEl.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node nextNode = children.item(i);
            Shape shape = null;
            if (nextNode.getNodeName().equals("symbol")) {
                SVGOMSymbolElement sym = (SVGOMSymbolElement)nextNode;
                int symX = SVGParserAndStore.parseToInt(sym.getAttribute("x"));
                int symY = SVGParserAndStore.parseToInt(sym.getAttribute("y"));
                NodeList symChilds = sym.getChildNodes();
                for (int j = 0; j < symChilds.getLength(); ++j) {
                    if (symChilds.item(j) instanceof SVGOMUseElement) {
                        SVGOMUseElement use = (SVGOMUseElement)symChilds.item(j);
                        int useX = SVGParserAndStore.parseToInt(use.getAttribute("x")) + symX;
                        int useY = SVGParserAndStore.parseToInt(use.getAttribute("y")) + symY;
                        shape = SVGParserAndStore.createShapeFromUseElement(use, useX, useY);
                    } else {
                        if (!(symChilds.item(j) instanceof SVGOMElement)) continue;
                        shape = SVGParserAndStore.createShapeFromElement((SVGOMElement)symChilds.item(j), symX, symY);
                    }
                    break;
                }
            } else if (nextNode.getNodeName().equals("g")) {
                SVGOMGElement gel = (SVGOMGElement)nextNode;
                int gX = SVGParserAndStore.parseToInt(gel.getAttribute("x"));
                int gY = SVGParserAndStore.parseToInt(gel.getAttribute("y"));
                shape = SVGParserAndStore.createShapeFromGElement(gel, gX, gY);
                break;
            }
            if (shape == null) continue;
            symbols.put(((SVGOMElement)nextNode).getId(), shape);
        }
        libraries.put(transcription, symbols);
    }

    private static Shape createShapeFromElement(SVGOMElement el, int transX, int transY) {
        if (el instanceof SVGOMGElement) {
            return SVGParserAndStore.createShapeFromGElement((SVGOMGElement)el, transX, transY);
        }
        if (el instanceof SVGOMRectElement) {
            return SVGParserAndStore.createShapeFromRectElement((SVGOMRectElement)el, transX, transY);
        }
        if (el instanceof SVGOMEllipseElement) {
            return SVGParserAndStore.createShapeFromEllipseElement((SVGOMEllipseElement)el, transX, transY);
        }
        if (el instanceof SVGOMCircleElement) {
            return SVGParserAndStore.createShapeFromCircleElement((SVGOMCircleElement)el, transX, transY);
        }
        if (el instanceof SVGOMPathElement) {
            return SVGParserAndStore.createShapeFromPathElement((SVGOMPathElement)el, transX, transY);
        }
        if (el instanceof SVGOMLineElement) {
            return SVGParserAndStore.createShapeFromLineElement((SVGOMLineElement)el, transX, transY);
        }
        return null;
    }

    private static Shape createShapeFromSymbolElement(SVGOMSymbolElement el, int transX, int transY) {
        NodeList symChilds = el.getChildNodes();
        int x = SVGParserAndStore.parseToInt(el.getAttribute("x")) + transX;
        int y = SVGParserAndStore.parseToInt(el.getAttribute("y")) + transY;
        for (int j = 0; j < symChilds.getLength(); ++j) {
            if (symChilds.item(j) instanceof SVGOMUseElement) {
                SVGOMUseElement use = (SVGOMUseElement)symChilds.item(j);
                return SVGParserAndStore.createShapeFromUseElement(use, x, y);
            }
            if (!(symChilds.item(j) instanceof SVGOMElement)) continue;
            return SVGParserAndStore.createShapeFromElement((SVGOMElement)symChilds.item(j), x, y);
        }
        return null;
    }

    private static Shape createShapeFromUseElement(SVGOMUseElement el, int transX, int transY) {
        String href = "";
        NamedNodeMap m = el.getAttributes();
        for (int j = 0; j < m.getLength(); ++j) {
            GenericAttrNS ans;
            Node n = m.item(j);
            if (!(n instanceof GenericAttrNS) || !(ans = (GenericAttrNS)n).getName().equals("xlink:href")) continue;
            Node cn = ans.getFirstChild();
            if (cn == null) break;
            href = cn.getNodeValue();
            break;
        }
        if (href == null || href.length() <= 1) {
            return null;
        }
        href = href.substring(1);
        int x = SVGParserAndStore.parseToInt(el.getAttribute("x")) + transX;
        int y = SVGParserAndStore.parseToInt(el.getAttribute("y")) + transY;
        SVGOMElement ref = (SVGOMElement)svgDoc.getElementById(href);
        if (ref instanceof SVGOMSymbolElement) {
            return SVGParserAndStore.createShapeFromSymbolElement((SVGOMSymbolElement)ref, x, y);
        }
        if (ref instanceof SVGOMElement) {
            return SVGParserAndStore.createShapeFromElement(ref, x, y);
        }
        return null;
    }

    private static Shape createShapeFromGElement(SVGOMGElement el, int transX, int transY) {
        NodeList ch = el.getChildNodes();
        int x = SVGParserAndStore.parseToInt(el.getAttribute("x")) + transX;
        int y = SVGParserAndStore.parseToInt(el.getAttribute("y")) + transY;
        for (int i = 0; i < ch.getLength(); ++i) {
            Node n = ch.item(i);
            if (n instanceof SVGOMUseElement) {
                return SVGParserAndStore.createShapeFromUseElement((SVGOMUseElement)n, x, y);
            }
            if (!(n instanceof SVGGraphicsElement)) continue;
            return SVGParserAndStore.createShapeFromElement((SVGOMElement)((SVGGraphicsElement)n), x, y);
        }
        return null;
    }

    private static Shape createShapeFromRectElement(SVGOMRectElement el, int transX, int transY) {
        int x = SVGParserAndStore.parseToInt(el.getAttribute("x")) + transX;
        int y = SVGParserAndStore.parseToInt(el.getAttribute("y")) + transY;
        int width = SVGParserAndStore.parseToInt(el.getAttribute("width"));
        int height = SVGParserAndStore.parseToInt(el.getAttribute("height"));
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    private static Shape createShapeFromEllipseElement(SVGOMEllipseElement el, int transX, int transY) {
        int cx = SVGParserAndStore.parseToInt(el.getAttribute("cx"));
        int cy = SVGParserAndStore.parseToInt(el.getAttribute("cy"));
        int rx = SVGParserAndStore.parseToInt(el.getAttribute("rx"));
        int ry = SVGParserAndStore.parseToInt(el.getAttribute("ry"));
        Ellipse2D.Float ellipse = new Ellipse2D.Float(transX + cx - rx / 2, transY + cy - ry / 2, 2 * rx, 2 * ry);
        return ellipse;
    }

    private static Shape createShapeFromCircleElement(SVGOMCircleElement el, int transX, int transY) {
        int cx = SVGParserAndStore.parseToInt(el.getAttribute("cx"));
        int cy = SVGParserAndStore.parseToInt(el.getAttribute("cy"));
        int r = SVGParserAndStore.parseToInt(el.getAttribute("r"));
        Ellipse2D.Float ellipse = new Ellipse2D.Float(transX + cx - r / 2, transY + cy - r / 2, 2 * r, 2 * r);
        return ellipse;
    }

    private static Shape createShapeFromPathElement(SVGOMPathElement el, int transX, int transY) {
        Shape shape = null;
        return shape;
    }

    private static Shape createShapeFromLineElement(SVGOMLineElement el, int transX, int transY) {
        int p1x = SVGParserAndStore.parseToInt(el.getAttribute("x1"));
        int p1y = SVGParserAndStore.parseToInt(el.getAttribute("y1"));
        int p2x = SVGParserAndStore.parseToInt(el.getAttribute("x2"));
        int p2y = SVGParserAndStore.parseToInt(el.getAttribute("y2"));
        Line2D.Float line = new Line2D.Float(p1x + transX, p1y + transY, p2x + transX, p2y + transY);
        return line;
    }

    private static int parseToInt(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        try {
            int val = 0;
            if (s.indexOf(46) > -1) {
                float floatVal = Float.parseFloat(s);
                val = (int)floatVal;
            } else {
                val = Integer.parseInt(s);
            }
            return val;
        }
        catch (NumberFormatException nfe) {
            LOG.warning("NFE: " + nfe.getMessage());
            return 0;
        }
    }

    public static synchronized void storeSVG(Transcription transcription) {
        if (transcription != null) {
            String svgFileString = null;
            if (transcription instanceof TranscriptionImpl) {
                svgFileString = ((TranscriptionImpl)transcription).getSVGFile();
            }
            if (svgFileString == null || svgFileString.length() == 0) {
                String path = "";
                path = transcription instanceof TranscriptionImpl ? transcription.getFullPath() : transcription.getName();
                if (!path.endsWith(".eaf")) {
                    return;
                }
                int index = path.lastIndexOf(".eaf");
                svgFileString = path.substring(0, index) + ".svg";
                if (!svgFileString.toLowerCase().endsWith(".svg")) {
                    svgFileString = svgFileString + ".svg";
                }
            }
            if (svgFileString.startsWith("file:")) {
                svgFileString = svgFileString.substring(5);
            }
            if (((TranscriptionImpl)transcription).getSVGFile() != null) {
                if (documents.get(transcription) instanceof SVGOMDocument) {
                    svgDoc = (SVGOMDocument)documents.get(transcription);
                }
                Element docElement = null;
                try {
                    docElement = SVGParserAndStore.createDOM(transcription);
                }
                catch (DOMException dome) {
                    LOG.severe("Could not save the svg file: could not create DOM tree.");
                    LOG.severe(LogUtil.formatStackTrace((Throwable)dome));
                    return;
                }
                if (docElement != null) {
                    try {
                        IoUtil.writeEncodedFile("UTF-8", svgFileString, docElement);
                    }
                    catch (Exception ex) {
                        LOG.severe("Error while saving file.");
                        LOG.warning(LogUtil.formatStackTrace((Throwable)ex));
                    }
                } else {
                    LOG.warning("Empty svg file.");
                }
            } else {
                File renamed;
                boolean success;
                File svgFile = new File(svgFileString);
                if (svgFile.exists() && !(success = svgFile.renameTo(renamed = new File(svgFileString + "_old")))) {
                    LOG.warning("Could not rename empty svg file");
                }
            }
        } else {
            return;
        }
    }

    private static Element createDOM(Transcription transcription) throws DOMException {
        boolean defsEmpty = true;
        SVG10Factory svgFactory = new SVG10Factory();
        if (svgDoc != null && svgDoc.getDoctype() != null) {
            svgFactory.appendChild(svgDoc.getDoctype());
        }
        Element svgEl = svgFactory.getDocumentElement();
        if (svgDoc != null) {
            NodeList children = svgDoc.getRootElement().getChildNodes();
            SVGOMDefsElement defsEl = null;
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (!n.getNodeName().equals("defs")) continue;
                defsEl = (SVGOMDefsElement)n;
                break;
            }
            if (defsEl != null && defsEl.hasChildNodes()) {
                defsEmpty = false;
                AbstractNode copyNode = (AbstractNode)defsEl.cloneNode(true);
                Document d = svgFactory.getDocument();
                copyNode.setOwnerDocument(d);
                svgEl.appendChild((Node)copyNode);
            }
        }
        Shape shape = null;
        for (TierImpl tier : transcription.getTiers()) {
            if (tier.getLinguisticType() == null || !tier.getLinguisticType().hasGraphicReferences()) continue;
            for (SVGAlignableAnnotation ann : tier.getAnnotations()) {
                Element ellEl;
                shape = ann.getShape();
                String id = ann.getSVGElementID();
                if (shape == null || id.length() == 0) continue;
                Element group = svgFactory.newGroup(id);
                if (shape instanceof Rectangle) {
                    Element rectEl = svgFactory.newRect((RectangularShape)shape);
                    group.appendChild(rectEl);
                    svgEl.appendChild(group);
                    continue;
                }
                if (shape instanceof Ellipse2D) {
                    ellEl = svgFactory.newEllipse((RectangularShape)shape);
                    group.appendChild(ellEl);
                    svgEl.appendChild(group);
                    continue;
                }
                if (!(shape instanceof Line2D)) continue;
                ellEl = svgFactory.newLine((Line2D)shape);
                group.appendChild(ellEl);
                svgEl.appendChild(group);
            }
        }
        return svgFactory.getDocumentElement();
    }
}

