/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CalcOverlapsStep1
extends StepPane
implements ListSelectionListener {
    protected TranscriptionImpl transcription;
    protected TierTableModel model1;
    protected TierTableModel model2;
    private JTable table1;
    private JTable table2;
    JLabel firstLabel;
    JLabel secLabel;

    public CalcOverlapsStep1(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    public void initComponents() {
        this.model1 = new TierTableModel(null, new String[]{"TierName", "LinguisticType"});
        this.model2 = new TierTableModel(null, new String[]{"TierName", "LinguisticType"});
        for (int i = 0; i < this.transcription.getTiers().size(); ++i) {
            TierImpl ti = (TierImpl)this.transcription.getTiers().get(i);
            if (!ti.isTimeAlignable()) continue;
            this.model1.addRow(ti);
            this.model2.addRow(ti);
        }
        this.table1 = new JTable(this.model1);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(this);
        this.table2 = new JTable(this.model2);
        this.table2.getSelectionModel().setSelectionMode(0);
        this.table2.getSelectionModel().addListSelectionListener(this);
        Dimension prdim = new Dimension(120, 80);
        JScrollPane p1 = new JScrollPane(this.table1);
        p1.setPreferredSize(prdim);
        JScrollPane p2 = new JScrollPane(this.table2);
        p2.setPreferredSize(prdim);
        this.firstLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.First"));
        this.secLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.Second"));
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.firstLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p1, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.secLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p2, gbc);
    }

    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.SelectTiers");
    }

    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    public boolean leaveStepForward() {
        if (this.table1.getSelectedRow() > -1 && this.table2.getSelectedRow() > -1 && this.table1.getSelectedRow() != this.table2.getSelectedRow()) {
            int row = this.table1.getSelectedRow();
            Object sel = this.table1.getValueAt(row, this.model1.findColumn("TierName"));
            if (sel != null) {
                this.multiPane.putStepProperty("Source-1", (String)sel);
            }
            if ((sel = this.table2.getValueAt(row = this.table2.getSelectedRow(), this.model2.findColumn("TierName"))) != null) {
                this.multiPane.putStepProperty("Source-2", (String)sel);
            }
            return true;
        }
        return false;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.table1.getSelectedRow() > -1 && this.table2.getSelectedRow() > -1 && this.table1.getSelectedRow() != this.table2.getSelectedRow()) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }
}

