/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AnnotationsFromOverlapsCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CalcOverlapsStep3
extends StepPane
implements ProgressListener {
    TranscriptionImpl transcription;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private AnnotationsFromOverlapsCommand com;

    public CalcOverlapsStep3(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.progressLabel = new JLabel("...");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.progressLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setValue(0);
        gbc.gridy = 1;
        this.add((Component)this.progressBar, gbc);
    }

    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.Calculating");
    }

    public void enterStepForward() {
        this.doFinish();
    }

    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        String tierName1 = (String)this.multiPane.getStepProperty("Source-1");
        String tierName2 = (String)this.multiPane.getStepProperty("Source-2");
        String destTier = (String)this.multiPane.getStepProperty("DestTier");
        String typeName = (String)this.multiPane.getStepProperty("Type");
        Boolean content = (Boolean)this.multiPane.getStepProperty("Content");
        Integer format = (Integer)this.multiPane.getStepProperty("Format");
        Boolean onlyWhenValuesMatch = (Boolean)this.multiPane.getStepProperty("MatchingValuesOnly");
        Boolean specValuesOnly = (Boolean)this.multiPane.getStepProperty("SpecificValueOnly");
        String specValue = (String)this.multiPane.getStepProperty("SpecificValue");
        if (tierName1 == null || tierName2 == null || destTier == null || typeName == null) {
            this.progressInterrupted(null, "Illegal argument: a tier or type could not be found");
        }
        this.com = (AnnotationsFromOverlapsCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromOverlaps");
        this.com.addProgressListener(this);
        this.com.execute(this.transcription, new Object[]{tierName1, tierName2, destTier, typeName, content, format, onlyWhenValuesMatch, specValuesOnly, specValue});
        return false;
    }

    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressLabel != null && message != null) {
            this.progressLabel.setText(message);
        }
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.progressBar.setValue(percent);
        if (percent >= 100) {
            if (this.com != null) {
                this.com.removeProgressListener(this);
            }
            this.showMessageDialog("Operation completed");
            this.multiPane.close();
        }
    }

    public void progressCompleted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.progressBar.setValue(100);
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.showMessageDialog("Operation completed");
        this.multiPane.close();
    }

    public void progressInterrupted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.showWarningDialog("Operation interrupted: " + message);
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.multiPane.close();
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message, null, 1);
    }
}

