/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCaseDlg
extends ClosableDialog
implements ActionListener,
ListSelectionListener,
CellEditorListener {
    private TranscriptionImpl transcription;
    private JPanel titlePanel;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private JTable tierTable;
    private TierExportTableModel model;
    private JRadioButton upperCaseRB;
    private JRadioButton lowerCaseRB;
    private JCheckBox beginCapCheckBox;

    public ChangeCaseDlg(TranscriptionImpl transcription, Frame frame) {
        super(frame);
        this.transcription = transcription;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.titleLabel = new JLabel();
        this.model = new TierExportTableModel();
        this.model.setColumnCount(2);
        this.tierTable = new JTable(this.model);
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        this.tierTable.getColumnModel().getColumn(0).setCellEditor(cellEd);
        this.tierTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tierTable.getSelectionModel().setSelectionMode(2);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        tierScroll.setPreferredSize(new Dimension(100, 100));
        this.upperCaseRB = new JRadioButton();
        this.upperCaseRB.setSelected(true);
        this.lowerCaseRB = new JRadioButton();
        this.beginCapCheckBox = new JCheckBox();
        this.beginCapCheckBox.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.upperCaseRB);
        group.add(this.lowerCaseRB);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tierPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.tierPanel.add((Component)tierScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.upperCaseRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.lowerCaseRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 20, 2, 6);
        this.optionsPanel.add((Component)this.beginCapCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 2, 6);
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.updateLocale();
        this.upperCaseRB.addActionListener(this);
        this.lowerCaseRB.addActionListener(this);
    }

    private void postInit() {
        this.pack();
        int minimalWidth = 500;
        int minimalHeight = 400;
        this.setSize(this.getSize().width < minimalWidth ? minimalWidth : this.getSize().width, this.getSize().height < minimalHeight ? minimalHeight : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void extractTiers() {
        if (this.transcription != null) {
            Vector v = this.transcription.getTiers();
            for (int i = 0; i < v.size(); ++i) {
                TierImpl t = (TierImpl)v.get(i);
                if (i == 0) {
                    this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            this.tierTable.getColumnModel().getColumn(0).getCellEditor().addCellEditorListener(this);
        }
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("ChangeCaseDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ChangeCaseDialog.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Tier")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Options")));
        this.upperCaseRB.setText(ElanLocale.getString("ChangeCaseDialog.UpperCase"));
        this.lowerCaseRB.setText(ElanLocale.getString("ChangeCaseDialog.LowerCase"));
        this.beginCapCheckBox.setText(ElanLocale.getString("ChangeCaseDialog.Capital"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void startOperation() {
        List<String> tierNames = null;
        tierNames = this.getSelectedTiers();
        if (tierNames.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        Object[] args = new Object[]{tierNames, new Boolean(this.upperCaseRB.isSelected()), new Boolean(this.beginCapCheckBox.isSelected())};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.ChangeCase");
        command.execute(this.transcription, args);
    }

    private List<String> getSelectedTiers() {
        ArrayList<String> tiers = new ArrayList<String>();
        Object selObj = null;
        Object nameObj = null;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.tierTable.getValueAt(i, 0);
            if (selObj != Boolean.TRUE || !((nameObj = this.tierTable.getValueAt(i, 1)) instanceof String)) continue;
            tiers.add((String)nameObj);
        }
        return tiers;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog();
        } else if (ae.getSource() == this.upperCaseRB || ae.getSource() == this.lowerCaseRB) {
            this.beginCapCheckBox.setEnabled(this.lowerCaseRB.isSelected());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            if (this.tierTable.getSelectionModel().getSelectionMode() == 0) {
                int i = this.tierTable.getSelectedRow();
                if (i > -1) {
                    for (int j = 0; j < this.tierTable.getRowCount(); ++j) {
                        if (j != i) {
                            this.tierTable.setValueAt(Boolean.FALSE, j, 0);
                            continue;
                        }
                        this.tierTable.setValueAt(Boolean.TRUE, j, 0);
                    }
                    this.tierTable.revalidate();
                }
            } else {
                int b = lse.getFirstIndex();
                int e = lse.getLastIndex();
                int col = 0;
                for (int i = b; i <= e; ++i) {
                    if (!this.tierTable.isRowSelected(i)) continue;
                    this.model.setValueAt(Boolean.TRUE, i, col);
                }
            }
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        int i;
        if (this.tierTable.getSelectionModel().getSelectionMode() == 0 && (i = this.tierTable.getSelectedRow()) > -1) {
            for (int j = 0; j < this.tierTable.getRowCount(); ++j) {
                if (j == i) continue;
                this.tierTable.setValueAt(Boolean.FALSE, j, 0);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }
}

