/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.AnnotatorCompareUtil;
import mpi.eudico.client.annotator.tier.CompareAnnotatorResultsDlg;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CompareAnnotatorsDlg
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private TierTableModel model1;
    private TierTableModel model2;
    private JTable table1;
    private JTable table2;
    private JLabel firstLabel;
    private JLabel secLabel;
    private JLabel titleLabel;
    private JPanel tierPanel;
    private JButton closeButton;
    private JButton compareButton;
    private JPanel buttonPanel;

    public CompareAnnotatorsDlg(TranscriptionImpl transcription, Frame parent) throws HeadlessException {
        super(parent, true);
        this.transcription = transcription;
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        this.model1 = new TierTableModel(null, new String[]{"TierName", "LinguisticType"});
        this.model2 = new TierTableModel(null, new String[]{"TierName", "LinguisticType"});
        for (int i = 0; i < this.transcription.getTiers().size(); ++i) {
            TierImpl ti = (TierImpl)this.transcription.getTiers().get(i);
            if (!ti.isTimeAlignable()) continue;
            this.model1.addRow(ti);
            this.model2.addRow(ti);
        }
        this.table1 = new JTable(this.model1);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table2 = new JTable(this.model2);
        this.table2.getSelectionModel().setSelectionMode(0);
        Dimension prdim = new Dimension(400, 150);
        JScrollPane p1 = new JScrollPane(this.table1);
        p1.setPreferredSize(prdim);
        JScrollPane p2 = new JScrollPane(this.table2);
        p2.setPreferredSize(prdim);
        this.firstLabel = new JLabel();
        this.secLabel = new JLabel();
        this.tierPanel = new JPanel();
        this.tierPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.tierPanel.add((Component)this.firstLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)p1, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.tierPanel.add((Component)this.secLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)p2, gbc);
        gbc.gridy = 1;
        this.getContentPane().add((Component)this.tierPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.compareButton = new JButton();
        this.closeButton = new JButton();
        this.compareButton.addActionListener(this);
        this.buttonPanel.add(this.compareButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("CompareAnnotatorsDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.SelectTiers")));
        this.firstLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.Label.First"));
        this.secLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.Label.Second"));
        this.compareButton.setText(ElanLocale.getString("CompareAnnotatorsDialog.Label.Compare"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.compareButton) {
            String name2;
            if (this.table1.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("CompareAnnotatorsDialog.Message.First"), ElanLocale.getString("Message.Error"), 2);
                return;
            }
            if (this.table2.getSelectedRow() == -1) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("CompareAnnotatorsDialog.Message.Second"), ElanLocale.getString("Message.Error"), 2);
                return;
            }
            AnnotatorCompareUtil acu = new AnnotatorCompareUtil();
            String name1 = (String)this.table1.getValueAt(this.table1.getSelectedRow(), this.model1.findColumn("TierName"));
            TableModel model = acu.getComparisonTable(this.transcription, name1, name2 = (String)this.table2.getValueAt(this.table2.getSelectedRow(), this.model2.findColumn("TierName")));
            if (model != null) {
                new CompareAnnotatorResultsDlg((Dialog)this, model).setVisible(true);
            }
        }
    }
}

