/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyTierStep1
extends StepPane
implements TreeSelectionListener {
    private TranscriptionImpl transcription;
    private JTree tierTree;
    private JCheckBox depTiersCB;
    private boolean copyMode = false;

    public CopyTierStep1(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        if (multiPane.getStepProperty("CopyMode") != null) {
            this.copyMode = true;
        }
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        if (this.transcription != null) {
            TierTree tree = new TierTree(this.transcription);
            this.tierTree = new JTree(tree.getTree());
        } else {
            this.tierTree = new JTree();
        }
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        model.setSelectionMode(1);
        model.addTreeSelectionListener(this);
        this.tierTree.setSelectionModel(model);
        this.tierTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tierTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tierTree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tierTree.setFont(this.tierTree.getFont().deriveFont(14.0f));
        JScrollPane scrollPane = new JScrollPane(this.tierTree);
        for (int i = 0; i < this.tierTree.getRowCount(); ++i) {
            this.tierTree.expandRow(i);
        }
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        if (this.copyMode) {
            this.add((Component)new JLabel("<html>" + ElanLocale.getString("MultiStep.Copy.SelectTier") + "</html>"), gbc);
        } else {
            this.add((Component)new JLabel("<html>" + ElanLocale.getString("MultiStep.Reparent.SelectTier") + " " + ElanLocale.getString("MultiStep.Reparent.Depending") + "</html>"), gbc);
        }
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
        if (this.copyMode) {
            this.depTiersCB = new JCheckBox(ElanLocale.getString("MultiStep.Copy.Depending"));
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.add((Component)this.depTiersCB, gbc);
        }
    }

    public String getStepTitle() {
        if (this.copyMode) {
            return ElanLocale.getString("MultiStep.Copy.SelectTier");
        }
        return ElanLocale.getString("MultiStep.Reparent.SelectTier");
    }

    public void enterStepForward() {
    }

    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    public boolean leaveStepForward() {
        if (this.tierTree.getSelectionModel().getSelectionCount() > 0) {
            Object o = this.tierTree.getLastSelectedPathComponent();
            if (o instanceof DefaultMutableTreeNode) {
                this.multiPane.putStepProperty("SelTier", ((DefaultMutableTreeNode)o).getUserObject());
            }
            if (this.copyMode) {
                this.multiPane.putStepProperty("IncludeDepTiers", new Boolean(this.depTiersCB.isSelected()));
            }
            return true;
        }
        return false;
    }

    public boolean leaveStepBackward() {
        return true;
    }

    public boolean doFinish() {
        return true;
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.tierTree.getSelectionCount() > 0 && this.tierTree.getSelectionModel().getMinSelectionRow() > 0) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }
}

