/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class LabelAndNumberDlg
extends ClosableDialog
implements ActionListener,
ChangeListener,
ItemListener,
ListSelectionListener,
CellEditorListener {
    private TranscriptionImpl transcription;
    private JPanel titlePanel;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton startButton;
    private JLabel titleLabel;
    private JRadioButton singleTierRB;
    private JRadioButton multiTierRB;
    private JTable tierTable;
    private TierExportTableModel model;
    private JCheckBox labelCheckBox;
    private JTextField labelTextField;
    private JCheckBox delimiterCheckBox;
    private JRadioButton spaceRadioButton;
    private JSpinner spaceSpinner;
    private JRadioButton otherDelRadioButton;
    private JTextField otherDelTextField;
    private JCheckBox includeNumberCheckBox;
    private JComboBox numberFormatComboBox;
    private JCheckBox leadingZerosCheckBox;
    private JRadioButton minIntDigitsRadioButton;
    private JSpinner numZerosSpinner;
    private JRadioButton minIntDigitsDependsRadioButton;
    private JLabel startLabel;
    private JSpinner startSpinner;
    private JLabel incrementLabel;
    private JSpinner incrementSpinner;
    private JLabel exampleLabel;
    private String intFormat = "Integer";
    private String decFormat = "Decimal";

    public LabelAndNumberDlg(TranscriptionImpl transcription, Frame frame) {
        super(frame);
        this.transcription = transcription;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LabelAndNumberDlg.this.closeDialog(evt);
            }
        });
        this.titlePanel = new JPanel();
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.titleLabel = new JLabel();
        this.singleTierRB = new JRadioButton();
        this.multiTierRB = new JRadioButton();
        ButtonGroup tierGroup = new ButtonGroup();
        tierGroup.add(this.singleTierRB);
        tierGroup.add(this.multiTierRB);
        this.model = new TierExportTableModel();
        this.model.setColumnCount(2);
        this.tierTable = new JTable(this.model);
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        this.tierTable.getColumnModel().getColumn(0).setCellEditor(cellEd);
        this.tierTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tierTable.getSelectionModel().setSelectionMode(0);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        tierScroll.setPreferredSize(new Dimension(100, 100));
        this.labelCheckBox = new JCheckBox();
        this.labelTextField = new JTextField(6);
        this.delimiterCheckBox = new JCheckBox();
        this.spaceRadioButton = new JRadioButton();
        this.spaceSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        this.otherDelRadioButton = new JRadioButton();
        this.otherDelTextField = new JTextField(4);
        this.includeNumberCheckBox = new JCheckBox();
        this.numberFormatComboBox = new JComboBox();
        this.leadingZerosCheckBox = new JCheckBox();
        this.minIntDigitsRadioButton = new JRadioButton();
        this.numZerosSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 10, 1));
        this.minIntDigitsDependsRadioButton = new JRadioButton();
        this.startLabel = new JLabel();
        this.startSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
        this.incrementLabel = new JLabel();
        this.incrementSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
        this.exampleLabel = new JLabel();
        this.exampleLabel.setFont(this.exampleLabel.getFont().deriveFont(2));
        this.exampleLabel.setForeground(Constants.ACTIVEANNOTATIONCOLOR);
        this.exampleLabel.setBorder(new LineBorder(Constants.ACTIVEANNOTATIONCOLOR));
        this.singleTierRB.setSelected(true);
        this.labelCheckBox.setSelected(true);
        this.spaceRadioButton.setSelected(true);
        this.delimiterCheckBox.setSelected(true);
        this.otherDelRadioButton.setSelected(false);
        this.otherDelTextField.setEnabled(false);
        ButtonGroup delGroup = new ButtonGroup();
        delGroup.add(this.spaceRadioButton);
        delGroup.add(this.otherDelRadioButton);
        this.includeNumberCheckBox.setSelected(true);
        this.intFormat = ElanLocale.getString("LabelAndNumberDialog.Label.IntFormat");
        this.decFormat = ElanLocale.getString("LabelAndNumberDialog.Label.IntAndFractionFormat");
        this.numberFormatComboBox.addItem(this.intFormat);
        this.numberFormatComboBox.addItem(this.decFormat);
        this.leadingZerosCheckBox.setSelected(true);
        this.minIntDigitsRadioButton.setSelected(false);
        this.numZerosSpinner.setEnabled(false);
        this.minIntDigitsDependsRadioButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.minIntDigitsRadioButton);
        group.add(this.minIntDigitsDependsRadioButton);
        this.setModal(true);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tierPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierPanel.add((Component)this.singleTierRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierPanel.add((Component)this.multiTierRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.tierPanel.add((Component)tierScroll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        insets.bottom = 3;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.labelCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.labelTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.delimiterCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.spaceRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.optionsPanel.add((Component)this.spaceSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.otherDelRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.optionsPanel.add((Component)this.otherDelTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.includeNumberCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.optionsPanel.add((Component)this.numberFormatComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.leadingZerosCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.minIntDigitsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.optionsPanel.add((Component)this.numZerosSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.minIntDigitsDependsRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.startSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.incrementLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 80, 2, 6);
        this.optionsPanel.add((Component)this.incrementSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.exampleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 2, 6);
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.updateLocale();
        this.singleTierRB.addActionListener(this);
        this.multiTierRB.addActionListener(this);
        this.labelCheckBox.addChangeListener(this);
        this.delimiterCheckBox.addChangeListener(this);
        this.spaceRadioButton.addChangeListener(this);
        this.otherDelRadioButton.addChangeListener(this);
        this.includeNumberCheckBox.addChangeListener(this);
        this.numberFormatComboBox.addItemListener(this);
        this.leadingZerosCheckBox.addChangeListener(this);
        this.minIntDigitsRadioButton.addChangeListener(this);
        this.minIntDigitsDependsRadioButton.addChangeListener(this);
        this.spaceSpinner.addChangeListener(this);
        this.numZerosSpinner.addChangeListener(this);
        this.startSpinner.addChangeListener(this);
        this.incrementSpinner.addChangeListener(this);
        KeyAdapter keyList = new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                LabelAndNumberDlg.this.updateExample();
            }
        };
        this.labelTextField.addKeyListener(keyList);
        this.otherDelTextField.addKeyListener(keyList);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.updateExample();
    }

    private void extractTiers() {
        if (this.transcription != null) {
            Vector v = this.transcription.getTiers();
            for (int i = 0; i < v.size(); ++i) {
                TierImpl t = (TierImpl)v.get(i);
                if (i == 0) {
                    this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
            }
            this.tierTable.getSelectionModel().addListSelectionListener(this);
            this.tierTable.getColumnModel().getColumn(0).getCellEditor().addCellEditorListener(this);
        }
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("LabelAndNumberDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("LabelAndNumberDialog.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Tier")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Options")));
        this.singleTierRB.setText(ElanLocale.getString("LabelAndNumberDialog.Label.Single"));
        this.multiTierRB.setText(ElanLocale.getString("LabelAndNumberDialog.Label.Multi"));
        this.labelCheckBox.setText(ElanLocale.getString("LabelAndNumberDialog.Label.IncludeLabel"));
        this.delimiterCheckBox.setText(ElanLocale.getString("LabelAndNumberDialog.Label.InsertDelimiter"));
        this.spaceRadioButton.setText(ElanLocale.getString("LabelAndNumberDialog.Label.InsertSpace"));
        this.otherDelRadioButton.setText(ElanLocale.getString("LabelAndNumberDialog.Label.InsertOther"));
        this.includeNumberCheckBox.setText(ElanLocale.getString("LabelAndNumberDialog.Label.IncludeNumber"));
        this.leadingZerosCheckBox.setText(ElanLocale.getString("LabelAndNumberDialog.Label.LeadingZeros"));
        this.minIntDigitsRadioButton.setText(ElanLocale.getString("LabelAndNumberDialog.Label.MinIntDigits"));
        this.minIntDigitsDependsRadioButton.setText(ElanLocale.getString("LabelAndNumberDialog.Label.MinDigitsDepends"));
        this.startLabel.setText(ElanLocale.getString("LabelAndNumberDialog.Label.Start"));
        this.incrementLabel.setText(ElanLocale.getString("LabelAndNumberDialog.Label.Increment"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.exampleLabel.setText("nnn");
    }

    private void updateExample() {
        StringBuffer sb = new StringBuffer();
        if (this.labelCheckBox.isSelected()) {
            sb.append(this.labelTextField.getText());
        }
        if (this.delimiterCheckBox.isSelected()) {
            if (this.spaceRadioButton.isSelected() && this.spaceRadioButton.isEnabled()) {
                int spaces = 1;
                Object so = this.spaceSpinner.getValue();
                if (so instanceof Integer) {
                    spaces = (Integer)so;
                    for (int i = 0; i < spaces; ++i) {
                        sb.append(" ");
                    }
                }
            } else if (this.otherDelRadioButton.isSelected() && this.otherDelRadioButton.isEnabled()) {
                sb.append(this.otherDelTextField.getText());
            }
        }
        if (this.includeNumberCheckBox.isSelected()) {
            if (this.leadingZerosCheckBox.isSelected()) {
                int numDig = 1;
                if (this.minIntDigitsRadioButton.isSelected()) {
                    Object nd = this.numZerosSpinner.getValue();
                    if (nd instanceof Integer) {
                        numDig = (Integer)nd;
                    }
                } else {
                    List tierNames = this.getSelectedTiers();
                    TierImpl tier = null;
                    int count = 0;
                    for (int i = 0; i < tierNames.size(); ++i) {
                        tier = (TierImpl)this.transcription.getTierWithId((String)tierNames.get(i));
                        if (tier == null) continue;
                        count += tier.getAnnotations().size();
                    }
                    Object startObj = this.startSpinner.getValue();
                    Object increObj = this.incrementSpinner.getValue();
                    if (startObj instanceof Integer) {
                        int start = (Integer)startObj;
                        count = start + (count - 1) * (Integer)increObj;
                    } else {
                        double startd = (Double)startObj;
                        count = (int)(startd + (double)(count - 1) * (Double)increObj);
                    }
                    while (count >= 10) {
                        ++numDig;
                        count /= 10;
                    }
                }
                Object stObj = this.startSpinner.getValue();
                if (stObj != null) {
                    String stVal = stObj.toString();
                    int index = stVal.indexOf(46);
                    if (index < 0) {
                        index = stVal.length();
                    }
                    for (int i = 0; i < numDig - index; ++i) {
                        sb.append("0");
                    }
                    sb.append(stVal);
                }
            } else {
                Object stObj = this.startSpinner.getValue();
                if (stObj != null) {
                    sb.append(stObj.toString());
                }
            }
        }
        if (sb.length() == 0) {
            this.exampleLabel.setText(" ");
        } else {
            this.exampleLabel.setText(sb.toString());
        }
    }

    private void startOperation() {
        List tierNames = null;
        String prefix = null;
        Number format = null;
        Integer numDigits = null;
        Number startVal = null;
        Number incrementVal = null;
        tierNames = this.getSelectedTiers();
        if (tierNames.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
            return;
        }
        if (this.labelCheckBox.isSelected()) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.labelTextField.getText());
            if (this.delimiterCheckBox.isSelected()) {
                if (this.spaceRadioButton.isSelected() && this.spaceRadioButton.isEnabled()) {
                    int spaces = 1;
                    Object so = this.spaceSpinner.getValue();
                    if (so instanceof Integer) {
                        spaces = (Integer)so;
                        for (int i = 0; i < spaces; ++i) {
                            buf.append(" ");
                        }
                    }
                } else if (this.otherDelRadioButton.isSelected() && this.otherDelRadioButton.isEnabled()) {
                    buf.append(this.otherDelTextField.getText());
                }
            }
            prefix = buf.toString();
        }
        if (this.includeNumberCheckBox.isSelected()) {
            format = this.decFormat.equals(this.numberFormatComboBox.getSelectedItem()) ? (Number)new Double(0.0) : (Number)new Integer(0);
            if (this.leadingZerosCheckBox.isSelected()) {
                int numDig = 1;
                if (this.minIntDigitsRadioButton.isSelected()) {
                    Object nd = this.numZerosSpinner.getValue();
                    if (nd instanceof Integer) {
                        numDig = (Integer)nd;
                    }
                } else {
                    String name = null;
                    TierImpl tier = null;
                    int count = 0;
                    for (int i = 0; i < tierNames.size(); ++i) {
                        name = (String)tierNames.get(i);
                        tier = (TierImpl)this.transcription.getTierWithId(name);
                        if (tier == null) continue;
                        count += tier.getAnnotations().size();
                    }
                    Object startObj = this.startSpinner.getValue();
                    Object increObj = this.incrementSpinner.getValue();
                    if (startObj instanceof Integer) {
                        int start = (Integer)startObj;
                        count = start + (count - 1) * (Integer)increObj;
                    } else {
                        double startd = (Double)startObj;
                        count = (int)(startd + (double)(count - 1) * (Double)increObj);
                    }
                    while (count >= 10) {
                        ++numDig;
                        count /= 10;
                    }
                }
                numDigits = new Integer(numDig);
            } else {
                numDigits = new Integer(0);
            }
            if (format instanceof Integer) {
                startVal = (Integer)this.startSpinner.getValue();
                incrementVal = (Integer)this.incrementSpinner.getValue();
            } else {
                startVal = (Double)this.startSpinner.getValue();
                incrementVal = (Double)this.incrementSpinner.getValue();
            }
        } else {
            numDigits = new Integer(0);
        }
        Object[] args = new Object[]{tierNames, prefix, format, numDigits, startVal, incrementVal};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.LabelAndNumber");
        command.execute(this.transcription, args);
    }

    private List getSelectedTiers() {
        ArrayList<Object> tiers = new ArrayList<Object>();
        Object selObj = null;
        Object nameObj = null;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.tierTable.getValueAt(i, 0);
            if (selObj != Boolean.TRUE || (nameObj = this.tierTable.getValueAt(i, 1)) == null) continue;
            tiers.add(nameObj);
        }
        return tiers;
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        } else if (ae.getSource() == this.singleTierRB) {
            boolean oneSel = false;
            int selRow = -1;
            this.tierTable.getSelectionModel().setSelectionMode(0);
            for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                if (!oneSel) {
                    if (this.tierTable.getValueAt(i, 0) != Boolean.TRUE) continue;
                    oneSel = true;
                    selRow = i;
                    continue;
                }
                this.tierTable.setValueAt(Boolean.FALSE, i, 0);
            }
            if (selRow > -1) {
                this.tierTable.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
        } else if (ae.getSource() == this.multiTierRB) {
            this.tierTable.getSelectionModel().setSelectionMode(2);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.labelCheckBox) {
            if (this.labelCheckBox.isSelected()) {
                this.labelTextField.setEnabled(true);
                this.delimiterCheckBox.setEnabled(true);
                this.spaceRadioButton.setEnabled(true);
                if (this.spaceRadioButton.isSelected()) {
                    this.spaceSpinner.setEnabled(true);
                }
            } else {
                this.labelTextField.setEnabled(false);
                this.delimiterCheckBox.setEnabled(false);
                this.spaceRadioButton.setEnabled(false);
                this.spaceSpinner.setEnabled(false);
            }
        } else if (e.getSource() == this.delimiterCheckBox) {
            boolean sel = this.delimiterCheckBox.isSelected();
            this.spaceRadioButton.setEnabled(sel);
            if (sel && this.spaceRadioButton.isSelected()) {
                this.spaceSpinner.setEnabled(true);
            } else {
                this.spaceSpinner.setEnabled(false);
            }
            this.otherDelRadioButton.setEnabled(sel);
            if (sel && this.otherDelRadioButton.isSelected()) {
                this.otherDelTextField.setEnabled(true);
            } else {
                this.otherDelTextField.setEnabled(false);
            }
        } else if (e.getSource() == this.spaceRadioButton) {
            if (this.spaceRadioButton.isSelected()) {
                this.spaceSpinner.setEnabled(true);
                this.otherDelTextField.setEnabled(false);
            } else {
                this.spaceSpinner.setEnabled(false);
                this.otherDelTextField.setEnabled(true);
            }
        } else if (e.getSource() == this.otherDelRadioButton) {
            if (this.otherDelRadioButton.isSelected()) {
                this.spaceSpinner.setEnabled(false);
                this.otherDelTextField.setEnabled(true);
            } else {
                this.spaceSpinner.setEnabled(true);
                this.otherDelTextField.setEnabled(false);
            }
        } else if (e.getSource() == this.includeNumberCheckBox) {
            boolean select = this.includeNumberCheckBox.isSelected();
            if (this.labelCheckBox.isSelected()) {
                this.delimiterCheckBox.setEnabled(select);
                this.spaceRadioButton.setEnabled(select);
                if (select && this.spaceRadioButton.isSelected()) {
                    this.spaceSpinner.setEnabled(true);
                } else {
                    this.spaceSpinner.setEnabled(false);
                }
            }
            this.numberFormatComboBox.setEnabled(select);
            this.leadingZerosCheckBox.setEnabled(select);
            this.minIntDigitsDependsRadioButton.setEnabled(select);
            this.minIntDigitsRadioButton.setEnabled(select);
            if (this.minIntDigitsRadioButton.isSelected() && select) {
                this.numZerosSpinner.setEnabled(true);
            } else {
                this.numZerosSpinner.setEnabled(false);
            }
            this.startSpinner.setEnabled(select);
            this.incrementSpinner.setEnabled(select);
        } else if (e.getSource() == this.leadingZerosCheckBox) {
            boolean select = this.leadingZerosCheckBox.isSelected();
            this.minIntDigitsRadioButton.setEnabled(select);
            this.minIntDigitsDependsRadioButton.setEnabled(select);
            if (this.minIntDigitsRadioButton.isSelected() && select) {
                this.numZerosSpinner.setEnabled(true);
            } else {
                this.numZerosSpinner.setEnabled(false);
            }
        } else if (e.getSource() == this.minIntDigitsRadioButton) {
            this.numZerosSpinner.setEnabled(this.minIntDigitsRadioButton.isSelected());
        } else if (e.getSource() == this.minIntDigitsDependsRadioButton) {
            this.numZerosSpinner.setEnabled(!this.minIntDigitsDependsRadioButton.isSelected());
        }
        this.updateExample();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.numberFormatComboBox && e.getStateChange() == 1) {
            String val = (String)this.numberFormatComboBox.getSelectedItem();
            this.startSpinner.removeChangeListener(this);
            this.incrementSpinner.removeChangeListener(this);
            if (this.decFormat.equals(val)) {
                Object spinVal = this.startSpinner.getValue();
                this.startSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, 1000.0, 1.0));
                this.startSpinner.setValue(new Double(((Integer)spinVal).intValue()));
                spinVal = this.incrementSpinner.getValue();
                this.incrementSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, 100.0, 0.1));
                this.incrementSpinner.setValue(new Double(((Integer)spinVal).intValue()));
            } else {
                Object spinVal = this.startSpinner.getValue();
                this.startSpinner.setModel(new SpinnerNumberModel(1, 0, 1000, 1));
                this.startSpinner.setValue(new Integer((int)((Double)spinVal).doubleValue()));
                spinVal = this.incrementSpinner.getValue();
                this.incrementSpinner.setModel(new SpinnerNumberModel(1, 0, 100, 1));
                this.incrementSpinner.setValue(new Integer((int)((Double)spinVal).doubleValue()));
            }
            this.startSpinner.addChangeListener(this);
            this.incrementSpinner.addChangeListener(this);
        }
        this.updateExample();
    }

    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            if (this.tierTable.getSelectionModel().getSelectionMode() == 0) {
                int i = this.tierTable.getSelectedRow();
                if (i > -1) {
                    for (int j = 0; j < this.tierTable.getRowCount(); ++j) {
                        if (j != i) {
                            this.tierTable.setValueAt(Boolean.FALSE, j, 0);
                            continue;
                        }
                        this.tierTable.setValueAt(Boolean.TRUE, j, 0);
                    }
                    this.tierTable.revalidate();
                }
            } else {
                int b = lse.getFirstIndex();
                int e = lse.getLastIndex();
                int col = 0;
                for (int i = b; i <= e; ++i) {
                    if (!this.tierTable.isRowSelected(i)) continue;
                    this.model.setValueAt(Boolean.TRUE, i, col);
                }
            }
        }
        this.updateExample();
    }

    public void editingStopped(ChangeEvent e) {
        if (this.tierTable.getSelectionModel().getSelectionMode() == 0) {
            int i = this.tierTable.getSelectedRow();
            if (i > -1) {
                for (int j = 0; j < this.tierTable.getRowCount(); ++j) {
                    if (j == i) continue;
                    this.tierTable.setValueAt(Boolean.FALSE, j, 0);
                }
            }
            this.updateExample();
        }
    }

    public void editingCanceled(ChangeEvent e) {
    }
}

