/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MergeTierGroupStep2
extends StepPane
implements ActionListener,
CaretListener {
    private TranscriptionImpl transcription;
    private JTextField suffixField;
    private JLabel nameLabel;
    private JLabel sufLabel;
    private String orgName;

    public MergeTierGroupStep2(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    protected void initComponents() {
        this.suffixField = new JTextField();
        this.suffixField.addActionListener(this);
        this.suffixField.addCaretListener(this);
        this.sufLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.DestNameSuffix"));
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(2));
        this.nameLabel.setForeground(this.nameLabel.getForeground().brighter());
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)this.sufLabel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.suffixField, gbc);
        gbc.gridy = 2;
        this.add((Component)this.nameLabel, gbc);
    }

    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.DefineDest");
    }

    public void enterStepBackward() {
        this.enterStepForward();
    }

    public void enterStepForward() {
        this.orgName = (String)this.multiPane.getStepProperty("Source-1");
        if (this.orgName == null) {
            this.orgName = "-";
        }
        this.updateNameLabel();
    }

    public boolean leaveStepForward() {
        if (!this.validTierName()) {
            return false;
        }
        this.multiPane.putStepProperty("Suffix", this.suffixField.getText());
        return true;
    }

    public boolean doFinish() {
        this.multiPane.nextStep();
        return false;
    }

    private boolean validTierName() {
        String name = this.suffixField.getText();
        if (this.orgName == null || name == null || name.length() == 0) {
            return false;
        }
        return this.transcription.getTierWithId(this.orgName + name) == null;
    }

    public void actionPerformed(ActionEvent e) {
        this.caretUpdate(null);
    }

    public void caretUpdate(CaretEvent e) {
        if (this.validTierName()) {
            this.multiPane.setButtonEnabled(3, true);
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
        this.updateNameLabel();
    }

    private void updateNameLabel() {
        if (this.orgName != null) {
            String suf = this.suffixField.getText();
            if (suf != null) {
                this.nameLabel.setText(this.orgName + suf);
            } else {
                this.nameLabel.setText(this.orgName);
            }
        }
    }
}

