/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TierTableModel
extends AbstractTableModel {
    public static final String LABEL_PREF = "EditTierDialog.Label.";
    public static final String NAME = "TierName";
    public static final String PARENT = "Parent";
    public static final String PARTICIPANT = "Participant";
    public static final String ANNOTATOR = "Annotator";
    public static final String TYPE = "LinguisticType";
    public static final String LANGUAGE = "Language";
    public static final String N_A = "-";
    private ArrayList tierList;
    private List columnIds;
    private List tableData;
    private List classes;

    public TierTableModel() {
        this(null);
    }

    public TierTableModel(Vector tiers) {
        this(tiers, null);
    }

    public TierTableModel(Vector tiers, String[] columns) {
        this.tierList = tiers == null ? new ArrayList(0) : new ArrayList(tiers);
        this.columnIds = new ArrayList();
        this.classes = new ArrayList();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].equals(NAME)) {
                    this.columnIds.add(NAME);
                    this.classes.add(String.class);
                    continue;
                }
                if (columns[i].equals(PARENT)) {
                    this.columnIds.add(PARENT);
                    this.classes.add(String.class);
                    continue;
                }
                if (columns[i].equals(TYPE)) {
                    this.columnIds.add(TYPE);
                    this.classes.add(String.class);
                    continue;
                }
                if (columns[i].equals(PARTICIPANT)) {
                    this.columnIds.add(PARTICIPANT);
                    this.classes.add(String.class);
                    continue;
                }
                if (columns[i].equals(ANNOTATOR)) {
                    this.columnIds.add(ANNOTATOR);
                    this.classes.add(String.class);
                    continue;
                }
                if (!columns[i].equals(LANGUAGE)) continue;
                this.columnIds.add(LANGUAGE);
                this.classes.add(String.class);
            }
        } else {
            this.columnIds.add(NAME);
            this.columnIds.add(PARENT);
            this.columnIds.add(TYPE);
            this.columnIds.add(PARTICIPANT);
            this.columnIds.add(ANNOTATOR);
            this.columnIds.add(LANGUAGE);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
            this.classes.add(String.class);
        }
        this.initData();
    }

    private void initData() {
        this.tableData = new ArrayList(this.tierList.size());
        for (int i = 0; i < this.tierList.size(); ++i) {
            TierImpl tier = (TierImpl)this.tierList.get(i);
            this.addRowData(tier);
        }
        this.fireTableDataChanged();
    }

    private void addRowData(TierImpl tier) {
        if (tier == null) {
            return;
        }
        ArrayList<String> rowData = new ArrayList<String>(6);
        int index = this.columnIds.indexOf(NAME);
        if (index > -1) {
            rowData.add(index, tier.getName());
        }
        if ((index = this.columnIds.indexOf(PARENT)) > -1) {
            if (tier.getParentTier() == null) {
                rowData.add(index, N_A);
            } else {
                rowData.add(index, tier.getParentTier().getName());
            }
        }
        if ((index = this.columnIds.indexOf(TYPE)) > -1) {
            rowData.add(index, tier.getLinguisticType().getLinguisticTypeName());
        }
        if ((index = this.columnIds.indexOf(PARTICIPANT)) > -1) {
            rowData.add(index, tier.getParticipant());
        }
        if ((index = this.columnIds.indexOf(ANNOTATOR)) > -1) {
            rowData.add(index, tier.getAnnotator());
        }
        if ((index = this.columnIds.indexOf(LANGUAGE)) > -1) {
            Locale loc = tier.getDefaultLocale();
            if (loc != null) {
                rowData.add(index, loc.getDisplayName());
            } else {
                rowData.add(index, N_A);
            }
        }
        this.tableData.add(rowData);
    }

    public int getRowCount() {
        return this.tableData.size();
    }

    public int getColumnCount() {
        return this.columnIds.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        ArrayList row = (ArrayList)this.tableData.get(rowIndex);
        return row.get(columnIndex);
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public int findColumn(String columnName) {
        return this.columnIds.indexOf(columnName);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.classes.size()) {
            return null;
        }
        return (Class)this.classes.get(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return "";
        }
        return ElanLocale.getString(LABEL_PREF + (String)this.columnIds.get(columnIndex));
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.tableData.size()) {
            this.tableData.remove(rowIndex);
            this.tierList.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeAllRows() {
        this.tableData.clear();
        this.tierList.clear();
        this.fireTableDataChanged();
    }

    public void addRow(TierImpl tier) {
        if (tier == null || this.tierList.contains(tier)) {
            return;
        }
        this.tierList.add(tier);
        this.addRowData(tier);
        this.fireTableDataChanged();
    }

    public void addTier(TierImpl tier) {
        this.addRow(tier);
    }

    public void rowDataChanged() {
        this.initData();
        this.fireTableDataChanged();
    }
}

