/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;

public class ContinuousRateTSTrack
extends AbstractTSTrack {
    private float sampleRate;
    private float msPerSample;
    private float[] data;

    public void setSampleRate(float rate) {
        this.sampleRate = rate;
        this.msPerSample = 1000.0f / this.sampleRate;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        if (!(data instanceof float[])) {
            throw new IllegalArgumentException("This track only accepts an array of floats");
        }
        this.data = (float[])data;
    }

    public int getIndexForTime(long time) {
        int index = -1;
        if (time + (long)this.timeOffset >= 0L) {
            index = this.msPerSample >= 1.0f ? (int)((float)(time + (long)this.timeOffset) / this.msPerSample) : (int)Math.ceil((float)(time + (long)this.timeOffset) / this.msPerSample);
        }
        return index;
    }

    public long getTimeForIndex(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index should be greater than or equal to 0");
        }
        long time = 0L;
        if (this.data != null) {
            if (index >= this.data.length) {
                throw new ArrayIndexOutOfBoundsException("Index (" + index + ") is greater than " + (this.data.length - 1));
            }
            time = (long)((float)index * this.msPerSample);
        }
        return time + (long)this.timeOffset;
    }

    public float getAverage(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        if ((float)end > this.msPerSample * (float)this.data.length) {
            throw new ArrayIndexOutOfBoundsException("End time greater than track duration: " + end + " > " + this.msPerSample * (float)this.data.length);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        int count = 0;
        float total = 0.0f;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            total += this.data[i];
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total / (float)count;
    }

    public float getMaximum(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        if ((float)end > this.msPerSample * (float)this.data.length) {
            throw new ArrayIndexOutOfBoundsException("End time greater than track duration: " + end + " > " + this.msPerSample * (float)this.data.length);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        float max = -2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (!(this.data[i] > max)) continue;
            max = this.data[i];
        }
        return max;
    }

    public float getMinimum(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException("Begin time " + begin + " < 0");
        }
        if ((float)end > this.msPerSample * (float)this.data.length) {
            throw new ArrayIndexOutOfBoundsException("End time greater than track duration: " + end + " > " + this.msPerSample * (float)this.data.length);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        float min = 2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.length; ++i) {
            if (!(this.data[i] < min)) continue;
            min = this.data[i];
        }
        return min;
    }
}

