/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ExtractTrackDataCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExtractStep3
extends StepPane
implements ClientLogger,
ProgressListener {
    private TranscriptionImpl transcription;
    private TSTrackManager manager;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private Command command;

    public ExtractStep3(MultiStepPane multiPane, TranscriptionImpl transcription, TSTrackManager manager) {
        super(multiPane);
        this.transcription = transcription;
        this.manager = manager;
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        this.progressLabel = new JLabel(ElanLocale.getString("TimeSeriesViewer.Extract.Extracting"));
        this.progressBar = new JProgressBar(0, 0, 100);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.insets = insets;
        this.add((Component)this.progressLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setValue(0);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.progressBar, gbc);
    }

    public String getStepTitle() {
        return ElanLocale.getString("TimeSeriesViewer.Extract.Extracting");
    }

    public boolean doFinish() {
        TierImpl sourceTier;
        this.multiPane.setButtonEnabled(8, false);
        String sourceTierName = (String)this.multiPane.getStepProperty("SourceTier");
        String destTierName = (String)this.multiPane.getStepProperty("DestTier");
        String trackName = (String)this.multiPane.getStepProperty("TrackName");
        String method = (String)this.multiPane.getStepProperty("Calc");
        if (method == null) {
            LOG.warning("Unknown calculation method.");
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NoMethod"));
            return false;
        }
        String overwr = (String)this.multiPane.getStepProperty("Overwrite");
        boolean overwrite = true;
        if ("false".equals(overwr)) {
            overwrite = false;
        }
        if ((sourceTier = (TierImpl)this.transcription.getTierWithId(sourceTierName)) == null) {
            LOG.warning("Source tier is null: " + sourceTierName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + sourceTierName);
            return false;
        }
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(destTierName);
        if (destTier == null) {
            LOG.warning("Destination tier is null: " + destTierName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + destTierName);
            return false;
        }
        AbstractTSTrack track = this.manager.getTrack(trackName);
        if (track == null) {
            LOG.warning("Track is null: " + trackName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + trackName);
            return false;
        }
        this.command = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ExtractTrackData");
        ((ExtractTrackDataCommand)this.command).addProgressListener(this);
        this.command.execute(this.transcription, new Object[]{sourceTierName, destTierName, track, method, new Boolean(overwrite)});
        return false;
    }

    public void enterStepForward() {
        this.doFinish();
    }

    private void notifyCancel(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressLabel != null && message != null) {
            this.progressLabel.setText(message);
        }
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.progressBar.setValue(percent);
        if (percent >= 100) {
            this.showMessageDialog("Operation completed");
            if (this.command != null) {
                ((ExtractTrackDataCommand)this.command).removeProgressListener(this);
            }
            this.multiPane.close();
        }
    }

    public void progressCompleted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.showMessageDialog("Operation completed");
        if (this.command != null) {
            ((ExtractTrackDataCommand)this.command).removeProgressListener(this);
        }
        this.multiPane.close();
    }

    public void progressInterrupted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.showWarningDialog("Operation interrupted: " + message);
        if (this.command != null) {
            ((ExtractTrackDataCommand)this.command).removeProgressListener(this);
        }
        this.multiPane.close();
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message, null, 1);
    }
}

