/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeValue;

public class NonContinuousRateTSTrack
extends AbstractTSTrack {
    private List data;

    public NonContinuousRateTSTrack() {
        this.setType(11);
    }

    public NonContinuousRateTSTrack(String name, String description) {
        super(name, description, 11);
    }

    public int getIndexForTime(long time) {
        TimeValue key;
        if (time < 0L) {
            throw new IllegalArgumentException("Time should be greater than or equal to 0: " + time);
        }
        if (this.data == null || this.data.isEmpty()) {
            return -1;
        }
        int index = -1;
        if (time + (long)this.timeOffset >= 0L && (index = Collections.binarySearch(this.data, key = new TimeValue(time + (long)this.timeOffset, 0.0f))) < 0 && (index = -(index + 1)) > 0) {
            --index;
        }
        return index;
    }

    public long getTimeForIndex(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index should be greater than or equal to 0");
        }
        long time = 0L;
        if (this.data != null) {
            if (index >= this.data.size()) {
                throw new ArrayIndexOutOfBoundsException("Index (" + index + ") is greater than " + (this.data.size() - 1));
            }
            time = ((TimeValue)this.data.get((int)index)).time;
        }
        return time + (long)this.timeOffset;
    }

    public void setSampleRate(float rate) {
    }

    public float getSampleRate() {
        return 0.0f;
    }

    public int getSampleCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        if (!(data instanceof List)) {
            throw new IllegalArgumentException("This track only accepts a List of TimeValue objects");
        }
        this.data = (List)data;
    }

    public float getMinimum(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        float maxTime = ((TimeValue)this.data.get((int)(this.data.size() - 1))).time;
        if (!this.data.isEmpty() && (float)end > maxTime) {
            throw new ArrayIndexOutOfBoundsException(end + " > " + maxTime);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        float min = 2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            float val = ((TimeValue)this.data.get((int)i)).value;
            if (!(val < min)) continue;
            min = val;
        }
        return min;
    }

    public float getMaximum(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        float maxTime = ((TimeValue)this.data.get((int)(this.data.size() - 1))).time;
        if (!this.data.isEmpty() && (float)end > maxTime) {
            throw new ArrayIndexOutOfBoundsException(end + " > " + maxTime);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        float max = -2.1474836E9f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            float val = ((TimeValue)this.data.get((int)i)).value;
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    public float getAverage(long begin, long end) {
        if (this.data == null) {
            return 0.0f;
        }
        if (begin >= end) {
            throw new IllegalArgumentException("Begin time should not be greater than or equal to the end time");
        }
        if (begin < 0L) {
            throw new ArrayIndexOutOfBoundsException(begin + " < 0");
        }
        float maxTime = ((TimeValue)this.data.get((int)(this.data.size() - 1))).time;
        if (!this.data.isEmpty() && (float)end > maxTime) {
            throw new ArrayIndexOutOfBoundsException(end + " > " + maxTime);
        }
        int bi = this.getIndexForTime(begin);
        int ei = this.getIndexForTime(end);
        int count = 0;
        float total = 0.0f;
        for (int i = bi; i <= ei && i < this.data.size(); ++i) {
            total += ((TimeValue)this.data.get((int)i)).value;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total / (float)count;
    }
}

