/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.util.ArrayList;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.MultiSourcePlayer;
import mpi.eudico.client.annotator.player.SyncPlayer;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class TSViewerPlayer
extends EmptyMediaPlayer
implements SyncPlayer,
MultiSourcePlayer {
    private TimeSeriesViewer viewer;
    private TSTrackManager trackManager;
    private String currentSource;
    private MediaDescriptor[] descriptors;
    private String[] sources;

    public TSViewerPlayer(long duration) {
        super(duration);
    }

    public TSViewerPlayer(TimeSeriesViewer viewer, long duration) {
        super(duration);
        this.viewer = viewer;
        viewer.setPlayer(this);
    }

    public Component getVisualComponent() {
        return this.viewer;
    }

    public TimeSeriesViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TimeSeriesViewer viewer) {
        this.viewer = viewer;
        viewer.setPlayer(this);
    }

    public TSTrackManager getTrackManager() {
        return this.trackManager;
    }

    public void setTrackManager(TSTrackManager trackManager) {
        this.trackManager = trackManager;
        this.sources = trackManager.getCurrentSourceNames();
        if (this.sources != null) {
            this.descriptors = new MediaDescriptor[this.sources.length];
            for (int i = 0; i < this.sources.length; ++i) {
                this.descriptors[i] = new MediaDescriptor(this.sources[i], "unknown");
            }
            if (this.sources.length > 0) {
                this.setCurrentSource(this.sources[0]);
            }
        }
    }

    private void updateDescriptorStrings() {
        String[] curTrackSources = this.trackManager.getCurrentSourceNames();
        if (this.sources == null) {
            int i;
            this.sources = curTrackSources;
            this.descriptors = new MediaDescriptor[this.sources.length];
            for (i = 0; i < this.sources.length; ++i) {
                this.descriptors[i] = new MediaDescriptor(this.sources[i], "unknown");
            }
            if (this.currentSource == null && this.sources.length > 0) {
                this.setCurrentSource(this.sources[0]);
            } else {
                for (i = 0; i < this.sources.length && !this.sources[i].equals(this.currentSource); ++i) {
                    if (i != this.sources.length - 1) continue;
                    this.setCurrentSource(this.sources[0]);
                }
            }
        } else {
            int i;
            int j;
            int i2;
            ArrayList<String> newSources = new ArrayList<String>(2);
            ArrayList<String> remSources = new ArrayList<String>(2);
            for (i2 = 0; i2 < curTrackSources.length; ++i2) {
                for (j = 0; j < this.sources.length && !curTrackSources[i2].equals(this.sources[j]); ++j) {
                    if (j != this.sources.length - 1) continue;
                    newSources.add(curTrackSources[i2]);
                }
            }
            for (i2 = 0; i2 < this.sources.length; ++i2) {
                for (j = 0; j < curTrackSources.length && !this.sources[i2].equals(curTrackSources[j]); ++j) {
                    if (j != curTrackSources.length - 1) continue;
                    remSources.add(this.sources[i2]);
                }
            }
            if (newSources.size() == 0 && remSources.size() == 0) {
                return;
            }
            ArrayList<String> curSources = new ArrayList<String>(4);
            for (j = 0; j < this.sources.length; ++j) {
                if (remSources.contains(this.sources[j])) continue;
                curSources.add(this.sources[j]);
            }
            curSources.addAll(newSources);
            this.sources = curSources.toArray(new String[0]);
            this.descriptors = new MediaDescriptor[this.sources.length];
            for (i = 0; i < this.sources.length; ++i) {
                this.descriptors[i] = new MediaDescriptor(this.sources[i], "unknown");
            }
            if (this.currentSource == null && this.sources.length > 0) {
                this.setCurrentSource(this.sources[0]);
            } else {
                for (i = 0; i < this.sources.length && !this.sources[i].equals(this.currentSource); ++i) {
                    if (i != this.sources.length - 1) continue;
                    this.setCurrentSource(this.sources[0]);
                }
            }
        }
    }

    public String getCurrentSource() {
        return this.currentSource;
    }

    public void setCurrentSource(String currentSource) {
        this.currentSource = currentSource;
        if (this.trackManager != null) {
            this.setOffset(this.trackManager.getOffset(currentSource));
        } else {
            this.setOffset(0L);
        }
    }

    public String[] getDescriptorStrings() {
        if (this.sources == null) {
            this.sources = new String[0];
        }
        this.updateDescriptorStrings();
        return this.sources;
    }

    public MediaDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(MediaDescriptor[] descriptors) {
        this.descriptors = descriptors;
        if (descriptors != null) {
            String[] sources = new String[descriptors.length];
            for (int i = 0; i < descriptors.length; ++i) {
                sources[i] = descriptors[i].mediaURL;
            }
        }
    }

    public void setOffset(long offset) {
        super.setOffset(offset);
        if (this.trackManager != null) {
            this.trackManager.setOffset(this.currentSource, (int)offset);
        }
        if (this.viewer != null) {
            this.viewer.componentResized(null);
        }
    }

    public float getAspectRatio() {
        return 1.33f;
    }
}

