/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.glove;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveConstants;
import mpi.eudico.client.annotator.util.ClientLogger;

public class DataGloveFileReader
implements DataGloveConstants,
ClientLogger {
    private boolean validLogFile = true;
    private File sourceFile;
    private FileReader fileRead;
    private BufferedReader bufRead;
    private StringTokenizer tokenizer;
    private float msPerSample = 0.0f;
    private float deltaT = 1.0f;
    private int sampleFrequency = 0;
    private int numRowsPerSample = 0;

    public DataGloveFileReader(File file) {
        if (file == null) {
            throw new NullPointerException("The file is null");
        }
        this.sourceFile = file;
        this.validLogFile = this.isValidDataFile();
        System.out.println("Valid log file: " + this.validLogFile);
    }

    public DataGloveFileReader(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("The file name is null");
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.sourceFile = new File(fileName);
        this.validLogFile = this.isValidDataFile();
        LOG.info("Valid Data Glove log file: " + this.validLogFile);
    }

    private boolean isValidDataFile() {
        if (this.sourceFile == null) {
            return false;
        }
        boolean valid = true;
        try {
            this.fileRead = new FileReader(this.sourceFile);
            this.bufRead = new BufferedReader(this.fileRead);
            int rowIndex = 0;
            String li = null;
            while ((li = this.bufRead.readLine()) != null && rowIndex < 40 && li.length() != 0) {
                if (li.charAt(0) == '#') continue;
                this.tokenizer = new StringTokenizer(li);
                if (rowIndex < COLS_PER_ROW.length && this.tokenizer.countTokens() < COLS_PER_ROW[rowIndex]) {
                    valid = false;
                    break;
                }
                ++rowIndex;
            }
            this.numRowsPerSample = rowIndex;
            if (rowIndex < COLS_PER_ROW.length - 1) {
                valid = false;
            }
            try {
                this.bufRead.close();
            }
            catch (IOException ie) {}
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return valid;
    }

    public void read() throws IOException {
        this.sampleFrequency = this.detectSampleFrequency();
        this.msPerSample = 1000.0f * (1.0f / (float)this.sampleFrequency);
        LOG.info("Ms per sample detected: " + this.msPerSample);
    }

    public static void main(String[] args) {
        String fileName = "D:\\MPI\\ELAN docs\\dataglove\\glove.log";
        DataGloveFileReader reader = new DataGloveFileReader(fileName);
        try {
            reader.read();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file " + fileName + " " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private float[] toFloatArray(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        this.tokenizer = new StringTokenizer(line);
        float[] result = new float[this.tokenizer.countTokens()];
        String token = null;
        int i = 0;
        while (this.tokenizer.hasMoreTokens()) {
            token = this.tokenizer.nextToken();
            try {
                result[i] = Float.parseFloat(token);
            }
            catch (NumberFormatException nfe) {
                LOG.severe("No float value: " + token);
                result[i] = 0.0f;
            }
            ++i;
        }
        return result;
    }

    public int detectSampleFrequency() throws IOException {
        if (!this.validLogFile) {
            return 0;
        }
        this.sampleFrequency = 0;
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        int numSamplesRead = 0;
        int indexInSample = 0;
        float curDuration = 0.0f;
        float[] flArray = null;
        String li = null;
        while ((li = this.bufRead.readLine()) != null && numSamplesRead < 10) {
            if (li.length() == 0) {
                if (++numSamplesRead == 1) {
                    this.numRowsPerSample = indexInSample;
                    LOG.info("Number of  rows per sample: " + this.numRowsPerSample);
                }
                indexInSample = 0;
                continue;
            }
            if (li.charAt(0) == '#') continue;
            if (indexInSample == 0 && (flArray = this.toFloatArray(li)).length >= 2) {
                curDuration = flArray[1];
            }
            ++indexInSample;
        }
        if (numSamplesRead > 1) {
            float average = curDuration / (float)(numSamplesRead - 1);
            this.sampleFrequency = Math.round(1.0f / average);
            this.msPerSample = 1000.0f * (1.0f / (float)this.sampleFrequency);
            this.deltaT = this.msPerSample / 1000.0f;
            LOG.info("Sec Per Sample: " + average + " - Freq. " + this.sampleFrequency);
            LOG.info("Ms per sample: " + this.msPerSample + " - dT: " + this.deltaT);
        }
        try {
            this.bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return this.sampleFrequency;
    }

    public Object readTrack(int row, int column) throws IOException {
        if (!this.validLogFile) {
            return null;
        }
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException("Row and column must be greater than or equal to 0");
        }
        if (row >= this.numRowsPerSample) {
            throw new IllegalArgumentException("Row " + row + " does not exist. There are " + this.numRowsPerSample + " rows per sample in the file.");
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<Float> values = new ArrayList<Float>();
        int indexInSample = 0;
        float curTimeStamp = 0.0f;
        float curSample = 0.0f;
        int sampleCount = 0;
        float[] flArray = null;
        String li = null;
        while ((li = this.bufRead.readLine()) != null) {
            if (li.length() == 0) {
                if (curTimeStamp - (float)sampleCount * this.msPerSample > this.msPerSample / 2.0f) {
                    LOG.info("Adding fill-in at sample: " + sampleCount);
                    values.add(new Float(curSample));
                    ++sampleCount;
                }
                values.add(new Float(curSample));
                indexInSample = 0;
                ++sampleCount;
                curSample = 0.0f;
                continue;
            }
            if (li.charAt(0) == '#') continue;
            if (indexInSample == 0) {
                flArray = this.toFloatArray(li);
                if (flArray.length >= 2) {
                    curTimeStamp = flArray[1];
                }
                if (row == 0) {
                    curSample = flArray[column];
                }
            } else if (indexInSample == row && (flArray = this.toFloatArray(li)).length > column) {
                curSample = flArray[column];
            }
            ++indexInSample;
        }
        LOG.info("Number of samples: " + sampleCount);
        try {
            this.bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        float[] result = new float[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            Float fl = (Float)values.get(i);
            result[i] = fl.floatValue();
        }
        return result;
    }

    public Object readTrack(int row, int column, int derivative) throws IOException {
        if (!this.validLogFile) {
            return null;
        }
        if (derivative == 0) {
            return this.readTrack(row, column);
        }
        if (row < 0 || column < 0) {
            throw new IllegalArgumentException("Row and column must be greater than or equal to 0");
        }
        if (row >= this.numRowsPerSample) {
            throw new IllegalArgumentException("Row " + row + " does not exist. There are " + this.numRowsPerSample + " rows per sample in the file.");
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<Float> values = new ArrayList<Float>();
        int indexInSample = 0;
        float curTimeStamp = 0.0f;
        float curSample = 0.0f;
        int sampleCount = 0;
        float[] flArray = null;
        String li = null;
        float[][] derivArray = new float[derivative + 1][2];
        while ((li = this.bufRead.readLine()) != null) {
            if (li.length() == 0) {
                if (curTimeStamp - (float)sampleCount * this.msPerSample > this.msPerSample / 2.0f) {
                    LOG.info("Adding fill-in at sample: " + sampleCount);
                    this.shiftSamplesInArray(derivArray);
                    derivArray[0][1] = curSample;
                    this.calculateDerivatives(derivArray);
                    values.add(new Float(derivArray[derivArray.length - 1][1]));
                    ++sampleCount;
                }
                if (sampleCount == 0) {
                    derivArray[0][0] = curSample;
                } else if (sampleCount == 1) {
                    derivArray[0][1] = curSample;
                    this.calculateDerivatives(derivArray);
                    values.add(new Float(derivArray[derivArray.length - 1][1]));
                    values.add(new Float(derivArray[derivArray.length - 1][1]));
                } else {
                    this.shiftSamplesInArray(derivArray);
                    derivArray[0][1] = curSample;
                    this.calculateDerivatives(derivArray);
                    values.add(new Float(derivArray[derivArray.length - 1][1]));
                }
                indexInSample = 0;
                ++sampleCount;
                curSample = 0.0f;
                continue;
            }
            if (li.charAt(0) == '#') continue;
            if (indexInSample == 0) {
                flArray = this.toFloatArray(li);
                if (flArray.length >= 2) {
                    curTimeStamp = flArray[1];
                }
            } else if (indexInSample == row && (flArray = this.toFloatArray(li)).length > column) {
                curSample = flArray[column];
            }
            ++indexInSample;
        }
        LOG.info("Derivative: " + derivative + " Number of samples: " + sampleCount);
        try {
            this.bufRead.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        float[] result = new float[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            Float fl = (Float)values.get(i);
            result[i] = fl.floatValue();
        }
        return result;
    }

    private void calculateDerivatives(float[][] derivArray) {
        for (int i = 0; i < derivArray.length - 1; ++i) {
            derivArray[i + 1][1] = (derivArray[i][1] - derivArray[i][0]) / this.deltaT;
        }
    }

    private void shiftSamplesInArray(float[][] derivArray) {
        for (int i = 0; i < derivArray.length; ++i) {
            derivArray[i][0] = derivArray[i][1];
        }
    }

    private boolean shouldConvertAngle(int row, int column) {
        switch (row) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
            case 8: {
                return column == 0 || column == 1;
            }
            case 10: 
            case 12: 
            case 14: {
                return column >= 3 && column < 5;
            }
        }
        return false;
    }

    public float getMsPerSample() {
        return this.msPerSample;
    }

    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    public boolean isValidFile() {
        return this.validLogFile;
    }
}

