/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import mpi.eudico.client.annotator.timeseries.csv.CSVServiceProvider;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveServiceProvider;
import mpi.eudico.client.annotator.timeseries.praat.PitchTierServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.BasicTSServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.timeseries.xml.XmlTsServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.ExtClassLoader;

public final class TSServiceRegistry
implements ClientLogger {
    private static TSServiceRegistry registry;
    private final String spiClassName = "mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider";
    private TSServiceProvider prefProvider;
    private List providers = new ArrayList();

    private TSServiceRegistry() {
        this.registerPropertySpi();
        this.registerStandardSpis();
        this.registerClasspathSpis2();
    }

    public static TSServiceRegistry getInstance() {
        if (registry == null) {
            registry = new TSServiceRegistry();
        }
        return registry;
    }

    public TSServiceProvider getProviderByClassName(String className) {
        if (className == null) {
            return null;
        }
        if (this.prefProvider != null && this.prefProvider.getClass().getName().equals(className)) {
            return this.prefProvider;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            Object prov = this.providers.get(i);
            if (prov == null || !prov.getClass().getName().equals(className)) continue;
            return (TSServiceProvider)prov;
        }
        return null;
    }

    public TSServiceProvider getProviderForFile(String filePath) {
        if (filePath == null) {
            LOG.warning("No file specified for TSServiceProvider");
            return null;
        }
        if (this.prefProvider != null && this.prefProvider.canHandle(filePath)) {
            return this.prefProvider;
        }
        for (int i = 0; i < this.providers.size(); ++i) {
            Object prov = this.providers.get(i);
            if (prov == null || !((TSServiceProvider)prov).canHandle(filePath)) continue;
            return (TSServiceProvider)prov;
        }
        return null;
    }

    private void registerPropertySpi() {
        String name = System.getProperty("mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider");
        if (name == null) {
            return;
        }
        try {
            Class<?> c = Class.forName(name, true, ClassLoader.getSystemClassLoader());
            this.prefProvider = (TSServiceProvider)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warning(cnfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            LOG.warning(iae.getMessage());
        }
        catch (InstantiationException ia) {
            LOG.warning(ia.getMessage());
        }
        catch (SecurityException se) {
            LOG.warning(se.getMessage());
        }
        if (this.prefProvider == null) {
            try {
                Class<?> propImpl = ExtClassLoader.getInstance().loadClass(name);
                if (propImpl != null) {
                    try {
                        this.prefProvider = (TSServiceProvider)propImpl.newInstance();
                    }
                    catch (IllegalAccessException iae) {
                        LOG.warning(iae.getMessage());
                    }
                    catch (InstantiationException ia) {
                        LOG.warning(ia.getMessage());
                    }
                    catch (SecurityException se) {
                        LOG.warning(se.getMessage());
                    }
                }
            }
            catch (ClassNotFoundException cne) {
                LOG.warning(cne.getMessage());
            }
        }
    }

    private void registerStandardSpis() {
        this.providers.add(new DataGloveServiceProvider());
        this.providers.add(new BasicTSServiceProvider());
        this.providers.add(new CSVServiceProvider());
        this.providers.add(new PitchTierServiceProvider());
        this.providers.add(new XmlTsServiceProvider());
    }

    private void registerClasspathSpis() {
        String line = null;
        try {
            Enumeration<URL> resEn = ClassLoader.getSystemClassLoader().getResources("META-INF/services/mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider");
            while (resEn.hasMoreElements()) {
                URL url = resEn.nextElement();
                BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = in.readLine()) != null) {
                    Class<?> cl;
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || !TSServiceProvider.class.isAssignableFrom(cl = ClassLoader.getSystemClassLoader().loadClass(line))) continue;
                    this.providers.add((TSServiceProvider)cl.newInstance());
                }
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.warning("Cannot create class: " + line);
            LOG.warning(ioe.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warning("Cannot create class: " + line);
            LOG.warning(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            LOG.warning("Cannot create class: " + line);
            LOG.warning(ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            LOG.warning("Cannot create class: " + line);
            LOG.warning(iae.getMessage());
        }
    }

    private void registerClasspathSpis2() {
        Class[] implementors = ExtClassLoader.getInstance().getImplementingClasses(TSServiceProvider.class);
        if (implementors != null && implementors.length > 0) {
            for (int i = 0; i < implementors.length; ++i) {
                Class cl = implementors[i];
                try {
                    this.providers.add((TSServiceProvider)cl.newInstance());
                    continue;
                }
                catch (IllegalAccessException iae) {
                    LOG.warning("Cannot create new instance of: " + cl);
                    LOG.warning(iae.getMessage());
                    continue;
                }
                catch (InstantiationException ia) {
                    LOG.warning("Cannot create new instance of: " + cl);
                    LOG.warning(ia.getMessage());
                    continue;
                }
                catch (SecurityException se) {
                    LOG.warning("Cannot create new instance of: " + cl);
                    LOG.warning(se.getMessage());
                    continue;
                }
                catch (Exception exc) {
                    LOG.warning("Cannot create new instance of: " + cl);
                    LOG.warning(exc.getMessage());
                }
            }
        }
    }
}

