/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.Serializable;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.util.TimeInterval;

public class AnnotationDataRecord
extends TimeInterval
implements Serializable {
    private String tierName;
    private String value;
    private String id;
    private boolean beginTimeAligned;
    private boolean endTimeAligned;
    private Object extRef;

    public AnnotationDataRecord(Annotation annotation) {
        super(0L, 0L);
        TimeSlot ts = null;
        if (annotation != null) {
            this.value = annotation.getValue();
            this.beginTime = annotation.getBeginTimeBoundary();
            this.endTime = annotation.getEndTimeBoundary();
            this.id = annotation.getId();
            this.tierName = annotation.getTier().getName();
            if (annotation instanceof AlignableAnnotation) {
                ts = ((AlignableAnnotation)annotation).getBegin();
                this.beginTimeAligned = ts.isTimeAligned();
                ts = ((AlignableAnnotation)annotation).getEnd();
                this.endTimeAligned = ts.isTimeAligned();
            }
            if (annotation instanceof AbstractAnnotation && ((AbstractAnnotation)annotation).getExtRef() instanceof ExternalReference) {
                try {
                    this.extRef = ((ExternalReference)((AbstractAnnotation)annotation).getExtRef()).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not clone:" + cnse.getMessage());
                }
            }
        }
    }

    public AnnotationDataRecord(String tierName, String value, long beginTime, long endTime) {
        super(beginTime, endTime);
        this.tierName = tierName;
        this.value = value;
        if (this.endTime < this.beginTime && this.endTime >= 0L) {
            this.endTime = this.beginTime + 1L;
        }
        if (this.beginTime > -1L) {
            this.beginTimeAligned = true;
        }
        if (this.endTime > -1L) {
            this.endTimeAligned = true;
        }
    }

    public boolean isBeginTimeAligned() {
        return this.beginTimeAligned;
    }

    public boolean isEndTimeAligned() {
        return this.endTimeAligned;
    }

    public String getTierName() {
        return this.tierName;
    }

    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getExtRef() {
        return this.extRef;
    }

    public void setExtRef(Object extRef) {
        this.extRef = extRef;
    }
}

