/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.svg.SVGAnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.SVGAlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AnnotationRecreator {
    private static final Logger LOG = Logger.getLogger(AnnotationRecreator.class.getName());

    public static void convertAnnotations(Transcription trans, LinguisticType type) {
        TierImpl t;
        int i;
        if (trans == null || type == null) {
            return;
        }
        ArrayList<TierImpl> convertedTiers = new ArrayList<TierImpl>();
        Vector<TierImpl> tiersToConvert = null;
        tiersToConvert = trans.getTiersWithLinguisticType(type.getLinguisticTypeName());
        Vector<TierImpl> rootTiers = new Vector<TierImpl>();
        for (i = 0; i < tiersToConvert.size(); ++i) {
            t = (TierImpl)tiersToConvert.get(i);
            if (t.hasParentTier()) continue;
            rootTiers.add(t);
        }
        for (i = 0; i < tiersToConvert.size(); ++i) {
            t = (TierImpl)tiersToConvert.get(i);
            if (rootTiers.contains(t)) continue;
            rootTiers.add(t);
        }
        tiersToConvert = rootTiers;
        Iterator convIt = tiersToConvert.iterator();
        TierImpl curTier = null;
        while (convIt.hasNext()) {
            curTier = (TierImpl)convIt.next();
            if (convertedTiers.contains(curTier)) continue;
            AnnotationRecreator.convertAnnotations(trans, curTier);
            convertedTiers.add(curTier);
            Vector depTiers = curTier.getDependentTiers();
            for (int i2 = 0; i2 < depTiers.size(); ++i2) {
                if (convertedTiers.contains(depTiers.get(i2))) continue;
                convertedTiers.add((TierImpl)depTiers.get(i2));
            }
        }
    }

    public static void convertAnnotations(Transcription trans, TierImpl tier) {
        if (trans == null || tier == null) {
            return;
        }
        Vector annotations = null;
        AbstractAnnotation absAnn2 = null;
        DefaultMutableTreeNode root2 = null;
        annotations = tier.getAnnotations();
        Iterator annIt = annotations.iterator();
        ArrayList<DefaultMutableTreeNode> annTreeList = new ArrayList<DefaultMutableTreeNode>(annotations.size());
        while (annIt.hasNext()) {
            absAnn2 = (AbstractAnnotation)annIt.next();
            root2 = AnnotationRecreator.createTreeForAnnotation(absAnn2);
            annTreeList.add(root2);
        }
        for (AbstractAnnotation absAnn2 : annotations) {
            tier.removeAnnotation(absAnn2);
        }
        for (DefaultMutableTreeNode root2 : annTreeList) {
            AnnotationRecreator.createAnnotationFromTree(trans, root2);
        }
    }

    public static DefaultMutableTreeNode createTreeForAnnotation(AbstractAnnotation aa) {
        DefaultMutableTreeNode root = null;
        root = aa instanceof SVGAlignableAnnotation ? new DefaultMutableTreeNode(new SVGAnnotationDataRecord((SVGAlignableAnnotation)aa)) : new DefaultMutableTreeNode(new AnnotationDataRecord(aa));
        ArrayList children = null;
        AbstractAnnotation next = null;
        AbstractAnnotation parent = null;
        DefaultMutableTreeNode nextNode = null;
        DefaultMutableTreeNode parentNode = root;
        TierImpl tier = null;
        String tierName = null;
        DefaultMutableTreeNode tempNode = null;
        AnnotationDataRecord dataRecord = null;
        children = aa.getParentListeners();
        if (children.size() > 0) {
            block0: for (int i = 0; i < children.size(); ++i) {
                next = (AbstractAnnotation)children.get(i);
                nextNode = next instanceof SVGAlignableAnnotation ? new DefaultMutableTreeNode(new SVGAnnotationDataRecord((SVGAlignableAnnotation)next)) : new DefaultMutableTreeNode(new AnnotationDataRecord(next));
                tier = (TierImpl)next.getTier();
                if (parentNode.getChildCount() == 0) {
                    parentNode.add(nextNode);
                } else {
                    long bt = next.getBeginTimeBoundary();
                    for (int k = 0; k < parentNode.getChildCount(); ++k) {
                        tempNode = (DefaultMutableTreeNode)parentNode.getChildAt(k);
                        dataRecord = (AnnotationDataRecord)tempNode.getUserObject();
                        tierName = next.getTier().getName();
                        if (dataRecord.getBeginTime() > bt && tierName != null && dataRecord.getTierName().equals(tierName)) {
                            parentNode.insert(nextNode, k);
                            break;
                        }
                        if (k != parentNode.getChildCount() - 1) continue;
                        parentNode.add(nextNode);
                    }
                }
                if (next.getParentListeners().size() > 0) {
                    children = next.getParentListeners();
                    parentNode = nextNode;
                    i = -1;
                    continue;
                }
                if (i != children.size() - 1) continue;
                while ((parent = (AbstractAnnotation)next.getParentAnnotation()) != null) {
                    parentNode = (DefaultMutableTreeNode)nextNode.getParent();
                    children = parent.getParentListeners();
                    int j = children.indexOf(next);
                    if (j == children.size() - 1) {
                        if (parent == aa) break block0;
                        next = parent;
                        nextNode = parentNode;
                        continue;
                    }
                    i = j;
                    continue block0;
                }
                break block0;
            }
        }
        return root;
    }

    public static DefaultMutableTreeNode createNodeForAnnotation(AbstractAnnotation aa) {
        DefaultMutableTreeNode node = null;
        node = aa instanceof SVGAlignableAnnotation ? new DefaultMutableTreeNode(new SVGAnnotationDataRecord((SVGAlignableAnnotation)aa)) : new DefaultMutableTreeNode(new AnnotationDataRecord(aa));
        return node;
    }

    public static AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root) {
        return AnnotationRecreator.createAnnotationFromTree(trans, root, false);
    }

    public static AbstractAnnotation createAnnotationFromTree(Transcription trans, DefaultMutableTreeNode root, boolean includeID) {
        long end;
        long begin;
        DefaultMutableTreeNode node;
        if (trans == null || root == null) {
            return null;
        }
        AbstractAnnotation annotation = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        while (en.hasMoreElements()) {
            AlignableAnnotation curAnn;
            aa = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (!tier.isTimeAlignable() || !annData.isBeginTimeAligned()) continue;
            begin = annData.getBeginTime();
            end = annData.getEndTime();
            if (!annData.isEndTimeAligned() && end == begin) {
                ++end;
            }
            aa = !annData.isEndTimeAligned() && tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().supportsInsertion() ? ((curAnn = (AlignableAnnotation)tier.getAnnotationAtTime(annData.getBeginTime())) != null && curAnn.getBeginTimeBoundary() == annData.getBeginTime() ? (AlignableAnnotation)tier.createAnnotationBefore(curAnn) : (AlignableAnnotation)tier.createAnnotation(begin, end)) : (AlignableAnnotation)tier.createAnnotation(begin, end);
            if (node == root) {
                annotation = aa;
            }
            if (aa != null) {
                aa.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    aa.setExtRef(annData.getExtRef());
                }
                if (includeID) {
                    aa.setId(annData.getId());
                }
                if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                if (svgRec.getShape() != null) {
                    ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                }
                if (svgRec.getSvgElementId() == null) continue;
                ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                continue;
            }
            LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime() + " et: " + annData.getEndTime());
        }
        en = root.breadthFirstEnumeration();
        Annotation prevAnn = null;
        while (en.hasMoreElements()) {
            aa = null;
            an = null;
            ra = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals(annData.getTierName()) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        end = annData.getEndTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, end);
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (node == root) {
                        annotation = aa;
                    }
                    if (aa != null) {
                        aa.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            aa.setExtRef(annData.getExtRef());
                        }
                        if (includeID) {
                            aa.setId(annData.getId());
                        }
                        if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() == null) continue;
                        ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                        continue;
                    }
                    LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    an = tier.getAnnotationAtTime(begin);
                    ra = an != null ? (an.getBeginTimeBoundary() == begin ? (RefAnnotation)tier.createAnnotationBefore(an) : (RefAnnotation)tier.createAnnotationAfter(an)) : (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (node == root) {
                    annotation = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        ra.setExtRef(annData.getExtRef());
                    }
                    if (!includeID) continue;
                    ra.setId(annData.getId());
                    continue;
                }
                LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (node == root) {
                annotation = ra;
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    ra.setExtRef(annData.getExtRef());
                }
                if (!includeID) continue;
                ra.setId(annData.getId());
                continue;
            }
            LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
        return annotation;
    }

    public static void createAnnotationsSequentially(Transcription trans, ArrayList annotationsNodes) {
        AnnotationRecreator.createAnnotationsSequentially(trans, annotationsNodes, false);
    }

    public static void createAnnotationsSequentially(Transcription trans, ArrayList annotationsNodes, boolean includeId) {
        DefaultMutableTreeNode node;
        int i;
        if (trans == null || annotationsNodes == null || annotationsNodes.size() == 0) {
            return;
        }
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        LinguisticType linType = null;
        for (i = 0; i < annotationsNodes.size(); ++i) {
            node = (DefaultMutableTreeNode)annotationsNodes.get(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            if (!annData.isBeginTimeAligned()) continue;
            AnnotationRecreator.createAnnotationFromTree(trans, node, includeId);
        }
        block1: for (i = 0; i < annotationsNodes.size(); ++i) {
            node = (DefaultMutableTreeNode)annotationsNodes.get(i);
            annData = (AnnotationDataRecord)node.getUserObject();
            if (annData.isBeginTimeAligned()) continue;
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            linType = tier.getLinguisticType();
            if (linType.getConstraints() != null && linType.getConstraints().getStereoType() == 4) {
                AnnotationRecreator.createAnnotationFromTree(trans, node, includeId);
                continue;
            }
            TierImpl parentTier = (TierImpl)tier.getParentTier();
            AbstractAnnotation parentAnn = (AbstractAnnotation)parentTier.getAnnotationAtTime(annData.getBeginTime());
            if (parentAnn == null) {
                LOG.severe("Cannot recreate annotations: parent annotation does not exist.");
                continue;
            }
            DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode("parent");
            parentNode.add(node);
            while (i < annotationsNodes.size()) {
                node = (DefaultMutableTreeNode)annotationsNodes.get(i);
                annData = (AnnotationDataRecord)node.getUserObject();
                if (parentTier.getAnnotationAtTime(annData.getBeginTime()) == parentAnn && !annData.isBeginTimeAligned()) {
                    parentNode.add(node);
                    if (i == annotationsNodes.size() - 1) {
                        AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, includeId);
                    }
                } else {
                    AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, includeId);
                    --i;
                    continue block1;
                }
                ++i;
            }
        }
    }

    static void createChildAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode parentNode) {
        AnnotationRecreator.createChildAnnotationsSkipRoot(trans, parentNode, false);
    }

    static void createChildAnnotationsSkipRoot(Transcription trans, DefaultMutableTreeNode parentNode, boolean includeId) {
        if (trans == null || parentNode == null || parentNode.getChildCount() == 0) {
            return;
        }
        Annotation prevAnn = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        Enumeration<TreeNode> en = parentNode.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            long begin;
            aa = null;
            an = null;
            ra = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            annData = (AnnotationDataRecord)node.getUserObject();
            tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                continue;
            }
            if (tier.isTimeAlignable()) {
                if (!annData.isBeginTimeAligned()) {
                    if (!(prevAnn == null || prevAnn.getTier().getName().equals(annData.getTierName()) && prevAnn.getEndTimeBoundary() > annData.getBeginTime())) {
                        prevAnn = null;
                    }
                    if (prevAnn == null) {
                        begin = annData.getBeginTime();
                        an = tier.getAnnotationAtTime(begin);
                        if (an != null) {
                            aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                            prevAnn = aa;
                        } else {
                            aa = (AlignableAnnotation)tier.createAnnotation(begin, annData.getEndTime());
                            prevAnn = aa;
                        }
                    } else {
                        aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                        prevAnn = aa;
                    }
                    if (aa != null) {
                        aa.setValue(annData.getValue());
                        if (annData.getExtRef() != null) {
                            aa.setExtRef(annData.getExtRef());
                        }
                        if (includeId) {
                            aa.setId(annData.getId());
                        }
                        if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                        SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                        if (svgRec.getShape() != null) {
                            ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                        }
                        if (svgRec.getSvgElementId() == null) continue;
                        ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                        continue;
                    }
                    LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                    continue;
                }
                prevAnn = null;
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        ra.setExtRef(annData.getExtRef());
                    }
                    if (!includeId) continue;
                    ra.setId(annData.getId());
                    continue;
                }
                LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    ra.setExtRef(annData.getExtRef());
                }
                if (!includeId) continue;
                ra.setId(annData.getId());
                continue;
            }
            LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
    }

    public static void createAnnotationsSequentiallyDepthless(Transcription trans, ArrayList annotationsRecords) {
        AnnotationRecreator.createAnnotationsSequentiallyDepthless(trans, annotationsRecords, false);
    }

    public static void createAnnotationsSequentiallyDepthless(Transcription trans, ArrayList annotationsRecords, boolean includeId) {
        if (trans == null || annotationsRecords == null || annotationsRecords.size() == 0) {
            return;
        }
        ArrayList siblingList = null;
        for (int i = 0; i < annotationsRecords.size(); ++i) {
            siblingList = (ArrayList)annotationsRecords.get(i);
            AnnotationRecreator.createSiblingAnnotations(trans, siblingList, includeId);
        }
    }

    static void createSiblingAnnotations(Transcription trans, ArrayList siblings, boolean includeId) {
        if (trans == null || siblings == null || siblings.size() == 0) {
            return;
        }
        AbstractAnnotation prevAnn = null;
        AlignableAnnotation aa = null;
        RefAnnotation ra = null;
        Annotation an = null;
        AnnotationDataRecord annData = null;
        TierImpl tier = null;
        int linStereoType = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            long begin;
            aa = null;
            an = null;
            ra = null;
            annData = (AnnotationDataRecord)siblings.get(i);
            if (tier == null) {
                tier = (TierImpl)trans.getTierWithId(annData.getTierName());
            }
            if (tier == null) {
                LOG.severe("Cannot recreate annotations: tier does not exist.");
                return;
            }
            if (tier.isTimeAlignable()) {
                if (annData.isBeginTimeAligned()) {
                    prevAnn = aa = (AlignableAnnotation)tier.createAnnotation(annData.getBeginTime(), annData.getEndTime());
                } else if (prevAnn == null) {
                    begin = annData.getBeginTime();
                    an = tier.getAnnotationAtTime(begin);
                    if (an != null) {
                        prevAnn = aa = (AlignableAnnotation)tier.createAnnotationAfter(an);
                    }
                } else {
                    prevAnn = aa = (AlignableAnnotation)tier.createAnnotationAfter(prevAnn);
                }
                if (aa != null) {
                    aa.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        aa.setExtRef(annData.getExtRef());
                    }
                    if (includeId) {
                        aa.setId(annData.getId());
                    }
                    if (!(aa instanceof SVGAlignableAnnotation) || !(annData instanceof SVGAnnotationDataRecord)) continue;
                    SVGAnnotationDataRecord svgRec = (SVGAnnotationDataRecord)annData;
                    if (svgRec.getShape() != null) {
                        ((SVGAlignableAnnotation)aa).setShape(svgRec.getShape());
                    }
                    if (svgRec.getSvgElementId() == null) continue;
                    ((SVGAlignableAnnotation)aa).setSVGElementID(svgRec.getSvgElementId());
                    continue;
                }
                LOG.severe("Alignable annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            linStereoType = tier.getLinguisticType().getConstraints().getStereoType();
            if (linStereoType == 3) {
                begin = annData.getBeginTime();
                if (prevAnn != null && !prevAnn.getTier().getName().equals(annData.getTierName())) {
                    prevAnn = null;
                }
                if (prevAnn != null && prevAnn.getEndTimeBoundary() < begin + 1L) {
                    prevAnn = null;
                }
                if (prevAnn == null) {
                    ra = (RefAnnotation)tier.createAnnotation(begin, begin);
                    prevAnn = ra;
                } else {
                    ra = (RefAnnotation)tier.createAnnotationAfter(prevAnn);
                    prevAnn = ra;
                }
                if (ra != null) {
                    ra.setValue(annData.getValue());
                    if (annData.getExtRef() != null) {
                        ra.setExtRef(annData.getExtRef());
                    }
                    if (!includeId) continue;
                    ra.setId(annData.getId());
                    continue;
                }
                LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
                continue;
            }
            if (linStereoType != 4) continue;
            begin = annData.getBeginTime();
            an = tier.getAnnotationAtTime(begin);
            if (an == null) {
                ra = (RefAnnotation)tier.createAnnotation(begin, begin);
            }
            if (ra != null) {
                ra.setValue(annData.getValue());
                if (annData.getExtRef() != null) {
                    ra.setExtRef(annData.getExtRef());
                }
                if (!includeId) continue;
                ra.setId(annData.getId());
                continue;
            }
            LOG.severe("Reference annotation could not be recreated: " + annData.getValue() + " bt: " + annData.getBeginTime());
        }
    }

    public static ArrayList storeGraphicsData(Transcription transcription, LinguisticType type) {
        if (transcription == null || type == null) {
            return null;
        }
        ArrayList storedGraphics = new ArrayList();
        Vector tiers = null;
        tiers = transcription.getTiersWithLinguisticType(type.getLinguisticTypeName());
        for (int i = 0; i < tiers.size(); ++i) {
            TierImpl curTier = (TierImpl)tiers.get(i);
            ArrayList temp = AnnotationRecreator.storeGraphicsData(transcription, curTier);
            if (temp == null) continue;
            storedGraphics.addAll(temp);
        }
        return storedGraphics;
    }

    public static ArrayList storeGraphicsData(Transcription transcription, TierImpl tier) {
        if (transcription == null || tier == null) {
            return null;
        }
        ArrayList<SVGAnnotationDataRecord> dataRecords = new ArrayList<SVGAnnotationDataRecord>();
        if (!tier.isTimeAlignable()) {
            return dataRecords;
        }
        Vector annos = tier.getAnnotations();
        for (int i = 0; i < annos.size(); ++i) {
            SVGAlignableAnnotation svgAa;
            Annotation aa = (Annotation)annos.get(i);
            if (!(aa instanceof SVGAlignableAnnotation) || (svgAa = (SVGAlignableAnnotation)aa).getShape() == null) continue;
            dataRecords.add(new SVGAnnotationDataRecord(svgAa));
        }
        return dataRecords;
    }

    public static void restoreGraphicsData(Transcription transcription, ArrayList graphicsDataRecords) {
        if (transcription == null || graphicsDataRecords == null) {
            return;
        }
        for (int i = 0; i < graphicsDataRecords.size(); ++i) {
            SVGAnnotationDataRecord record = (SVGAnnotationDataRecord)graphicsDataRecords.get(i);
            String tierName = record.getTierName();
            TierImpl curTier = (TierImpl)transcription.getTierWithId(tierName);
            Annotation aa = curTier.getAnnotationAtTime(record.getBeginTime());
            if (!(aa instanceof SVGAlignableAnnotation)) continue;
            SVGAlignableAnnotation svgAa = (SVGAlignableAnnotation)aa;
            svgAa.setShape(record.getShape());
            svgAa.setSVGElementID(record.getSvgElementId());
        }
    }
}

