/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FileUtility {
    public static String pathToURLString(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).startsWith("rtsp:")) {
            return path;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        int n = 0;
        while (path.charAt(0) == '/') {
            path = path.substring(1);
            ++n;
        }
        if (n == 2) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    public static boolean sameNameIgnoreExtension(String path1, String path2) {
        int extensionPos;
        if (path1 == null || path2 == null) {
            return false;
        }
        String name1 = path1 = path1.replace('\\', '/');
        int delimiterPos = path1.lastIndexOf(47);
        if (delimiterPos >= 0) {
            name1 = path1.substring(delimiterPos + 1);
        }
        if ((extensionPos = name1.lastIndexOf(46)) >= 0) {
            name1 = name1.substring(0, extensionPos);
        }
        String name2 = path2 = path2.replace('\\', '/');
        delimiterPos = path2.lastIndexOf(47);
        if (delimiterPos >= 0) {
            name2 = path2.substring(delimiterPos + 1);
        }
        if ((extensionPos = name2.lastIndexOf(46)) >= 0) {
            name2 = name2.substring(0, extensionPos);
        }
        return name1.equals(name2);
    }

    public static String fileNameFromPath(String path) {
        if (path == null) {
            return null;
        }
        String name = path.replace('\\', '/');
        int delimiterPos = name.lastIndexOf(47);
        if (delimiterPos >= 0) {
            name = name.substring(delimiterPos + 1);
        }
        return name;
    }

    public static boolean fileExists(String path) {
        File file;
        if (path == null) {
            return false;
        }
        int colonPos = path.indexOf(58);
        String fileName = path;
        if (colonPos > -1) {
            fileName = path.substring(colonPos + 1);
        }
        return (file = new File(fileName = fileName.replace('\\', '/'))).exists();
    }

    public static final String getExtenstion(File f) {
        String name = f.getName();
        int li = name.lastIndexOf(".");
        return li == -1 ? null : name.substring(li + 1);
    }

    public void copyToDir(File sourceFile, File destDir) throws Exception {
        int len;
        byte[] buffer = new byte[4096];
        destDir.mkdirs();
        File destFile = new File(destDir, sourceFile.getName());
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public static void copyToFile(File sourceFile, File destFile) throws Exception {
        int len;
        byte[] buffer = new byte[4096];
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile);
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.close();
        in.close();
    }

    public static String urlToAbsPath(String filename) {
        if (filename == null) {
            return filename;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
        }
        return filename;
    }

    public static String getRelativePath(String referenceFilename, String resourceFilename) {
        int i;
        if (referenceFilename == null || resourceFilename == null) {
            return resourceFilename;
        }
        if (resourceFilename.startsWith("../") || resourceFilename.startsWith("./")) {
            return resourceFilename;
        }
        String[] refFields = FileUtility.urlToAbsPath(referenceFilename).split("/");
        String[] resourceFields = FileUtility.urlToAbsPath(resourceFilename).split("/");
        int refFieldsLen = refFields.length;
        int resourceFieldsLen = resourceFields.length;
        int minFieldsLen = refFieldsLen;
        if (resourceFieldsLen < refFieldsLen) {
            minFieldsLen = resourceFieldsLen;
        }
        for (i = 0; i < minFieldsLen && refFields[i].equals(resourceFields[i]); ++i) {
        }
        int restIndex = i;
        StringBuffer relPathBuf = new StringBuffer();
        if (i == refFieldsLen - 1) {
            relPathBuf.append("./");
        }
        while (i < refFieldsLen - 1) {
            relPathBuf.append("../");
            ++i;
        }
        for (i = restIndex; i < resourceFieldsLen - 1; ++i) {
            relPathBuf.append(resourceFields[i] + "/");
        }
        relPathBuf.append(resourceFields[i]);
        return relPathBuf.toString();
    }

    public static String getAbsolutePath(String referenceFilename, String resourceFilename) {
        if (referenceFilename == null || resourceFilename == null) {
            return resourceFilename;
        }
        if (resourceFilename.startsWith("../") || resourceFilename.startsWith("./")) {
            int i;
            String[] refFields = FileUtility.urlToAbsPath(referenceFilename).split("/");
            String[] resourceFields = FileUtility.urlToAbsPath(resourceFilename).split("/");
            int refFieldsLen = refFields.length;
            int resourceFieldsLen = resourceFields.length;
            int minFieldsLen = refFieldsLen;
            if (resourceFieldsLen < refFieldsLen) {
                minFieldsLen = resourceFieldsLen;
            }
            for (i = 0; i < resourceFieldsLen && resourceFields[i].equalsIgnoreCase(".."); ++i) {
            }
            int refBaseIndex = i;
            StringBuffer absPathBuf = new StringBuffer();
            for (int s = 0; s < refFieldsLen - refBaseIndex - 1; ++s) {
                absPathBuf.append(refFields[s] + "/");
            }
            if (resourceFilename.startsWith("./")) {
                i = 1;
            }
            while (i < resourceFieldsLen - 1) {
                absPathBuf.append(resourceFields[i] + "/");
                ++i;
            }
            absPathBuf.append(resourceFields[i]);
            return absPathBuf.toString();
        }
        return resourceFilename;
    }
}

