/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.util.StringUtil;

public final class SystemInstallationSecurity {
    private static SystemInstallationSecurity _singleton = null;
    private static boolean _done = false;
    private static boolean restartIsNecessary = false;
    private static final Logger LOG = Logger.getLogger(SystemInstallationSecurity.class.getName());

    private SystemInstallationSecurity() {
    }

    private final void verifyLibExt() throws Exception {
        int ii;
        if (_done) {
            return;
        }
        File extDir = SystemReporting.getLibExtDir();
        if (extDir == null || !extDir.exists()) {
            System.out.println("Extension directory does not exist");
            return;
        }
        String thelibextString = extDir.toString().toUpperCase();
        LOG.info("verifying lib/ext " + thelibextString);
        System.setSecurityManager(null);
        String[] snoopString = new String[40];
        String[] acceptString = new String[40];
        int NOFsnoop = 0;
        int NOFaccept = 0;
        for (int ii2 = 0; ii2 < 10; ++ii2) {
            snoopString[ii2] = System.getProperty("SIS.snoop." + ii2);
            acceptString[ii2] = System.getProperty("SIS.accept." + ii2);
            if (snoopString[ii2] != null) {
                NOFsnoop = ii2 + 1;
            }
            if (acceptString[ii2] == null) continue;
            NOFaccept = ii2 + 1;
        }
        if (NOFsnoop == 0) {
            return;
        }
        File[] potext = SystemReporting.getLibExt();
        int NOFfiles = potext == null ? 0 : potext.length;
        HashSet<String> goodFiles = new HashSet<String>();
        if (System.getProperty("java.version").startsWith("1.4") && SystemReporting.OS_NAME.startsWith("Windows")) {
            System.out.println("\taccepting Java 1.4 Win32 files");
            goodFiles.add("dnsns.jar");
            goodFiles.add("ldapsec.jar");
            goodFiles.add("localedata.jar");
            goodFiles.add("sunjce_provider.jar");
        } else if (SystemReporting.OS_NAME.startsWith("Mac")) {
            goodFiles.add(".DS_Store");
        }
        for (ii = 0; ii < NOFaccept; ++ii) {
            goodFiles.add(acceptString[ii]);
            LOG.info("\taccepting (" + acceptString[ii] + ")");
        }
        for (ii = 0; ii < NOFsnoop; ++ii) {
            boolean found = false;
            LOG.info("snooping " + snoopString[ii] + " ...");
            URL url = this.getClass().getResource(snoopString[ii]);
            if (url == null) {
                LOG.warning("cannot snoop " + snoopString[ii]);
                continue;
            }
            String filename = url.getFile();
            filename = StringUtil.replace((String)filename, (String)("!" + snoopString[ii]), (String)"");
            filename = StringUtil.replace((String)filename, (String)"file:", (String)"");
            filename = StringUtil.replace((String)filename, (String)"%20", (String)" ");
            File source = new File(filename);
            String parentOfSource = source.getParent();
            parentOfSource = StringUtil.replace((String)parentOfSource, (String)"%20", (String)" ");
            boolean fromlibext = (parentOfSource = parentOfSource.toUpperCase()).equals(thelibextString);
            if (fromlibext) {
                goodFiles.add(source.getName());
                LOG.info("...found");
                continue;
            }
            if (source.getName().startsWith("RM")) {
                restartIsNecessary = true;
                try {
                    File destFile = new File(extDir, source.getName().substring(2));
                    FileUtility.copyToFile(source, destFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                File copy = new File(extDir, source.getName().substring(2));
                if (copy.exists()) {
                    goodFiles.add(copy.getName());
                    LOG.info("...copied (" + copy + ")");
                    continue;
                }
                LOG.warning("  FAILURE to copy (" + copy + ")");
                continue;
            }
            LOG.warning(source + " does not start with RM !!!!");
        }
        String badfiles = "";
        for (int i = 0; i < NOFfiles; ++i) {
            String fn = potext[i].getName();
            LOG.info("\t verify (" + fn + ")");
            if (goodFiles.contains(fn)) continue;
            if (fn.startsWith("nl.mpi.")) {
                File deleteme = new File(extDir, fn);
                FileWriter out = new FileWriter(deleteme);
                if (deleteme.canWrite()) {
                    LOG.info("can write to " + deleteme);
                } else {
                    LOG.info("CAN'T write to " + deleteme);
                }
                try {
                    out.write(120);
                }
                catch (Exception ioe) {
                    LOG.warning("FAILURE to access (" + deleteme + ")\nContact your administrator");
                }
                out.flush();
                out.close();
                continue;
            }
            badfiles = badfiles + "\n  " + fn;
        }
        if (badfiles.length() != 0) {
            LOG.warning("WARNING: your java environment contains unknown files that can effect proper functioning of the MPI-tools.\nDirectory is: " + SystemReporting.getLibExtDir() + "\nfiles are: " + badfiles);
        }
        if (restartIsNecessary) {
            JOptionPane.showMessageDialog(null, "Start the tool again to enable Unicode input methods", "", 0);
            restartIsNecessary = false;
        }
        _done = true;
    }

    public static final SystemInstallationSecurity Instance() {
        if (_singleton == null) {
            _singleton = new SystemInstallationSecurity();
        }
        return _singleton;
    }

    public final void go() {
        try {
            this.verifyLibExt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] a) {
        SystemInstallationSecurity sis = SystemInstallationSecurity.Instance();
    }
}

