/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.Color;
import mpi.eudico.client.annotator.util.Tier2D;
import mpi.eudico.server.corpora.clom.Annotation;

public class Tag2D {
    private Annotation annotation;
    private Tier2D tier2d;
    private String truncatedValue;
    private int x;
    private int width;
    private boolean isTruncated = false;
    private Color color;

    public Tag2D(Annotation annotation) {
        this.annotation = annotation;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setTier2D(Tier2D tier2d) {
        this.tier2d = tier2d;
    }

    public Tier2D getTier2D() {
        return this.tier2d;
    }

    public String getValue() {
        if (this.annotation != null) {
            return this.annotation.getValue();
        }
        return null;
    }

    public String getTruncatedValue() {
        if (this.truncatedValue != null) {
            return this.truncatedValue;
        }
        return "";
    }

    public void setTruncatedValue(String truncatedValue) {
        this.truncatedValue = truncatedValue;
        this.isTruncated = this.annotation == null || truncatedValue == null || this.annotation.getValue() == null ? false : truncatedValue.length() < this.annotation.getValue().length();
    }

    public long getBeginTime() {
        if (this.annotation != null) {
            return this.annotation.getBeginTimeBoundary();
        }
        return 0L;
    }

    public long getEndTime() {
        if (this.annotation != null) {
            return this.annotation.getEndTimeBoundary();
        }
        return 0L;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

