/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.util.AnnotationTreeDataFlavor;

public class TransferableAnnotationTree
implements Transferable,
ClipboardOwner {
    private DefaultMutableTreeNode node;
    private static final DataFlavor[] flavors = new DataFlavor[]{AnnotationTreeDataFlavor.getInstance()};

    public TransferableAnnotationTree(DefaultMutableTreeNode node) {
        if (node == null) {
            throw new NullPointerException("Annotation TreeNode is null.");
        }
        this.node = node;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == null) {
            return false;
        }
        return flavor.equals(flavors[0]);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.node;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.node = null;
    }
}

