/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.util.Tier2D;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSize;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSizeContainer;
import mpi.eudico.server.corpora.clomimpl.shoebox.SBLayout;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class InterlinearViewer
extends AbstractViewer
implements ComponentListener,
MouseMotionListener,
MouseListener,
MouseWheelListener,
MultiTierViewer,
AdjustmentListener,
ActionListener,
KeyListener,
ACMEditListener {
    private Transcription transcription = null;
    private SBLayout sbl = null;
    protected int pixelsForTierHeight;
    protected int pixelsForTierHeightMargin;
    private BufferedImage bi;
    private Graphics2D g2d;
    private FontMetrics currentMetrics;
    private BasicStroke stroke;
    private JButton prevButton;
    private JButton nextButton;
    private JPopupMenu popup;
    private ButtonGroup fontSizeBG;
    private JMenu fontMenu;
    private Font font;
    private HashMap prefTierFonts;
    private JMenuItem newAnnoMI;
    private JMenuItem newAnnoBeforeMI;
    private JMenuItem newAnnoAfterMI;
    private JMenuItem modifyAnnoMI;
    private JMenuItem deleteAnnoMI;
    private JMenuItem activeTierMI;
    private JMenuItem deleteTierMI;
    private JMenuItem changeTierMI;
    private long selSTime;
    private long selETime;
    private long curSTime = -1L;
    private long curETime;
    private SBTime curSBSelection = null;
    private SBTime cursorTag = null;
    private Annotation refAnnotation = null;
    private Annotation activeAnnotation = null;
    private int imageWidth = 1200;
    private int imageHeight = 380;
    private final int HOR_TAG_GAP = 20;
    private final int VER_MARGIN;
    private final int HOR_TAG_SURPLUS = 5;
    private final int MIN_TAG_SIZE = 15;
    private Vector _vTiers = new Vector();
    private ArrayList allTiers;
    private int currentSegmentWidth;
    private int MAX_BUF_WIDTH = 3000;
    private ArrayList visibleTiers;
    private JPanel buttonPanel;
    private JScrollBar vScrollBar;
    private JScrollBar hScrollBar;
    private final int defBarWidth;
    private int horizontalScrollOffset;
    private int verticalScrollOffset;
    private MultiTierControlPanel multiTierControlPanel;
    private int[] tierYPositions;
    private boolean showEmptySlots;
    private long rightClickTime;
    private int rightClickTierIndex;
    private Tier2D rightClickTier;
    private SBTime rightClickTag;
    private InlineEditBox editBox;
    private boolean deselectCommits = false;

    public InterlinearViewer(Transcription transcription) {
        this.transcription = transcription;
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.currentMetrics = this.getFontMetrics(this.font);
        this.prefTierFonts = new HashMap();
        this.pixelsForTierHeight = this.getFont().getSize() + 24;
        this.pixelsForTierHeightMargin = 2;
        this.stroke = new BasicStroke();
        this.initTiers();
        this.sbl = new SBLayout(transcription);
        this.sbl.getSegOrder();
        this.sbl.getPrevRef();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        this.defBarWidth = this.getDefaultBarWidth();
        this.hScrollBar = new JScrollBar(0, 0, 10, 0, this.imageWidth);
        this.hScrollBar.setUnitIncrement(10);
        this.hScrollBar.setBlockIncrement(50);
        this.hScrollBar.addAdjustmentListener(this);
        this.vScrollBar = new JScrollBar(1, 0, 10, 0, this.imageHeight);
        this.vScrollBar.setUnitIncrement(this.pixelsForTierHeight / 2);
        this.vScrollBar.setBlockIncrement(this.pixelsForTierHeight);
        this.vScrollBar.addAdjustmentListener(this);
        this.setLayout(null);
        this.add(this.hScrollBar);
        this.add(this.vScrollBar);
        this.buttonPanel = this.createButtonPanel();
        this.add(this.buttonPanel);
        this.VER_MARGIN = this.buttonPanel.getPreferredSize() != null ? this.buttonPanel.getPreferredSize().height : 32;
        this.horizontalScrollOffset = 0;
        this.verticalScrollOffset = 0;
        this.editBox = new InlineEditBox(true);
        this.editBox.setVisible(false);
        this.add(this.editBox);
        this.extractCurrentSegment();
    }

    private int getDefaultBarWidth() {
        int width = 20;
        if (UIManager.getDefaults().get("ScrollBar.width") != null) {
            width = (Integer)UIManager.getDefaults().get("ScrollBar.width");
        }
        return width;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setFocusable(false);
        this.prevButton = new JButton();
        this.prevButton.setText(ElanLocale.getString("InterlinearViewer.PrevButton.Text"));
        this.prevButton.setToolTipText(ElanLocale.getString("InterlinearViewer.PrevButton.Tooltip"));
        this.prevButton.setActionCommand("prev");
        this.prevButton.addActionListener(this);
        this.prevButton.setFocusable(false);
        this.nextButton = new JButton();
        this.nextButton.setText(ElanLocale.getString("InterlinearViewer.NextButton.Text"));
        this.nextButton.setToolTipText(ElanLocale.getString("InterlinearViewer.NextButton.Tooltip"));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        this.nextButton.setFocusable(false);
        Insets inset = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = inset;
        panel.add((Component)this.prevButton, gbc);
        gbc.gridx = 1;
        panel.add((Component)this.nextButton, gbc);
        JPanel spacer = new JPanel();
        spacer.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        spacer.setFocusable(false);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)spacer, gbc);
        int w = Toolkit.getDefaultToolkit().getScreenSize().width;
        panel.setPreferredSize(new Dimension(w, this.prevButton.getPreferredSize().height + 4));
        panel.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        panel.setBorder(BorderFactory.createLineBorder(Constants.SELECTIONCOLOR));
        return panel;
    }

    private void initTiers() {
        this.allTiers = new ArrayList(10);
        this.visibleTiers = new ArrayList(10);
        for (TierImpl tier : this.transcription.getTiers()) {
            Tier2D tier2d = new Tier2D(tier);
            this.allTiers.add(tier2d);
        }
        this.tierYPositions = new int[this.allTiers.size()];
    }

    private void extractCurrentSegment() {
        this.dismissEditBox();
        this.cursorTag = null;
        this._vTiers = new Vector(20);
        if (this.allTiers.size() <= 0 || !this.sbl.isRefAnnAvailable()) {
            this.buildLayout();
            return;
        }
        AnnotationSize as = null;
        if (this.prefTierFonts.size() > 0) {
            HashMap metricsMap = new HashMap(this.prefTierFonts.size());
            for (Object key : this.prefTierFonts.keySet()) {
                Font tf = (Font)this.prefTierFonts.get(key);
                if (tf == null) continue;
                metricsMap.put(key, this.getFontMetrics(tf));
            }
            as = new AnnotationSize(this.transcription, this.sbl.getRefAnn(), this.currentMetrics, metricsMap);
        } else {
            as = new AnnotationSize(this.transcription, this.sbl.getRefAnn(), this.currentMetrics);
        }
        Vector segTiers = as.getTiers();
        int segWidth = 0;
        Iterator tierIt = this.visibleTiers.iterator();
        Font tf = null;
        FontMetrics tfm = null;
        int yPos = this.VER_MARGIN;
        int xPos = 0;
        long time = -1L;
        while (tierIt.hasNext()) {
            TierImpl tier = ((Tier2D)tierIt.next()).getTier();
            tf = this.getFontForTier(tier);
            tfm = this.getFontMetrics(tf);
            xPos = 0;
            boolean symbassflag = false;
            int stereo = 0;
            if (tier != null && segTiers.contains(tier)) {
                ArrayList tieranns = as.getTierLayoutInPixels(tier, tfm);
                if (tieranns == null) {
                    System.err.println("SB DRAWING ERROR!");
                    return;
                }
                Vector<SBTime> ht = new Vector<SBTime>(20);
                Rectangle rect = null;
                for (int itor = 0; itor < tieranns.size(); ++itor) {
                    AnnotationSizeContainer asc = (AnnotationSizeContainer)tieranns.get(itor);
                    Annotation a = asc.getAnnotation();
                    int tagWidth = asc.getSize() + 5;
                    if (tagWidth < 15) {
                        tagWidth = 15;
                    }
                    int tagHeight = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
                    stereo = tier.getLinguisticType().getConstraints() != null ? tier.getLinguisticType().getConstraints().getStereoType() : -1;
                    if (a == null) {
                        time = asc.getStartTime();
                        if (tier.getParentTier() == tier.getRootTier() && (stereo != 4 || symbassflag) && asc != tieranns.get(0)) {
                            time = -1L;
                        }
                        rect = new Rectangle();
                        rect.x = xPos;
                        rect.y = yPos + this.pixelsForTierHeightMargin;
                        rect.height = tagHeight;
                        rect.width = tagWidth;
                    } else {
                        rect = new Rectangle();
                        rect.x = xPos;
                        rect.y = yPos + this.pixelsForTierHeightMargin;
                        rect.height = tagHeight;
                        rect.width = tagWidth;
                    }
                    if (stereo == 4) {
                        symbassflag = true;
                    }
                    SBTime sbt = null;
                    sbt = null != a ? new SBTime(a, a.getBeginTimeBoundary(), a.getEndTimeBoundary(), rect, a.getValue()) : new SBTime(null, time, time, rect, "");
                    ht.add(sbt);
                    if (a != null && a == this.activeAnnotation) {
                        this.refAnnotation = this.sbl.getRefAnn();
                        this.cursorTag = sbt;
                    }
                    if (xPos + tagWidth > segWidth) {
                        segWidth = xPos + tagWidth;
                    }
                    xPos += tagWidth + 20;
                }
                this._vTiers.add(ht);
            } else {
                this._vTiers.add(new Vector());
            }
            yPos += this.pixelsForTierHeight;
        }
        this.currentSegmentWidth = segWidth + 20;
        this.buildLayout();
    }

    private void updateScrollBar() {
        int vValue = this.vScrollBar.getValue();
        int max = this.VER_MARGIN + this.visibleTiers.size() * this.pixelsForTierHeight;
        this.vScrollBar.setValue(0);
        this.vScrollBar.setMaximum(max);
        this.vScrollBar.setVisibleAmount(this.getHeight() - this.defBarWidth);
        if (vValue + this.getHeight() - this.defBarWidth > max) {
            vValue = max - this.getHeight() - this.defBarWidth;
        }
        this.vScrollBar.setValue(vValue);
        int hValue = this.hScrollBar.getValue();
        int hBarWidth = 2 * this.defBarWidth;
        this.hScrollBar.setValue(0);
        this.hScrollBar.setMaximum(this.currentSegmentWidth);
        this.hScrollBar.setVisibleAmount(this.getWidth() - hBarWidth);
        if (hValue + this.getWidth() - hBarWidth > this.currentSegmentWidth) {
            hValue = this.currentSegmentWidth - this.getWidth() - hBarWidth;
        }
        this.hScrollBar.setValue(hValue);
        this.vScrollBar.revalidate();
        this.hScrollBar.revalidate();
    }

    public void setVisibleTiers(Vector tiers) {
        this.visibleTiers.clear();
        Enumeration en = tiers.elements();
        block0: while (en.hasMoreElements()) {
            Tier tier = (Tier)en.nextElement();
            for (Tier2D t2d : this.allTiers) {
                if (t2d.getTier() != tier) continue;
                this.visibleTiers.add(t2d);
                continue block0;
            }
        }
        this.extractCurrentSegment();
        this.updateScrollBar();
        this.notifyMultiTierControlPanel();
    }

    public void setActiveTier(Tier tier) {
        Iterator it = this.allTiers.iterator();
        String name = tier.getName();
        while (it.hasNext()) {
            Tier2D t2d = (Tier2D)it.next();
            if (t2d.getName().equals(name)) {
                t2d.setActive(true);
                int tierIndex = this.visibleTiers.indexOf(t2d);
                int cy = tierIndex * this.pixelsForTierHeight;
                if (cy < this.verticalScrollOffset) {
                    this.vScrollBar.setValue(cy);
                    continue;
                }
                if (cy + this.pixelsForTierHeight - this.verticalScrollOffset <= this.getHeight() - this.VER_MARGIN - this.defBarWidth) continue;
                this.vScrollBar.setValue(cy + this.pixelsForTierHeight + this.VER_MARGIN + this.defBarWidth - this.getHeight());
                continue;
            }
            t2d.setActive(false);
        }
        this.buildLayout();
    }

    public void setMultiTierControlPanel(MultiTierControlPanel controller) {
        this.multiTierControlPanel = controller;
        this.notifyMultiTierControlPanel();
    }

    private void notifyMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            return;
        }
        if (this.tierYPositions.length > 0) {
            this.tierYPositions[0] = this.VER_MARGIN + this.pixelsForTierHeight / 2 - this.verticalScrollOffset;
            for (int i = 1; i < this.visibleTiers.size(); ++i) {
                this.tierYPositions[i] = this.tierYPositions[0] + i * this.pixelsForTierHeight;
            }
        }
        this.multiTierControlPanel.setTierPositions(this.tierYPositions);
    }

    public void updateSelection() {
        this.selSTime = this.getSelectionBeginTime();
        this.selETime = this.getSelectionEndTime();
        this.repaint();
    }

    public void updateActiveAnnotation() {
        this.activeAnnotation = this.getActiveAnnotation();
        this.extractCurrentSegment();
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierAdded((TierImpl)e.getModification());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierAdded((TierImpl)e.getModification());
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl)) break;
                this.tierRemoved((TierImpl)e.getModification());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierRemoved((TierImpl)e.getModification());
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                if (this.multiTierControlPanel == null) break;
                this.multiTierControlPanel.tierChanged((TierImpl)e.getInvalidatedObject());
                break;
            }
            case 3: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation)) break;
                this.annotationChanged((TierImpl)e.getInvalidatedObject(), (Annotation)e.getModification());
                this.showEditBoxForAnnotation((Annotation)e.getModification());
                if (!this.editBox.isVisible()) break;
                this.editBox.requestFocus();
                break;
            }
            case 4: 
            case 5: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation)) break;
                this.annotationChanged((TierImpl)e.getInvalidatedObject(), (Annotation)e.getModification());
                this.showEditBoxForAnnotation((Annotation)e.getModification());
                if (!this.editBox.isVisible()) break;
                this.editBox.requestFocus();
                break;
            }
            case 14: {
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                this.transcriptionChanged();
                break;
            }
            case 6: {
                if (e.getModification() instanceof Annotation) {
                    this.annotationRemoved((Annotation)e.getModification());
                    break;
                }
                if (!(e.getInvalidatedObject() instanceof Transcription)) break;
                this.transcriptionChanged();
                break;
            }
            case 7: 
            case 8: {
                Annotation a;
                if (!(e.getInvalidatedObject() instanceof Annotation) || !((a = (Annotation)e.getInvalidatedObject()).getTier() instanceof TierImpl)) break;
                this.annotationChanged((TierImpl)a.getTier(), a);
                break;
            }
        }
        if (this.multiTierControlPanel != null) {
            this.multiTierControlPanel.annotationsChanged();
        }
    }

    protected void buildLayout() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.getWidth() > this.MAX_BUF_WIDTH) {
            this.MAX_BUF_WIDTH = this.getWidth();
        }
        int width = this.currentSegmentWidth + 20;
        int height = this.VER_MARGIN + this.visibleTiers.size() * this.pixelsForTierHeight;
        if (this.imageWidth < width && width < this.MAX_BUF_WIDTH) {
            this.imageWidth = width;
        }
        if (this.imageHeight < height) {
            this.imageHeight = height;
        }
        if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
            this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.g2d = this.bi.createGraphics();
        }
        if (SystemReporting.antiAliasedText) {
            this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.g2d.setFont(this.getFont());
        this.g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.g2d.fillRect(0, 0, this.imageWidth, this.bi.getHeight());
        if (this.currentSegmentWidth > this.MAX_BUF_WIDTH) {
            this.g2d.translate(-this.horizontalScrollOffset, 0);
            block0: for (int i = 0; i < this.visibleTiers.size(); ++i) {
                Tier2D tier2d = (Tier2D)this.visibleTiers.get(i);
                if (tier2d.isActive()) {
                    this.g2d.setColor(Constants.ACTIVETIERCOLOR);
                    this.g2d.fillRect(this.horizontalScrollOffset, this.VER_MARGIN + i * this.pixelsForTierHeight, this.imageWidth, this.pixelsForTierHeight);
                }
                if (i >= this._vTiers.size()) continue;
                for (SBTime sbt : (Vector)this._vTiers.get(i)) {
                    if (sbt._rect.x + sbt._rect.width < this.horizontalScrollOffset) continue;
                    if (sbt._rect.x > this.horizontalScrollOffset + this.getWidth()) continue block0;
                    this.drawTag(this.g2d, sbt);
                }
            }
            this.g2d.translate(this.horizontalScrollOffset, 0);
        } else {
            for (int i = 0; i < this.visibleTiers.size(); ++i) {
                Tier2D tier2d = (Tier2D)this.visibleTiers.get(i);
                if (tier2d.isActive()) {
                    this.g2d.setColor(Constants.ACTIVETIERCOLOR);
                    this.g2d.fillRect(0, this.VER_MARGIN + i * this.pixelsForTierHeight, this.imageWidth, this.pixelsForTierHeight);
                }
                if (i >= this._vTiers.size()) continue;
                for (SBTime sbt : (Vector)this._vTiers.get(i)) {
                    this.drawTag(this.g2d, sbt);
                }
            }
        }
        this.repaint();
    }

    protected void drawTag(Graphics2D g, SBTime tag) {
        if (tag != null) {
            if (tag.annotation != null && tag.value.length() == 0) {
                g.setColor(Color.gray);
                g.draw(tag._rect);
            }
            g.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            if (tag.annotation != null) {
                g.setFont(this.getFontForTier(tag.annotation.getTier()));
            }
            g.drawString(tag.value, tag._rect.x, tag._rect.y + tag._rect.height / 2 + this.getFont().getSize() / 2);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g2.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentSegmentWidth > this.MAX_BUF_WIDTH) {
            g2.translate(0, -this.verticalScrollOffset);
        } else {
            g2.translate(-this.horizontalScrollOffset, -this.verticalScrollOffset);
        }
        if (this.bi == null) {
            return;
        }
        g2.drawImage((Image)this.bi, 0, 0, this);
        if (this.currentSegmentWidth > this.MAX_BUF_WIDTH) {
            g2.translate(-this.horizontalScrollOffset, 0);
        }
        if (this.selSTime != this.selETime) {
            this.paintSelectionMarker(g2);
        }
        if (!this.playerIsPlaying()) {
            this.paintMediaTimeMarker(g2);
            if (this.showEmptySlots) {
                for (int i = 0; i < this.visibleTiers.size(); ++i) {
                    TierImpl ti = ((Tier2D)this.visibleTiers.get(i)).getTier();
                    if (ti.getParentTier() == null || ti.isTimeAlignable()) continue;
                    this.paintEmptySlots(g2, ti, i);
                }
            }
        }
        if (this.cursorTag != null && this.sbl.getRefAnn() == this.refAnnotation) {
            g2.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            g2.draw(this.cursorTag._rect);
        }
        g2.translate(this.horizontalScrollOffset, this.verticalScrollOffset);
    }

    private void paintSelectionMarker(Graphics2D g2) {
        Enumeration enm = this._vTiers.elements();
        block0: while (enm.hasMoreElements()) {
            Vector ht = (Vector)enm.nextElement();
            if (ht == null) continue;
            Enumeration e = ht.elements();
            while (e.hasMoreElements()) {
                SBTime sbt = (SBTime)e.nextElement();
                if (sbt.startt == -1L || !(sbt.startt <= this.selSTime && sbt.endt > this.selSTime || sbt.startt >= this.selSTime && sbt.endt < this.selETime) && (sbt.startt >= this.selETime || sbt.endt < this.selETime)) continue;
                Rectangle rect = sbt._rect;
                if (rect != null) {
                    g2.setColor(Constants.SELECTIONCOLOR);
                    g2.fill(rect);
                    this.drawTag(g2, sbt);
                }
                int pos = ht.indexOf(sbt);
                for (int i = pos + 1; i < ht.size(); ++i) {
                    sbt = (SBTime)ht.get(i);
                    if (sbt.startt >= this.selETime) continue block0;
                    rect = sbt._rect;
                    if (rect == null || sbt.startt == -1L) continue;
                    g2.setColor(Constants.SELECTIONCOLOR);
                    g2.fill(rect);
                    this.drawTag(g2, sbt);
                }
            }
        }
    }

    public boolean shouldPaint() {
        return this.getMediaTime() != this.curSTime;
    }

    public void paintMediaTimeMarker(Graphics2D g2) {
        Enumeration enm = this._vTiers.elements();
        block0: while (enm.hasMoreElements()) {
            Vector ht = (Vector)enm.nextElement();
            if (ht == null) continue;
            Enumeration e = ht.elements();
            while (e.hasMoreElements()) {
                SBTime sbt = (SBTime)e.nextElement();
                if (sbt.startt == -1L || sbt.startt > this.getMediaTime() || sbt.endt <= this.getMediaTime()) continue;
                g2.setColor(Constants.CROSSHAIRCOLOR);
                Rectangle rect = sbt._rect;
                this.curSTime = sbt.startt;
                if (rect == null) continue block0;
                g2.drawRect(rect.x, rect.y, rect.width, rect.height);
                continue block0;
            }
        }
    }

    private void paintEmptySlots(Graphics2D g2d, TierImpl tier, int tierIndex) {
        if (tierIndex >= this._vTiers.size()) {
            return;
        }
        Iterator tagIt = ((Vector)this._vTiers.get(tierIndex)).iterator();
        TierImpl parent = (TierImpl)tier.getParentTier();
        while (tagIt.hasNext()) {
            SBTime sbt = (SBTime)tagIt.next();
            if (sbt.annotation != null || sbt.startt == -1L || parent.getAnnotationAtTime(sbt.startt + 1L) == null) continue;
            g2d.setColor(Constants.SHAREDCOLOR4);
            g2d.fill(sbt._rect);
            g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            g2d.draw(sbt._rect);
        }
    }

    private Tier2D getTierAtPoint(Point p) {
        Point pp = new Point(p);
        pp.y += this.verticalScrollOffset;
        int index = this.getTierIndexForPoint(pp);
        if (index < 0 || index >= this.visibleTiers.size()) {
            return null;
        }
        return (Tier2D)this.visibleTiers.get(index);
    }

    private int getTierIndexForPoint(Point p) {
        int y = (int)p.getY() - this.VER_MARGIN;
        if (y < 0 || y > this._vTiers.size() * this.pixelsForTierHeight) {
            return -1;
        }
        return y / this.pixelsForTierHeight;
    }

    private int getTagIndex(Tier2D tier, SBTime tag) {
        int j = this.visibleTiers.indexOf(tier);
        if (j > -1) {
            Vector v = (Vector)this._vTiers.get(j);
            return v.indexOf(tag);
        }
        return -1;
    }

    private SBTime getTagAtPoint(Point p) {
        if (p.y <= this.VER_MARGIN) {
            return null;
        }
        p.x += this.horizontalScrollOffset;
        p.y += this.verticalScrollOffset;
        int size = this._vTiers.size();
        int curtier = this.getTierIndexForPoint(p);
        if (curtier >= size || curtier < 0) {
            return null;
        }
        Vector v = (Vector)this._vTiers.elementAt(curtier);
        SBTime sb = null;
        int pos = -1;
        pos = Collections.binarySearch(v, p);
        if (pos >= 0) {
            sb = (SBTime)v.elementAt(pos);
            return sb;
        }
        return null;
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("Interlinear Viewer");
        int fontSize = this.getFont().getSize();
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int i = 0; i < Constants.FONT_SIZES.length; ++i) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(Constants.FONT_SIZES[i]));
            fontRB.setActionCommand("font" + Constants.FONT_SIZES[i]);
            if (fontSize == Constants.FONT_SIZES[i]) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.popup.add(this.fontMenu);
        this.popup.addSeparator();
        this.activeTierMI = new JMenuItem(ElanLocale.getString("Menu.Tier.ActiveTier"));
        this.activeTierMI.setActionCommand("activeTier");
        this.activeTierMI.addActionListener(this);
        this.popup.add(this.activeTierMI);
        this.deleteTierMI = new JMenuItem(ElanLocale.getString("Menu.Tier.DeleteTier"));
        this.deleteTierMI.setActionCommand("deleteTier");
        this.deleteTierMI.addActionListener(this);
        this.popup.add(this.deleteTierMI);
        this.changeTierMI = new JMenuItem(ElanLocale.getString("Menu.Tier.ChangeTier"));
        this.changeTierMI.setActionCommand("changeTier");
        this.changeTierMI.addActionListener(this);
        this.popup.add(this.changeTierMI);
        this.popup.addSeparator();
        this.newAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.NewAnnotation"));
        this.newAnnoMI.setActionCommand("newAnn");
        this.newAnnoMI.addActionListener(this);
        this.popup.add(this.newAnnoMI);
        this.newAnnoBeforeMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.NewAnnotationBefore"));
        this.newAnnoBeforeMI.setActionCommand("annBefore");
        this.newAnnoBeforeMI.addActionListener(this);
        this.popup.add(this.newAnnoBeforeMI);
        this.newAnnoAfterMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.NewAnnotationAfter"));
        this.newAnnoAfterMI.setActionCommand("annAfter");
        this.newAnnoAfterMI.addActionListener(this);
        this.popup.add(this.newAnnoAfterMI);
        this.modifyAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.ModifyAnnotation"));
        this.modifyAnnoMI.setActionCommand("modifyAnn");
        this.modifyAnnoMI.addActionListener(this);
        this.popup.add(this.modifyAnnoMI);
        this.deleteAnnoMI = new JMenuItem(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
        this.deleteAnnoMI.setActionCommand("deleteAnn");
        this.deleteAnnoMI.addActionListener(this);
        this.popup.add(this.deleteAnnoMI);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    private void updatePopup(Point p) {
        this.newAnnoMI.setEnabled(false);
        this.newAnnoBeforeMI.setEnabled(false);
        this.newAnnoAfterMI.setEnabled(false);
        this.modifyAnnoMI.setEnabled(false);
        this.deleteAnnoMI.setEnabled(false);
        this.activeTierMI.setEnabled(false);
        this.deleteTierMI.setEnabled(false);
        this.changeTierMI.setEnabled(false);
        if (p.y < this.VER_MARGIN) {
            return;
        }
        Point pp = new Point(p);
        this.rightClickTier = this.getTierAtPoint(pp);
        if (this.rightClickTier == null) {
            return;
        }
        TierImpl tier = this.rightClickTier.getTier();
        if (tier == null) {
            return;
        }
        this.deleteTierMI.setEnabled(true);
        this.changeTierMI.setEnabled(true);
        if (!this.rightClickTier.isActive()) {
            this.activeTierMI.setEnabled(true);
        }
        Point tp = new Point(p);
        this.rightClickTag = this.getTagAtPoint(tp);
        if (this.rightClickTag == null) {
            return;
        }
        boolean supportsInsertion = false;
        try {
            LinguisticType lt = tier.getLinguisticType();
            Constraint c = null;
            if (lt != null) {
                c = lt.getConstraints();
            }
            if (c != null) {
                supportsInsertion = c.supportsInsertion();
            }
            if (this.rightClickTag == this.cursorTag) {
                this.modifyAnnoMI.setEnabled(true);
                this.deleteAnnoMI.setEnabled(true);
                if (supportsInsertion) {
                    this.newAnnoAfterMI.setEnabled(true);
                    this.newAnnoBeforeMI.setEnabled(true);
                } else if (tier.isTimeAlignable() && this.rightClickTag.annotation != null) {
                    this.newAnnoMI.setEnabled(true);
                }
            } else if (this.rightClickTag.startt == this.rightClickTag.endt && this.rightClickTag.startt != -1L) {
                this.newAnnoMI.setEnabled(true);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
    }

    private void dismissEditBox() {
        if (this.editBox.isVisible()) {
            if (this.deselectCommits) {
                this.editBox.commitEdit();
            } else {
                this.editBox.cancelEdit();
            }
        }
    }

    private void showEditBoxForTag(SBTime sbt) {
        if (sbt.annotation == null) {
            return;
        }
        this.editBox.setAnnotation(sbt.annotation);
        this.editBox.setSize(new Dimension(sbt._rect.width, sbt._rect.height));
        Font f = this.getFontForTier(sbt.annotation.getTier());
        if (f != null) {
            this.editBox.setFont(f);
        }
        this.editBox.setLocation(sbt._rect.x - this.horizontalScrollOffset, sbt._rect.y - this.verticalScrollOffset);
        this.editBox.configureEditor(JPanel.class, null, new Dimension(sbt._rect.width, sbt._rect.height));
        this.editBox.startEdit();
    }

    public void showEditBoxForAnnotation(Annotation a) {
        if (a == null) {
            return;
        }
        for (Vector v : this._vTiers) {
            for (SBTime tag : v) {
                if (tag.annotation != a) continue;
                this.showEditBoxForTag(tag);
                return;
            }
        }
    }

    private void tierAdded(TierImpl tier) {
        Tier2D t2d = new Tier2D(tier);
        this.allTiers.add(t2d);
        this.sbl.getSegOrder();
        this.tierYPositions = new int[this.allTiers.size()];
    }

    private void tierRemoved(TierImpl tier) {
        this.dismissEditBox();
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Tier2D tier2d = (Tier2D)this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            this.allTiers.remove(i);
            this.prefTierFonts.remove(tier.getName());
            if (this.cursorTag == null || this.cursorTag.annotation == null || this.cursorTag.annotation.getTier() != tier) break;
            this.cursorTag = null;
            this.setActiveAnnotation(null);
            break;
        }
    }

    private void tierChanged(TierImpl tier) {
        for (int i = 0; i < this.allTiers.size(); ++i) {
            Object opf;
            Tier2D tier2d = (Tier2D)this.allTiers.get(i);
            if (tier2d.getTier() != tier) continue;
            if (!tier2d.getName().equals(tier.getName()) && (opf = this.prefTierFonts.remove(tier2d.getName())) != null) {
                this.prefTierFonts.put(tier.getName(), opf);
            }
            tier2d.updateName();
            break;
        }
    }

    private void autoInsertAnnotation(Tier2D tier2d, Point p) {
        this.dismissEditBox();
        TierImpl child = tier2d.getTier();
        if (child == null || child.isTimeAlignable() || !child.hasParentTier()) {
            return;
        }
        SBTime sbt = this.getTagAtPoint(p);
        if (sbt == null || sbt.annotation != null || sbt.startt == -1L || sbt.startt != sbt.endt) {
            return;
        }
        Command c = null;
        Object val = Preferences.get("CreateDependingAnnotations", null);
        c = val instanceof Boolean ? (((Boolean)val).booleanValue() ? ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationRecursive") : ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotation")) : ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotation");
        Object[] args = new Object[]{new Long(sbt.startt + 1L), new Long(sbt.startt + 1L)};
        c.execute(child, args);
        Annotation aa = child.getAnnotationAtTime(sbt.startt + 1L);
        if (aa != null) {
            sbt.annotation = aa;
            this.setActiveAnnotation(aa);
            this.showEditBoxForTag(sbt);
            if (this.editBox.isVisible()) {
                this.editBox.requestFocus();
            }
        }
    }

    private void annotationChanged(TierImpl tier, Annotation annotation) {
        this.sbl.getRefTierOrder();
        this.extractCurrentSegment();
    }

    private void transcriptionChanged() {
        this.sbl.getRefTierOrder();
        this.extractCurrentSegment();
    }

    private void annotationRemoved(Annotation annotation) {
        if (annotation.getBeginTimeBoundary() >= this.sbl.getCurrentRefStartTime() && annotation.getEndTimeBoundary() <= this.sbl.getCurrentRefEndTime()) {
            this.sbl.getRefTierOrder();
            this.extractCurrentSegment();
        }
    }

    public void setTranscription(Transcription transcription) {
        Tier2D tier2d;
        int i;
        this.transcription = transcription;
        this.curSBSelection = null;
        this.activeAnnotation = null;
        if (transcription == null) {
            this.allTiers.clear();
            this.visibleTiers.clear();
            this.tierYPositions = new int[0];
            this.setVisibleTiers(new Vector());
            this.sbl = new SBLayout(null);
            return;
        }
        Vector<TierImpl> oldVisibles = new Vector<TierImpl>(this.visibleTiers.size());
        for (int i2 = 0; i2 < this.visibleTiers.size(); ++i2) {
            Tier2D tier2d2 = (Tier2D)this.visibleTiers.get(i2);
            oldVisibles.add(tier2d2.getTier());
        }
        String activeTierName = "";
        for (i = 0; i < this.allTiers.size(); ++i) {
            tier2d = (Tier2D)this.allTiers.get(i);
            if (!tier2d.isActive()) continue;
            activeTierName = tier2d.getName();
            break;
        }
        this.sbl = new SBLayout(transcription);
        this.sbl.getSegOrder();
        this.sbl.getPrevRef();
        this.sbl.setWorkingSegmentsRange(1, 0);
        this.initTiers();
        if (this.sbl.setBlocksVisibleAtTime(this.getMediaTime() + 1L)) {
            this.extractCurrentSegment();
            this.updateScrollBar();
        }
        for (i = 0; i < this.allTiers.size(); ++i) {
            tier2d = (Tier2D)this.allTiers.get(i);
            if (!tier2d.getName().equals(activeTierName)) continue;
            tier2d.setActive(true);
            break;
        }
        this.setVisibleTiers(oldVisibles);
    }

    public void updateLocale() {
        this.prevButton.setText(ElanLocale.getString("InterlinearViewer.PrevButton.Text"));
        this.nextButton.setText(ElanLocale.getString("InterlinearViewer.NextButton.Text"));
        this.prevButton.setToolTipText(ElanLocale.getString("InterlinearViewer.PrevButton.Tooltip"));
        this.nextButton.setToolTipText(ElanLocale.getString("InterlinearViewer.NextButton.Tooltip"));
        if (this.popup != null) {
            this.fontMenu.setText(ElanLocale.getString("Menu.View.FontSize"));
            this.activeTierMI.setText(ElanLocale.getString("Menu.Tier.ActiveTier"));
            this.deleteTierMI.setText(ElanLocale.getString("Menu.Tier.DeleteTier"));
            this.changeTierMI.setText(ElanLocale.getString("Menu.Tier.ChangeTier"));
            this.newAnnoMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotation"));
            this.newAnnoBeforeMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotationBefore"));
            this.newAnnoAfterMI.setText(ElanLocale.getString("Menu.Annotation.NewAnnotationAfter"));
            this.modifyAnnoMI.setText(ElanLocale.getString("Menu.Annotation.ModifyAnnotation"));
            this.deleteAnnoMI.setText(ElanLocale.getString("Menu.Annotation.DeleteAnnotation"));
        }
        this.revalidate();
        if (this.editBox != null) {
            this.editBox.updateLocale();
        }
    }

    public void updateFont(Font f) {
        int oldSize = this.getFont().getSize();
        this.setFont(f);
        this.currentMetrics = this.getFontMetrics(this.getFont());
        Iterator keyIt = this.prefTierFonts.keySet().iterator();
        String key = null;
        Font prFont = null;
        while (keyIt.hasNext()) {
            key = (String)keyIt.next();
            prFont = (Font)this.prefTierFonts.get(key);
            if (prFont == null) continue;
            this.prefTierFonts.put(key, new Font(prFont.getName(), 0, this.font.getSize()));
        }
        this.pixelsForTierHeight = this.getFont().getSize() + 24;
        if (oldSize != f.getSize()) {
            this.notifyMultiTierControlPanel();
            this.extractCurrentSegment();
            this.vScrollBar.setBlockIncrement(this.pixelsForTierHeight);
            this.updateScrollBar();
        } else {
            this.extractCurrentSegment();
        }
    }

    public void setFontSize(int fontSize) {
        this.updateFont(this.getFont().deriveFont((float)fontSize));
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != fontSize) continue;
                    item.setSelected(true);
                    break;
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    private Font getFontForTier(Tier tier) {
        Font fo;
        if (tier != null && (fo = (Font)this.prefTierFonts.get(tier.getName())) != null) {
            return fo;
        }
        return this.font;
    }

    public void controllerUpdate(ControllerEvent ce) {
        if (this.sbl.setBlocksVisibleAtTime(this.getMediaTime())) {
            this.extractCurrentSegment();
            this.updateScrollBar();
        } else if (this.shouldPaint() && !this.playerIsPlaying()) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (e.getPoint().y < this.VER_MARGIN) {
                return;
            }
            Point pp = e.getPoint();
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.updatePopup(pp);
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        this.dismissEditBox();
        this.curSBSelection = this.getTagAtPoint(e.getPoint());
        if (this.curSBSelection != null) {
            this.cursorTag = this.curSBSelection;
            this.refAnnotation = this.sbl.getRefAnn();
            this.activeAnnotation = this.cursorTag.annotation;
        } else {
            this.cursorTag = null;
            this.refAnnotation = null;
            this.activeAnnotation = null;
        }
        this.setActiveAnnotation(this.activeAnnotation);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        this.requestFocus();
        if (e.getPoint().y <= this.VER_MARGIN) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.dismissEditBox();
            if (this.cursorTag != null) {
                this.showEditBoxForTag(this.cursorTag);
            } else {
                Point dp = new Point(e.getPoint());
                Tier2D tier2d = this.getTierAtPoint(dp);
                if (tier2d != null) {
                    this.autoInsertAnnotation(tier2d, e.getPoint());
                }
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.showEmptySlots = false;
        this.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getUnitsToScroll() > 0) {
            this.vScrollBar.setValue(this.vScrollBar.getValue() + this.pixelsForTierHeight);
        } else {
            this.vScrollBar.setValue(this.vScrollBar.getValue() - this.pixelsForTierHeight);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getModifiers() == 8 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1) {
            if (!this.showEmptySlots) {
                this.showEmptySlots = true;
                this.repaint();
            }
        } else if (this.showEmptySlots) {
            this.showEmptySlots = false;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        if ((e.getKeyCode() == 17 || e.getKeyCode() == 18 || e.getKeyCode() == 16) && this.showEmptySlots) {
            this.showEmptySlots = false;
            this.repaint();
        }
    }

    public boolean isValidNewChildTag(Tier tier, SBTime sbt) {
        Tier pt = ((TierImpl)tier).getParentTier();
        if (pt == null) {
            return false;
        }
        return ((TierImpl)pt).getAnnotationAtTime(sbt.startt + 1L) != null;
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return this.vScrollBar.getWidth();
    }

    public void componentResized(ComponentEvent e) {
        this.buildLayout();
        this.vScrollBar.setBounds(this.getWidth() - this.defBarWidth, 0, this.defBarWidth, this.getHeight() - this.defBarWidth);
        this.vScrollBar.revalidate();
        this.hScrollBar.setBounds(0, this.getHeight() - this.defBarWidth, this.getWidth(), this.defBarWidth);
        this.hScrollBar.revalidate();
        this.buttonPanel.setBounds(0, 0, this.getWidth() - this.defBarWidth, this.VER_MARGIN);
        this.updateScrollBar();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int value = e.getValue();
        if (((JScrollBar)e.getSource()).getOrientation() == 0) {
            if (this.editBox.isVisible()) {
                Point p = this.editBox.getLocation();
                p.x += this.horizontalScrollOffset - value;
                this.editBox.setLocation(p);
            }
            this.horizontalScrollOffset = value;
            if (this.currentSegmentWidth > this.MAX_BUF_WIDTH) {
                this.buildLayout();
            } else {
                this.repaint();
            }
        } else {
            if (this.editBox.isVisible()) {
                Point p = this.editBox.getLocation();
                p.y += this.verticalScrollOffset - value;
                this.editBox.setLocation(p);
            }
            this.verticalScrollOffset = value;
            this.repaint();
            this.notifyMultiTierControlPanel();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("prev")) {
            if (this.allTiers.size() == 0) {
                return;
            }
            this.sbl.setWorkingSegmentsRange(1, -1);
            this.extractCurrentSegment();
            this.updateScrollBar();
            Annotation an = this.sbl.getRefAnn();
            if (an != null) {
                this.setMediaTime(an.getBeginTimeBoundary());
            }
        } else if (e.getActionCommand().equals("next")) {
            if (this.allTiers.size() == 0) {
                return;
            }
            this.sbl.setWorkingSegmentsRange(1, 1);
            this.extractCurrentSegment();
            this.updateScrollBar();
            Annotation an = this.sbl.getRefAnn();
            if (an != null) {
                this.setMediaTime(an.getBeginTimeBoundary());
            }
        } else if (e.getActionCommand().indexOf("font") > -1) {
            String sizeString = e.getActionCommand();
            int index = sizeString.indexOf("font") + 4;
            int size = 12;
            try {
                size = Integer.parseInt(sizeString.substring(index));
                this.dismissEditBox();
                this.updateFont(this.getFont().deriveFont((float)size));
                this.setPreference("InterlinearViewer.FontSize", new Integer(size), this.transcription);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing font size");
            }
        } else if (e.getActionCommand().equals("activeTier")) {
            this.doActiveTier();
        } else if (e.getActionCommand().equals("deleteTier")) {
            this.doDeleteTier();
        } else if (e.getActionCommand().equals("changeTier")) {
            this.doChangeTier();
        } else if (e.getActionCommand().equals("newAnn")) {
            this.doNewAnnotation();
        } else if (e.getActionCommand().equals("annBefore")) {
            this.doAnnotationBefore();
        } else if (e.getActionCommand().equals("annAfter")) {
            this.doAnnotationAfter();
        } else if (e.getActionCommand().equals("modifyAnn")) {
            this.doModifyAnnotation();
        } else if (e.getActionCommand().equals("deleteAnn")) {
            this.doDeleteAnnotation();
        }
    }

    public void preferencesChanged() {
        Object val;
        Object fo;
        Integer fontSize = (Integer)this.getPreference("InterlinearViewer.FontSize", this.transcription);
        if (fontSize != null) {
            this.setFontSize(fontSize);
        }
        if ((fo = this.getPreference("TierFonts", this.transcription)) instanceof HashMap) {
            HashMap foMap = (HashMap)fo;
            Iterator keyIt = foMap.keySet().iterator();
            String key = null;
            Font ft = null;
            Tier2D t2d = null;
            while (keyIt.hasNext()) {
                key = (String)keyIt.next();
                ft = (Font)foMap.get(key);
                if (key == null || ft == null) continue;
                for (int i = 0; i < this.allTiers.size() && !(t2d = (Tier2D)this.allTiers.get(i)).getName().equals(key); ++i) {
                }
                if (this.prefTierFonts.containsKey(key)) {
                    Font oldF = (Font)this.prefTierFonts.get(key);
                    if (oldF.getName().equals(ft.getName())) continue;
                    this.prefTierFonts.put(key, new Font(ft.getName(), 0, this.font.getSize()));
                    this.extractCurrentSegment();
                    continue;
                }
                this.prefTierFonts.put(key, new Font(ft.getName(), 0, this.font.getSize()));
                this.extractCurrentSegment();
            }
            Iterator keyIt2 = this.prefTierFonts.keySet().iterator();
            ArrayList<String> remKeys = new ArrayList<String>(4);
            while (keyIt2.hasNext()) {
                key = (String)keyIt2.next();
                if (foMap.containsKey(key)) continue;
                remKeys.add(key);
                this.prefTierFonts.remove(key);
            }
            if (remKeys.size() > 0) {
                for (int j = 0; j < remKeys.size(); ++j) {
                    this.prefTierFonts.remove((String)remKeys.get(j));
                }
            }
        }
        if ((val = this.getPreference("InlineEdit.EnterCommits", null)) instanceof Boolean) {
            this.editBox.setEnterCommits((Boolean)val);
        }
        if ((val = Preferences.get("InlineEdit.DeselectCommits", null)) instanceof Boolean) {
            this.deselectCommits = (Boolean)val;
        }
        this.extractCurrentSegment();
    }

    private void doActiveTier() {
        if (this.rightClickTier == null || this.multiTierControlPanel == null) {
            return;
        }
        this.multiTierControlPanel.setActiveTier(this.rightClickTier.getTier());
    }

    private void doDeleteTier() {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{new Integer(2), this.rightClickTier.getTier()};
        c.execute(this.transcription, args);
    }

    private void doChangeTier() {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{new Integer(1), this.rightClickTier.getTier()};
        c.execute(this.transcription, args);
    }

    private void doNewAnnotation() {
        if (this.rightClickTier == null) {
            return;
        }
        TierImpl tier = this.rightClickTier.getTier();
        long begin = -1L;
        long end = -1L;
        if (tier.isTimeAlignable() && this.cursorTag != null && this.cursorTag.startt > -1L) {
            begin = this.cursorTag.startt;
            end = this.cursorTag.endt;
        } else if (this.rightClickTag != null && this.rightClickTag.startt == this.rightClickTag.endt) {
            begin = this.rightClickTag.startt + 1L;
            end = this.rightClickTag.startt + 1L;
        }
        if (begin != -1L && end != -1L) {
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotation");
            Object[] args = new Object[]{new Long(begin), new Long(end)};
            c.execute(tier, args);
            Annotation aa = tier.getAnnotationAtTime(begin);
            if (aa != null) {
                this.setActiveAnnotation(aa);
                this.showEditBoxForAnnotation(aa);
                if (this.editBox.isVisible()) {
                    this.editBox.requestFocus();
                }
            }
        }
    }

    private void doAnnotationBefore() {
        if (this.rightClickTier == null || this.cursorTag == null) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationBefore");
        Object[] args = new Object[]{this.cursorTag.annotation};
        c.execute(this.rightClickTier.getTier(), args);
        Annotation aa = this.rightClickTier.getTier().getAnnotationBefore(this.cursorTag.annotation);
        if (aa != null) {
            this.setActiveAnnotation(aa);
            this.showEditBoxForAnnotation(aa);
            if (this.editBox.isVisible()) {
                this.editBox.requestFocus();
            }
        }
    }

    private void doAnnotationAfter() {
        if (this.rightClickTier == null || this.cursorTag == null) {
            return;
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.NewAnnotationAfter");
        Object[] args = new Object[]{this.cursorTag.annotation};
        c.execute(this.rightClickTier.getTier(), args);
        Annotation aa = this.rightClickTier.getTier().getAnnotationAfter(this.cursorTag.annotation);
        if (aa != null) {
            this.setActiveAnnotation(aa);
            this.showEditBoxForAnnotation(aa);
            if (this.editBox.isVisible()) {
                this.editBox.requestFocus();
            }
        }
    }

    private void doModifyAnnotation() {
        if (this.cursorTag != null && this.cursorTag.annotation != null) {
            this.showEditBoxForTag(this.cursorTag);
        }
    }

    private void doDeleteAnnotation() {
        if (this.cursorTag != null && this.cursorTag.annotation != null) {
            TierImpl tier = this.rightClickTier.getTier();
            Annotation aa = this.cursorTag.annotation;
            Command c = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteAnnotation");
            c.execute(tier, new Object[]{this.getViewerManager(), aa});
        }
    }

    private class SBTime
    implements Comparable {
        public Annotation annotation;
        public long startt = 0L;
        public long endt = 0L;
        public Rectangle _rect;
        public String value;

        public SBTime(Annotation a, long st, long et, Rectangle rect, String val) {
            this.annotation = a;
            this.startt = st;
            this.endt = et;
            this._rect = rect;
            this.value = val;
        }

        public int compareTo(Object o) {
            if (o instanceof Long) {
                long wl = 0L;
                wl = (Long)o;
                if (wl >= this.startt && wl <= this.endt) {
                    return 0;
                }
                if (this.startt == -1L) {
                    return 1;
                }
                if (this.endt < wl) {
                    return -1;
                }
            }
            if (o instanceof Point) {
                Point pt = (Point)o;
                if (this._rect.contains(pt.x, pt.y)) {
                    return 0;
                }
                if (this._rect.x < pt.x) {
                    return -1;
                }
            }
            return 1;
        }
    }
}

