/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.TierDependenciesCA;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.util.gui.TreeFrame;

public class MultiTierControlPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
ComponentListener,
ElanLocaleListener,
PreferencesUser {
    public static final int MIN_WIDTH = 120;
    public static final int MARGIN = 5;
    public static final int LEVEL_INDENT = 10;
    public static final int MARKER_SIZE = 6;
    private Dimension dimension;
    private Transcription transcription;
    private Vector tiers;
    private Vector visibleTiers;
    private JPopupMenu popup;
    private JMenu viewerMenu;
    private JMenu visTiersMenu;
    private JMenu sortTiersMenu;
    private JMenuItem hideAllMI;
    private JMenuItem showAllMI;
    private JMenuItem showHideMoreMI;
    private JMenuItem collapseAllMI;
    private JMenuItem expandAllMI;
    private JMenuItem hideMI;
    private JMenuItem changeMI;
    private JMenuItem deleteMI;
    private JMenuItem colOrExpMI;
    private JMenuItem showHierMI;
    private JCheckBoxMenuItem numAnnosMI;
    private JRadioButtonMenuItem timelineMI;
    private JRadioButtonMenuItem interlinearMI;
    private JRadioButtonMenuItem sortByHierarchMI;
    private JRadioButtonMenuItem sortByTypeMI;
    private JRadioButtonMenuItem sortByPartMI;
    private JRadioButtonMenuItem sortByAnnotMI;
    private JRadioButtonMenuItem unsortedMI;
    private JCheckBoxMenuItem sortAlphabeticallyMI;
    private MultiTierViewer viewer;
    private int[] tierPositions;
    private Hashtable tierNames;
    private BufferedImage bi;
    private Graphics2D big2d;
    private FontMetrics fontMetrics;
    private Font boldFont;
    private FontMetrics boldMetrics;
    private boolean dragging;
    private int dragX;
    private int dragY;
    private int dragIndex;
    private String dragLabel;
    private Tier activeTier;
    private TierImpl rightClickTier;
    private int[] colorValues;
    private Hashtable tierRootColors;
    private HashMap prefTierColors;
    private int tierHeight;
    private HashMap numAnnosPerTier;
    private boolean showNumberOfAnnotations = true;
    private boolean reducedTierHeight = false;
    private boolean disableInterlinearMI = false;
    private boolean sortAlphabetically = false;
    private DefaultMutableTreeNode sortedRootNode;
    private int sortMode;
    private final int UNSORTED = 0;
    private final int SORT_BY_HIERARCHY = 1;
    private final int SORT_BY_PARTICIPANT = 2;
    private final int SORT_BY_LINGUISTIC_TYPE = 3;
    private final int SORT_BY_ANNOTATOR = 4;
    private Vector displayableTierNodes;
    private final String NOT_SPECIFIED = "not specified";
    private final String TIER_AC = "@&@";
    private Vector viewers;
    private JComponent resizer = null;

    public MultiTierControlPanel(Transcription transcription) {
        this.setLayout(null);
        this.dimension = new Dimension();
        this.visibleTiers = new Vector();
        this.displayableTierNodes = new Vector();
        this.viewers = new Vector();
        this.setFont(Constants.DEFAULTFONT);
        this.sortMode = 0;
        this.colorValues = new int[]{0, 90, 160};
        this.setTranscription(transcription);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.tierHeight = 3 * f.getSize();
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.boldFont = this.getFont().deriveFont(1);
        this.boldMetrics = this.getFontMetrics(this.boldFont);
    }

    public void setResizeComponent(JComponent comp) {
        if (this.resizer != null) {
            this.remove(this.resizer);
        }
        this.resizer = comp;
        if (this.resizer != null) {
            this.add(this.resizer);
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
        }
        this.repaint();
    }

    public void disableShowInterlinearViewer(boolean val) {
        this.disableInterlinearMI = val;
        if (val) {
            if (this.interlinearMI != null) {
                this.interlinearMI.setEnabled(false);
            }
            if (this.timelineMI != null) {
                this.timelineMI.setSelected(true);
            }
        } else if (this.interlinearMI != null) {
            this.interlinearMI.setEnabled(true);
        }
    }

    public void setViewer(MultiTierViewer viewer) {
        this.viewer = viewer;
        viewer.setMultiTierControlPanel(this);
        if (viewer instanceof TimeLineViewer) {
            if (this.timelineMI != null) {
                this.timelineMI.setSelected(true);
            }
        } else if (viewer instanceof InterlinearViewer && this.interlinearMI != null) {
            this.interlinearMI.setSelected(true);
        }
        if (this.visibleTiers != null) {
            this.setVisibleTiers(this.visibleTiers);
        }
        if (this.activeTier != null) {
            this.setActiveTier(this.activeTier);
        }
    }

    public void addViewer(MultiTierViewer viewer) {
        this.viewers.add(viewer);
        viewer.setMultiTierControlPanel(this);
        if (this.visibleTiers != null) {
            this.setVisibleTiers(this.visibleTiers);
        }
        if (this.activeTier != null) {
            this.setActiveTier(this.activeTier);
        }
    }

    public void removeViewer(MultiTierViewer viewer) {
        viewer.setMultiTierControlPanel(null);
        this.viewers.remove(viewer);
    }

    public void updateLocale() {
        if (this.popup == null) {
            return;
        }
        this.hideAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.HideAllTiers"));
        this.showAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
        this.showHideMoreMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ShowHideMore"));
        this.viewerMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.Viewer"));
        this.visTiersMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.VisibleTiers"));
        this.sortTiersMenu.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortTiers"));
        this.expandAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ExpandAll"));
        this.collapseAllMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.CollapseAll"));
        this.unsortedMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.Unsorted"));
        this.sortByHierarchMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByHierarchy"));
        this.sortByTypeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByType"));
        this.sortByPartMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByParticipant"));
        this.sortByAnnotMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortByAnnotator"));
        this.sortAlphabeticallyMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.SortAlpabetically"));
        this.hideMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide"));
        this.changeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change"));
        this.deleteMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete"));
        this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
        this.showHierMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.ShowInHierarchy"));
        this.numAnnosMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.NumberAnnotations"));
    }

    private void setTranscription(Transcription transcription) {
        this.transcription = transcription;
        try {
            this.tiers = transcription.getTiers();
            this.tierNames = new Hashtable();
            this.tierRootColors = new Hashtable();
            this.prefTierColors = new HashMap();
            this.numAnnosPerTier = new HashMap();
            this.popup = new JPopupMenu("");
            this.viewerMenu = new JMenu();
            this.popup.add(this.viewerMenu);
            this.popup.addSeparator();
            this.visTiersMenu = new JMenu();
            this.popup.add(this.visTiersMenu);
            this.expandAllMI = new JMenuItem();
            this.expandAllMI.setActionCommand("expandAll");
            this.expandAllMI.addActionListener(this);
            this.visTiersMenu.add(this.expandAllMI);
            this.collapseAllMI = new JMenuItem();
            this.collapseAllMI.setActionCommand("collapseAll");
            this.collapseAllMI.addActionListener(this);
            this.visTiersMenu.add(this.collapseAllMI);
            this.visTiersMenu.addSeparator();
            this.hideAllMI = new JMenuItem("");
            this.hideAllMI.setActionCommand("hideAll");
            this.hideAllMI.addActionListener(this);
            this.visTiersMenu.add(this.hideAllMI);
            this.showAllMI = new JMenuItem("");
            this.showAllMI.setActionCommand("showAll");
            this.showAllMI.addActionListener(this);
            this.visTiersMenu.add(this.showAllMI);
            this.showHideMoreMI = new JMenuItem();
            this.showHideMoreMI.setActionCommand("showHideMore");
            this.showHideMoreMI.addActionListener(this);
            this.visTiersMenu.add(this.showHideMoreMI);
            this.visTiersMenu.addSeparator();
            for (int i = 0; i < this.tiers.size(); ++i) {
                TierImpl tier = (TierImpl)this.tiers.elementAt(i);
                String tierName = tier.getName();
                this.tierNames.put(tier, tierName);
                if (tier.getParentTier() == null) {
                    this.addToRootColors(tier);
                }
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(tierName);
                menuItem.setSelected(true);
                menuItem.setActionCommand("@&@" + tierName);
                menuItem.addActionListener(this);
                this.visTiersMenu.add(menuItem);
                this.visibleTiers.add(tier);
            }
            this.sortTiersMenu = new JMenu();
            ButtonGroup sortGroup = new ButtonGroup();
            this.unsortedMI = new JRadioButtonMenuItem();
            this.unsortedMI.setActionCommand("unsorted");
            this.unsortedMI.addActionListener(this);
            sortGroup.add(this.unsortedMI);
            this.sortTiersMenu.add(this.unsortedMI);
            this.sortByHierarchMI = new JRadioButtonMenuItem();
            this.sortByHierarchMI.setActionCommand("sortHier");
            this.sortByHierarchMI.addActionListener(this);
            sortGroup.add(this.sortByHierarchMI);
            this.sortTiersMenu.add(this.sortByHierarchMI);
            this.sortByTypeMI = new JRadioButtonMenuItem();
            this.sortByTypeMI.setActionCommand("sortType");
            this.sortByTypeMI.addActionListener(this);
            sortGroup.add(this.sortByTypeMI);
            this.sortTiersMenu.add(this.sortByTypeMI);
            this.sortByPartMI = new JRadioButtonMenuItem();
            this.sortByPartMI.setActionCommand("sortPart");
            this.sortByPartMI.addActionListener(this);
            sortGroup.add(this.sortByPartMI);
            this.sortTiersMenu.add(this.sortByPartMI);
            this.sortByAnnotMI = new JRadioButtonMenuItem();
            this.sortByAnnotMI.setActionCommand("sortAnn");
            this.sortByAnnotMI.addActionListener(this);
            sortGroup.add(this.sortByAnnotMI);
            this.sortTiersMenu.add(this.sortByAnnotMI);
            this.sortTiersMenu.addSeparator();
            this.sortAlphabeticallyMI = new JCheckBoxMenuItem();
            this.sortAlphabeticallyMI.addActionListener(this);
            this.sortTiersMenu.add(this.sortAlphabeticallyMI);
            switch (this.sortMode) {
                case 0: {
                    this.unsortedMI.setSelected(true);
                    break;
                }
                case 1: {
                    this.sortByHierarchMI.setSelected(true);
                    break;
                }
                case 2: {
                    this.sortByPartMI.setSelected(true);
                    break;
                }
                case 3: {
                    this.sortByTypeMI.setSelected(true);
                }
            }
            this.popup.add(this.sortTiersMenu);
            this.popup.addSeparator();
            this.hideMI = new JMenuItem();
            this.hideMI.setActionCommand("hideThis");
            this.hideMI.addActionListener(this);
            this.hideMI.setEnabled(false);
            this.popup.add(this.hideMI);
            this.changeMI = new JMenuItem();
            this.changeMI.setActionCommand("changeThis");
            this.changeMI.addActionListener(this);
            this.changeMI.setEnabled(false);
            this.popup.add(this.changeMI);
            this.deleteMI = new JMenuItem();
            this.deleteMI.setActionCommand("deleteThis");
            this.deleteMI.addActionListener(this);
            this.deleteMI.setEnabled(false);
            this.popup.add(this.deleteMI);
            this.colOrExpMI = new JMenuItem();
            this.colOrExpMI.setActionCommand("toggleExpandThis");
            this.colOrExpMI.addActionListener(this);
            this.colOrExpMI.setEnabled(false);
            this.popup.add(this.colOrExpMI);
            this.showHierMI = new JMenuItem();
            this.showHierMI.setActionCommand("showThis");
            this.showHierMI.addActionListener(this);
            this.showHierMI.setEnabled(false);
            this.popup.add(this.showHierMI);
            this.popup.addSeparator();
            this.numAnnosMI = new JCheckBoxMenuItem();
            this.numAnnosMI.setActionCommand("numAnnos");
            this.numAnnosMI.addActionListener(this);
            this.numAnnosMI.setSelected(true);
            this.popup.add(this.numAnnosMI);
            this.setVisibleTiers(this.visibleTiers);
            this.updateLocale();
            this.createSortedTree();
            if (this.visibleTiers.size() > 0 && Preferences.get("MultiTierViewer.ActiveTierName", transcription) == null) {
                this.setActiveTier((Tier)this.visibleTiers.get(0));
            }
            this.annotationsChanged();
            this.paintBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSortedTree() {
        if (this.sortAlphabetically) {
            Collections.sort(this.visibleTiers, new TierComparer());
        }
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>(this.visibleTiers);
        for (int i = 0; i < this.tiers.size(); ++i) {
            TierImpl tier = (TierImpl)this.tiers.elementAt(i);
            if (tierList.contains(tier)) continue;
            tierList.add(tier);
        }
        this.sortedRootNode = new DefaultMutableTreeNode("sortRoot");
        switch (this.sortMode) {
            case 1: {
                TierImpl tier;
                int i;
                HashMap<TierImpl, TierTreeNode> nodes = new HashMap<TierImpl, TierTreeNode>();
                for (i = 0; i < tierList.size(); ++i) {
                    tier = (TierImpl)tierList.get(i);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    nodes.put(tier, n);
                }
                for (i = 0; i < tierList.size(); ++i) {
                    tier = (TierImpl)tierList.get(i);
                    if (tier.getParentTier() == null) {
                        this.sortedRootNode.add((TierTreeNode)nodes.get(tier));
                        continue;
                    }
                    ((TierTreeNode)nodes.get(tier.getParentTier())).add((TierTreeNode)nodes.get(tier));
                }
                break;
            }
            case 2: {
                HashMap participantMap = new HashMap();
                for (int i = 0; i < tierList.size(); ++i) {
                    String part;
                    TierImpl tier = (TierImpl)tierList.get(i);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    if ((part = tier.getParticipant()).length() == 0) {
                        part = "not specified";
                    }
                    if (participantMap.get(part) == null) {
                        ArrayList<TierTreeNode> list = new ArrayList<TierTreeNode>();
                        list.add(n);
                        participantMap.put(part, list);
                        continue;
                    }
                    ((ArrayList)participantMap.get(part)).add(n);
                }
                if (participantMap.size() <= 0) break;
                Set keys = participantMap.keySet();
                ArrayList names = new ArrayList(keys);
                Collections.sort(names);
                for (int j = 0; j < names.size(); ++j) {
                    ArrayList pList = (ArrayList)participantMap.get(names.get(j));
                    for (int k = 0; k < pList.size(); ++k) {
                        this.sortedRootNode.add((TierTreeNode)pList.get(k));
                    }
                }
                break;
            }
            case 4: {
                HashMap annotMap = new HashMap();
                for (int i = 0; i < tierList.size(); ++i) {
                    String annot;
                    TierImpl tier = (TierImpl)tierList.get(i);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    if ((annot = tier.getAnnotator()) == null || annot.length() == 0) {
                        annot = "not specified";
                    }
                    if (annotMap.get(annot) == null) {
                        ArrayList<TierTreeNode> list = new ArrayList<TierTreeNode>();
                        list.add(n);
                        annotMap.put(annot, list);
                        continue;
                    }
                    ((ArrayList)annotMap.get(annot)).add(n);
                }
                if (annotMap.size() <= 0) break;
                Set keys = annotMap.keySet();
                ArrayList names = new ArrayList(keys);
                Collections.sort(names);
                for (int j = 0; j < names.size(); ++j) {
                    ArrayList pList = (ArrayList)annotMap.get(names.get(j));
                    for (int k = 0; k < pList.size(); ++k) {
                        this.sortedRootNode.add((TierTreeNode)pList.get(k));
                    }
                }
                break;
            }
            case 3: {
                HashMap typeMap = new HashMap();
                for (int i = 0; i < tierList.size(); ++i) {
                    LinguisticType type;
                    TierImpl tier = (TierImpl)tierList.get(i);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    if ((type = tier.getLinguisticType()) == null) {
                        type = new LinguisticType("not specified");
                    }
                    if (typeMap.get(type) == null) {
                        ArrayList<TierTreeNode> list = new ArrayList<TierTreeNode>();
                        list.add(n);
                        typeMap.put(type, list);
                        continue;
                    }
                    ((ArrayList)typeMap.get(type)).add(n);
                }
                if (typeMap.size() <= 0) break;
                for (ArrayList typeList : typeMap.values()) {
                    for (int k = 0; k < typeList.size(); ++k) {
                        this.sortedRootNode.add((TierTreeNode)typeList.get(k));
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < tierList.size(); ++i) {
                    TierImpl tier = (TierImpl)tierList.get(i);
                    TierTreeNode n = new TierTreeNode(tier);
                    if (this.activeTier != null && this.activeTier == tier) {
                        n.setActive(true);
                    }
                    if (!this.visibleTiers.contains(tier)) {
                        n.setVisible(false);
                    }
                    this.sortedRootNode.add(n);
                }
            }
        }
        this.updateDisplayableTiers();
    }

    private void updateDisplayableTiers() {
        Vector<TierImpl> dispTiers;
        block10: {
            dispTiers = new Vector<TierImpl>();
            this.visibleTiers.clear();
            this.displayableTierNodes.clear();
            if (this.sortMode == 1 && this.sortedRootNode.getChildCount() > 0) {
                int level = -1;
                TierTreeNode curNode = (TierTreeNode)this.sortedRootNode.getFirstChild();
                DefaultMutableTreeNode parent = null;
                block0: while (level != 0) {
                    if (curNode.isVisible()) {
                        this.visibleTiers.add(curNode.getTier());
                        this.displayableTierNodes.add(curNode);
                        dispTiers.add(curNode.getTier());
                        if (curNode.getChildCount() > 0 && curNode.isExpanded()) {
                            curNode = (TierTreeNode)curNode.getFirstChild();
                            level = curNode.getLevel();
                            continue;
                        }
                        parent = (DefaultMutableTreeNode)curNode.getParent();
                    } else {
                        parent = (DefaultMutableTreeNode)curNode.getParent();
                    }
                    while (true) {
                        if (parent.getChildAfter(curNode) != null) {
                            curNode = (TierTreeNode)parent.getChildAfter(curNode);
                            continue block0;
                        }
                        if (parent != this.sortedRootNode) {
                            curNode = (TierTreeNode)parent;
                            level = curNode.getLevel();
                            parent = (DefaultMutableTreeNode)curNode.getParent();
                            continue;
                        }
                        break block10;
                        break;
                    }
                }
            } else {
                Enumeration<TreeNode> nodeEnum = this.sortedRootNode.children();
                TierTreeNode cn = null;
                while (nodeEnum.hasMoreElements()) {
                    cn = (TierTreeNode)nodeEnum.nextElement();
                    if (!cn.isVisible()) continue;
                    this.visibleTiers.add(cn.getTier());
                    this.displayableTierNodes.add(cn);
                    dispTiers.add(cn.getTier());
                }
            }
        }
        this.setVisibleTiers(dispTiers);
    }

    private void updatePopup(TierImpl tier) {
        if (this.timelineMI == null) {
            ButtonGroup multitierViewerGroup = new ButtonGroup();
            this.timelineMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.ShowTimeline"));
            this.interlinearMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.ShowInterlinear"));
            this.timelineMI.setSelected(true);
            multitierViewerGroup.add(this.timelineMI);
            multitierViewerGroup.add(this.interlinearMI);
            this.viewerMenu.add(this.timelineMI);
            this.viewerMenu.add(this.interlinearMI);
            if (this.viewer instanceof TimeLineViewer) {
                this.timelineMI.setSelected(true);
            } else if (this.viewer instanceof InterlinearViewer) {
                this.interlinearMI.setSelected(true);
            }
        }
        if (this.disableInterlinearMI) {
            this.interlinearMI.setEnabled(false);
            this.timelineMI.setSelected(this.disableInterlinearMI);
        }
        if (tier != null) {
            String name = tier.getName();
            if (name != null && name.length() > 0) {
                this.hideMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide") + " " + "<i>" + name + "</i></html>");
                this.changeMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change") + " " + "<i>" + name + "</i></html>");
                this.deleteMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete") + " " + "<i>" + name + "</i></html>");
                if (this.sortMode == 1) {
                    this.colOrExpMI.setText("<html>" + ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand") + " " + "<i>" + name + "</i></html>");
                    this.colOrExpMI.setEnabled(true);
                } else {
                    this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
                    this.colOrExpMI.setEnabled(false);
                }
                this.hideMI.setEnabled(true);
                this.changeMI.setEnabled(true);
                this.deleteMI.setEnabled(true);
                this.showHierMI.setEnabled(true);
            }
        } else {
            this.hideMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Hide"));
            this.changeMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Change"));
            this.deleteMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.Delete"));
            this.colOrExpMI.setText(ElanLocale.getString("MultiTierControlPanel.Menu.ThisTier.CollapseExpand"));
            this.hideMI.setEnabled(false);
            this.changeMI.setEnabled(false);
            this.deleteMI.setEnabled(false);
            this.colOrExpMI.setEnabled(false);
            this.showHierMI.setEnabled(false);
        }
        if (this.sortMode == 1) {
            this.expandAllMI.setEnabled(true);
            this.collapseAllMI.setEnabled(true);
        } else {
            this.expandAllMI.setEnabled(false);
            this.collapseAllMI.setEnabled(false);
        }
    }

    public void setTierPositions(int[] tierPositions) {
        this.tierPositions = tierPositions;
        if (tierPositions.length > 1) {
            this.tierHeight = tierPositions[1] - tierPositions[0];
            if (this.tierHeight > 0) {
                this.reducedTierHeight = (double)this.tierHeight < 2.5 * (double)this.getFont().getSize();
            }
        }
        this.paintBuffer();
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        Point p = e.getPoint();
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            int index = this.getClosestTierIndexForMouseY(p.y);
            TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(index);
            this.setActiveTier(node.getTier());
        }
        this.paintBuffer();
    }

    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            int y = e.getPoint().y;
            int tierIndex = this.getClosestTierIndexForMouseY(y);
            if (tierIndex < this.displayableTierNodes.size() && this.displayableTierNodes.size() > 0) {
                TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(tierIndex);
                TierImpl tier = null;
                if (node != null) {
                    this.rightClickTier = tier = node.getTier();
                }
                this.updatePopup(tier);
            } else {
                this.rightClickTier = null;
                this.updatePopup(null);
            }
            this.popup.show(this, e.getPoint().x, y);
            return;
        }
        this.dragIndex = this.getClosestTierIndexForMouseY(e.getPoint().y);
        if (this.dragIndex == 0 && this.displayableTierNodes.size() == 0) {
            return;
        }
        this.dragLabel = (String)this.tierNames.get(((TierTreeNode)this.displayableTierNodes.elementAt(this.dragIndex)).getTier());
        this.dragging = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragging) {
            this.dragX = e.getPoint().x - 40;
            this.dragY = e.getPoint().y;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragging) {
            if (this.displayableTierNodes.size() <= 1) {
                this.dragging = false;
                this.dragLabel = "";
                this.repaint();
                return;
            }
            int index = this.getInsertionIndexForMouseY(e.getPoint().y);
            if (index >= this.displayableTierNodes.size()) {
                index = this.displayableTierNodes.size() - 1;
            }
            if (index != this.dragIndex && index - 1 != this.dragIndex) {
                TierTreeNode node = (TierTreeNode)this.displayableTierNodes.elementAt(this.dragIndex);
                TierTreeNode insertBeforeNode = (TierTreeNode)this.displayableTierNodes.get(index);
                TierTreeNode insertAfterNode = null;
                if (index - 1 >= 0) {
                    insertAfterNode = (TierTreeNode)this.displayableTierNodes.get(index - 1);
                }
                if (index == this.displayableTierNodes.size() - 1) {
                    insertBeforeNode = null;
                    insertAfterNode = (TierTreeNode)this.displayableTierNodes.get(index);
                }
                switch (this.sortMode) {
                    case 1: {
                        if (insertAfterNode != null && node.getParent() == insertAfterNode.getParent()) {
                            node.removeFromParent();
                            int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                            ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                            break;
                        }
                        if (insertBeforeNode != null && node.getParent() == insertBeforeNode.getParent()) {
                            int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                            ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                            break;
                        }
                        if (insertAfterNode == null || node.getParent() != insertAfterNode.getSharedAncestor(node)) break;
                        int curLevel = node.getLevel();
                        DefaultMutableTreeNode sameLevelNode = insertAfterNode;
                        while (sameLevelNode.getLevel() != curLevel) {
                            sameLevelNode = (DefaultMutableTreeNode)sameLevelNode.getParent();
                        }
                        node.removeFromParent();
                        int afterIndex = sameLevelNode.getParent().getIndex(sameLevelNode);
                        ((DefaultMutableTreeNode)sameLevelNode.getParent()).insert(node, afterIndex + 1);
                        break;
                    }
                    case 2: {
                        if (insertAfterNode != null && insertBeforeNode != null) {
                            if (insertAfterNode.getTier().getParticipant().equals(node.getTier().getParticipant())) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            if (insertBeforeNode.getTier().getParticipant().equals(node.getTier().getParticipant())) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                        }
                        if (insertAfterNode != null) {
                            if (insertAfterNode.getTier().getParticipant().equals(node.getTier().getParticipant())) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            String afterPartName = insertAfterNode.getTier().getParticipant();
                            String dragPartName = node.getTier().getParticipant();
                            TierTreeNode lastNode = insertAfterNode;
                            while (lastNode.getNextNode() != null && ((TierTreeNode)lastNode.getNextNode()).getTier().getParticipant().equals(afterPartName)) {
                                lastNode = (TierTreeNode)lastNode.getNextNode();
                            }
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!nn.getTier().getParticipant().equals(dragPartName)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int afterIndex = lastNode.getParent().getIndex(lastNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)lastNode.getParent()).insert((DefaultMutableTreeNode)moveGroup.get(i), afterIndex + 1);
                            }
                        } else {
                            if (insertBeforeNode == null) break;
                            if (insertBeforeNode.getTier().getParticipant().equals(node.getTier().getParticipant())) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                            String dragPartName = node.getTier().getParticipant();
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!nn.getTier().getParticipant().equals(dragPartName)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert((DefaultMutableTreeNode)moveGroup.get(i), beforeIndex);
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (insertAfterNode != null && insertBeforeNode != null) {
                            if (insertAfterNode.getTier().getLinguisticType().equals(node.getTier().getLinguisticType())) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            if (insertBeforeNode.getTier().getLinguisticType().equals(node.getTier().getLinguisticType())) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                        }
                        if (insertAfterNode != null) {
                            if (insertAfterNode.getTier().getLinguisticType().equals(node.getTier().getLinguisticType())) {
                                node.removeFromParent();
                                int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                                ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                                break;
                            }
                            LinguisticType insertType = insertAfterNode.getTier().getLinguisticType();
                            LinguisticType dragType = node.getTier().getLinguisticType();
                            TierTreeNode lastNode = insertAfterNode;
                            while (lastNode.getNextNode() != null && ((TierTreeNode)lastNode.getNextNode()).getTier().getLinguisticType().equals(insertType)) {
                                lastNode = (TierTreeNode)lastNode.getNextNode();
                            }
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!nn.getTier().getLinguisticType().equals(dragType)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int afterIndex = lastNode.getParent().getIndex(lastNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)lastNode.getParent()).insert((DefaultMutableTreeNode)moveGroup.get(i), afterIndex + 1);
                            }
                        } else {
                            if (insertBeforeNode == null) break;
                            if (insertBeforeNode.getTier().getLinguisticType().equals(node.getTier().getLinguisticType())) {
                                int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                                break;
                            }
                            LinguisticType dragType = node.getTier().getLinguisticType();
                            ArrayList<TierTreeNode> moveGroup = new ArrayList<TierTreeNode>();
                            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                            en.nextElement();
                            while (en.hasMoreElements()) {
                                TierTreeNode nn = (TierTreeNode)en.nextElement();
                                if (!nn.getTier().getLinguisticType().equals(dragType)) continue;
                                moveGroup.add(nn);
                            }
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)moveGroup.get(i)).removeFromParent();
                            }
                            int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                            for (int i = moveGroup.size() - 1; i >= 0; --i) {
                                ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert((DefaultMutableTreeNode)moveGroup.get(i), beforeIndex);
                            }
                        }
                        break;
                    }
                    case 0: {
                        if (insertAfterNode != null) {
                            node.removeFromParent();
                            int afterIndex = insertAfterNode.getParent().getIndex(insertAfterNode);
                            ((DefaultMutableTreeNode)insertAfterNode.getParent()).insert(node, afterIndex + 1);
                            break;
                        }
                        if (insertBeforeNode == null) break;
                        int beforeIndex = insertBeforeNode.getParent().getIndex(insertBeforeNode);
                        ((DefaultMutableTreeNode)insertBeforeNode.getParent()).insert(node, beforeIndex);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.updateDisplayableTiers();
            }
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            this.dragging = false;
            this.dragLabel = "";
            this.paintBuffer();
            this.storeTierOrder();
        }
    }

    private int getClosestTierIndexForMouseY(int y) {
        int index;
        if (this.tierPositions.length == 0 || this.displayableTierNodes.size() == 0) {
            return 0;
        }
        for (index = 0; index < this.displayableTierNodes.size() && y >= this.tierPositions[index]; ++index) {
        }
        if (index > 0 && --index == this.displayableTierNodes.size() && index != 0) {
            --index;
        }
        float d1 = Math.abs(y - this.tierPositions[index]);
        float d2 = Float.MAX_VALUE;
        if (index + 1 < this.displayableTierNodes.size()) {
            d2 = Math.abs(y - this.tierPositions[index + 1]);
        }
        if (d2 < d1) {
            ++index;
        }
        return index;
    }

    private int getInsertionIndexForMouseY(int y) {
        int index = 0;
        if (this.displayableTierNodes.size() > 0) {
            for (index = 0; index < this.displayableTierNodes.size() && y >= this.tierPositions[index]; ++index) {
            }
        }
        return index;
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (e.getSource() == this.sortAlphabeticallyMI) {
            int sortMode = this.getSorting();
            this.sortAlphabetically = this.sortAlphabeticallyMI.isSelected();
            this.setPreference("MultiTierViewer.SortAlpabetically", this.sortAlphabetically, this.transcription);
            this.setSorting(sortMode);
        } else if (command.equals("hideAll")) {
            this.hideAllTiers();
        } else if (command.equals("showAll")) {
            this.showAllTiers();
        } else if (command.equals("showHideMore")) {
            new VisibilityDialog(this.transcription, this.visibleTiers);
        } else if (command.equals("unsorted")) {
            this.setSorting(0);
        } else if (command.equals("sortHier")) {
            this.setSorting(1);
        } else if (command.equals("sortPart")) {
            this.setSorting(2);
        } else if (command.equals("sortType")) {
            this.setSorting(3);
        } else if (command.equals("sortAnn")) {
            this.setSorting(4);
        } else if (command.equals("expandAll")) {
            this.expandAllNodes();
        } else if (command.equals("collapseAll")) {
            this.collapseAllNodes();
        } else if (command.equals("hideThis")) {
            this.hideTier(this.rightClickTier);
        } else if (command.equals("changeThis")) {
            this.changeTier(this.rightClickTier);
        } else if (command.equals("deleteThis")) {
            this.deleteTier(this.rightClickTier);
        } else if (command.equals("toggleExpandThis")) {
            this.toggleExpandedState(this.rightClickTier);
        } else if (command.equals("showThis")) {
            this.showInTierDependencyFrame(this.rightClickTier);
        } else if (command.equals("numAnnos")) {
            this.showNumberOfAnnotations = this.numAnnosMI.isSelected();
            this.setPreference("MultiTierViewer.ShowNumberOfAnnotations", new Boolean(this.showNumberOfAnnotations), this.transcription);
            this.paintBuffer();
        } else if (command.startsWith("@&@")) {
            String tierName = command.substring("@&@".length());
            Tier tier = this.transcription.getTierWithId(tierName);
            Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
            nodeEnum.nextElement();
            while (nodeEnum.hasMoreElements()) {
                TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
                if (node.getTier() != tier) continue;
                node.setVisible(!node.isVisible());
                break;
            }
            this.updateDisplayableTiers();
            this.storeHiddenTiers();
        }
    }

    private void setVisibleTiers(Vector visibleTiers) {
        for (int i = 0; i < this.viewers.size(); ++i) {
            ((MultiTierViewer)this.viewers.elementAt(i)).setVisibleTiers(visibleTiers);
        }
        this.paintBuffer();
    }

    public Vector getVisibleTiers() {
        return this.visibleTiers;
    }

    public List getTierOrder() {
        ArrayList<String> visibleTierNames = new ArrayList<String>();
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            visibleTierNames.add(((Tier)this.visibleTiers.elementAt(i)).getName());
        }
        return visibleTierNames;
    }

    public void setTierOrder(List tierNames) {
        this.sortMode = 0;
        if (!this.unsortedMI.isSelected()) {
            this.unsortedMI.setSelected(true);
        }
        Vector visTiers = new Vector();
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        MenuElement[] items = menu.getSubElements();
        block0: for (int i = 0; i < tierNames.size(); ++i) {
            String tierName = (String)tierNames.get(i);
            for (int j = 0; j < this.tiers.size(); ++j) {
                if (!tierName.equals(((Tier)this.tiers.elementAt(j)).getName())) continue;
                visTiers.add(this.tiers.elementAt(j));
                continue block0;
            }
        }
        for (int k = 0; k < items.length; ++k) {
            if (!(items[k] instanceof JCheckBoxMenuItem)) continue;
            if (tierNames.contains(((JCheckBoxMenuItem)items[k]).getText())) {
                ((JCheckBoxMenuItem)items[k]).setSelected(true);
                continue;
            }
            ((JCheckBoxMenuItem)items[k]).setSelected(false);
        }
        this.visibleTiers = visTiers;
        this.createSortedTree();
    }

    public String getActiveTierName() {
        if (this.activeTier == null) {
            return null;
        }
        return this.activeTier.getName();
    }

    public void setActiveTierForName(String name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.tiers.size(); ++i) {
            if (!name.equals(((Tier)this.tiers.elementAt(i)).getName())) continue;
            this.setActiveTier((Tier)this.tiers.elementAt(i));
        }
    }

    public void setSorting(int mode) {
        if (this.sortAlphabetically) {
            this.sortAlphabeticallyMI.setSelected(true);
        } else {
            this.sortAlphabeticallyMI.setSelected(false);
        }
        int oldSortMode = this.sortMode;
        this.sortMode = mode < 0 || mode > 4 ? 0 : mode;
        switch (this.sortMode) {
            case 0: {
                if (this.unsortedMI.isSelected()) break;
                this.unsortedMI.setSelected(true);
                break;
            }
            case 1: {
                if (this.sortByHierarchMI.isSelected()) break;
                this.sortByHierarchMI.setSelected(true);
                break;
            }
            case 3: {
                if (this.sortByTypeMI.isSelected()) break;
                this.sortByTypeMI.setSelected(true);
                break;
            }
            case 2: {
                if (this.sortByPartMI.isSelected()) break;
                this.sortByPartMI.setSelected(true);
                break;
            }
            case 4: {
                if (this.sortByAnnotMI.isSelected()) break;
                this.sortByAnnotMI.setSelected(true);
            }
        }
        if (oldSortMode == 1 && this.sortMode != oldSortMode) {
            int i;
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            MenuElement[] items = menu.getSubElements();
            Vector<String> visTierNames = new Vector<String>();
            for (i = 0; i < this.tiers.size(); ++i) {
                Tier t = (Tier)this.tiers.get(i);
                if (!this.visibleTiers.contains(t)) continue;
                visTierNames.add(t.getName());
            }
            for (i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof JCheckBoxMenuItem)) continue;
                if (visTierNames.contains(((JCheckBoxMenuItem)items[i]).getText())) {
                    ((JCheckBoxMenuItem)items[i]).setSelected(true);
                    continue;
                }
                ((JCheckBoxMenuItem)items[i]).setSelected(false);
            }
        }
        this.setPreference("MultiTierViewer.TierSortingMode", new Integer(this.sortMode), this.transcription);
        this.createSortedTree();
        this.storeTierOrder();
    }

    public int getSorting() {
        return this.sortMode;
    }

    public void tierAdded(TierImpl tier) {
        String name = tier.getName();
        if (!this.tierNames.contains(tier)) {
            this.tierNames.put(tier, name);
            TierTreeNode node = new TierTreeNode(tier);
            if (tier.getParentTier() == null) {
                this.addToRootColors(tier);
            }
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(name);
            menuItem.setSelected(true);
            menuItem.addActionListener(this);
            menuItem.setActionCommand("@&@" + name);
            this.visTiersMenu.add(menuItem);
            block0 : switch (this.sortMode) {
                case 0: {
                    this.sortedRootNode.add(node);
                    break;
                }
                case 1: {
                    if (tier.getParentTier() == null) {
                        this.sortedRootNode.add(node);
                        break;
                    }
                    Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
                    en.nextElement();
                    while (en.hasMoreElements()) {
                        TierTreeNode nextNode = (TierTreeNode)en.nextElement();
                        if (nextNode.getTier() != tier.getParentTier()) continue;
                        nextNode.add(node);
                        break block0;
                    }
                    break;
                }
                case 2: {
                    String parti = tier.getParticipant();
                    boolean groupFound = false;
                    Enumeration<TreeNode> partEnum = this.sortedRootNode.children();
                    TierTreeNode lastInGroupNode = null;
                    while (partEnum.hasMoreElements()) {
                        TierTreeNode nextNode = (TierTreeNode)partEnum.nextElement();
                        if (nextNode.getTier().getParticipant().equals(parti)) {
                            groupFound = true;
                            lastInGroupNode = nextNode;
                            continue;
                        }
                        if (!groupFound) continue;
                        ((DefaultMutableTreeNode)lastInGroupNode.getParent()).add(node);
                        break;
                    }
                    if (groupFound) break;
                    this.sortedRootNode.add(node);
                    break;
                }
                case 3: {
                    LinguisticType type = tier.getLinguisticType();
                    boolean typesFound = false;
                    Enumeration<TreeNode> typesEnum = this.sortedRootNode.children();
                    TierTreeNode lastInTypeGroupNode = null;
                    while (typesEnum.hasMoreElements()) {
                        TierTreeNode nextTypeNode = (TierTreeNode)typesEnum.nextElement();
                        if (type == null && nextTypeNode.getTier().getLinguisticType() == null || type.equals(nextTypeNode.getTier().getLinguisticType())) {
                            typesFound = true;
                            lastInTypeGroupNode = nextTypeNode;
                            continue;
                        }
                        if (!typesFound) continue;
                        ((DefaultMutableTreeNode)lastInTypeGroupNode.getParent()).add(node);
                        break;
                    }
                    if (typesFound) break;
                    this.sortedRootNode.add(node);
                }
            }
            this.annotationsChanged();
            this.updateDisplayableTiers();
            this.storeTierOrder();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            if (this.visibleTiers.size() == 1) {
                this.setActiveTier(tier);
            }
        }
    }

    public void tierRemoved(TierImpl tier) {
        if (this.tierNames.containsKey(tier)) {
            String name = (String)this.tierNames.get(tier);
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            MenuElement[] items = menu.getSubElements();
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof JCheckBoxMenuItem) || !((JCheckBoxMenuItem)items[i]).getText().equals(name)) continue;
                this.visTiersMenu.remove((JCheckBoxMenuItem)items[i]);
                break;
            }
            this.tierNames.remove(tier);
            this.tierRootColors.remove(tier);
            this.numAnnosPerTier.remove(name);
            Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
            nodeEnum.nextElement();
            while (nodeEnum.hasMoreElements()) {
                TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
                if (node.getTier() != tier) continue;
                ((DefaultMutableTreeNode)node.getParent()).remove(node);
                break;
            }
            this.updateDisplayableTiers();
            this.storeTierOrder();
            this.storeHiddenTiers();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            if (this.activeTier == tier) {
                if (this.visibleTiers.size() > 0) {
                    this.setActiveTier((Tier)this.visibleTiers.get(0));
                } else {
                    this.setActiveTier(null);
                }
            }
        }
    }

    public void tierChanged(TierImpl tier) {
        String oldName;
        String name = tier.getName();
        if (!name.equals(oldName = (String)this.tierNames.get(tier))) {
            MenuElement menu = this.visTiersMenu.getSubElements()[0];
            MenuElement[] items = menu.getSubElements();
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof JCheckBoxMenuItem) || !((JCheckBoxMenuItem)items[i]).getText().equals(oldName)) continue;
                ((JCheckBoxMenuItem)items[i]).setText(name);
                ((JCheckBoxMenuItem)items[i]).setActionCommand("@&@" + name);
                break;
            }
            Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
            nodeEnum.nextElement();
            while (nodeEnum.hasMoreElements()) {
                TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
                if (node.getTier() != tier) continue;
                node.setTierName(name);
                break;
            }
            this.tierNames.put(tier, name);
            this.annotationsChanged();
            if (this.sortAlphabetically) {
                this.setSorting(this.sortMode);
            }
            this.paintBuffer();
            this.storeHiddenTiers();
            this.storeTierOrder();
        } else {
            this.createSortedTree();
        }
    }

    public void setActiveTier(Tier tier) {
        this.activeTier = tier;
        Enumeration<TreeNode> e = this.sortedRootNode.preorderEnumeration();
        e.nextElement();
        while (e.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)e.nextElement();
            if (node.getTier() == this.activeTier) {
                node.setActive(true);
                continue;
            }
            node.setActive(false);
        }
        for (int j = 0; j < this.viewers.size(); ++j) {
            ((MultiTierViewer)this.viewers.elementAt(j)).setActiveTier(tier);
        }
        this.paintBuffer();
        if (this.activeTier != null) {
            this.setPreference("MultiTierViewer.ActiveTierName", this.activeTier.getName(), this.transcription);
        } else {
            this.setPreference("MultiTierViewer.ActiveTierName", null, this.transcription);
        }
    }

    public Tier getActiveTier() {
        return this.activeTier;
    }

    public void setNextActiveTier(boolean next) {
        if (this.displayableTierNodes.size() == 0) {
            return;
        }
        if (this.activeTier == null) {
            if (this.displayableTierNodes.size() > 0) {
                TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(0);
                this.setActiveTier(node.getTier());
            }
        } else {
            TierTreeNode node = null;
            TierImpl tier = null;
            for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                node = (TierTreeNode)this.displayableTierNodes.get(i);
                tier = node.getTier();
                if (tier != this.activeTier) continue;
                if (!next) {
                    if (i > 0) {
                        node = (TierTreeNode)this.displayableTierNodes.get(i - 1);
                        this.setActiveTier(node.getTier());
                    }
                    return;
                }
                if (i < this.displayableTierNodes.size() - 1) {
                    node = (TierTreeNode)this.displayableTierNodes.get(i + 1);
                    this.setActiveTier(node.getTier());
                }
                return;
            }
            Enumeration<TreeNode> e = this.sortedRootNode.preorderEnumeration();
            e.nextElement();
            while (e.hasMoreElements()) {
                node = (TierTreeNode)e.nextElement();
                if (node.getTier() != this.activeTier) continue;
                if (!next) {
                    while (node.getParent() != null && !((DefaultMutableTreeNode)node.getParent()).isRoot()) {
                        if (!this.displayableTierNodes.contains(node = (TierTreeNode)node.getParent())) continue;
                        this.setActiveTier(node.getTier());
                        return;
                    }
                } else {
                    while (e.hasMoreElements()) {
                        node = (TierTreeNode)e.nextElement();
                        if (!this.displayableTierNodes.contains(node)) continue;
                        this.setActiveTier(node.getTier());
                        return;
                    }
                }
                return;
            }
        }
    }

    private void changeTier(TierImpl tier) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{new Integer(1), tier};
        c.execute(this.transcription, args);
    }

    private void deleteTier(TierImpl tier) {
        Command c = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{new Integer(2), tier};
        c.execute(this.transcription, args);
    }

    private void showInTierDependencyFrame(TierImpl tier) {
        JFrame fr;
        CommandAction ca = ELANCommandFactory.getCommandAction(this.transcription, "Menu.View.Dependencies");
        ca.actionPerformed(null);
        String name = tier.getName();
        if (ca instanceof TierDependenciesCA && (fr = ((TierDependenciesCA)ca).getFrame()) instanceof TreeFrame) {
            JTree tree = ((TreeFrame)fr).getTree();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Enumeration<TreeNode> en = root.preorderEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode target = (DefaultMutableTreeNode)en.nextElement();
                if (target.getUserObject() == null || !target.getUserObject().equals(name)) continue;
                Object[] path = target.getPath();
                tree.setSelectionPath(new TreePath(path));
            }
        }
    }

    private void showAllTiers() {
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        MenuElement[] items = menu.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)items[i]).setSelected(true);
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setVisible(true);
        }
        this.updateDisplayableTiers();
        this.storeTierOrder();
        this.storeHiddenTiers();
    }

    private void hideAllTiers() {
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        MenuElement[] items = menu.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof JCheckBoxMenuItem)) continue;
            ((JCheckBoxMenuItem)items[i]).setSelected(false);
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setVisible(false);
        }
        this.updateDisplayableTiers();
        this.storeTierOrder();
        this.storeHiddenTiers();
    }

    private void storeHiddenTiers() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                if (nn.isVisible()) continue;
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.HiddenTiers", tNames, this.transcription);
        }
    }

    private void storeTierOrder() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.TierOrder", tNames, this.transcription);
        }
    }

    private void storeCollapsedTiers() {
        if (this.sortedRootNode != null) {
            ArrayList<String> tNames = new ArrayList<String>(this.tiers.size());
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                if (nn.isLeaf() || nn.isExpanded()) continue;
                tNames.add(nn.getTierName());
            }
            this.setPreference("MultiTierViewer.CollapsedTiers", tNames, this.transcription);
        }
    }

    protected void updateVisibleTiers(Vector visTierNames) {
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        MenuElement[] items = menu.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof JCheckBoxMenuItem)) continue;
            if (visTierNames.contains(((JCheckBoxMenuItem)items[i]).getText())) {
                ((JCheckBoxMenuItem)items[i]).setSelected(true);
                continue;
            }
            ((JCheckBoxMenuItem)items[i]).setSelected(false);
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            if (visTierNames.contains(node.getTierName())) {
                node.setVisible(true);
                continue;
            }
            node.setVisible(false);
        }
        this.updateDisplayableTiers();
        this.storeTierOrder();
        this.storeHiddenTiers();
    }

    private void hideTier(TierImpl tier) {
        if (tier == null) {
            return;
        }
        String name = tier.getName();
        MenuElement menu = this.visTiersMenu.getSubElements()[0];
        MenuElement[] items = menu.getSubElements();
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof JCheckBoxMenuItem) || !((JCheckBoxMenuItem)items[i]).getText().equals(name)) continue;
            ((JCheckBoxMenuItem)items[i]).setSelected(false);
            break;
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            if (node.getTier() != tier) continue;
            node.setVisible(false);
            break;
        }
        this.updateDisplayableTiers();
        this.storeHiddenTiers();
    }

    private void expandAllNodes() {
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setExpanded(true);
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void collapseAllNodes() {
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            node.setExpanded(false);
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void toggleExpandedState(TierImpl tier) {
        if (tier == null) {
            return;
        }
        Enumeration<TreeNode> nodeEnum = this.sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            TierTreeNode node = (TierTreeNode)nodeEnum.nextElement();
            if (node.getTier() != tier) continue;
            node.setExpanded(!node.isExpanded());
            break;
        }
        this.updateDisplayableTiers();
        this.storeCollapsedTiers();
    }

    private void addToRootColors(TierImpl t) {
        int i = 0;
        Color c = this.getRandomColor();
        while (true) {
            if (c.getRed() == c.getGreen() && c.getRed() == c.getBlue()) {
                c = this.getRandomColor();
                ++i;
                continue;
            }
            if (i > 50) {
                this.tierRootColors.put(t, c);
                break;
            }
            if (this.tierRootColors.size() >= 16) {
                this.tierRootColors.put(t, c);
                break;
            }
            if (!this.tierRootColors.values().contains(c)) {
                this.tierRootColors.put(t, c);
                break;
            }
            c = this.getRandomColor();
            ++i;
        }
    }

    private Color getRandomColor() {
        int r = this.colorValues[(int)(Math.random() * 3.0)];
        int g = this.colorValues[(int)(Math.random() * 3.0)];
        int b = this.colorValues[(int)(Math.random() * 3.0)];
        return new Color(r, g, b);
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        String line = string;
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth(line)) > width - 4) {
            int i = 0;
            String s = "";
            int size = line.length();
            while (i < size && fMetrics.stringWidth(s) <= width - 4) {
                s = s + line.charAt(i++);
            }
            line = !s.equals("") ? s.substring(0, s.length() - 1) : s;
        }
        return line;
    }

    public void annotationsChanged() {
        if (this.transcription != null) {
            TierImpl ti = null;
            int numTiers = this.transcription.getTiers().size();
            for (int i = 0; i < numTiers; ++i) {
                ti = (TierImpl)this.transcription.getTiers().get(i);
                this.numAnnosPerTier.put(ti.getName(), "[" + String.valueOf(ti.getAnnotations().size()) + "]");
            }
            this.paintBuffer();
        }
    }

    public Dimension getMinimumSize() {
        this.dimension.setSize(120, ((JComponent)((Object)this.viewer)).getHeight());
        return this.dimension;
    }

    public Dimension getPreferredSize() {
        this.dimension.setSize(360, ((JComponent)((Object)this.viewer)).getHeight());
        return this.dimension;
    }

    private void paintBuffer() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.displayableTierNodes == null || this.tierPositions == null || this.displayableTierNodes.size() > this.tierPositions.length) {
            return;
        }
        if (this.bi == null || this.bi.getWidth() != this.getWidth() || this.bi.getHeight() != this.getHeight()) {
            this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.big2d = this.bi.createGraphics();
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.big2d.setColor(this.getBackground());
        this.big2d.fillRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
        if (this.tierPositions.length > 1) {
            this.big2d.setColor(Constants.SIGNALCHANNELCOLOR);
            int y = this.tierPositions[0] + this.tierHeight / 2;
            for (int i = 0; i < this.tierPositions.length; ++i) {
                this.big2d.drawLine(0, y, this.bi.getWidth(), y);
                y += this.tierHeight;
            }
        }
        int panelWidth = this.getWidth();
        int availableLabelWidth = panelWidth - 10;
        switch (this.sortMode) {
            case 1: {
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(i);
                    this.paintLabelHierarchically(this.big2d, node, i, availableLabelWidth);
                }
                break;
            }
            case 2: {
                boolean startNewGroup = true;
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(i);
                    if (i > 0) {
                        TierTreeNode prevNode = (TierTreeNode)this.displayableTierNodes.get(i - 1);
                        startNewGroup = !node.getTier().getParticipant().equals(prevNode.getTier().getParticipant());
                    }
                    this.paintLabelInBlock(this.big2d, node, i, availableLabelWidth, startNewGroup);
                }
                break;
            }
            case 4: {
                boolean startAnnGroup = true;
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(i);
                    if (i > 0) {
                        TierTreeNode prevAnnNode = (TierTreeNode)this.displayableTierNodes.get(i - 1);
                        startAnnGroup = !node.getTier().getAnnotator().equals(prevAnnNode.getTier().getAnnotator());
                    }
                    this.paintLabelInBlock(this.big2d, node, i, availableLabelWidth, startAnnGroup);
                }
                break;
            }
            case 3: {
                boolean startLinGroup = true;
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(i);
                    if (i > 0) {
                        TierTreeNode prevLinNode = (TierTreeNode)this.displayableTierNodes.get(i - 1);
                        startLinGroup = !node.getTier().getLinguisticType().equals(prevLinNode.getTier().getLinguisticType());
                    }
                    this.paintLabelInBlock(this.big2d, node, i, availableLabelWidth, startLinGroup);
                }
                break;
            }
            default: {
                for (int i = 0; i < this.displayableTierNodes.size(); ++i) {
                    TierTreeNode node = (TierTreeNode)this.displayableTierNodes.get(i);
                    this.paintLabelInBlock(this.big2d, node, i, availableLabelWidth, false);
                }
            }
        }
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        }
        g2d.setColor(Constants.SELECTIONCOLOR);
        g2d.drawLine(0, 0, this.getWidth() - 1, 0);
        g2d.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        if (this.dragging) {
            g2d.setFont(this.boldFont);
            g2d.setColor(Color.blue);
            g2d.drawString(this.dragLabel, this.dragX, this.dragY);
        }
        if (this.resizer != null) {
            this.resizer.repaint();
        }
    }

    private void paintLabelHierarchically(Graphics g, TierTreeNode node, int positionIndex, int availableLabelWidth) {
        int levelCount;
        int widthForLabel;
        int level = node.getLevel();
        boolean hasChildren = node.getChildCount() != 0;
        boolean atLeastOneChildVisible = false;
        if (node.getChildCount() > 0) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                if (!((TierTreeNode)en.nextElement()).isVisible()) continue;
                atLeastOneChildVisible = true;
                break;
            }
        }
        boolean[] isParentLastChild = new boolean[level];
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        isParentLastChild[level - 1] = parent.getLastChild() == node;
        for (int i = level - 2; i >= 0; --i) {
            DefaultMutableTreeNode upNode = parent;
            isParentLastChild[i] = (parent = (DefaultMutableTreeNode)upNode.getParent()).getLastChild() == upNode;
        }
        int actualLabelWidth = widthForLabel = availableLabelWidth - (level * 10 + 5);
        String label = "";
        if (node.isActive()) {
            label = this.truncateString(node.getTierName(), widthForLabel, this.boldMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.boldMetrics, label);
        } else {
            label = this.truncateString(node.getTierName(), widthForLabel, this.fontMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.fontMetrics, label);
        }
        g.setColor(Color.DARK_GRAY);
        int y = this.tierPositions[positionIndex];
        int minY = y - this.tierHeight / 2;
        int minX = 10;
        for (int i = levelCount = 1; i < level; ++i) {
            if (!isParentLastChild[i - 1]) {
                g.drawLine(minX, minY, minX, minY + this.tierHeight);
            }
            minX += 10;
        }
        int x = 5 + level * 10 - 5;
        if (isParentLastChild[level - 1]) {
            g.drawLine(x, minY, x, y);
        } else {
            g.drawLine(x, minY, x, minY + this.tierHeight);
        }
        g.drawLine(x, y, x + 10, y);
        if (hasChildren && node.isExpanded()) {
            if (atLeastOneChildVisible) {
                g.drawLine(x + 10, y, x + 10, y + this.tierHeight / 2);
            }
            g.drawRect(x - 3, y - 3, 6, 6);
        } else if (hasChildren && !node.isExpanded()) {
            g.fillRect(x - 3, y - 3, 6, 6);
        }
        x += 15;
        y += this.boldFont.getSize() / 2;
        if (node.isActive()) {
            g.setColor(Constants.CROSSHAIRCOLOR);
            g.setFont(this.boldFont);
            g.drawLine(x, y + 3, x + actualLabelWidth, y + 3);
            g.drawString(label, x, y);
            if (this.showNumberOfAnnotations) {
                if (!this.reducedTierHeight) {
                    g.setFont(Constants.SMALLFONT);
                    g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), x, minY + this.tierHeight - 1);
                } else {
                    int numW = this.getFontMetrics(Constants.SMALLFONT).stringWidth((String)this.numAnnosPerTier.get(node.getTierName()));
                    if (actualLabelWidth + numW < widthForLabel - 3) {
                        g.setFont(Constants.SMALLFONT);
                        g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), x + actualLabelWidth + 3, y);
                    }
                }
            }
        } else {
            Color col = (Color)this.prefTierColors.get(node.getTier());
            if (col == null) {
                TierImpl root = node.getTier().getRootTier();
                if (root != null) {
                    g.setColor((Color)this.tierRootColors.get(root));
                }
            } else {
                g.setColor(col);
            }
            g.setFont(this.getFont());
            g.drawString(label, x, y);
            if (this.showNumberOfAnnotations) {
                if (!this.reducedTierHeight) {
                    g.setFont(Constants.SMALLFONT);
                    g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), x, minY + this.tierHeight - 2);
                } else {
                    int numW = this.getFontMetrics(Constants.SMALLFONT).stringWidth((String)this.numAnnosPerTier.get(node.getTierName()));
                    if (actualLabelWidth + numW < widthForLabel - 3) {
                        g.setFont(Constants.SMALLFONT);
                        g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), x + actualLabelWidth + 3, y);
                    }
                }
            }
        }
    }

    private void paintLabelInBlock(Graphics g, TierTreeNode node, int positionIndex, int availableLabelWidth, boolean startNewGroup) {
        int y = this.tierPositions[positionIndex];
        int minY = y - this.tierHeight / 2;
        if (this.sortMode != 0 && (positionIndex == 0 || startNewGroup)) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(5, minY, 5 + availableLabelWidth, minY);
        }
        if (this.sortMode != 0 && positionIndex == this.displayableTierNodes.size() - 1) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(5, minY + this.tierHeight, 5 + availableLabelWidth, minY + this.tierHeight);
        }
        int actualLabelWidth = availableLabelWidth;
        String label = "";
        if (node.isActive()) {
            label = this.truncateString(node.getTierName(), availableLabelWidth, this.boldMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.boldMetrics, label);
            int x = 5 + availableLabelWidth - actualLabelWidth;
            y += this.getFont().getSize() / 2;
            g.setColor(Constants.CROSSHAIRCOLOR);
            if (this.showNumberOfAnnotations) {
                g.setFont(Constants.SMALLFONT);
                int numW = this.getFontMetrics(Constants.SMALLFONT).stringWidth((String)this.numAnnosPerTier.get(node.getTierName()));
                if (!this.reducedTierHeight) {
                    g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, minY + this.tierHeight - 1);
                } else {
                    int xx = x - 3 - numW;
                    if (xx >= 5) {
                        x = xx;
                        g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, y);
                    }
                }
            }
            g.setFont(this.boldFont);
            g.drawLine(x, y + 3, x + actualLabelWidth, y + 3);
            g.drawString(label, x, y);
        } else {
            label = this.truncateString(node.getTierName(), availableLabelWidth, this.fontMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.fontMetrics, label);
            int x = 5 + availableLabelWidth - actualLabelWidth;
            y += this.getFont().getSize() / 2;
            Color col = (Color)this.prefTierColors.get(node.getTier());
            if (col == null) {
                TierImpl root = node.getTier().getRootTier();
                if (root != null) {
                    g.setColor((Color)this.tierRootColors.get(root));
                }
            } else {
                g.setColor(col);
            }
            if (this.showNumberOfAnnotations) {
                g.setFont(Constants.SMALLFONT);
                int numW = this.getFontMetrics(Constants.SMALLFONT).stringWidth((String)this.numAnnosPerTier.get(node.getTierName()));
                if (!this.reducedTierHeight) {
                    g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, minY + this.tierHeight - 2);
                } else {
                    int xx = x - 3 - numW;
                    if (xx >= 5) {
                        x = xx;
                        g.drawString((String)this.numAnnosPerTier.get(node.getTierName()), this.getWidth() - 5 - numW, y);
                    }
                }
            }
            g.setFont(this.getFont());
            g.drawString(label, x, y);
        }
    }

    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        int tierIndex = this.getClosestTierIndexForMouseY(p.y);
        if (tierIndex >= this.displayableTierNodes.size()) {
            return;
        }
        TierTreeNode tierNode = (TierTreeNode)this.displayableTierNodes.get(tierIndex);
        TierImpl tier = tierNode.getTier();
        if (tier == null) {
            return;
        }
        StringBuffer tooltip = new StringBuffer("<html><table>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.TierName"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getName());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Parent"));
        tooltip.append("</b></td><td>");
        if (tier.hasParentTier()) {
            tooltip.append(tier.getParentTier().getName());
        } else {
            tooltip.append("-");
        }
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Participant"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getParticipant());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Annotator"));
        tooltip.append("</b></td><td>");
        tooltip.append(tier.getAnnotator());
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.LinguisticType"));
        tooltip.append("</b></td><td>");
        if (tier.getLinguisticType() != null) {
            tooltip.append(tier.getLinguisticType().getLinguisticTypeName());
        }
        tooltip.append("</td></tr>");
        tooltip.append("<tr><td><b>");
        tooltip.append(ElanLocale.getString("EditTierDialog.Label.Language"));
        tooltip.append("</b></td><td>");
        Locale defLoc = tier.getDefaultLocale();
        if (defLoc != null) {
            tooltip.append(defLoc.getDisplayName());
        }
        tooltip.append("</td></tr>");
        tooltip.append("</table></html>");
        this.setToolTipText(tooltip.toString());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    public void preferencesChanged() {
        Boolean numAnn;
        Integer sortMode;
        String atName;
        List hiddenTiers = (List)Preferences.get("MultiTierViewer.HiddenTiers", this.transcription);
        List tierOrder = (List)Preferences.get("MultiTierViewer.TierOrder", this.transcription);
        List collTiers = (List)Preferences.get("MultiTierViewer.CollapsedTiers", this.transcription);
        Object useTyp = Preferences.get("MultiTierViewer.SortAlpabetically", this.transcription);
        if (useTyp instanceof Boolean) {
            this.sortAlphabetically = (Boolean)useTyp;
        }
        if (tierOrder != null) {
            int i;
            if (hiddenTiers != null) {
                for (i = tierOrder.size() - 1; i >= 0; --i) {
                    Object tn = tierOrder.get(i);
                    if (!hiddenTiers.contains(tn)) continue;
                    tierOrder.remove(i);
                }
            }
            for (i = 0; i < this.tiers.size(); ++i) {
                Tier t = (Tier)this.tiers.get(i);
                if (hiddenTiers == null || hiddenTiers.contains(t.getName()) || tierOrder.contains(t.getName())) continue;
                tierOrder.add(t.getName());
            }
            this.setTierOrder(tierOrder);
        }
        if ((atName = (String)Preferences.get("MultiTierViewer.ActiveTierName", this.transcription)) != null) {
            this.setActiveTierForName(atName);
        }
        if ((sortMode = (Integer)Preferences.get("MultiTierViewer.TierSortingMode", this.transcription)) != null) {
            this.setSorting(sortMode);
        }
        if (collTiers != null && collTiers.size() > 0 && this.sortedRootNode != null) {
            Enumeration<TreeNode> en = this.sortedRootNode.preorderEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                TierTreeNode nn = (TierTreeNode)en.nextElement();
                if (!collTiers.contains(nn.getTierName())) continue;
                nn.setExpanded(false);
            }
        }
        this.prefTierColors.clear();
        Object colorsObj = Preferences.get("TierColors", this.transcription);
        if (colorsObj instanceof Map) {
            Map colors = (Map)colorsObj;
            for (String name : colors.keySet()) {
                Color col = (Color)colors.get(name);
                TierImpl t = (TierImpl)this.transcription.getTierWithId(name);
                if (t == null) continue;
                if (t.getParentTier() == null) {
                    this.tierRootColors.put(t, col);
                }
                this.prefTierColors.put(t, col);
            }
        }
        if ((numAnn = (Boolean)Preferences.get("MultiTierViewer.ShowNumberOfAnnotations", this.transcription)) != null) {
            this.showNumberOfAnnotations = numAnn;
            this.numAnnosMI.setSelected(this.showNumberOfAnnotations);
        }
        this.updateDisplayableTiers();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.resizer != null) {
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
        }
        this.paintBuffer();
    }

    public void componentShown(ComponentEvent e) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TierComparer
    implements Comparator<TierImpl> {
        @Override
        public int compare(TierImpl o1, TierImpl o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VisibilityDialog
    extends ClosableDialog
    implements ActionListener,
    MouseListener {
        private Transcription trans;
        private Vector allTiers;
        private Vector visibleTiers;
        private Vector<String> allTierNames;
        private Vector<LinguisticType> allLinguisticTypes;
        private Vector<String> allLinTypeNames;
        private Vector<String> visibleTypeNames;
        private Vector<String> allParticipants;
        private Vector<String> visibleParts;
        private Vector<String> allAnnotators;
        private Vector<String> visibleAnns;
        private final String NOT_SPECIFIED = "not specified";
        private final String SHOW_TIERS;
        private final String SHOW_TYPES;
        private final String SHOW_PART;
        private final String SHOW_ANN;
        private JPanel checkboxPanel;
        private JButton showAllButton;
        private JButton hideAllButton;
        private JButton applyButton;
        private JButton cancelButton;
        private JButton sortButton;
        private JButton sortDefaultButton;
        private JTabbedPane showTabPane;
        private boolean sortAlphabetically;
        private int currentTabIndex;

        public VisibilityDialog(Transcription trans, Vector visibleTiers) {
            super(ELANCommandFactory.getRootFrame(trans), ElanLocale.getString("MultiTierControlPanel.Menu.VisibleTiers"), true);
            this.NOT_SPECIFIED = "not specified";
            this.SHOW_TIERS = ElanLocale.getString("MultiTierControlPanel.Menu.ShowTiers");
            this.SHOW_TYPES = ElanLocale.getString("MultiTierControlPanel.Menu.ShowLinguisticType");
            this.SHOW_PART = ElanLocale.getString("MultiTierControlPanel.Menu.ShowParticipant");
            this.SHOW_ANN = ElanLocale.getString("MultiTierControlPanel.Menu.ShowAnnotator");
            this.sortAlphabetically = false;
            this.currentTabIndex = 0;
            this.trans = trans;
            this.allTiers = trans.getTiers();
            this.visibleTiers = visibleTiers;
            this.allLinguisticTypes = trans.getLinguisticTypes();
            this.allLinTypeNames = new Vector();
            this.allTierNames = new Vector();
            this.allParticipants = new Vector();
            this.allAnnotators = new Vector();
            this.visibleTypeNames = new Vector();
            this.visibleParts = new Vector();
            this.visibleAnns = new Vector();
            this.initDialog();
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocation();
            this.setVisible(true);
        }

        private void initDialog() {
            JCheckBox checkbox;
            int i;
            this.showAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.ShowAllTiers"));
            this.showAllButton.addActionListener(this);
            this.hideAllButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.HideAllTiers"));
            this.hideAllButton.addActionListener(this);
            this.applyButton = new JButton(ElanLocale.getString("Button.OK"));
            this.applyButton.addActionListener(this);
            this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
            this.cancelButton.addActionListener(this);
            this.sortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Sort"));
            this.sortButton.addActionListener(this);
            this.sortDefaultButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Default"));
            this.sortDefaultButton.addActionListener(this);
            this.showTabPane = new JTabbedPane();
            JPanel buttonPanel1 = new JPanel(new GridBagLayout());
            buttonPanel1.add(this.sortButton);
            buttonPanel1.add(this.sortDefaultButton);
            buttonPanel1.add(this.showAllButton);
            buttonPanel1.add(this.hideAllButton);
            GridLayout gl = new GridLayout(1, 2, 6, 2);
            JPanel buttonPanel2 = new JPanel(gl);
            buttonPanel2.add(this.applyButton);
            buttonPanel2.add(this.cancelButton);
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().setPreferredSize(new Dimension(600, 400));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 0;
            gbc.anchor = 11;
            gbc.insets = new Insets(2, 6, 2, 6);
            gbc.gridy = 1;
            gbc.gridx = 0;
            this.getContentPane().add((Component)buttonPanel1, gbc);
            gbc.gridy = 1;
            gbc.gridx = 2;
            gbc.anchor = 13;
            this.getContentPane().add((Component)buttonPanel2, gbc);
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 3;
            gbc.fill = 1;
            this.getContentPane().add((Component)this.showTabPane, gbc);
            this.getRootPane().setDefaultButton(this.applyButton);
            this.checkboxPanel = new JPanel();
            BoxLayout box = new BoxLayout(this.checkboxPanel, 1);
            this.checkboxPanel.setLayout(box);
            for (i = 0; i < this.allTiers.size(); ++i) {
                String annName;
                TierImpl tier = (TierImpl)this.allTiers.get(i);
                checkbox = new JCheckBox(tier.getName());
                this.allTierNames.add(tier.getName());
                this.checkboxPanel.add(checkbox);
                String partName = tier.getParticipant();
                if (partName.length() == 0) {
                    partName = "not specified";
                }
                if (!this.allParticipants.contains(partName)) {
                    this.allParticipants.add(partName);
                }
                if ((annName = tier.getAnnotator()).length() == 0) {
                    annName = "not specified";
                }
                if (this.allAnnotators.contains(annName)) continue;
                this.allAnnotators.add(annName);
            }
            this.showTabPane.add(this.SHOW_TIERS, new JScrollPane(this.checkboxPanel));
            this.checkboxPanel = new JPanel();
            box = new BoxLayout(this.checkboxPanel, 1);
            this.checkboxPanel.setLayout(box);
            for (i = 0; i < this.allLinguisticTypes.size(); ++i) {
                String type = this.allLinguisticTypes.get(i).getLinguisticTypeName();
                this.allLinTypeNames.add(type);
                checkbox = new JCheckBox(type);
                this.checkboxPanel.add(checkbox);
            }
            this.showTabPane.add(this.SHOW_TYPES, new JScrollPane(this.checkboxPanel));
            this.checkboxPanel = new JPanel();
            box = new BoxLayout(this.checkboxPanel, 1);
            this.checkboxPanel.setLayout(box);
            for (i = 0; i < this.allParticipants.size(); ++i) {
                checkbox = new JCheckBox(this.allParticipants.get(i));
                this.checkboxPanel.add(checkbox);
            }
            this.showTabPane.addTab(this.SHOW_PART, new JScrollPane(this.checkboxPanel));
            this.checkboxPanel = new JPanel();
            box = new BoxLayout(this.checkboxPanel, 1);
            this.checkboxPanel.setLayout(box);
            for (i = 0; i < this.allAnnotators.size(); ++i) {
                checkbox = new JCheckBox(this.allAnnotators.get(i));
                this.checkboxPanel.add(checkbox);
            }
            this.showTabPane.addTab(this.SHOW_ANN, new JScrollPane(this.checkboxPanel));
            this.showTabPane.addMouseListener(this);
            this.showTiers();
        }

        private void updateTab(int index, Vector<String> sortedList) {
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            checkboxPanel.removeAll();
            for (int i = 0; i < sortedList.size(); ++i) {
                checkboxPanel.add(new JCheckBox(sortedList.get(i)));
            }
            this.showTabPane.repaint();
            this.updateTabAtIndex(index);
        }

        private void updateShowTiersTab() {
            int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            checkboxPanel.removeAll();
            for (int i = 0; i < this.allTierNames.size(); ++i) {
                checkboxPanel.add(new JCheckBox(this.allTierNames.get(i)));
            }
            this.showTabPane.repaint();
            this.showTiers();
        }

        private void updateShowTypesTab() {
            int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            checkboxPanel.removeAll();
            for (int i = 0; i < this.allLinTypeNames.size(); ++i) {
                checkboxPanel.add(new JCheckBox(this.allLinTypeNames.get(i)));
            }
            this.showTabPane.repaint();
            this.showTypes();
        }

        private void updateShowPartTab() {
            int index = this.showTabPane.indexOfTab(this.SHOW_PART);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            checkboxPanel.removeAll();
            for (int i = 0; i < this.allParticipants.size(); ++i) {
                checkboxPanel.add(new JCheckBox(this.allParticipants.get(i)));
            }
            this.showTabPane.repaint();
            this.showParticipants();
        }

        private void updateShowAnnTab() {
            int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            checkboxPanel.removeAll();
            for (int i = 0; i < this.allAnnotators.size(); ++i) {
                checkboxPanel.add(new JCheckBox(this.allAnnotators.get(i)));
            }
            this.showTabPane.repaint();
            this.showAnnotators();
        }

        private void setLocation() {
            MultiTierControlPanel parent = MultiTierControlPanel.this;
            Point p = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p, parent);
            int windowHeight = SwingUtilities.getWindowAncestor(parent).getHeight();
            if (this.getHeight() > windowHeight) {
                this.setSize(this.getWidth(), windowHeight);
            }
            p.x += ((Component)parent).getWidth();
            p.y -= this.getHeight() - ((Component)parent).getHeight();
            this.setLocation(p);
        }

        private Vector<String> getVisibleTierNames() {
            Vector<String> visibleTierNames = new Vector<String>();
            if (this.visibleTiers != null) {
                for (int i = 0; i < this.visibleTiers.size(); ++i) {
                    TierImpl tier = (TierImpl)this.visibleTiers.get(i);
                    visibleTierNames.add(tier.getName());
                }
            }
            return visibleTierNames;
        }

        private void showTiers() {
            int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Vector<String> visibleTierNames = this.getVisibleTierNames();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox)) continue;
                if (visibleTierNames.contains(((JCheckBox)boxes[i]).getText())) {
                    ((JCheckBox)boxes[i]).setSelected(true);
                    continue;
                }
                ((JCheckBox)boxes[i]).setSelected(false);
            }
        }

        private void showTypes() {
            int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox)) continue;
                if (this.visibleTypeNames.contains(((JCheckBox)boxes[i]).getText())) {
                    ((JCheckBox)boxes[i]).setSelected(true);
                    continue;
                }
                ((JCheckBox)boxes[i]).setSelected(false);
            }
        }

        private void showParticipants() {
            int index = this.showTabPane.indexOfTab(this.SHOW_PART);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox)) continue;
                if (this.visibleParts.contains(((JCheckBox)boxes[i]).getText())) {
                    ((JCheckBox)boxes[i]).setSelected(true);
                    continue;
                }
                ((JCheckBox)boxes[i]).setSelected(false);
            }
        }

        private void showAnnotators() {
            int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox)) continue;
                if (this.visibleAnns.contains(((JCheckBox)boxes[i]).getText())) {
                    ((JCheckBox)boxes[i]).setSelected(true);
                    continue;
                }
                ((JCheckBox)boxes[i]).setSelected(false);
            }
        }

        private void updateTiers() {
            int index = this.showTabPane.indexOfTab(this.SHOW_TIERS);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Vector<String> oldVisibleTierNames = this.getVisibleTierNames();
            boolean valueChanged = false;
            this.visibleTiers.clear();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected()) continue;
                String tierName = ((JCheckBox)boxes[i]).getText();
                this.visibleTiers.add(this.trans.getTierWithId(tierName));
                if (oldVisibleTierNames.contains(tierName)) continue;
                valueChanged = true;
            }
            if (valueChanged) {
                this.visibleTypeNames.clear();
                this.visibleParts.clear();
                this.visibleAnns.clear();
            }
        }

        private void updateLinguisticTypes() {
            String typeName;
            int i;
            int index = this.showTabPane.indexOfTab(this.SHOW_TYPES);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            boolean changed = false;
            Vector<String> selectedTypes = new Vector<String>();
            Component[] boxes = checkboxPanel.getComponents();
            for (i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedTypes.contains(typeName = ((JCheckBox)boxes[i]).getText())) continue;
                selectedTypes.add(typeName);
            }
            if (selectedTypes.size() != this.visibleTypeNames.size()) {
                changed = true;
            } else {
                for (i = 0; i < selectedTypes.size(); ++i) {
                    if (this.visibleTypeNames.contains(selectedTypes.get(i))) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.visibleTypeNames = selectedTypes;
                this.visibleTiers.clear();
                for (i = 0; i < this.visibleTypeNames.size(); ++i) {
                    typeName = this.visibleTypeNames.get(i);
                    if (typeName.equals("not specified")) {
                        typeName = "";
                    }
                    this.visibleTiers.addAll(this.trans.getTiersWithLinguisticType(typeName));
                }
                this.visibleAnns.clear();
                this.visibleParts.clear();
            }
        }

        private void updateParticipants() {
            int i;
            int index = this.showTabPane.indexOfTab(this.SHOW_PART);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            boolean changed = false;
            Vector<String> selectedPart = new Vector<String>();
            Component[] boxes = checkboxPanel.getComponents();
            for (i = 0; i < boxes.length; ++i) {
                String partName;
                if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedPart.contains(partName = ((JCheckBox)boxes[i]).getText())) continue;
                selectedPart.add(partName);
            }
            if (selectedPart.size() != this.visibleParts.size()) {
                changed = true;
            } else {
                for (i = 0; i < selectedPart.size(); ++i) {
                    if (this.visibleParts.contains(selectedPart.get(i))) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.visibleTiers.clear();
                this.visibleParts = selectedPart;
                for (i = 0; i < this.allTiers.size(); ++i) {
                    TierImpl tier = (TierImpl)this.allTiers.get(i);
                    String partName = tier.getParticipant();
                    if (partName.length() == 0) {
                        partName = "not specified";
                    }
                    if (!this.visibleParts.contains(partName)) continue;
                    this.visibleTiers.add(tier);
                }
                this.visibleTypeNames.clear();
                this.visibleAnns.clear();
            }
        }

        private void updateAnnotators() {
            int i;
            int index = this.showTabPane.indexOfTab(this.SHOW_ANN);
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            boolean changed = false;
            Vector<String> selectedAnn = new Vector<String>();
            Component[] boxes = checkboxPanel.getComponents();
            for (i = 0; i < boxes.length; ++i) {
                String annName;
                if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedAnn.contains(annName = ((JCheckBox)boxes[i]).getText())) continue;
                selectedAnn.add(annName);
            }
            if (selectedAnn.size() != this.visibleAnns.size()) {
                changed = true;
            } else {
                for (i = 0; i < selectedAnn.size(); ++i) {
                    if (this.visibleAnns.contains(selectedAnn.get(i))) continue;
                    changed = true;
                    break;
                }
            }
            if (changed) {
                this.visibleAnns = selectedAnn;
                this.visibleTiers.clear();
                for (i = 0; i < this.allTiers.size(); ++i) {
                    TierImpl tier = (TierImpl)this.allTiers.get(i);
                    String annName = tier.getAnnotator();
                    if (annName.length() == 0) {
                        annName = "not specified";
                    }
                    if (!this.visibleAnns.contains(annName)) continue;
                    this.visibleTiers.add(tier);
                }
                this.visibleTypeNames.clear();
                this.visibleParts.clear();
            }
        }

        private void updateVisibleTiers() {
            MultiTierControlPanel.this.updateVisibleTiers(this.getVisibleTierNames());
        }

        private void setAllSelected(boolean selected) {
            int index = this.showTabPane.getSelectedIndex();
            JPanel checkboxPanel = (JPanel)((JScrollPane)this.showTabPane.getComponentAt(index)).getViewport().getView();
            Component[] boxes = checkboxPanel.getComponents();
            for (int i = 0; i < boxes.length; ++i) {
                if (!(boxes[i] instanceof JCheckBox)) continue;
                ((JCheckBox)boxes[i]).setSelected(selected);
            }
        }

        private void close() {
            this.setVisible(false);
            this.dispose();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source == this.showAllButton) {
                this.setAllSelected(true);
            } else if (source == this.hideAllButton) {
                this.setAllSelected(false);
            } else if (source == this.applyButton) {
                this.updateChanges(this.showTabPane.getSelectedIndex());
                this.updateVisibleTiers();
                this.close();
            } else if (source == this.cancelButton) {
                this.close();
            } else if (source == this.sortButton) {
                this.sortAlphabetically = true;
                int index = this.showTabPane.getSelectedIndex();
                this.updateChanges(index);
                this.sortAlphabetically(index);
            } else if (source == this.sortDefaultButton) {
                this.sortAlphabetically = false;
                int index = this.showTabPane.getSelectedIndex();
                this.updateChanges(index);
                this.sortInDefaultOrder(index);
            }
        }

        private void sortInDefaultOrder(int index) {
            String tabName = this.showTabPane.getTitleAt(index);
            if (tabName.equals(this.SHOW_TYPES)) {
                this.updateTab(index, this.allLinTypeNames);
            } else if (tabName.equals(this.SHOW_TIERS)) {
                this.updateTab(index, this.allTierNames);
            } else if (tabName.equals(this.SHOW_PART)) {
                this.updateTab(index, this.allParticipants);
            } else if (tabName.equals(this.SHOW_ANN)) {
                this.updateTab(index, this.allAnnotators);
            }
        }

        private void sortAlphabetically(int index) {
            String tabName = this.showTabPane.getTitleAt(index);
            if (tabName.equals(this.SHOW_TYPES)) {
                Object[] array = this.allLinTypeNames.toArray();
                Arrays.sort(array);
                Vector<String> sortedLinTypeNames = new Vector<String>();
                for (int i = 0; i < array.length; ++i) {
                    sortedLinTypeNames.add((String)array[i]);
                }
                this.updateTab(index, sortedLinTypeNames);
            } else if (tabName.equals(this.SHOW_TIERS)) {
                Object[] array = this.allTierNames.toArray();
                Arrays.sort(array);
                Vector<String> sortedTierNames = new Vector<String>();
                for (int i = 0; i < array.length; ++i) {
                    sortedTierNames.add((String)array[i]);
                }
                this.updateTab(index, sortedTierNames);
            } else if (tabName.equals(this.SHOW_PART)) {
                Object[] array = this.allParticipants.toArray();
                Arrays.sort(array);
                Vector<String> sortedParticipants = new Vector<String>();
                for (int i = 0; i < array.length; ++i) {
                    sortedParticipants.add((String)array[i]);
                }
                this.updateTab(index, sortedParticipants);
            } else if (tabName.equals(this.SHOW_ANN)) {
                Object[] array = this.allAnnotators.toArray();
                Arrays.sort(array);
                Vector<String> sortedAnnotators = new Vector<String>();
                for (int i = 0; i < array.length; ++i) {
                    sortedAnnotators.add((String)array[i]);
                }
                this.updateTab(index, sortedAnnotators);
            }
        }

        private void updateChanges(int index) {
            String tabName = this.showTabPane.getTitleAt(index);
            if (tabName.equals(this.SHOW_TYPES)) {
                this.updateLinguisticTypes();
            } else if (tabName.equals(this.SHOW_TIERS)) {
                this.updateTiers();
            } else if (tabName.equals(this.SHOW_PART)) {
                this.updateParticipants();
            } else if (tabName.equals(this.SHOW_ANN)) {
                this.updateAnnotators();
            }
        }

        private void updateTabAtIndex(int index) {
            String tabName = this.showTabPane.getTitleAt(index);
            if (tabName.equals(this.SHOW_TYPES)) {
                this.showTypes();
            } else if (tabName.equals(this.SHOW_TIERS)) {
                this.showTiers();
            } else if (tabName.equals(this.SHOW_PART)) {
                this.showParticipants();
            } else if (tabName.equals(this.SHOW_ANN)) {
                this.showAnnotators();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == this.showTabPane) {
                this.updateChanges(this.currentTabIndex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == this.showTabPane) {
                this.currentTabIndex = this.showTabPane.getSelectedIndex();
                this.updateTabAtIndex(this.currentTabIndex);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    public class TierTreeNode
    extends DefaultMutableTreeNode {
        private TierImpl tier;
        private String tierName;
        private String label;
        private boolean visible = true;
        private boolean active = false;
        private boolean expanded = true;

        public TierTreeNode(TierImpl tier) {
            this.tier = tier;
            this.label = this.tierName = tier.getName();
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public void setExpanded(boolean expanded) {
            this.expanded = expanded;
        }

        public TierImpl getTier() {
            return this.tier;
        }

        public void setTier(TierImpl tier) {
            this.tier = tier;
        }

        public String getTierName() {
            return this.tierName;
        }

        public void setTierName(String tierName) {
            this.tierName = tierName;
        }

        public String toString() {
            return this.tierName;
        }
    }
}

