/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.util.Tag2D;
import mpi.eudico.client.annotator.util.Tier2D;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeInterval;

public class SegmentationViewer
extends AbstractViewer
implements SingleTierViewer,
MouseListener,
MouseMotionListener,
ComponentListener {
    private Transcription transcription;
    private Font font;
    private FontMetrics metrics;
    private int rulerHeight;
    private TimeRuler ruler;
    private BufferedImage bi;
    private Graphics2D big2d;
    private int msPerPixel;
    private int imageWidth;
    private int imageHeight;
    private long crossHairTime;
    private int crossHairPos;
    private long intervalBeginTime;
    private long intervalEndTime;
    private Point dragStartPoint;
    private Point dragEndPoint;
    private int pixelsForTierHeight;
    private int pixelsForTierHeightMargin;
    public final int SCROLL_OFFSET = 16;
    private boolean panMode;
    private TierImpl tier;
    private Tier2D tier2d;
    private Tier2D segments2d;
    private long currentBeginTime = -1L;

    public SegmentationViewer(Transcription transcription) {
        this.transcription = transcription;
        this.initViewer();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(true);
        this.paintBuffer();
    }

    private void initViewer() {
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.metrics = this.getFontMetrics(this.font);
        this.ruler = new TimeRuler(this.font, TimeFormatter.toString(0L));
        this.rulerHeight = this.ruler.getHeight();
        this.msPerPixel = 10;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.pixelsForTierHeight = this.font.getSize() * 3;
        this.pixelsForTierHeightMargin = 2;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int h = this.getHeight();
        if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        }
        if (this.crossHairPos >= 0 && this.crossHairPos <= this.imageWidth) {
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        }
    }

    private void paintBuffer() {
        int width;
        int x;
        Tag2D tag2d;
        Iterator tagIt;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.imageWidth != this.getWidth()) {
            this.imageWidth = this.getWidth();
        }
        if (this.imageHeight != this.getHeight()) {
            this.imageHeight = this.getHeight();
        }
        this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
        if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
            this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.big2d = this.bi.createGraphics();
        }
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.imageWidth, this.bi.getHeight());
        if (this.intervalEndTime > this.getMediaDuration()) {
            int xx = this.xAt(this.getMediaDuration());
            if (!SystemReporting.isMacOS()) {
                this.big2d.setColor(UIManager.getColor("Panel.background"));
            } else {
                this.big2d.setColor(Color.LIGHT_GRAY);
            }
            this.big2d.fillRect(xx, 0, this.imageWidth - xx, this.bi.getHeight());
        }
        this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
        this.big2d.translate(-(this.intervalBeginTime / (long)this.msPerPixel), 0.0);
        this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth, this.msPerPixel, 1);
        this.big2d.setFont(this.font);
        int height = this.pixelsForTierHeight - 2 * this.pixelsForTierHeightMargin;
        int y = this.rulerHeight + this.pixelsForTierHeightMargin;
        if (this.tier2d != null) {
            tagIt = this.tier2d.getTags();
            while (tagIt.hasNext()) {
                tag2d = (Tag2D)tagIt.next();
                if (tag2d.getEndTime() < this.intervalBeginTime) continue;
                if (tag2d.getBeginTime() > this.intervalEndTime) break;
                x = tag2d.getX();
                width = tag2d.getWidth();
                this.big2d.drawLine(x, y, x, y + height);
                this.big2d.drawLine(x, y + height / 2, x + width, y + height / 2);
                this.big2d.drawLine(x + width, y, x + width, y + height);
                int descent = this.big2d.getFontMetrics().getDescent();
                this.big2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height / 2 - descent + 1)));
            }
        }
        if (this.segments2d != null) {
            this.big2d.setColor(Constants.SHAREDCOLOR3);
            tagIt = this.segments2d.getTags();
            int intBeginPos = this.timeToPixels(this.intervalBeginTime);
            int intEndPos = this.timeToPixels(this.intervalEndTime);
            while (tagIt.hasNext()) {
                tag2d = (Tag2D)tagIt.next();
                x = tag2d.getX();
                if (x + (width = tag2d.getWidth()) < intBeginPos) continue;
                if (x > intEndPos) break;
                this.big2d.drawLine(x, y, x, y + height);
                this.big2d.drawLine(x, y + height / 2, x + width, y + height / 2);
                this.big2d.drawLine(x + width, y, x + width, y + height);
                int descent = this.big2d.getFontMetrics().getDescent();
                this.big2d.drawString(tag2d.getTruncatedValue(), (float)(x + 4), (float)(y + (height / 2 - descent + 1)));
            }
        }
        if (this.currentBeginTime > -1L) {
            this.big2d.setColor(Constants.SHAREDCOLOR3);
            x = this.timeToPixels(this.currentBeginTime);
            this.big2d.drawLine(x, y, x, y + height);
        }
        this.big2d.setTransform(new AffineTransform());
        this.repaint();
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        String line = string.replace('\n', ' ');
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth(line)) > width - 4) {
            int i = 0;
            String s = "";
            int size = line.length();
            while (i < size && fMetrics.stringWidth(s) <= width - 4) {
                s = s + line.charAt(i++);
            }
            line = !s.equals("") ? s.substring(0, s.length() - 1) : s;
        }
        return line;
    }

    private void setIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        if (this.playerIsPlaying()) {
            this.intervalBeginTime = begin;
            this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
            this.crossHairPos = this.xAt(this.crossHairTime);
        } else {
            this.intervalBeginTime = !this.panMode ? begin - (long)(16 * this.msPerPixel) : begin;
            if (this.intervalBeginTime < 0L) {
                this.intervalBeginTime = 0L;
            }
            this.intervalEndTime = this.intervalBeginTime + (long)(this.imageWidth * this.msPerPixel);
            this.crossHairPos = this.xAt(this.crossHairTime);
        }
        this.paintBuffer();
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime >= this.intervalEndTime) {
                this.setIntervalBeginTime(this.crossHairTime);
            } else if (this.playerIsPlaying()) {
                long intervalMidTime = (this.intervalBeginTime + this.intervalEndTime) / 2L;
                if (this.crossHairTime > intervalMidTime + (long)(1 * this.msPerPixel)) {
                    this.setIntervalBeginTime(this.intervalBeginTime + (this.crossHairTime - intervalMidTime));
                } else if (this.crossHairTime < intervalMidTime) {
                    int oldPos = this.crossHairPos;
                    this.crossHairPos = this.xAt(this.crossHairTime);
                    if (this.crossHairPos >= oldPos) {
                        this.repaint(oldPos - 2, 0, this.crossHairPos - oldPos + 4, this.getHeight());
                    } else {
                        this.repaint(this.crossHairPos - 2, 0, oldPos - this.crossHairPos + 4, this.getHeight());
                    }
                } else {
                    this.repaint();
                }
            } else {
                int oldPos = this.crossHairPos;
                this.crossHairPos = this.xAt(this.crossHairTime);
                if (this.crossHairPos >= oldPos) {
                    this.repaint(oldPos - 2, 0, this.crossHairPos - oldPos + 4, this.getHeight());
                } else {
                    this.repaint(this.crossHairPos - 2, 0, oldPos - this.crossHairPos + 4, this.getHeight());
                }
            }
        }
    }

    public void updateSelection() {
    }

    public void updateActiveAnnotation() {
    }

    public void updateLocale() {
    }

    public void setTier(Tier tier) {
        this.tier = tier instanceof TierImpl ? (TierImpl)tier : null;
        this.createTier2D(this.tier);
        this.paintBuffer();
    }

    public Tier getTier() {
        return this.tier;
    }

    public void preferencesChanged() {
    }

    public void addSegment(TimeInterval ti) {
        if (ti == null || ti.getDuration() <= 0L) {
            return;
        }
        Tag2D tag2d = new Tag2D(null);
        int x = this.timeToPixels(ti.getBeginTime());
        int w = this.timeToPixels(ti.getEndTime()) - x;
        tag2d.setX(x);
        tag2d.setWidth(w);
        if (ti instanceof AnnotationDataRecord && ((AnnotationDataRecord)ti).getValue() != null) {
            tag2d.setTruncatedValue(this.truncateString(((AnnotationDataRecord)ti).getValue(), w, this.metrics));
        }
        this.currentBeginTime = -1L;
        if (this.segments2d != null) {
            this.segments2d.insertTag(tag2d);
            this.paintBuffer();
        }
    }

    public void setCurrentBeginTime(long time) {
        this.currentBeginTime = time;
        this.paintBuffer();
    }

    private void createTier2D(TierImpl tier) {
        if (tier == null) {
            this.tier2d = null;
            this.segments2d = null;
        }
        this.tier2d = new Tier2D(tier);
        this.segments2d = new Tier2D(tier);
        for (Annotation a : tier.getAnnotations()) {
            Tag2D tag2d = new Tag2D(a);
            int xPos = this.timeToPixels(a.getBeginTimeBoundary());
            tag2d.setX(xPos);
            int tagWidth = this.timeToPixels(a.getEndTimeBoundary()) - xPos;
            tag2d.setWidth(tagWidth);
            tag2d.setTruncatedValue(this.truncateString(a.getValue(), tagWidth, this.metrics));
            this.tier2d.addTag(tag2d);
        }
    }

    public int xAt(long t) {
        return (int)((t - this.intervalBeginTime) / (long)this.msPerPixel);
    }

    private int timeToPixels(long theTime) {
        return (int)theTime / this.msPerPixel;
    }

    public long timeAt(int x) {
        return this.intervalBeginTime + (long)(x * this.msPerPixel);
    }

    public void mouseClicked(MouseEvent e) {
        this.setMediaTime(this.timeAt(e.getPoint().x));
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isAltDown()) {
            if (this.playerIsPlaying()) {
                this.stopPlayer();
            }
            this.dragStartPoint = e.getPoint();
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.panMode) {
            this.dragEndPoint = e.getPoint();
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)(scrolldiff * this.msPerPixel);
            if (this.intervalBeginTime < 0L && newTime < this.intervalBeginTime) {
                newTime = this.intervalBeginTime;
            }
            this.setIntervalBeginTime(newTime);
            this.dragStartPoint = this.dragEndPoint;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.paintBuffer();
    }

    public void componentShown(ComponentEvent e) {
        this.paintBuffer();
    }
}

