/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class SingleTierViewerPanel
extends JPanel
implements ACMEditListener,
ElanLocaleListener,
ItemListener {
    private static final String EMPTY_ITEM = "Empty";
    private ViewerManager2 viewerManager;
    private SingleTierViewer viewer;
    private JComboBox tierComboBox;
    private JCheckBox multiCheckBox;
    private Hashtable tierTable;
    private Tier currentTier;

    public SingleTierViewerPanel(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.tierComboBox = new JComboBox();
        this.tierComboBox.setMaximumRowCount(20);
        this.multiCheckBox = new JCheckBox();
        this.tierTable = new Hashtable();
        this.fillComboBox();
        this.tierComboBox.addItemListener(this);
        this.multiCheckBox.addItemListener(this);
        this.setLayout(new BorderLayout());
    }

    public void setViewer(SingleTierViewer viewer) {
        this.viewer = viewer;
        if (this.currentTier != null) {
            this.viewerManager.setTierForViewer(viewer, this.currentTier);
        }
        if (viewer instanceof GridViewer) {
            JPanel jp = new JPanel();
            jp.setLayout(new BorderLayout());
            jp.add((Component)this.multiCheckBox, "West");
            jp.add((Component)this.tierComboBox, "Center");
            this.add((Component)jp, "North");
        } else {
            this.add((Component)this.tierComboBox, "North");
        }
        this.add((Component)((AbstractViewer)((Object)viewer)), "Center");
    }

    public SingleTierViewer getViewer() {
        return this.viewer;
    }

    private void fillComboBox() {
        this.tierComboBox.removeAllItems();
        this.tierTable.clear();
        this.tierComboBox.addItem(EMPTY_ITEM);
        try {
            Vector tiers = this.viewerManager.getTranscription().getTiers();
            int tiers_size = tiers.size();
            for (int i = 0; i < tiers_size; ++i) {
                Tier tier = (Tier)tiers.elementAt(i);
                String tierName = tier.getName();
                this.tierComboBox.addItem(tierName);
                this.tierTable.put(tierName, tier);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: {
                this.updateComboBox();
                break;
            }
            case 2: {
                if (!(e.getInvalidatedObject() instanceof TierImpl)) break;
                this.tierChanged((TierImpl)e.getInvalidatedObject());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void tierChanged(TierImpl tier) {
        block8: {
            if (tier == this.currentTier) {
                String curName = (String)this.tierComboBox.getSelectedItem();
                String newTierName = tier.getName();
                if (!newTierName.equals(curName)) {
                    this.tierTable.remove(curName);
                    this.tierTable.put(newTierName, this.currentTier);
                    for (int i = 0; i < this.tierComboBox.getItemCount(); ++i) {
                        if (!this.tierComboBox.getItemAt(i).equals(curName)) continue;
                        this.tierComboBox.removeItemAt(i);
                        this.tierComboBox.insertItemAt(newTierName, i);
                        this.tierComboBox.setSelectedItem(newTierName);
                        break;
                    }
                }
            } else {
                String newTierName = tier.getName();
                if (!this.tierTable.containsKey(newTierName)) {
                    for (String name : this.tierTable.keySet()) {
                        if (this.tierTable.get(name) != tier) continue;
                        this.tierTable.remove(name);
                        this.tierTable.put(newTierName, tier);
                        for (int i = 0; i < this.tierComboBox.getItemCount(); ++i) {
                            if (!this.tierComboBox.getItemAt(i).equals(name)) continue;
                            this.tierComboBox.removeItemAt(i);
                            this.tierComboBox.insertItemAt(newTierName, i);
                            break block8;
                        }
                        break;
                    }
                }
            }
        }
        if (this.multiCheckBox.isSelected()) {
            this.updateComboBox();
        }
    }

    private void updateComboBox() {
        try {
            String strComboItem = (String)this.tierComboBox.getSelectedItem();
            if (!this.multiCheckBox.isSelected()) {
                this.fillComboBox();
                if (!this.tierTable.containsKey(strComboItem)) {
                    strComboItem = EMPTY_ITEM;
                }
            } else {
                this.fillComboBoxMulti();
                strComboItem = this.swapComboItemIfNecessary(strComboItem);
            }
            this.tierComboBox.setSelectedItem(strComboItem);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String swapComboItemIfNecessary(String strComboItem) {
        if (this.tierTable.containsKey(strComboItem)) {
            return strComboItem;
        }
        Vector tiers = this.viewerManager.getTranscription().getTiers();
        int tiers_size = tiers.size();
        for (int i = 0; i < tiers_size; ++i) {
            Tier tierParent;
            TierImpl tier = (TierImpl)tiers.elementAt(i);
            String tierName = tier.getName();
            if (!strComboItem.equals(tierName) || (tierParent = tier.getParentTier()) == null) continue;
            String parentName = tierParent.getName();
            return parentName;
        }
        return EMPTY_ITEM;
    }

    public void itemStateChanged(ItemEvent e) {
        Object objSource = e.getSource();
        if (objSource == this.tierComboBox) {
            if (e.getStateChange() == 1) {
                String selectedTierName = (String)this.tierComboBox.getSelectedItem();
                Tier tier = null;
                if (!selectedTierName.equals(EMPTY_ITEM)) {
                    tier = (Tier)this.tierTable.get(selectedTierName);
                }
                this.viewerManager.setTierForViewer(this.viewer, tier);
                this.currentTier = tier;
            }
        } else if (objSource == this.multiCheckBox) {
            if (this.viewer instanceof GridViewer) {
                if (!this.multiCheckBox.isSelected()) {
                    ((GridViewer)this.viewer).setMode(0);
                } else {
                    ((GridViewer)this.viewer).setMode(1);
                }
            }
            this.updateComboBox();
        }
    }

    private void fillComboBoxMulti() {
        this.tierComboBox.removeAllItems();
        this.tierTable.clear();
        this.tierComboBox.addItem(EMPTY_ITEM);
        try {
            Vector tiers = this.viewerManager.getTranscription().getTiers();
            int tiers_size = tiers.size();
            for (int i = 0; i < tiers_size; ++i) {
                TierImpl tier = (TierImpl)tiers.elementAt(i);
                LinguisticType lt = tier.getLinguisticType();
                Constraint c = lt.getConstraints();
                if (c == null || c.getStereoType() != 4) continue;
                Tier tierParent = tier.getParentTier();
                String parentName = tierParent.getName();
                this.addToCombo(parentName, tierParent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToCombo(String parentName, Tier tierParent) {
        String str = null;
        int combo_size = this.tierComboBox.getItemCount();
        for (int i = 0; i < combo_size; ++i) {
            str = (String)this.tierComboBox.getItemAt(i);
            if (str == null || !parentName.equals(str)) continue;
            return;
        }
        this.tierComboBox.addItem(parentName);
        this.tierTable.put(parentName, tierParent);
    }

    public void selectTier(String tierName) {
        if (tierName != null) {
            this.tierComboBox.setSelectedItem(tierName);
        }
    }

    public String getSelectedTierName() {
        String name = null;
        if (this.currentTier != null) {
            name = this.currentTier.getName();
        }
        return name;
    }

    public boolean isMultiTierMode() {
        return this.viewer instanceof GridViewer && this.multiCheckBox.isSelected();
    }

    public void setMultiTierMode(boolean multiMode) {
        if (this.viewer instanceof GridViewer) {
            this.multiCheckBox.setSelected(multiMode);
        }
    }

    public void updateLocale() {
        this.multiCheckBox.setToolTipText(ElanLocale.getString("SingleTierViewerPanel.Label.MultiTier"));
    }
}

