/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class StyledHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    public static final int STROKED = 0;
    public static final int FILLED = 1;
    int paintOffset;
    boolean visible = true;
    int paintMode = 0;

    public StyledHighlightPainter(Color c, int paintOffset) {
        super(c);
        this.paintOffset = paintOffset;
    }

    public StyledHighlightPainter(Color c, int paintOffset, int paintMode) {
        super(c);
        this.paintOffset = paintOffset;
        if (paintMode >= 0 && paintMode <= 1) {
            this.paintMode = paintMode;
        }
    }

    public void paint(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c) {
        if (!this.visible) {
            return;
        }
        Rectangle alloc = bounds.getBounds();
        try {
            TextUI mapper = c.getUI();
            Rectangle p0 = mapper.modelToView(c, offs0);
            Rectangle p1 = mapper.modelToView(c, offs1);
            Color color = this.getColor(offs0);
            if (color == null) {
                g.setColor(c.getSelectionColor());
            } else {
                g.setColor(color);
            }
            if (p0.y == p1.y) {
                Rectangle r = p0.union(p1);
                if (this.paintMode == 0) {
                    g.drawRect(r.x + this.paintOffset, r.y + this.paintOffset, r.width - 2 * this.paintOffset, r.height - 2 * this.paintOffset);
                } else if (this.paintMode == 1) {
                    g.fillRect(r.x + this.paintOffset, r.y + this.paintOffset, r.width - 2 * this.paintOffset, r.height - 2 * this.paintOffset);
                }
            } else {
                int p0ToMarginWidth = alloc.x + alloc.width - p0.x;
                if (this.paintMode == 0) {
                    g.drawRect(p0.x + this.paintOffset, p0.y + this.paintOffset, p0ToMarginWidth - 2 * this.paintOffset, p0.height - 2 * this.paintOffset);
                    if (p0.y + p0.height != p1.y) {
                        g.drawRect(alloc.x + this.paintOffset, p0.y + p0.height + this.paintOffset, alloc.width - 2 * this.paintOffset, p1.y - (p0.y + p0.height) - 2 * this.paintOffset);
                    }
                    g.drawRect(alloc.x + this.paintOffset, p1.y + this.paintOffset, p1.x - alloc.x - 2 * this.paintOffset, p1.height - 2 * this.paintOffset);
                } else if (this.paintMode == 1) {
                    g.fillRect(p0.x + this.paintOffset, p0.y + this.paintOffset, p0ToMarginWidth - 2 * this.paintOffset, p0.height - 2 * this.paintOffset);
                    if (p0.y + p0.height != p1.y) {
                        g.fillRect(alloc.x + this.paintOffset, p0.y + p0.height + this.paintOffset, alloc.width - 2 * this.paintOffset, p1.y - (p0.y + p0.height) - 2 * this.paintOffset);
                    }
                    g.fillRect(alloc.x + this.paintOffset, p1.y + this.paintOffset, p1.x - alloc.x - 2 * this.paintOffset, p1.height - 2 * this.paintOffset);
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        if (!this.visible) {
            return null;
        }
        Color color = this.getColor(offs0);
        if (color == null) {
            g.setColor(c.getSelectionColor());
        } else {
            g.setColor(color);
        }
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            if (this.paintMode == 0) {
                g.drawRect(alloc.x + this.paintOffset, alloc.y + this.paintOffset, alloc.width - 2 * this.paintOffset, alloc.height - 2 * this.paintOffset);
            } else if (this.paintMode == 1) {
                g.fillRect(alloc.x + this.paintOffset, alloc.y + this.paintOffset, alloc.width - 2 * this.paintOffset, alloc.height - 2 * this.paintOffset);
            }
            return alloc;
        }
        try {
            Rectangle r;
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            Rectangle rectangle = r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.paintMode == 0) {
                g.drawRect(r.x + this.paintOffset, r.y + this.paintOffset, r.width - 2 * this.paintOffset, r.height - 2 * this.paintOffset);
            } else if (this.paintMode == 1) {
                g.fillRect(r.x + this.paintOffset, r.y + this.paintOffset, r.width - 2 * this.paintOffset, r.height - 2 * this.paintOffset);
            }
            return r;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public Color getColor(int beginIndex) {
        return this.getColor();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setPaintMode(int mode) {
        if (mode == 1 || mode == 0) {
            this.paintMode = mode;
        }
    }

    public int getPaintOffset() {
        return this.paintOffset;
    }

    public void setPaintOffset(int offset) {
        this.paintOffset = offset;
    }
}

