/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.StyledHighlightPainter;
import mpi.eudico.client.annotator.viewer.ValueHighlightPainter;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class TextViewer
extends AbstractViewer
implements SingleTierViewer,
ACMEditListener,
ActionListener {
    private JMenu fontMenu;
    private ButtonGroup fontSizeBG;
    private int fontSize;
    private JPopupMenu popup;
    private JMenuItem centerMI;
    private JTextArea taText;
    private JScrollPane jspText;
    private TierImpl tier;
    private Vector annotations = new Vector();
    private long begintime = 0L;
    private long endtime = 0L;
    private long[] arrTagTimes;
    private int[] arrTagPositions;
    private String tierText = "";
    private Highlighter highlighter;
    private StyledHighlightPainter selectionPainter;
    private StyledHighlightPainter currentPainter;
    private StyledHighlightPainter activeAnnotationPainter;
    private ValueHighlightPainter valuePainter;
    private Object selectionHighLightInfo;
    private Object currentHighLightInfo;
    private Object activeHighLightInfo;
    private List<Object> valueHighLightInfos;
    private int indexActiveAnnotationBegin = 0;
    private int indexActiveAnnotationEnd = 0;
    private int indexSelectionBegin = 0;
    private int indexSelectionEnd = 0;
    private int indexMediaTime = 0;
    private boolean bVisDotted = true;
    private int extraLength = 4;
    private boolean centerVertically = true;
    private final Color transparent = new Color(Constants.SELECTIONCOLOR.getRed(), Constants.SELECTIONCOLOR.getGreen(), Constants.SELECTIONCOLOR.getBlue(), 0);
    private boolean enterCommits = false;
    private final String DOTS = "  \u00b7  ";

    public TextViewer() {
        try {
            this.setLayout(new BorderLayout());
            this.taText = new JTextArea(4, 10){

                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    return false;
                }
            };
            this.taText.setFont(Constants.DEFAULTFONT);
            this.fontSize = 12;
            this.taText.setLineWrap(true);
            this.taText.setWrapStyleWord(true);
            this.taText.setForeground(Constants.DEFAULTFOREGROUNDCOLOR);
            this.taText.setEditable(false);
            this.taText.addMouseListener(new TextViewerMouseListener(this.taText));
            this.taText.addMouseMotionListener(new TextViewerMouseMotionListener());
            this.taText.getCaret().setSelectionVisible(false);
            this.taText.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.taText.setSelectionColor(this.taText.getBackground());
            this.highlighter = this.taText.getHighlighter();
            this.selectionPainter = new StyledHighlightPainter(Constants.SELECTIONCOLOR, 1, 1);
            this.selectionPainter.setVisible(false);
            this.currentPainter = new StyledHighlightPainter(Constants.CROSSHAIRCOLOR, 0);
            this.currentPainter.setVisible(false);
            this.activeAnnotationPainter = new StyledHighlightPainter(Constants.ACTIVEANNOTATIONCOLOR, 1);
            this.activeAnnotationPainter.setVisible(false);
            this.valuePainter = new ValueHighlightPainter(null, 0);
            this.valuePainter.setVisible(false);
            this.valueHighLightInfos = new ArrayList<Object>();
            this.currentHighLightInfo = this.highlighter.addHighlight(0, 0, this.currentPainter);
            this.activeHighLightInfo = this.highlighter.addHighlight(0, 0, this.activeAnnotationPainter);
            this.selectionHighLightInfo = this.highlighter.addHighlight(0, 0, this.selectionPainter);
            this.highlighter.addHighlight(0, 0, this.valuePainter);
            this.jspText = new JScrollPane(this.taText);
            this.jspText.setHorizontalScrollBarPolicy(31);
            this.jspText.setVerticalScrollBarPolicy(20);
            this.add((Component)this.jspText, "Center");
            this.addComponentListener(new TextViewerComponentListener());
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateSelection() {
        this.doUpdate();
    }

    public void updateActiveAnnotation() {
        this.doUpdate();
    }

    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: {
                this.setTier(this.getTier());
                this.doUpdate();
            }
        }
    }

    public void updateLocale() {
        this.createPopup();
    }

    private void createPopup() {
        this.popup = new JPopupMenu("");
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int i = 0; i < Constants.FONT_SIZES.length; ++i) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(Constants.FONT_SIZES[i]));
            fontRB.setActionCommand("font" + Constants.FONT_SIZES[i]);
            if (this.fontSize == Constants.FONT_SIZES[i]) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.popup.add(this.fontMenu);
        this.popup.addSeparator();
        JMenuItem menuItem = new JMenuItem(ElanLocale.getString("TextViewer.ToggleVisualization"));
        menuItem.setActionCommand("TOGGLEVISUALIZATION");
        menuItem.addActionListener(this);
        this.popup.add(menuItem);
        this.centerMI = new JCheckBoxMenuItem(ElanLocale.getString("TextViewer.CenterVertical"));
        this.centerMI.setSelected(this.centerVertically);
        this.centerMI.setActionCommand("centerVert");
        this.centerMI.addActionListener(this);
        this.popup.add(this.centerMI);
        this.popup.addSeparator();
        JMenuItem copyItem = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        copyItem.setActionCommand("copy");
        copyItem.addActionListener(this);
        this.popup.add(copyItem);
    }

    public void actionPerformed(ActionEvent e) {
        String strAction = e.getActionCommand();
        if (strAction.indexOf("font") != -1) {
            int index = strAction.indexOf("font") + 4;
            try {
                this.fontSize = Integer.parseInt(strAction.substring(index));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
            this.setPreference("TextViewer.FontSize", new Integer(this.fontSize), this.getViewerManager().getTranscription());
        } else if (strAction.equals("TOGGLEVISUALIZATION")) {
            this.bVisDotted = !this.bVisDotted;
            this.setTier(this.getTier());
            this.setPreference("TextViewer.DotSeparated", new Boolean(this.bVisDotted), this.getViewerManager().getTranscription());
        } else if (strAction == "centerVert") {
            this.setCenteredVertically(this.centerMI.isSelected());
            this.setPreference("TextViewer.CenterVertical", new Boolean(this.centerVertically), this.getViewerManager().getTranscription());
        } else if (strAction.equals("copy")) {
            this.taText.copy();
        }
    }

    public void controllerUpdate(ControllerEvent event) {
        this.doUpdate();
    }

    public void preferencesChanged() {
        Object cvPrefs;
        Boolean vertCent;
        Boolean dotSep;
        Integer fontSi = (Integer)this.getPreference("TextViewer.FontSize", this.getViewerManager().getTranscription());
        if (fontSi != null) {
            this.setFontSize(fontSi);
        }
        if ((dotSep = (Boolean)this.getPreference("TextViewer.DotSeparated", this.getViewerManager().getTranscription())) != null) {
            this.setDotSeparated(dotSep);
        }
        if ((vertCent = (Boolean)this.getPreference("TextViewer.CenterVertical", this.getViewerManager().getTranscription())) != null) {
            this.setCenteredVertically(vertCent);
        }
        if (this.tier != null) {
            Object fonts = Preferences.get("TierFonts", this.getViewerManager().getTranscription());
            if (fonts instanceof HashMap) {
                Font tf = (Font)((HashMap)fonts).get(this.tier.getName());
                if (tf != null) {
                    this.taText.setFont(new Font(tf.getName(), 0, this.fontSize));
                } else {
                    this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
                }
            }
        } else {
            this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        }
        Object val = Preferences.get("InlineEdit.EnterCommits", null);
        if (val instanceof Boolean) {
            this.enterCommits = (Boolean)val;
        }
        if (this.tier != null && (cvPrefs = Preferences.get("CV.Prefs", (Transcription)this.tier.getParent())) != null && this.tier.getLinguisticType().getControlledVocabylaryName() != null) {
            this.setTier(this.tier);
        }
    }

    private void scrollIfNeeded() {
        try {
            Highlighter.Highlight[] h_arr = this.highlighter.getHighlights();
            for (int i = 0; i < h_arr.length; ++i) {
                if (h_arr[i].getPainter() != this.currentPainter) continue;
                int idx = h_arr[i].getStartOffset();
                int ide = h_arr[i].getEndOffset();
                Rectangle rect = this.taText.modelToView(idx);
                Rectangle endRect = this.taText.modelToView(ide);
                if (rect == null || endRect == null) {
                    return;
                }
                Rectangle union = rect.union(endRect);
                if (this.centerVertically) {
                    int restY = this.jspText.getViewport().getHeight() - union.height;
                    union.y -= restY / 2;
                    if (union.y < 0) {
                        union.y = 0;
                    }
                    union.height = union.height + restY + 1;
                    this.taText.scrollRectToVisible(union);
                } else {
                    this.taText.scrollRectToVisible(union);
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int getIndexBegin(int index, long beginTime) {
        int retIndex = -1;
        for (int j = -2; j <= 2; ++j) {
            int indexj = index + j;
            if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] > beginTime) continue;
            retIndex = indexj;
        }
        if (retIndex == -1) {
            return index;
        }
        return retIndex;
    }

    private int getIndexEnd(int index, long endTime) {
        int retIndex = -1;
        for (int j = 2; j >= -2; --j) {
            int indexj = index + j;
            if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] < endTime) continue;
            retIndex = indexj;
        }
        if (retIndex == -1) {
            return index;
        }
        return retIndex;
    }

    public void doUpdate() {
        Dimension dim = this.getSize();
        if (dim.height <= 0 || dim.width <= 0) {
            return;
        }
        if (this.arrTagTimes == null) {
            return;
        }
        long mediatime = this.getMediaTime();
        int indexj = 0;
        int index = 0;
        long activeAnnotationBeginTime = 0L;
        long activeAnnotationEndTime = 0L;
        this.indexActiveAnnotationBegin = 0;
        this.indexActiveAnnotationEnd = 0;
        long selectionBeginTime = this.getSelectionBeginTime();
        long selectionEndTime = this.getSelectionEndTime();
        Annotation activeAnnotation = this.getActiveAnnotation();
        if (activeAnnotation != null && activeAnnotation.getTier() == this.tier) {
            activeAnnotationBeginTime = activeAnnotation.getBeginTimeBoundary();
            activeAnnotationEndTime = activeAnnotation.getEndTimeBoundary();
        }
        try {
            if (activeAnnotation != null && activeAnnotation.getTier() == this.tier) {
                index = Math.abs(Arrays.binarySearch(this.arrTagTimes, activeAnnotationBeginTime));
                this.indexActiveAnnotationBegin = this.getIndexBegin(index, activeAnnotationBeginTime);
                index = Math.abs(Arrays.binarySearch(this.arrTagTimes, activeAnnotationEndTime));
                this.indexActiveAnnotationEnd = this.getIndexEnd(index, activeAnnotationEndTime);
            }
            if (selectionBeginTime == 0L && selectionEndTime == 0L) {
                this.indexSelectionBegin = 0;
                this.indexSelectionEnd = 0;
            } else {
                index = Math.abs(Arrays.binarySearch(this.arrTagTimes, selectionBeginTime));
                this.indexSelectionBegin = this.getIndexBegin(index, selectionBeginTime);
                index = Math.abs(Arrays.binarySearch(this.arrTagTimes, selectionEndTime));
                this.indexSelectionEnd = this.getIndexEnd(index, selectionEndTime);
                if (this.indexSelectionEnd >= this.arrTagPositions.length) {
                    this.indexSelectionEnd = this.arrTagPositions.length - 1;
                }
            }
            index = Math.abs(Arrays.binarySearch(this.arrTagTimes, mediatime));
            for (int j = -2; j <= 2; ++j) {
                indexj = index + j;
                if (indexj < 0) {
                    this.indexMediaTime = -1;
                    break;
                }
                if (indexj < 0 || indexj >= this.arrTagTimes.length || this.arrTagTimes[indexj] > mediatime) continue;
                this.indexMediaTime = indexj;
            }
            if (this.indexMediaTime >= 0 && this.indexMediaTime + 1 < this.arrTagPositions.length) {
                this.currentPainter.setVisible(true);
                this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.indexMediaTime], this.arrTagPositions[this.indexMediaTime + 1] - this.extraLength);
            } else {
                this.currentPainter.setVisible(false);
                if (this.indexMediaTime < 0 && this.arrTagPositions.length > 1) {
                    this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[0], this.arrTagPositions[1]);
                } else if (this.indexMediaTime + 1 >= this.arrTagPositions.length && this.arrTagPositions.length > 1) {
                    this.highlighter.changeHighlight(this.currentHighLightInfo, this.arrTagPositions[this.arrTagPositions.length - 2], this.arrTagPositions[this.arrTagPositions.length - 1]);
                }
            }
            if (this.indexActiveAnnotationBegin >= 0 && this.indexActiveAnnotationBegin < this.arrTagPositions.length && this.indexActiveAnnotationEnd >= 0 && this.indexActiveAnnotationEnd < this.arrTagPositions.length) {
                if (activeAnnotation != null) {
                    this.activeAnnotationPainter.setVisible(true);
                    this.highlighter.changeHighlight(this.activeHighLightInfo, this.arrTagPositions[this.indexActiveAnnotationBegin], this.arrTagPositions[this.indexActiveAnnotationEnd] - this.extraLength);
                } else {
                    this.activeAnnotationPainter.setVisible(false);
                }
            } else {
                this.activeAnnotationPainter.setVisible(false);
            }
            if (this.indexSelectionBegin >= 0 && this.indexSelectionBegin < this.arrTagPositions.length && this.indexSelectionEnd >= 0 && this.indexSelectionEnd < this.arrTagPositions.length) {
                this.selectionPainter.setVisible(true);
                this.highlighter.changeHighlight(this.selectionHighLightInfo, this.arrTagPositions[this.indexSelectionBegin], this.arrTagPositions[this.indexSelectionEnd] - this.extraLength);
            } else {
                this.selectionPainter.setVisible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.scrollIfNeeded();
        this.repaint();
    }

    public void setTier(Tier tier) {
        Map<Integer, Color> cm;
        if (tier == null) {
            this.tier = null;
            this.annotations = new Vector();
            this.setPreference("TextViewer.TierName", tier, this.getViewerManager().getTranscription());
            this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        } else {
            this.tier = (TierImpl)tier;
            try {
                this.annotations = this.tier.getAnnotations();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setPreference("TextViewer.TierName", tier.getName(), this.getViewerManager().getTranscription());
            Object fonts = Preferences.get("TierFonts", this.getViewerManager().getTranscription());
            if (fonts instanceof HashMap) {
                Font tf = (Font)((HashMap)fonts).get(tier.getName());
                if (tf != null) {
                    this.taText.setFont(new Font(tf.getName(), 0, this.fontSize));
                } else {
                    this.taText.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
                }
            }
        }
        for (Object obj : this.valueHighLightInfos) {
            this.highlighter.removeHighlight(obj);
        }
        this.valueHighLightInfos.clear();
        this.buildArrayAndText();
        this.taText.setText(this.tierText);
        if (this.valueHighLightInfos.size() > 0 && (cm = this.valuePainter.getColors()) != null) {
            ArrayList<Integer> kl = new ArrayList<Integer>(cm.keySet());
            Collections.sort(kl);
            if (kl.size() == this.valueHighLightInfos.size()) {
                int j = 0;
                int pos = 0;
                block5: for (int i = 0; i < kl.size(); ++i) {
                    pos = kl.get(i);
                    while (j < this.arrTagPositions.length - 1) {
                        if (this.arrTagPositions[j] == pos) {
                            try {
                                this.highlighter.changeHighlight(this.valueHighLightInfos.get(i), pos, this.arrTagPositions[j + 1] - this.extraLength);
                                ++j;
                            }
                            catch (BadLocationException ble) {}
                            continue block5;
                        }
                        ++j;
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TextViewer.this.doUpdate();
            }
        });
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        if (this.fontSizeBG != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != this.fontSize) continue;
                    item.setSelected(true);
                    this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
                    break;
                }
                catch (NumberFormatException nfe) {
                }
            }
        } else {
            this.createPopup();
            this.taText.setFont(this.taText.getFont().deriveFont((float)this.fontSize));
        }
    }

    public boolean isDotSeparated() {
        return this.bVisDotted;
    }

    public void setDotSeparated(boolean dotted) {
        if (dotted != this.bVisDotted) {
            this.bVisDotted = dotted;
            this.setTier(this.getTier());
        }
    }

    public void setCenteredVertically(boolean centered) {
        this.centerVertically = centered;
        if (this.centerMI.isSelected() != this.centerVertically) {
            this.centerMI.setSelected(this.centerVertically);
        }
        this.scrollIfNeeded();
        this.repaint();
    }

    public boolean isCenteredVertically() {
        return this.centerVertically;
    }

    private void buildArrayAndText() {
        ControlledVocabulary cv;
        String cvName;
        this.tierText = "";
        StringBuilder builder = new StringBuilder(256);
        int annotations_size = this.annotations.size();
        this.arrTagTimes = new long[2 * annotations_size];
        this.arrTagPositions = new int[2 * annotations_size];
        int arrIndexTimes = 0;
        int arrIndexPositions = 0;
        Color c = null;
        CVEntry[] relEntries = null;
        HashMap<Integer, Color> colors = null;
        if (this.tier != null && (cvName = this.tier.getLinguisticType().getControlledVocabylaryName()) != null && (cv = ((TranscriptionImpl)this.tier.getParent()).getControlledVocabulary(cvName)) != null) {
            relEntries = cv.getEntries();
            colors = new HashMap<Integer, Color>();
        }
        try {
            for (int i = 0; i < annotations_size; ++i) {
                Annotation ann = (Annotation)this.annotations.elementAt(i);
                String strTagValue = ann.getValue();
                c = null;
                if (relEntries != null) {
                    for (int j = 0; j < relEntries.length; ++j) {
                        if (!relEntries[j].getValue().equals(strTagValue)) continue;
                        c = relEntries[j].getPrefColor();
                        break;
                    }
                }
                strTagValue = strTagValue.replace('\n', ' ');
                if (this.bVisDotted) {
                    builder.append(strTagValue).append("  \u00b7  ");
                    this.extraLength = 4;
                } else {
                    builder.append(strTagValue).append(' ');
                    this.extraLength = 0;
                }
                this.begintime = ann.getBeginTimeBoundary();
                this.endtime = ann.getEndTimeBoundary();
                this.arrTagTimes[arrIndexTimes++] = this.begintime;
                this.arrTagTimes[arrIndexTimes++] = this.endtime;
                int taglength = strTagValue.length() + this.extraLength;
                if (arrIndexPositions == 0 || arrIndexPositions == 1) {
                    this.arrTagPositions[arrIndexPositions++] = 0;
                    this.arrTagPositions[arrIndexPositions++] = taglength;
                } else {
                    this.arrTagPositions[arrIndexPositions] = this.arrTagPositions[arrIndexPositions - 1] + 1;
                    this.arrTagPositions[++arrIndexPositions] = this.arrTagPositions[arrIndexPositions - 1] + taglength;
                    ++arrIndexPositions;
                }
                if (c == null) continue;
                colors.put(this.arrTagPositions[arrIndexPositions - 2], c);
                Object hl = this.highlighter.addHighlight(this.arrTagPositions[arrIndexPositions - 2], this.arrTagPositions[arrIndexPositions - 1] - this.extraLength, this.valuePainter);
                this.valueHighLightInfos.add(hl);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.valuePainter.setColors(colors);
        this.valuePainter.setVisible(colors != null && colors.size() > 0);
        this.tierText = builder.toString();
    }

    private class TextViewerComponentListener
    extends ComponentAdapter {
        private TextViewerComponentListener() {
        }

        public void componentResized(ComponentEvent e) {
            TextViewer.this.doUpdate();
        }
    }

    private class TextViewerMouseMotionListener
    extends MouseMotionAdapter {
        private TextViewerMouseMotionListener() {
        }

        public void mouseDragged(MouseEvent e) {
            TextViewer.this.taText.setSelectionColor(Constants.SELECTIONCOLOR);
        }
    }

    private class TextViewerMouseListener
    extends MouseAdapter {
        private InlineEditBox inlineEditBox = null;
        private JComponent comp;

        public TextViewerMouseListener(JComponent c) {
            this.comp = c;
        }

        public void mousePressed(MouseEvent e) {
            TextViewer.this.stopPlayer();
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, this.comp);
                int x = e.getPoint().x;
                int y = e.getPoint().y;
                TextViewer.this.popup.show(this.comp, x, y);
            }
        }

        private int getArrayIndex() {
            int index = -1;
            int annotations_size = TextViewer.this.annotations.size();
            for (int i = 0; i < annotations_size; ++i) {
                Annotation ann = (Annotation)TextViewer.this.annotations.elementAt(i);
                if (TextViewer.this.getActiveAnnotation() == null || TextViewer.this.getActiveAnnotation().getBeginTimeBoundary() != ann.getBeginTimeBoundary()) continue;
                index = i;
                break;
            }
            return index;
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                return;
            }
            int annotations_size = TextViewer.this.annotations.size();
            if (e.getClickCount() == 2) {
                if (this.inlineEditBox == null) {
                    this.inlineEditBox = new InlineEditBox(false);
                    this.inlineEditBox.setLocale(ElanLocale.getLocale());
                } else {
                    this.inlineEditBox.setEnterCommits(TextViewer.this.enterCommits);
                }
                Annotation annotation = null;
                int index = this.getArrayIndex();
                if (index >= 0 && index < annotations_size) {
                    annotation = (Annotation)TextViewer.this.annotations.elementAt(index);
                    if (e.isShiftDown()) {
                        this.inlineEditBox.setAnnotation(annotation, true);
                    } else {
                        this.inlineEditBox.setAnnotation(annotation);
                    }
                    this.inlineEditBox.setFont(TextViewer.this.taText.getFont());
                    this.inlineEditBox.detachEditor();
                }
                return;
            }
            TextViewer.this.taText.setSelectionColor(TextViewer.this.transparent);
            if (!TextViewer.this.taText.getText().equals("")) {
                int j;
                int selectionStartPosition = TextViewer.this.taText.getSelectionStart();
                int selectionEndPosition = TextViewer.this.taText.getSelectionEnd();
                int indexSelectionStart = 0;
                int indexSelectionEnd = 0;
                int indexj = 0;
                int index = Math.abs(Arrays.binarySearch(TextViewer.this.arrTagPositions, selectionStartPosition));
                for (j = -2; j <= 2; ++j) {
                    indexj = index + j;
                    if (indexj < 0 || indexj >= TextViewer.this.arrTagPositions.length || TextViewer.this.arrTagPositions[indexj] > selectionStartPosition) continue;
                    indexSelectionStart = indexj;
                }
                if (selectionStartPosition == selectionEndPosition && indexSelectionStart + 1 < TextViewer.this.arrTagTimes.length) {
                    index = (int)Math.ceil(indexSelectionStart / 2);
                    if (index < annotations_size) {
                        Annotation ann = (Annotation)TextViewer.this.annotations.elementAt(index);
                        TextViewer.this.setActiveAnnotation(ann);
                    } else {
                        TextViewer.this.setMediaTime(TextViewer.this.arrTagTimes[indexSelectionStart]);
                    }
                    return;
                }
                index = Math.abs(Arrays.binarySearch(TextViewer.this.arrTagPositions, selectionEndPosition));
                for (j = 2; j >= -2; --j) {
                    indexj = index + j;
                    if (indexj < 0 || indexj >= TextViewer.this.arrTagTimes.length || TextViewer.this.arrTagPositions[indexj] < selectionEndPosition) continue;
                    indexSelectionEnd = indexj;
                }
                int indexNewJ = indexj + 2 < TextViewer.this.arrTagTimes.length ? indexj + 2 : (indexj + 1 < TextViewer.this.arrTagTimes.length ? indexj + 1 : indexj);
                if (indexSelectionEnd == 0) {
                    indexSelectionEnd = indexNewJ;
                }
                if (indexSelectionStart < indexSelectionEnd && indexSelectionEnd < TextViewer.this.arrTagTimes.length) {
                    TextViewer.this.setSelection(TextViewer.this.arrTagTimes[indexSelectionStart], TextViewer.this.arrTagTimes[indexSelectionEnd]);
                    TextViewer.this.setMediaTime(TextViewer.this.arrTagTimes[indexSelectionStart]);
                }
            }
        }
    }
}

