/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.im;

import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import mpi.eudico.client.im.ImUtil;

public class ImUtilTest
extends JFrame
implements ActionListener {
    private Locale[] allLanguages;
    private JTextArea jTextArea = new JTextArea(25, 53);

    public ImUtilTest() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add((Component)this.jTextArea, null);
        this.allLanguages = ImUtil.getLanguages(this.jTextArea);
        MenuBar menuBar = new MenuBar();
        this.setMenuBar(menuBar);
        Menu fileMenu = new Menu("File");
        Menu selectLanguageMenu = new Menu("Select Language");
        menuBar.add(fileMenu);
        menuBar.add(selectLanguageMenu);
        for (int i = 0; i < this.allLanguages.length; ++i) {
            this.addItem(selectLanguageMenu, this.allLanguages[i].getDisplayName());
        }
        this.addItem(fileMenu, "Exit");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ImUtilTest.this.jTextArea.requestFocus();
            }
        });
        ImUtil.setLanguage(this.jTextArea, this.allLanguages[0]);
        this.setLocation(60, 30);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] a) throws Exception {
        IUT iut = new IUT(){

            public void go() throws Exception {
                new ImUtilTest();
            }
        };
        iut.go();
    }

    private void addItem(Menu menu, String text) {
        MenuItem newItem = new MenuItem(text);
        newItem.addActionListener(this);
        menu.add(newItem);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Exit")) {
            System.exit(0);
        }
        for (int i = 0; i < this.allLanguages.length; ++i) {
            if (!command.equals(this.allLanguages[i].getDisplayName())) continue;
            ImUtil.setLanguage(this.jTextArea, this.allLanguages[i]);
            return;
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    static interface IUT {
        public void go() throws Exception;
    }
}

