/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.SubtitleUnit;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;

public class SubtitleSequencer
implements ClientLogger {
    public List createSequence(Transcription transcription, List tierNames, long intervalBegin, long intervalEnd, int minimalDuration, long offset, boolean resolveOverlaps) {
        if (transcription == null) {
            throw new NullPointerException("The transcription is null");
        }
        if (tierNames == null) {
            throw new NullPointerException("The list of tier names is null");
        }
        if (tierNames.size() == 0) {
            throw new IllegalArgumentException("No tiers have been specified");
        }
        Stack<SubtitleUnit> units = new Stack<SubtitleUnit>();
        for (int i = 0; i < tierNames.size(); ++i) {
            String name = (String)tierNames.get(i);
            TierImpl tier = (TierImpl)transcription.getTierWithId(name);
            if (tier == null) {
                LOG.warning("The tier does not exist: " + name);
                continue;
            }
            Vector annotations = tier.getAnnotations();
            SubtitleUnit sub1 = null;
            SubtitleUnit sub2 = null;
            for (int j = 0; j < annotations.size(); ++j) {
                AbstractAnnotation ann = (AbstractAnnotation)annotations.get(j);
                if (ann == null || !TimeRelation.overlaps(ann, intervalBegin, intervalEnd)) continue;
                sub1 = new SubtitleUnit(ann.getBeginTimeBoundary() + offset, ann.getEndTimeBoundary() + offset, i, ann.getValue());
                if (sub2 != null && sub2.getCalcEnd() - sub2.getBegin() < (long)minimalDuration) {
                    if (resolveOverlaps && sub2.getBegin() + (long)minimalDuration > sub1.getBegin()) {
                        sub2.setValue(sub2.getValue() + " " + sub1.getValue());
                        sub2.setCalcEnd(sub1.getCalcEnd());
                        continue;
                    }
                    sub2.setCalcEnd(Math.min(sub1.getBegin(), sub2.getBegin() + (long)minimalDuration));
                }
                units.add(sub1);
                sub2 = sub1;
            }
        }
        Collections.sort(units, Collections.reverseOrder());
        if (!resolveOverlaps) {
            return units;
        }
        ArrayList<SubtitleUnit> output = new ArrayList<SubtitleUnit>();
        Stack agroup = new Stack();
        do {
            int i;
            SubtitleUnit sub = null;
            long tmpStart = -1L;
            while (units.size() > 0) {
                sub = (SubtitleUnit)units.peek();
                if (tmpStart < 0L) {
                    tmpStart = sub.getBegin();
                }
                if (sub.getBegin() != tmpStart && agroup.size() != 1) break;
                agroup.add(units.pop());
            }
            ArrayList<SubtitleUnit> firsts = new ArrayList<SubtitleUnit>();
            long first_start = -1L;
            long second_start = -1L;
            long first_end = -1L;
            for (int i2 = 0; i2 < agroup.size(); ++i2) {
                sub = (SubtitleUnit)agroup.get(i2);
                if (first_start < 0L || first_start > sub.getBegin()) {
                    if (second_start < 0L || second_start > first_start) {
                        second_start = first_start;
                    }
                    first_start = sub.getBegin();
                    firsts.clear();
                }
                if (sub.getBegin() != first_start && (second_start < 0L || second_start > sub.getBegin())) {
                    second_start = sub.getBegin();
                }
                if (first_start == sub.getBegin()) {
                    firsts.add(sub);
                }
                if (first_end >= 0L && (first_start != sub.getBegin() || first_end <= sub.getCalcEnd())) continue;
                first_end = sub.getCalcEnd();
            }
            ArrayList<String> values = new ArrayList<String>();
            if (firsts.size() > 1) {
                for (i = 1; i < firsts.size(); ++i) {
                    for (int j = 0; j < i; ++j) {
                        if (((SubtitleUnit)firsts.get(i)).getLineIndex() >= ((SubtitleUnit)firsts.get(j)).getLineIndex()) continue;
                        firsts.add(j, (SubtitleUnit)firsts.remove(i));
                    }
                }
            }
            for (i = 0; i < firsts.size(); ++i) {
                sub = (SubtitleUnit)firsts.get(i);
                String[] vals = sub.getValues();
                if (vals == null) {
                    String val = sub.getValue();
                    if (val == null) continue;
                    values.add(val);
                    continue;
                }
                for (int j = 0; j < vals.length; ++j) {
                    values.add(vals[j]);
                }
            }
            long min_end = Math.min(first_end, second_start < 0L ? first_end : second_start);
            SubtitleUnit out = new SubtitleUnit(first_start, min_end, null);
            out.setValues(values.toArray(new String[0]));
            output.add(out);
            for (int i3 = 0; i3 < firsts.size(); ++i3) {
                sub = (SubtitleUnit)firsts.get(i3);
                sub.setBegin(min_end);
                if (min_end < sub.getCalcEnd()) continue;
                agroup.remove(sub);
            }
        } while (!agroup.isEmpty() || !units.isEmpty());
        return output;
    }

    public List createSequence(Transcription transcription, List tierNames, long intervalBegin, long intervalEnd, int minimalDuration) {
        return this.createSequence(transcription, tierNames, intervalBegin, intervalEnd, minimalDuration, 0L, false);
    }

    public List createSequence(Transcription transcription, String[] tierNames, long intervalBegin, long intervalEnd, int minimalDuration, long offset, boolean resolveOverlaps) {
        ArrayList<String> names = null;
        if (tierNames != null) {
            names = new ArrayList<String>(tierNames.length);
            for (int i = 0; i < tierNames.length; ++i) {
                names.add(tierNames[i]);
            }
        }
        return this.createSequence(transcription, names, intervalBegin, intervalEnd, minimalDuration, offset, resolveOverlaps);
    }

    public List createSequence(Transcription transcription, String[] tierNames, long intervalBegin, long intervalEnd, int minimalDuration) {
        return this.createSequence(transcription, tierNames, intervalBegin, intervalEnd, minimalDuration, 0L, false);
    }
}

