/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TierSorter {
    public final int UNSORTED = 0;
    public final int BY_HIERARCHY = 1;
    public final int BY_PARTICIPANT = 2;
    public final int BY_LINGUISTIC_TYPE = 3;
    private final String NOT_SPECIFIED = "not specified";
    private TranscriptionImpl transcription;

    public TierSorter(TranscriptionImpl transcription) {
        this.transcription = transcription;
    }

    public ArrayList sortTiers(int mode) {
        return this.sortTiers(mode, null);
    }

    public ArrayList sortTiers(int mode, ArrayList currentTierOrder) {
        ArrayList<Object> sortedTiers = new ArrayList<Object>();
        ArrayList<TierImpl> tierList = null;
        tierList = currentTierOrder == null ? new ArrayList<TierImpl>() : new ArrayList(currentTierOrder);
        Vector allTiers = this.transcription.getTiers();
        for (int i = 0; i < allTiers.size(); ++i) {
            TierImpl tier = (TierImpl)allTiers.elementAt(i);
            if (tierList.contains(tier)) continue;
            tierList.add(tier);
        }
        switch (mode) {
            case 1: {
                TierImpl tier;
                int i;
                HashMap<TierImpl, DefaultMutableTreeNode> nodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
                DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("Root");
                for (i = 0; i < tierList.size(); ++i) {
                    tier = (TierImpl)tierList.get(i);
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(tier);
                    nodes.put(tier, n);
                }
                for (i = 0; i < tierList.size(); ++i) {
                    tier = (TierImpl)tierList.get(i);
                    if (tier.getParentTier() == null) {
                        sortedRootNode.add((DefaultMutableTreeNode)nodes.get(tier));
                        continue;
                    }
                    ((DefaultMutableTreeNode)nodes.get(tier.getParentTier())).add((DefaultMutableTreeNode)nodes.get(tier));
                }
                Enumeration<TreeNode> nodeEnum = sortedRootNode.preorderEnumeration();
                nodeEnum.nextElement();
                while (nodeEnum.hasMoreElements()) {
                    DefaultMutableTreeNode nextnode = (DefaultMutableTreeNode)nodeEnum.nextElement();
                    sortedTiers.add(nextnode.getUserObject());
                }
                break;
            }
            case 2: {
                HashMap participantTable = new HashMap();
                ArrayList<String> names = new ArrayList<String>();
                for (int i = 0; i < tierList.size(); ++i) {
                    TierImpl tier = (TierImpl)tierList.get(i);
                    String part = tier.getParticipant();
                    if (part.length() == 0) {
                        part = "not specified";
                    }
                    if (participantTable.get(part) == null) {
                        ArrayList<TierImpl> list = new ArrayList<TierImpl>();
                        list.add(tier);
                        participantTable.put(part, list);
                        names.add(part);
                        continue;
                    }
                    ((ArrayList)participantTable.get(part)).add(tier);
                }
                if (participantTable.size() <= 0) break;
                for (int j = 0; j < names.size(); ++j) {
                    ArrayList pList = (ArrayList)participantTable.get(names.get(j));
                    for (int k = 0; k < pList.size(); ++k) {
                        sortedTiers.add(pList.get(k));
                    }
                }
                break;
            }
            case 3: {
                HashMap typeTable = new HashMap();
                ArrayList<LinguisticType> types = new ArrayList<LinguisticType>();
                for (int i = 0; i < tierList.size(); ++i) {
                    TierImpl tier = (TierImpl)tierList.get(i);
                    LinguisticType type = tier.getLinguisticType();
                    if (type == null) {
                        type = new LinguisticType("not specified");
                    }
                    if (typeTable.get(type) == null) {
                        ArrayList<TierImpl> list = new ArrayList<TierImpl>();
                        list.add(tier);
                        typeTable.put(type, list);
                        types.add(type);
                        continue;
                    }
                    ((ArrayList)typeTable.get(type)).add(tier);
                }
                if (typeTable.size() <= 0) break;
                for (int j = 0; j < types.size(); ++j) {
                    ArrayList typeList = (ArrayList)typeTable.get(types.get(j));
                    for (int k = 0; k < typeList.size(); ++k) {
                        sortedTiers.add(typeList.get(k));
                    }
                }
                break;
            }
            default: {
                sortedTiers = tierList;
            }
        }
        return sortedTiers;
    }
}

