/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import mpi.eudico.client.util.SubtitleSequencer;
import mpi.eudico.client.util.SubtitleUnit;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class Transcription2QtSubtitle {
    private static final String NEWLINE = "\n";
    private static final char[] bracks = new char[]{'[', ']', '(', ')'};
    private static final char NL_CHAR = '\n';

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, int minimalDuration) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, beginTime, endTime, 0L, 0, 0L, false, null);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration) throws IOException {
        Transcription2QtSubtitle.exportTiers(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, false, null);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration, boolean reCalculateTime, HashMap newSubtitleSetting) throws IOException {
        TierImpl tier;
        int j;
        if (exportFile == null) {
            return;
        }
        Annotation[] annotations = null;
        FileOutputStream out = null;
        BufferedWriter writer = null;
        if (tierNames.length == 1) {
            out = new FileOutputStream(exportFile);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        }
        long recalculateTimeInterval = 0L;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
            block0: for (j = 0; j < tierNames.length; ++j) {
                tier = (TierImpl)transcription.getTierWithId(tierNames[j]);
                annotations = tier.getAnnotations().toArray(new Annotation[0]);
                for (int i = 0; i < annotations.length; ++i) {
                    long b;
                    if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime) || (b = annotations[i].getBeginTimeBoundary()) >= recalculateTimeInterval) continue;
                    recalculateTimeInterval = b;
                    continue block0;
                }
            }
            annotations = null;
        }
        for (j = 0; j < tierNames.length; ++j) {
            if (tierNames.length > 1) {
                String nextName = exportFile.getAbsolutePath();
                int index = nextName.lastIndexOf(46);
                nextName = index > 0 ? nextName.substring(0, index) + "_" + tierNames[j] + ".txt" : nextName + "_" + tierNames[j];
                out = new FileOutputStream(new File(nextName));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            }
            tier = (TierImpl)transcription.getTierWithId(tierNames[j]);
            annotations = tier.getAnnotations().toArray(new Annotation[0]);
            writer.write(Transcription2QtSubtitle.getSettings(newSubtitleSetting));
            long nextB = 0L;
            long lastE = 0L;
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime)) continue;
                long b = annotations[i].getBeginTimeBoundary();
                long d = b + (long)minimalDuration;
                long e = Math.max(annotations[i].getEndTimeBoundary(), d);
                if (i < annotations.length - 1) {
                    nextB = annotations[i + 1].getBeginTimeBoundary();
                    e = Math.min(e, nextB);
                }
                if (lastE < e) {
                    lastE = e;
                }
                writer.write("[" + TimeFormatter.toString(b - recalculateTimeInterval + offset) + "]" + NEWLINE);
                writer.write("{textEncoding:256}");
                writer.write(Transcription2QtSubtitle.replaceBrackets(annotations[i].getValue()));
                writer.append('\n');
                if (nextB - e < 10L && nextB - b >= 20L) {
                    writer.write("[" + TimeFormatter.toString(nextB - recalculateTimeInterval - 10L + offset) + "]" + NEWLINE);
                    continue;
                }
                writer.write("[" + TimeFormatter.toString(e - recalculateTimeInterval + offset) + "]" + NEWLINE);
            }
            if (mediaDuration > lastE + 20L) {
                writer.write("[" + TimeFormatter.toString(mediaDuration - Math.min(40L, mediaDuration - lastE + 10L)) + "]" + NEWLINE);
                writer.write("[" + TimeFormatter.toString(mediaDuration) + "]");
            }
            if (tierNames.length <= 1) continue;
            writer.close();
        }
        writer.close();
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration) throws IOException {
        Transcription2QtSubtitle.exportTiersMerged(transcription, tierNames, exportFile, beginTime, endTime, offset, minimalDuration, mediaDuration, false, null);
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, long offset, int minimalDuration, long mediaDuration, boolean reCalculateTime, HashMap newSubtitleSetting) throws IOException {
        String fileName;
        int index;
        if (exportFile == null) {
            return;
        }
        long recalculateTimeInterval = 0L;
        boolean selection = false;
        if (reCalculateTime) {
            recalculateTimeInterval = beginTime;
            offset = 0L;
        }
        if ((index = (fileName = exportFile.getAbsolutePath()).lastIndexOf(46)) > 0) {
            fileName = fileName.substring(0, index) + ".txt";
        }
        FileOutputStream out = new FileOutputStream(new File(fileName));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        writer.write(Transcription2QtSubtitle.getSettings(newSubtitleSetting));
        SubtitleSequencer sequencer = new SubtitleSequencer();
        List allUnits = sequencer.createSequence(transcription, tierNames, beginTime, endTime, minimalDuration, offset, true);
        SubtitleUnit unit = null;
        SubtitleUnit nextUnit = null;
        Long d = 0L;
        for (int i = 0; i < allUnits.size(); ++i) {
            unit = (SubtitleUnit)allUnits.get(i);
            if (!selection && unit.getBegin() < recalculateTimeInterval) {
                recalculateTimeInterval = unit.getBegin();
                selection = true;
            }
            writer.write("[" + TimeFormatter.toString(unit.getBegin() - recalculateTimeInterval) + "]" + NEWLINE);
            writer.write("{textEncoding:256}");
            if (unit.getValue() != null) {
                writer.write(Transcription2QtSubtitle.replaceBrackets(unit.getValue()));
                writer.append('\n');
            } else {
                for (int j = 0; j < unit.getValues().length; ++j) {
                    writer.write(Transcription2QtSubtitle.replaceBrackets(unit.getValues()[j]));
                    writer.append('\n');
                }
            }
            if (i < allUnits.size() - 1) {
                nextUnit = (SubtitleUnit)allUnits.get(i + 1);
                if (nextUnit.getBegin() - unit.getCalcEnd() < 10L && nextUnit.getBegin() - unit.getBegin() >= 20L) {
                    writer.write("[" + TimeFormatter.toString(nextUnit.getBegin() - 10L - recalculateTimeInterval) + "]" + NEWLINE);
                    continue;
                }
                writer.write("[" + TimeFormatter.toString(unit.getCalcEnd() - recalculateTimeInterval) + "]" + NEWLINE);
                continue;
            }
            writer.write("[" + TimeFormatter.toString(unit.getCalcEnd() - recalculateTimeInterval) + "]" + NEWLINE);
        }
        if (unit != null && mediaDuration > unit.getCalcEnd() + 20L) {
            writer.write("[" + TimeFormatter.toString(mediaDuration - Math.min(40L, mediaDuration - unit.getCalcEnd() - 10L)) + "]" + NEWLINE);
            writer.write("[" + TimeFormatter.toString(mediaDuration) + "]");
        }
        writer.close();
    }

    public static void exportTiersMerged(Transcription transcription, String[] tierNames, File exportFile, int minimalDuration) throws IOException {
        Transcription2QtSubtitle.exportTiersMerged(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE, 0L, minimalDuration, 0L, false, null);
    }

    private static char[] replaceBrackets(String value) {
        if (value == null || value.length() == 0) {
            return new char[0];
        }
        char[] ch = value.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == bracks[0]) {
                ch[i] = bracks[2];
                continue;
            }
            if (ch[i] != bracks[1]) continue;
            ch[i] = bracks[3];
        }
        return ch;
    }

    private static String getSettings(HashMap newSubtitleSetting) {
        if (newSubtitleSetting != null) {
            Color newColor;
            String setting = "{QTtext}{timescale:100}";
            setting = newSubtitleSetting.get("font") != null ? setting + "{font:" + newSubtitleSetting.get("font").toString() + "}" : setting + "{font:Arial Unicode MS}";
            setting = newSubtitleSetting.get("size") != null ? setting + "{size:" + newSubtitleSetting.get("size").toString() + "}" : setting + "{size:12}";
            if (newSubtitleSetting.get("backColor") != null) {
                newColor = (Color)newSubtitleSetting.get("backColor");
                setting = setting + "{backColor:" + newColor.getRed() * 257 + "," + newColor.getGreen() * 257 + "," + newColor.getBlue() * 257 + "}";
            } else {
                setting = setting + "{backColor:0,0,0}";
            }
            if (newSubtitleSetting.get("textColor") != null) {
                newColor = (Color)newSubtitleSetting.get("textColor");
                setting = setting + "{textColor:" + newColor.getRed() * 257 + "," + newColor.getGreen() * 257 + "," + newColor.getBlue() * 257 + "}";
            } else {
                setting = setting + "{textColor:65535,65535,65535}";
            }
            if (newSubtitleSetting.get("transparent") != null) {
                setting = (Boolean)newSubtitleSetting.get("transparent") != false ? setting + "{keyedText:on}" : setting + "{keyedText:off}";
            }
            setting = setting + "{width:320}";
            setting = newSubtitleSetting.get("justify") != null ? setting + "{justify:" + newSubtitleSetting.get("justify").toString() + "}" : setting + "{justify:left}";
            setting = setting + NEWLINE;
            return setting;
        }
        return "{QTtext}{timescale:100}{size:12}{backColor:0,0,0}{textColor:65535,65535,65535}{width:320}{justify:left}\n";
    }
}

