/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.TabExportTableModel;
import mpi.eudico.client.annotator.util.AnnotationDataComparator;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class Transcription2TabDelimitedText {
    public static final String TAB = "\t";
    private static final String NEWLINE = "\n";

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile) throws IOException {
        Transcription2TabDelimitedText.exportTiers(transcription, tierNames, exportFile, 0L, Long.MAX_VALUE);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime) throws IOException {
        Transcription2TabDelimitedText.exportTiers(transcription, tierNames, exportFile, beginTime, endTime, true, true, true, true, true, false);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, long beginTime, long endTime, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS) throws IOException {
        Transcription2TabDelimitedText.exportTiers(transcription, tierNames, exportFile, "UTF-8", beginTime, endTime, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, String charEncoding, long beginTime, long endTime, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS) throws IOException {
        Transcription2TabDelimitedText.exportTiers(transcription, tierNames, exportFile, charEncoding, beginTime, endTime, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, false, false, 0L, true);
    }

    public static void exportTiers(Transcription transcription, String[] tierNames, File exportFile, String charEncoding, long beginTime, long endTime, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat, long mediaOffset, boolean includeNames) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        AnnotationCore[] annotations = null;
        String participant = "";
        for (int j = 0; j < tierNames.length; ++j) {
            TierImpl tier = (TierImpl)transcription.getTierWithId(tierNames[j]);
            participant = tier.getParticipant();
            if (participant == null) {
                participant = "";
            }
            annotations = tier.getAnnotations().toArray(new AnnotationCore[0]);
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null || !TimeRelation.overlaps(annotations[i], beginTime, endTime)) continue;
                if (includeNames) {
                    writer.write(tierNames[j] + TAB + participant);
                }
                String ts = Transcription2TabDelimitedText.getTabString(annotations[i], includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat, mediaOffset);
                writer.write(ts, 0 + (includeNames ? 0 : 1), includeNames ? ts.length() : ts.length() - 1);
            }
        }
        writer.close();
    }

    public static void exportTiersColumnPerTier(Transcription transcription, String[] tierNames, File exportFile, String charEncoding, long beginTime, long endTime, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat, long mediaOffset) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        ArrayList<AnnotationCore> allAnnotations = new ArrayList<AnnotationCore>(100);
        AnnotationCore[] annotations = null;
        block2: for (int j = 0; j < tierNames.length; ++j) {
            TierImpl tier = (TierImpl)transcription.getTierWithId(tierNames[j]);
            if (tier == null) continue;
            annotations = tier.getAnnotations().toArray(new AnnotationCore[0]);
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null) continue;
                if (TimeRelation.overlaps(annotations[i], beginTime, endTime)) {
                    allAnnotations.add(annotations[i]);
                }
                if (annotations[i].getBeginTimeBoundary() > endTime) continue block2;
            }
        }
        Collections.sort(allAnnotations, new AnnotationDataComparator());
        TabExportTableModel model = new TabExportTableModel(allAnnotations, tierNames);
        writer.write(Transcription2TabDelimitedText.getHeaders(model, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat));
        Transcription2TabDelimitedText.writeRows(writer, model, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat, mediaOffset, false, false);
        writer.close();
    }

    public static void exportTiersColumnPerTier(List files, String[] tierNames, File exportFile, String charEncoding, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat, boolean includeFileName, boolean includeFilePath) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            throw new IOException("No files specified for export");
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        ArrayList<AnnotationCore> allAnnotations = new ArrayList<AnnotationCore>(100);
        AnnotationCore[] annotations = null;
        TabExportTableModel model = null;
        AnnotationDataComparator comparator = new AnnotationDataComparator();
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            allAnnotations.clear();
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                for (int j = 0; j < tierNames.length; ++j) {
                    TierImpl tier = (TierImpl)trans.getTierWithId(tierNames[j]);
                    if (tier == null) continue;
                    annotations = tier.getAnnotations().toArray(new AnnotationCore[0]);
                    for (int k = 0; k < annotations.length; ++k) {
                        if (annotations[k] == null) continue;
                        allAnnotations.add(annotations[k]);
                    }
                }
                Collections.sort(allAnnotations, comparator);
                model = new TabExportTableModel(allAnnotations, tierNames);
                model.setFileName(file.getName());
                model.setAbsoluteFilePath(file.getAbsolutePath());
                if (i == 0) {
                    String header = Transcription2TabDelimitedText.getHeaders(model, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat);
                    writer.write(header, 0, header.length() - 1);
                    writer.write(TAB + ElanLocale.getString("Frame.GridFrame.ColumnFileName") + TAB + ElanLocale.getString("Frame.GridFrame.ColumnFilePath") + NEWLINE);
                }
                Transcription2TabDelimitedText.writeRows(writer, model, includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat, 0L, includeFileName, includeFilePath);
                continue;
            }
            catch (Exception ex) {
                System.out.println("Could not handle file: " + file.getAbsolutePath());
            }
        }
        writer.close();
    }

    public static void exportTiers(List files, String[] tierNames, File exportFile, String charEncoding, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat, boolean includeNames, boolean includeFileName, boolean includeFilePath) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            throw new IOException("No files specified for export");
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)out, charEncoding);
        }
        catch (UnsupportedCharsetException uce) {
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        BufferedWriter writer = new BufferedWriter(osw);
        AnnotationCore[] annotations = null;
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                Vector tiers = trans.getTiers();
                block5: for (int j = 0; j < tiers.size(); ++j) {
                    int k;
                    TierImpl tier = (TierImpl)tiers.get(j);
                    String name = tier.getName();
                    if (tierNames != null) {
                        for (k = 0; k < tierNames.length && !tierNames[k].equals(name); ++k) {
                            if (k == tierNames.length - 1) continue block5;
                        }
                    }
                    annotations = tier.getAnnotations().toArray(new AnnotationCore[0]);
                    for (k = 0; k < annotations.length; ++k) {
                        if (annotations[k] == null) continue;
                        if (includeNames) {
                            writer.write(name);
                        }
                        String tabString = Transcription2TabDelimitedText.getTabString(annotations[k], includeBeginTime, includeEndTime, includeDuration, includeHHMM, includeSSMS, includeMS, includeSMPTE, palFormat, 0L);
                        writer.write(tabString, 0 + (includeNames ? 0 : 1), tabString.length() - 1);
                        if (includeFileName) {
                            writer.write(TAB + file.getName());
                        }
                        if (includeFilePath) {
                            writer.write(TAB + file.getAbsolutePath());
                        }
                        writer.write(NEWLINE);
                    }
                }
                continue;
            }
            catch (Exception ex) {
                System.out.println("Could not handle file: " + file.getAbsolutePath());
            }
        }
        writer.close();
    }

    private static String getHeaders(TabExportTableModel model, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat) {
        StringBuffer buf = new StringBuffer();
        if (includeBeginTime) {
            if (includeHHMM) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + TAB);
            }
            if (includeSSMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + TAB);
            }
            if (includeMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + TAB);
            }
            if (includeSMPTE) {
                if (palFormat) {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + TAB);
                } else {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + TAB);
                }
            }
        }
        if (includeEndTime) {
            if (includeHHMM) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + TAB);
            }
            if (includeSSMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + TAB);
            }
            if (includeMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + TAB);
            }
            if (includeSMPTE) {
                if (palFormat) {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + TAB);
                } else {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + TAB);
                }
            }
        }
        if (includeDuration) {
            if (includeHHMM) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + TAB);
            }
            if (includeSSMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + TAB);
            }
            if (includeMS) {
                buf.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + TAB);
            }
            if (includeSMPTE) {
                if (palFormat) {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + TAB);
                } else {
                    buf.append(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + TAB);
                }
            }
        }
        for (int i = 2; i < model.getColumnCount(); ++i) {
            buf.append(model.getColumnName(i));
            if (i == model.getColumnCount() - 1) continue;
            buf.append(TAB);
        }
        buf.append(NEWLINE);
        return buf.toString();
    }

    private static void writeRows(BufferedWriter writer, TabExportTableModel model, boolean includeBeginTime, boolean includeEndTime, boolean includeDuration, boolean includeHHMM, boolean includeSSMS, boolean includeMS, boolean includeSMPTE, boolean palFormat, long mediaOffset, boolean includeFileName, boolean includeFilePath) throws IOException {
        for (int i = 0; i < model.getRowCount(); ++i) {
            long bt = (Long)model.getValueAt(i, 0) + mediaOffset;
            long et = (Long)model.getValueAt(i, 1) + mediaOffset;
            if (includeBeginTime) {
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(bt) + TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)bt / 1000.0) + TAB);
                }
                if (includeMS) {
                    writer.write(bt + TAB);
                }
                if (includeSMPTE) {
                    if (palFormat) {
                        writer.write(TimeFormatter.toTimecodePAL(bt) + TAB);
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(bt) + TAB);
                    }
                }
            }
            if (includeEndTime) {
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(et) + TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)et / 1000.0) + TAB);
                }
                if (includeMS) {
                    writer.write(et + TAB);
                }
                if (includeSMPTE && palFormat) {
                    if (palFormat) {
                        writer.write(TimeFormatter.toTimecodePAL(et) + TAB);
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(et) + TAB);
                    }
                }
            }
            if (includeDuration) {
                long d = et - bt;
                if (includeHHMM) {
                    writer.write(TimeFormatter.toString(d) + TAB);
                }
                if (includeSSMS) {
                    writer.write(Double.toString((double)d / 1000.0) + TAB);
                }
                if (includeMS) {
                    writer.write(d + TAB);
                }
            }
            for (int j = 2; j < model.getColumnCount(); ++j) {
                Object value = model.getValueAt(i, j);
                if (value instanceof String) {
                    writer.write(((String)value).replace(NEWLINE, " "));
                }
                if (j == model.getColumnCount() - 1) continue;
                writer.write(TAB);
            }
            if (model.getFileName() != null) {
                if (includeFileName) {
                    writer.write(TAB + model.getFileName());
                }
                if (includeFilePath) {
                    writer.write(TAB + model.getAbsoluteFilePath());
                }
            }
            writer.write(NEWLINE);
        }
        writer.write(NEWLINE);
    }

    public static void exportAnnotations(String tierName, List annotations, File exportFile) throws IOException {
        if (exportFile == null) {
            return;
        }
        FileOutputStream out = new FileOutputStream(exportFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        for (int i = 0; i < annotations.size(); ++i) {
            if (!(annotations.get(i) instanceof AnnotationCore)) continue;
            writer.write(tierName + Transcription2TabDelimitedText.getTabString((AnnotationCore)annotations.get(i)));
        }
        writer.close();
    }

    public static String getTabString(AnnotationCore annotationCore) {
        return Transcription2TabDelimitedText.getTabString(annotationCore, true, true);
    }

    public static String getTabString(AnnotationCore annotationCore, boolean HHMMformat, boolean SSMSFormat) {
        return Transcription2TabDelimitedText.getTabString(annotationCore, true, true, true, HHMMformat, SSMSFormat, false);
    }

    public static String getTabString(AnnotationCore annotationCore, boolean beginTime, boolean endTime, boolean duration, boolean HHMMformat, boolean SSMSFormat, boolean MSFormat) {
        return Transcription2TabDelimitedText.getTabString(annotationCore, beginTime, endTime, duration, HHMMformat, SSMSFormat, MSFormat, false, false, 0L);
    }

    public static String getTabString(AnnotationCore annotationCore, boolean beginTime, boolean endTime, boolean duration, boolean HHMMformat, boolean SSMSFormat, boolean MSFormat, boolean SMPTEFormat, boolean PAL, long mediaOffset) {
        StringBuffer sb = new StringBuffer(TAB);
        long bt = annotationCore.getBeginTimeBoundary() + mediaOffset;
        long et = annotationCore.getEndTimeBoundary() + mediaOffset;
        if (beginTime) {
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(bt) + TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)bt / 1000.0) + TAB);
            }
            if (MSFormat) {
                sb.append(bt + TAB);
            }
            if (SMPTEFormat) {
                if (PAL) {
                    sb.append(TimeFormatter.toTimecodePAL(bt) + TAB);
                } else {
                    sb.append(TimeFormatter.toTimecodeNTSC(bt) + TAB);
                }
            }
        }
        if (endTime) {
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(et) + TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)et / 1000.0) + TAB);
            }
            if (MSFormat) {
                sb.append(et + TAB);
            }
            if (SMPTEFormat) {
                if (PAL) {
                    sb.append(TimeFormatter.toTimecodePAL(et) + TAB);
                } else {
                    sb.append(TimeFormatter.toTimecodeNTSC(et) + TAB);
                }
            }
        }
        if (duration) {
            long d = et - bt;
            if (HHMMformat) {
                sb.append(TimeFormatter.toString(d) + TAB);
            }
            if (SSMSFormat) {
                sb.append(Double.toString((double)d / 1000.0) + TAB);
            }
            if (MSFormat) {
                sb.append(d + TAB);
            }
        }
        sb.append(annotationCore.getValue().replace('\n', ' ') + NEWLINE);
        return sb.toString();
    }
}

