/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ECVStore;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class TranscriptionECVLoader {
    public void loadExternalCVs(TranscriptionImpl transcription, Frame parent) {
        int numCV = transcription.getControlledVocabularies().size();
        if (numCV > 0) {
            int numLoadedExternal = 0;
            ControlledVocabulary cv = null;
            ECVStore ecvStore = null;
            HashMap urlMap = new HashMap(4);
            for (int i = 0; i < numCV; ++i) {
                String urlString;
                Object extRef;
                ExternalCV ecv;
                cv = (ControlledVocabulary)transcription.getControlledVocabularies().get(i);
                if (!(cv instanceof ExternalCV) || (ecv = (ExternalCV)cv).isLoadedFromURL() || ecv.isLoadedFromCache() || !((extRef = ecv.getExternalRef()) instanceof ExternalReference) || ((ExternalReference)extRef).getReferenceType() != 4 || (urlString = ((ExternalReference)extRef).getValue()) == null) continue;
                if (urlMap.containsKey(urlString)) {
                    ((List)urlMap.get(urlString)).add(ecv);
                    continue;
                }
                ArrayList<ExternalCV> ecvList = new ArrayList<ExternalCV>(4);
                ecvList.add(ecv);
                urlMap.put(urlString, ecvList);
            }
            Iterator keyIt = urlMap.keySet().iterator();
            String urlStr = null;
            List ecvList = null;
            String cachedCV = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "CVCACHE";
            while (keyIt.hasNext()) {
                urlStr = (String)keyIt.next();
                ecvList = (List)urlMap.get(urlStr);
                if (ecvStore == null) {
                    ecvStore = new ECVStore();
                }
                try {
                    ecvStore.loadExternalCVS(ecvList, urlStr);
                    for (ExternalCV excv : ecvList) {
                        excv.setLoadedFromURL(true);
                    }
                    numLoadedExternal += ecvList.size();
                    ecvStore.storeExternalCVS(ecvList, cachedCV, urlStr);
                }
                catch (Exception exc) {
                    try {
                        URL url = new URL(urlStr);
                        String urlHost = url.getHost();
                        if (urlHost.equals("")) {
                            urlHost = "localfile_system";
                        }
                        cachedCV = cachedCV + Constants.FILESEPARATOR + urlHost;
                        String[] pathElements = url.getPath().substring(1).split("/");
                        for (int j = 0; j < pathElements.length; ++j) {
                            cachedCV = cachedCV + Constants.FILESEPARATOR + pathElements[j];
                        }
                        ecvStore.loadExternalCVS(ecvList, cachedCV);
                        for (ExternalCV excv : ecvList) {
                            excv.setLoadedFromCache(true);
                        }
                        String message = ElanLocale.getString("LoadExternalCV.Message.Readerror") + " " + urlStr + "\n" + ElanLocale.getString("LoadExternalCV.Message.LoadedFromCache");
                        if (parent != null) {
                            JOptionPane.showMessageDialog(parent, message, ElanLocale.getString("Message.Warning"), 2);
                            continue;
                        }
                        ClientLogger.LOG.warning("Warning: " + message);
                    }
                    catch (Exception ex) {
                        String message = ElanLocale.getString("LoadExternalCV.Message.Readerror") + " " + urlStr + "\n" + ElanLocale.getString("LoadExternalCV.Message.NotLoadedFromCache");
                        if (parent != null) {
                            JOptionPane.showMessageDialog(parent, message, ElanLocale.getString("Message.Warning"), 2);
                            continue;
                        }
                        ClientLogger.LOG.warning("Warning: " + message);
                    }
                }
            }
            if (numLoadedExternal > 0) {
                transcription.checkAnnotECVConsistency();
            }
        }
    }
}

