/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.p2p;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.p2p.CollaborationPanel;
import mpi.eudico.p2p.P2P2Here;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.util.BidirectionalPipeService;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class ElanP2P
implements PipeMsgListener {
    private static boolean jxtaInitialized = false;
    private static PeerGroup netGroup = null;
    private static DiscoveryService netDiscoSvc;
    private PeerGroup sessionGroup = null;
    private DiscoveryService sessionDiscoSvc;
    private PipeService pipeSvc;
    private InputPipe inputPipe;
    private OutputPipe outputPipe;
    private Message msg;
    private static final String TAG = "DataTag";
    private static final String COMMAND = "Command";
    private static final String ELAN_COMMAND = "elanCommand";
    private static final String PARAMETER1 = "parameter1";
    private static final String PARAMETER2 = "parameter2";
    private static final String SET_EAF = "setEAF";
    private static final String EAF_STRING = "EAFString";
    private static final String INPIPE_OFFERED = "InpipeOffered";
    private static final String PARTICIPANT_MAIL = "ParticipantMail";
    private static final String PARTICIPANT_NAME = "ParticipantName";
    private static final String GET_PARTICIPANTS = "GetParticipants";
    private static final String ADD_PARTICIPANT = "AddParticipant";
    private static final String TRANSCRIPTION_ID = "TranscriptionID";
    private static final String FILENAME = "pipeserver.adv";
    private static final String REQUEST_CONTROL = "RequestControl";
    private static final String LEAVE_SESSION = "LeaveSession";
    private static final String GET_SESSION_INFO = "GetSessionInfo";
    private static final String SESSION_INFO = "SessionInfo";
    private OutputPipe broadcastPipe;
    private BidirectionalPipeService.Pipe pipe = null;
    private BidirectionalPipeService.AcceptPipe acceptPipe = null;
    private Transcription transcription;
    private ViewerManager2 viewerManager;
    private ElanFrame2 frame;
    private ElanLayoutManager layoutManager;
    private P2P2Here p2p2Here;
    private CollaborationPanel collaborationPanel;
    private Hashtable outputPipeHash;
    private boolean hasControl = false;
    private String localEmail;
    private String localName;

    public ElanP2P(ElanFrame2 frame) {
        this.frame = frame;
        this.initP2P();
    }

    public void setManagers(ViewerManager2 viewerManager, ElanLayoutManager layoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = layoutManager;
        this.transcription = viewerManager.getTranscription();
        this.p2p2Here = new P2P2Here(this, viewerManager, this.frame);
        this.collaborationPanel = new CollaborationPanel(this);
        this.populateCollaborationPanel();
        layoutManager.add(this.collaborationPanel);
    }

    public ElanP2P(Transcription theTranscription) {
        this.transcription = theTranscription;
    }

    private void initP2P() {
        if (!jxtaInitialized) {
            System.out.println("Setup Elan for p2p services");
            ElanP2P.startJxta();
            jxtaInitialized = true;
        }
    }

    public void sendCommand(String command) {
        this.sendCommand(command, "", "");
    }

    public void sendCommand(String command, String parameter1) {
        this.sendCommand(command, parameter1, "");
    }

    public void sendCommand(String command, String parameter1, String parameter2) {
        this.sendCommand(COMMAND, command, parameter1, parameter2);
    }

    public void sendElanCommand(String command) {
        this.sendElanCommand(command, "", "");
    }

    public void sendElanCommand(String command, String parameter1) {
        this.sendElanCommand(command, parameter1, "");
    }

    public void sendElanCommand(String command, String parameter1, String parameter2) {
        if (this.hasControl) {
            this.sendCommand(ELAN_COMMAND, command, parameter1, parameter2);
        }
    }

    private void sendCommand(String type, String command, String parameter1, String parameter2) {
        if (this.pipeSvc == null) {
            return;
        }
        try {
            if (parameter1 == null) {
                parameter1 = "";
            }
            if (parameter2 == null) {
                parameter2 = "";
            }
            Message msg = this.pipeSvc.createMessage();
            msg.setString(type, command);
            msg.setString(PARAMETER1, parameter1);
            msg.setString(PARAMETER2, parameter2);
            if (this.outputPipe != null) {
                this.outputPipe.send(msg);
            }
            System.out.println("sent command: " + command + " par1 = " + parameter1 + " par2 = " + parameter2 + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void startJxta() {
        try {
            netGroup = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException e) {
            System.out.println("fatal error : group creation failure");
            e.printStackTrace();
            return;
        }
        System.out.println("Getting NetDiscoveryService");
        netDiscoSvc = netGroup.getDiscoveryService();
    }

    public void startServer(String theName, String theEmail) {
        this.hasControl = true;
        this.localName = theName;
        this.localEmail = theEmail;
        this.populateCollaborationPanel();
        this.sessionGroup = this.createGroup();
        if (this.sessionGroup != null) {
            this.joinGroup(this.sessionGroup);
        }
        try {
            System.out.println("Share " + this.transcription.getName() + " in p2p annotation session");
            this.collaborationPanel.setSessionName(this.transcription.getName());
            this.collaborationPanel.setChairName(this.localEmail);
            this.collaborationPanel.setSharedDocumentName(this.transcription.getName());
            this.sessionDiscoSvc = this.sessionGroup.getDiscoveryService();
            if (this.pipeSvc == null) {
                System.out.println("Getting Session PipeService");
                this.pipeSvc = this.sessionGroup.getPipeService();
            }
            ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleClassAdvertisement.getAdvertisementType());
            mcadv.setName("JXTAMOD:ELAN");
            mcadv.setDescription("First attempt to provide p2p annotation services");
            ModuleClassID mcID = IDFactory.newModuleClassID();
            mcadv.setModuleClassID(mcID);
            this.sessionDiscoSvc.publish((Advertisement)mcadv, 2);
            this.sessionDiscoSvc.remotePublish((Advertisement)mcadv, 2);
            ModuleSpecAdvertisement mdadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleSpecAdvertisement.getAdvertisementType());
            mdadv.setName(this.transcription.getName());
            mdadv.setVersion("Version 1.0");
            mdadv.setCreator("mpi.nl");
            ModuleSpecID id = IDFactory.newModuleSpecID((ModuleClassID)mcID);
            mdadv.setModuleSpecID(id);
            mdadv.setSpecURI("http://www.mpi.nl/tools");
            PipeAdvertisement pipeadv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            pipeadv.setName("JXTA-ELAN");
            PipeID pid = IDFactory.newPipeID((PeerGroupID)this.sessionGroup.getPeerGroupID());
            pipeadv.setPipeID((ID)pid);
            mdadv.setPipeAdvertisement(pipeadv);
            System.out.println("Created service advertisement:");
            StructuredTextDocument doc = (StructuredTextDocument)mdadv.getDocument(new MimeMediaType("text/plain"));
            StringWriter out = new StringWriter();
            doc.sendToWriter((Writer)out);
            System.out.println(out.toString());
            out.close();
            this.sessionDiscoSvc.publish((Advertisement)mdadv, 2);
            this.sessionDiscoSvc.remotePublish((Advertisement)mdadv, 2);
            this.inputPipe = this.pipeSvc.createInputPipe(pipeadv, (PipeMsgListener)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Server: Error publishing the module");
        }
    }

    public void startClient(String key, String theName, String theEmail) {
        System.out.println("Starting Client peer ....");
        this.hasControl = false;
        this.localName = theName;
        this.localEmail = theEmail;
        PeerGroup sessionGroup = this.discoverGroup(key);
        if (sessionGroup == null) {
            JOptionPane.showMessageDialog(this.frame, "The requested document was not found", "Warning", 2);
            return;
        }
        if (this.sessionDiscoSvc == null) {
            this.sessionDiscoSvc = sessionGroup.getDiscoveryService();
        }
        if (this.pipeSvc == null) {
            System.out.println("Getting Session PipeService");
            this.pipeSvc = sessionGroup.getPipeService();
        }
        this.connectToDocument(sessionGroup);
        this.offerInputPipe(sessionGroup);
    }

    private PeerGroup discoverGroup(String key) {
        PeerGroup sessionPeerGroup;
        block13: {
            String groupName = "";
            Enumeration en = null;
            sessionPeerGroup = null;
            try {
                if (key == null) break block13;
                groupName = key;
                System.out.println("Searching for the " + groupName + " Group");
                int timeout = 20000;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start <= 20000L) {
                    try {
                        en = netDiscoSvc.getLocalAdvertisements(1, "Name", groupName);
                        if (en != null && en.hasMoreElements()) break;
                        netDiscoSvc.getRemoteAdvertisements(null, 1, "Name", groupName, 1, null);
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Exception e) {}
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    System.out.print(".");
                }
                if (en == null || !en.hasMoreElements()) {
                    System.out.println("\nNo group found");
                    return null;
                }
                System.out.println("We found the group!");
                Object str = null;
                PeerGroupAdvertisement pgAdv = null;
                while (en.hasMoreElements()) {
                    try {
                        pgAdv = (PeerGroupAdvertisement)en.nextElement();
                        StructuredTextDocument doc = (StructuredTextDocument)pgAdv.getDocument(new MimeMediaType("text/plain"));
                        StringWriter out = new StringWriter();
                        doc.sendToWriter((Writer)out);
                        System.out.println(out.toString());
                        out.close();
                        System.out.println(" Peer Group = " + pgAdv.getName());
                        if (!pgAdv.getName().equals(groupName)) continue;
                        try {
                            sessionPeerGroup = netGroup.newGroup((Advertisement)pgAdv);
                        }
                        catch (PeerGroupException e) {
                            System.out.println("error creating PeerGroup from advertisement");
                        }
                        this.joinGroup(sessionPeerGroup);
                    }
                    catch (IOException e) {
                        System.out.println("error parsing response element");
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sessionPeerGroup;
    }

    private void connectToDocument(PeerGroup sessionPeerGroup) {
        if (sessionPeerGroup == null) {
            System.out.println("Peer group for session not avaible");
            return;
        }
        String groupName = sessionPeerGroup.getPeerGroupName();
        System.out.println("Searching for the " + groupName + " Service advertisement");
        Enumeration en = null;
        while (true) {
            try {
                en = this.sessionDiscoSvc.getLocalAdvertisements(2, "Name", groupName);
                if (en != null && en.hasMoreElements()) break;
                this.sessionDiscoSvc.getRemoteAdvertisements(null, 2, "Name", groupName, 1, null);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {}
            }
            catch (IOException e) {
                // empty catch block
            }
            System.out.print(".");
        }
        System.out.println("We found the service advertisement:");
        ModuleSpecAdvertisement mdsadv = (ModuleSpecAdvertisement)en.nextElement();
        try {
            StructuredTextDocument doc = (StructuredTextDocument)mdsadv.getDocument(new MimeMediaType("text/plain"));
            StringWriter out = new StringWriter();
            doc.sendToWriter((Writer)out);
            System.out.println(out.toString());
            out.close();
            PipeAdvertisement pipeadv = mdsadv.getPipeAdvertisement();
            if (pipeadv == null) {
                System.out.println("Error -- Null pipe advertisement!");
                System.exit(1);
            }
            this.outputPipe = null;
            for (int i = 0; i < 3; ++i) {
                System.out.println("Trying to bind to pipe...");
                try {
                    this.outputPipe = this.pipeSvc.createOutputPipe(pipeadv, 10000L);
                    break;
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (this.outputPipe == null) {
                System.out.println("Error resolving pipe endpoint");
                System.exit(1);
            } else {
                if (this.outputPipeHash == null) {
                    this.outputPipeHash = new Hashtable();
                }
                this.outputPipeHash.put("KNOEP", this.outputPipe);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Client: Error sending message to the service");
        }
    }

    private void offerInputPipe(PeerGroup sessionPeerGroup) {
        try {
            PipeAdvertisement pipeadv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            pipeadv.setName("JXTA-ELAN");
            PipeID pid = IDFactory.newPipeID((PeerGroupID)sessionPeerGroup.getPeerGroupID());
            pipeadv.setPipeID((ID)pid);
            this.inputPipe = this.pipeSvc.createInputPipe(pipeadv, (PipeMsgListener)this);
            StructuredTextDocument doc = (StructuredTextDocument)pipeadv.getDocument(new MimeMediaType("text/xml"));
            StringWriter out = new StringWriter();
            doc.sendToWriter((Writer)out);
            this.msg = this.pipeSvc.createMessage();
            this.msg.setString(INPIPE_OFFERED, out.toString());
            this.msg.setString(PARTICIPANT_MAIL, this.localEmail);
            this.msg.setString(PARTICIPANT_NAME, this.localName);
            this.outputPipe.send(this.msg);
            System.out.println("Input pipe advertisement returned");
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Server: Error publishing the module");
        }
    }

    private void buildPipeInfrastructure() {
        this.msg = this.pipeSvc.createMessage();
        this.msg.setString("Init", "PipeAdvertisements");
        try {
            this.outputPipe.send(this.msg);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void sendCommands() {
        String command = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Type command: ");
        try {
            while ((command = br.readLine()) != null) {
                this.msg = this.pipeSvc.createMessage();
                this.msg.setString(COMMAND, command);
                this.outputPipe.send(this.msg);
                System.out.println("Command: \"" + command + "\" sent to the Server");
                System.out.println("\nType command: ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            msg = event.getMessage();
            if (msg == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String command = msg.getString(COMMAND);
        if (command != null) {
            String par1 = msg.getString(PARAMETER1);
            String par2 = msg.getString(PARAMETER2);
            System.out.println("received command: " + command + " with p1: " + par1 + " and p2: " + par2);
            if (command.equals(GET_PARTICIPANTS)) {
                this.sendCommand(ADD_PARTICIPANT, this.localName, this.localEmail);
            } else if (command.equals(ADD_PARTICIPANT)) {
                this.collaborationPanel.addParticipant(par1, par2);
                this.collaborationPanel.setControllingParticipant(par2);
            } else if (command.equals(REQUEST_CONTROL)) {
                this.collaborationPanel.setControllingParticipant(par1);
                this.hasControl = false;
            } else if (command.equals(LEAVE_SESSION)) {
                this.collaborationPanel.removeParticipant(par1);
                this.pipeSvc = null;
            } else if (command.equals(GET_SESSION_INFO)) {
                this.sendCommand(SESSION_INFO, this.collaborationPanel.getSharedDocumentName(), this.collaborationPanel.getChairName());
            } else if (command.equals(SESSION_INFO)) {
                this.collaborationPanel.setSessionName(par1);
                this.collaborationPanel.setChairName(par2);
                this.collaborationPanel.setSharedDocumentName(par1);
            }
        }
        if ((command = msg.getString(ELAN_COMMAND)) != null) {
            String parameter1 = msg.getString(PARAMETER1);
            String parameter2 = msg.getString(PARAMETER2);
            if (command.equals(SET_EAF)) {
                String eafString = parameter1;
                try {
                    String fullPath = Constants.USERHOME + Constants.FILESEPARATOR + "p2p.eaf";
                    File p2pEafFile = new File(fullPath);
                    FileWriter out = new FileWriter(p2pEafFile);
                    out.write(eafString, 0, eafString.length());
                    out.flush();
                    out.close();
                    this.frame.openEAF(fullPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.p2p2Here.handleCommand(command, parameter1, parameter2);
            }
            return;
        }
        String offeredInputPipeString = msg.getString(INPIPE_OFFERED);
        if (offeredInputPipeString != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(offeredInputPipeString.getBytes());
                PipeAdvertisement offeredPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)is);
                OutputPipe p = this.pipeSvc.createOutputPipe(offeredPipeAdv, 10000L);
                String participantEmailString = msg.getString(PARTICIPANT_MAIL);
                String participantNameString = msg.getString(PARTICIPANT_NAME);
                if (participantEmailString != null) {
                    if (this.outputPipeHash == null) {
                        this.outputPipeHash = new Hashtable();
                    }
                    this.outputPipeHash.put(participantEmailString, p);
                    this.collaborationPanel.addParticipant(participantNameString, participantEmailString);
                    if (this.outputPipe == null) {
                        this.outputPipe = p;
                    }
                    System.out.println("pipe advertisement received: " + offeredPipeAdv.getName() + " from: " + participantEmailString);
                    System.out.println("sending eaf document to newly connected in pipe");
                    this.sendEAFDocument(p);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    private void sendEAFDocument(OutputPipe theOutPipe) {
        if (this.transcription != null) {
            try {
                int c;
                String eafPath = ((TranscriptionImpl)this.transcription).getFullPath();
                eafPath = "/" + eafPath.substring(5);
                File eafFile = new File(eafPath);
                FileReader in = new FileReader(eafFile);
                BufferedReader br = new BufferedReader(in);
                StringBuffer sb = new StringBuffer();
                while ((c = br.read()) != -1) {
                    sb.append((char)c);
                }
                br.close();
                String eafString = sb.toString();
                Message msg = this.pipeSvc.createMessage();
                msg.setString(ELAN_COMMAND, SET_EAF);
                msg.setString(PARAMETER1, eafString);
                theOutPipe.send(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void messageReceived(Message message, OutputPipe pipe) {
        System.out.println("message received:" + message.getString(COMMAND));
    }

    private PeerGroup createGroup() {
        PeerGroupAdvertisement adv;
        PeerGroup pg;
        System.out.println("Creating a new group advertisement");
        try {
            ModuleImplAdvertisement implAdv = netGroup.getAllPurposePeerGroupImplAdvertisement();
            pg = netGroup.newGroup(null, (Advertisement)implAdv, this.transcription.getName(), "testing group adv");
            adv = pg.getPeerGroupAdvertisement();
            PeerGroupID GID = adv.getPeerGroupID();
            System.out.println("  Group = " + adv.getName() + "\n  Group ID = " + GID.toString());
        }
        catch (Exception eee) {
            System.out.println("Group creation failed with " + eee.toString());
            return null;
        }
        try {
            netDiscoSvc.remotePublish((Advertisement)adv, 1);
            System.out.println("Group published successfully.\n");
        }
        catch (Exception e) {
            System.out.println("Error publishing group advertisement");
            e.printStackTrace();
            return null;
        }
        return pg;
    }

    private void joinGroup(PeerGroup grp) {
        System.out.println("Joining peer group...");
        Element creds = null;
        try {
            AuthenticationCredential authCred = new AuthenticationCredential(grp, null, creds);
            MembershipService membership = grp.getMembershipService();
            Authenticator auth = membership.apply(authCred);
            if (auth.isReadyForJoin()) {
                Credential myCred = membership.join(auth);
                System.out.println("Successfully joined group " + grp.getPeerGroupName());
                System.out.println("\nCredential: ");
                StructuredTextDocument doc = (StructuredTextDocument)myCred.getDocument(new MimeMediaType("text/plain"));
                StringWriter out = new StringWriter();
                doc.sendToWriter((Writer)out);
                System.out.println(out.toString());
                out.close();
            } else {
                System.out.println("Failure: unable to join group");
            }
        }
        catch (Exception e) {
            System.out.println("Failure in authentication.");
            e.printStackTrace();
        }
    }

    public void requestControl() {
        this.sendCommand(REQUEST_CONTROL, this.localEmail);
        this.hasControl = true;
    }

    public void leaveSession() {
        this.sendCommand(LEAVE_SESSION, this.localEmail);
        this.pipeSvc = null;
    }

    public void populateCollaborationPanel() {
        if (this.localEmail != null) {
            this.collaborationPanel.setLocalParticipantName(this.localName);
            this.collaborationPanel.setLocalParticipantMail(this.localEmail);
            this.collaborationPanel.addParticipant(this.localName, this.localEmail);
        }
        if (this.hasControl) {
            this.collaborationPanel.setControllingParticipant(this.localEmail);
        }
        if (this.outputPipe != null) {
            this.sendCommand(GET_PARTICIPANTS);
            this.sendCommand(GET_SESSION_INFO);
        }
    }
}

