/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.p2p;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Transcription;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredTextDocument;
import net.jxta.endpoint.Message;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleClassAdvertisement;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.ModuleSpecAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class ElanP2PServer
implements PipeMsgListener {
    private static PeerGroup netGroup = null;
    private static DiscoveryService netDiscoSvc;
    private static final String TAG = "DataTag";
    private static final String COMMAND = "Command";
    private static final String TRANSCRIPTION_ID = "TranscriptionID";
    private static final String FILENAME = "pipeserver.adv";
    private PeerGroup sessionGroup = null;
    private DiscoveryService sessionDiscoSvc;
    private PipeService pipeSvc;
    private InputPipe myPipe;
    private Message msg;
    private OutputPipe broadcastPipe;
    private Transcription transcription;

    public ElanP2PServer(Transcription theTranscription) {
        this.transcription = theTranscription;
    }

    public static void initP2P() {
        System.out.println("Setup Elan for p2p services");
        ElanP2PServer.startJxta();
    }

    private static void startJxta() {
        try {
            netGroup = PeerGroupFactory.newNetPeerGroup();
        }
        catch (PeerGroupException e) {
            System.out.println("fatal error : group creation failure");
            e.printStackTrace();
            return;
        }
        System.out.println("Getting NetDiscoveryService");
        netDiscoSvc = netGroup.getDiscoveryService();
    }

    public void startServer() {
        this.sessionGroup = this.createGroup();
        if (this.sessionGroup != null) {
            this.joinGroup(this.sessionGroup);
        }
        try {
            System.out.println("Share " + this.transcription.getName() + " in p2p annotation session");
            this.sessionDiscoSvc = this.sessionGroup.getDiscoveryService();
            System.out.println("Getting Session PipeService");
            this.pipeSvc = this.sessionGroup.getPipeService();
            ModuleClassAdvertisement mcadv = (ModuleClassAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleClassAdvertisement.getAdvertisementType());
            mcadv.setName("JXTAMOD:ELAN");
            mcadv.setDescription("First attempt to provide p2p annotation services");
            ModuleClassID mcID = IDFactory.newModuleClassID();
            mcadv.setModuleClassID(mcID);
            this.sessionDiscoSvc.publish((Advertisement)mcadv, 2);
            this.sessionDiscoSvc.remotePublish((Advertisement)mcadv, 2);
            ModuleSpecAdvertisement mdadv = (ModuleSpecAdvertisement)AdvertisementFactory.newAdvertisement((String)ModuleSpecAdvertisement.getAdvertisementType());
            mdadv.setName(this.transcription.getName());
            mdadv.setVersion("Version 1.0");
            mdadv.setCreator("mpi.nl");
            ModuleSpecID id = IDFactory.newModuleSpecID((ModuleClassID)mcID);
            mdadv.setModuleSpecID(id);
            mdadv.setSpecURI("http://www.mpi.nl/tools");
            PipeAdvertisement pipeadv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
            pipeadv.setName("JXTA-ELAN");
            PipeID pid = IDFactory.newPipeID((PeerGroupID)this.sessionGroup.getPeerGroupID());
            pipeadv.setPipeID((ID)pid);
            mdadv.setPipeAdvertisement(pipeadv);
            System.out.println("Created service advertisement:");
            StructuredTextDocument doc = (StructuredTextDocument)mdadv.getDocument(new MimeMediaType("text/plain"));
            StringWriter out = new StringWriter();
            doc.sendToWriter((Writer)out);
            System.out.println(out.toString());
            out.close();
            this.sessionDiscoSvc.publish((Advertisement)mdadv, 2);
            this.sessionDiscoSvc.remotePublish((Advertisement)mdadv, 2);
            this.myPipe = this.pipeSvc.createInputPipe(pipeadv, (PipeMsgListener)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Server: Error publishing the module");
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message msg = null;
        try {
            msg = event.getMessage();
            if (msg == null) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String commandID = msg.getString(COMMAND);
        String broadcastPipeString = msg.getString("BroadcastPipe");
        if (broadcastPipeString != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(broadcastPipeString.getBytes());
                PipeAdvertisement broadcastPipeAdv = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)is);
                this.broadcastPipe = this.pipeSvc.createOutputPipe(broadcastPipeAdv, 10000L);
                System.out.println("broadcast pipe advertisement received: " + broadcastPipeAdv.getName());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (commandID == null) {
            System.out.println("msg received is null");
        } else {
            try {
                if (this.broadcastPipe != null) {
                    msg = this.pipeSvc.createMessage();
                    msg.setString("ACK", commandID);
                    this.broadcastPipe.send(msg);
                }
                System.out.println("Received command: " + commandID + " for transcription: " + this.transcription.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CommandAction ca = ELANCommandFactory.getCommandAction(this.transcription, commandID);
        if (ca != null) {
            ca.externalCommand(null, null);
        } else {
            System.out.println("no command could be retrieved for received msg");
        }
    }

    private PeerGroup createGroup() {
        PeerGroupAdvertisement adv;
        PeerGroup pg;
        System.out.println("Creating a new group advertisement");
        try {
            ModuleImplAdvertisement implAdv = netGroup.getAllPurposePeerGroupImplAdvertisement();
            pg = netGroup.newGroup(null, (Advertisement)implAdv, this.transcription.getName(), "testing group adv");
            adv = pg.getPeerGroupAdvertisement();
            PeerGroupID GID = adv.getPeerGroupID();
            System.out.println("  Group = " + adv.getName() + "\n  Group ID = " + GID.toString());
        }
        catch (Exception eee) {
            System.out.println("Group creation failed with " + eee.toString());
            return null;
        }
        try {
            netDiscoSvc.remotePublish((Advertisement)adv, 1);
            System.out.println("Group published successfully.\n");
        }
        catch (Exception e) {
            System.out.println("Error publishing group advertisement");
            e.printStackTrace();
            return null;
        }
        return pg;
    }

    private void joinGroup(PeerGroup grp) {
        System.out.println("Joining peer group...");
        Element creds = null;
        try {
            AuthenticationCredential authCred = new AuthenticationCredential(grp, null, creds);
            MembershipService membership = grp.getMembershipService();
            Authenticator auth = membership.apply(authCred);
            if (auth.isReadyForJoin()) {
                Credential myCred = membership.join(auth);
                System.out.println("Successfully joined group " + grp.getPeerGroupName());
                System.out.println("\nCredential: ");
                StructuredTextDocument doc = (StructuredTextDocument)myCred.getDocument(new MimeMediaType("text/plain"));
                StringWriter out = new StringWriter();
                doc.sendToWriter((Writer)out);
                System.out.println(out.toString());
                out.close();
            } else {
                System.out.println("Failure: unable to join group");
            }
        }
        catch (Exception e) {
            System.out.println("Failure in authentication.");
            e.printStackTrace();
        }
    }
}

