/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

public class LinkedFileDescriptor
implements Cloneable {
    public static final String UNKNOWN_MIME_TYPE = "unknown";
    public static final String TEXT_TYPE = "text/plain";
    public static final String XML_TYPE = "text/xml";
    public static final String SVG_TYPE = "image/svg+xml";
    public String linkURL;
    public String relativeLinkURL;
    public String mimeType;
    public long timeOrigin;
    public String associatedWith;
    public String configFile;

    public LinkedFileDescriptor(String linkURL, String mimeType) {
        if (linkURL == null) {
            throw new NullPointerException();
        }
        this.linkURL = linkURL;
        this.mimeType = mimeType != null ? mimeType : UNKNOWN_MIME_TYPE;
    }

    public String toString() {
        return this.linkURL + " " + this.mimeType + " " + this.timeOrigin + " " + this.associatedWith + " " + this.configFile;
    }

    public Object clone() {
        try {
            LinkedFileDescriptor cloneLFD = (LinkedFileDescriptor)super.clone();
            if (this.linkURL != null) {
                cloneLFD.linkURL = new String(this.linkURL);
            }
            if (this.relativeLinkURL != null) {
                cloneLFD.relativeLinkURL = new String(this.relativeLinkURL);
            }
            if (this.mimeType != null) {
                cloneLFD.mimeType = new String(this.mimeType);
            }
            if (this.associatedWith != null) {
                cloneLFD.associatedWith = new String(this.associatedWith);
            }
            if (this.configFile != null) {
                cloneLFD.configFile = new String(this.configFile);
            }
            cloneLFD.timeOrigin = this.timeOrigin;
            return cloneLFD;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinkedFileDescriptor)) {
            return false;
        }
        LinkedFileDescriptor other = (LinkedFileDescriptor)obj;
        if (this.linkURL != null && other.linkURL == null || this.linkURL == null && other.linkURL != null || this.linkURL != null && other.linkURL != null && !this.linkURL.equals(other.linkURL)) {
            return false;
        }
        if (this.relativeLinkURL != null && other.relativeLinkURL == null || this.relativeLinkURL == null && other.relativeLinkURL != null || this.relativeLinkURL != null && other.relativeLinkURL != null && !this.relativeLinkURL.equals(other.relativeLinkURL)) {
            return false;
        }
        if (this.mimeType != null && other.mimeType == null || this.mimeType == null && other.mimeType != null || this.mimeType != null && other.mimeType != null && !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.associatedWith != null && other.associatedWith == null || this.associatedWith == null && other.associatedWith != null || this.associatedWith != null && other.associatedWith != null && !this.associatedWith.equals(other.associatedWith)) {
            return false;
        }
        if (this.configFile != null && other.configFile == null || this.configFile == null && other.configFile != null || this.configFile != null && other.configFile != null && !this.configFile.equals(other.configFile)) {
            return false;
        }
        return this.timeOrigin == other.timeOrigin;
    }
}

