/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TimeOrderImpl
implements TimeOrder {
    private Vector orderedTimeSlotList;
    private Transcription transcription;

    public TimeOrderImpl(Transcription theTranscription) {
        this.transcription = theTranscription;
        this.orderedTimeSlotList = new Vector();
    }

    public void insertTimeSlot(TimeSlot theTimeSlot) {
        if (theTimeSlot.isTimeAligned()) {
            int index = 0;
            long time = theTimeSlot.getTime();
            if (this.orderedTimeSlotList.size() > 0) {
                Iterator tsIter = this.orderedTimeSlotList.iterator();
                while (tsIter.hasNext() && ((TimeSlot)tsIter.next()).getTime() <= time) {
                    ++index;
                }
            }
            this.orderedTimeSlotList.insertElementAt(theTimeSlot, index);
            this.reindex(index);
        } else {
            this.orderedTimeSlotList.add(theTimeSlot);
            this.reindex(this.orderedTimeSlotList.size() - 1);
        }
    }

    private void reindex() {
        int i = 0;
        Iterator tsIter = this.orderedTimeSlotList.iterator();
        while (tsIter.hasNext()) {
            ((TimeSlot)tsIter.next()).setIndex(i++);
        }
    }

    private void reindex(int fromIndex) {
        for (int i = fromIndex; i < this.orderedTimeSlotList.size(); ++i) {
            ((TimeSlot)this.orderedTimeSlotList.get(i)).setIndex(i);
        }
    }

    public void insertTimeSlot(TimeSlot theTimeSlot, TimeSlot afterSlot, TimeSlot beforeSlot) {
        int index = 0;
        boolean positioned = false;
        long time = theTimeSlot.getTime();
        Iterator tsIter = this.orderedTimeSlotList.iterator();
        while (tsIter.hasNext()) {
            ++index;
            if ((TimeSlot)tsIter.next() != afterSlot) continue;
        }
        if (!tsIter.hasNext()) {
            positioned = true;
        }
        while (tsIter.hasNext()) {
            TimeSlot ts = (TimeSlot)tsIter.next();
            if (ts.isTimeAligned() && ts.getTime() > time) {
                positioned = true;
                break;
            }
            if (!theTimeSlot.isTimeAligned() && beforeSlot == null) {
                positioned = true;
                break;
            }
            if (ts == beforeSlot) {
                if (ts.isTimeAligned()) break;
                positioned = true;
                break;
            }
            ++index;
        }
        tsIter = null;
        if (positioned) {
            this.orderedTimeSlotList.insertElementAt(theTimeSlot, index);
            this.reindex(index);
        } else {
            System.out.println("Not positioned...");
            this.reindex();
        }
    }

    public void removeTimeSlot(TimeSlot theSlot) {
        this.orderedTimeSlotList.removeElement(theSlot);
        this.reindex();
    }

    public void printTimeOrder() {
        System.out.println("");
        for (TimeSlot t : this.orderedTimeSlotList) {
            System.out.println(t.getIndex() + " " + t.getTime());
        }
    }

    public boolean isBefore(TimeSlot timeSlot1, TimeSlot timeSlot2) {
        boolean before = true;
        before = timeSlot1.getIndex() <= timeSlot2.getIndex();
        return before;
    }

    public int size() {
        return this.orderedTimeSlotList.size();
    }

    public void pruneTimeSlots() {
        ArrayList<TimeSlot> slotsToBeDeleted = new ArrayList<TimeSlot>();
        HashSet usedSlots = ((TranscriptionImpl)this.transcription).getTimeSlotsInUse();
        TimeSlot ts = null;
        for (int i = this.orderedTimeSlotList.size() - 1; i >= 0; --i) {
            ts = (TimeSlot)this.orderedTimeSlotList.get(i);
            if (usedSlots.contains(ts)) continue;
            slotsToBeDeleted.add(ts);
        }
        this.orderedTimeSlotList.removeAll(slotsToBeDeleted);
        this.reindex();
    }

    public long proposeTimeFor(TimeSlot theSlot) {
        if (theSlot.isTimeAligned()) {
            return theSlot.getTime();
        }
        TimeSlot lastAlignedSlot = null;
        long segmentBegin = 0L;
        long segmentEnd = 0L;
        boolean slotFound = false;
        int numOfUnalignedSlots = 0;
        int slotCount = 0;
        for (TimeSlot sl : this.orderedTimeSlotList) {
            if (sl.isTimeAligned()) {
                lastAlignedSlot = sl;
                if (slotFound) {
                    segmentEnd = lastAlignedSlot.getTime();
                    break;
                }
                numOfUnalignedSlots = 0;
            } else {
                ++numOfUnalignedSlots;
            }
            if (sl != theSlot) continue;
            if (lastAlignedSlot != null) {
                segmentBegin = lastAlignedSlot.getTime();
            }
            slotFound = true;
            slotCount = numOfUnalignedSlots;
        }
        long deltaT = (segmentEnd - segmentBegin) / (long)(numOfUnalignedSlots + 1);
        return segmentBegin + (long)slotCount * deltaT;
    }

    public Enumeration elements() {
        return this.orderedTimeSlotList.elements();
    }

    public void modifyTimeSlot(TimeSlot theSlot, long newTime) {
        TimeSlot ts;
        int i;
        int currentIndex = this.orderedTimeSlotList.indexOf(theSlot);
        int newIndex = -1;
        if (!theSlot.isTimeAligned() || newTime > theSlot.getTime()) {
            for (i = currentIndex + 1; i < this.orderedTimeSlotList.size(); ++i) {
                ts = (TimeSlot)this.orderedTimeSlotList.elementAt(i);
                if (ts.isTimeAligned() && ts.getTime() <= newTime) {
                    newIndex = i;
                    continue;
                }
                if (ts.getTime() >= newTime) break;
            }
        }
        if (!(newIndex != -1 || theSlot.isTimeAligned() && newTime >= theSlot.getTime())) {
            for (i = currentIndex - 1; i >= 0; --i) {
                ts = (TimeSlot)this.orderedTimeSlotList.elementAt(i);
                if (ts.isTimeAligned() && ts.getTime() >= newTime) {
                    newIndex = i;
                    continue;
                }
                if (ts.getTime() <= newTime && ts.isTimeAligned()) break;
            }
        }
        theSlot.updateTime(newTime);
        if (newIndex >= 0 && currentIndex >= 0) {
            this.orderedTimeSlotList.removeElementAt(currentIndex);
            if (newIndex < currentIndex) {
                this.orderedTimeSlotList.insertElementAt(theSlot, newIndex);
            } else {
                this.orderedTimeSlotList.insertElementAt(theSlot, newIndex);
            }
            this.reindex();
        }
    }

    public void shift(long fromTime, long shift, TimeSlot lastFixedSlot, Vector otherFixedSlots) {
        TimeSlot slot;
        if (shift < 0L) {
            Enumeration en = this.elements();
            while (en.hasMoreElements()) {
                TimeSlot ts = (TimeSlot)en.nextElement();
                if (!ts.isTimeAligned() || ts.getTime() < fromTime || ts == lastFixedSlot) continue;
                ts.updateTime(ts.getTime() + shift);
            }
            return;
        }
        if (otherFixedSlots != null && otherFixedSlots.contains(lastFixedSlot)) {
            otherFixedSlots.remove(lastFixedSlot);
        }
        Vector<TimeSlot> slotsToShift = new Vector<TimeSlot>();
        Vector<TimeSlot> slotsToReorder = new Vector<TimeSlot>();
        Enumeration enum1 = this.elements();
        boolean startAdding = false;
        boolean pastFixedSlot = false;
        TimeSlot beforeSlot = null;
        while (enum1.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)enum1.nextElement();
            if (otherFixedSlots != null && otherFixedSlots.contains(ts)) continue;
            if (ts.isTimeAligned() && ts.getTime() >= fromTime) {
                startAdding = true;
            }
            if (!startAdding) continue;
            if (ts != lastFixedSlot) {
                slotsToShift.add(ts);
            } else {
                pastFixedSlot = true;
            }
            if (!pastFixedSlot) {
                slotsToReorder.add(ts);
                continue;
            }
            if (beforeSlot != null || ts == lastFixedSlot) continue;
            beforeSlot = ts;
        }
        TimeSlot afterSlot = lastFixedSlot;
        for (int k = 0; k < slotsToShift.size(); ++k) {
            slot = (TimeSlot)slotsToShift.elementAt(k);
            if (!slot.isTimeAligned()) continue;
            slot.updateTime(slot.getTime() + shift);
        }
        for (int i = 0; i < slotsToReorder.size(); ++i) {
            slot = (TimeSlot)slotsToReorder.elementAt(i);
            this.removeTimeSlot(slot);
            this.insertTimeSlot(slot, afterSlot, beforeSlot);
            afterSlot = slot;
        }
    }

    public void shiftAll(long shiftValue) throws IllegalArgumentException {
        long firstAlignedTime = 0L;
        for (TimeSlot slot : this.orderedTimeSlotList) {
            if (!slot.isTimeAligned()) continue;
            firstAlignedTime = slot.getTime();
            break;
        }
        if (shiftValue < 0L && -shiftValue > firstAlignedTime) {
            throw new IllegalArgumentException("The shift value should be greater than: " + firstAlignedTime + " otherwise slots would get a negative time value.");
        }
        for (TimeSlot slot : this.orderedTimeSlotList) {
            if (!slot.isTimeAligned()) continue;
            slot.updateTime(slot.getTime() + shiftValue);
        }
    }

    public void insertOrderedSlots(List slots) {
        if (slots == null) {
            return;
        }
        this.orderedTimeSlotList.addAll(slots);
        this.reindex();
    }
}

