/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.chat;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.chat.CHATEncoderInfo;

public class CHATEncoder
implements AnnotationDocEncoder {
    private static String BEGIN_LABEL = "@Begin";
    private static String END_LABEL = "@End";
    private static String LANGUAGE_LABEL = "@Languages:\t";
    private static String PARTICIPANTS_LABEL = "@Participants:\t";
    private static String ID_LABEL = "@ID:\t";
    private static String SOUND_LABEL = "%snd:";
    private static String VIDEO_LABEL = "%mov:";
    private static String LANG_LABEL = "%lan:";
    private final char BULLET = (char)21;
    private long lastAlignedBeginTime = 0L;
    private String[][] mainTierInfo;
    private String[][] dependentTierInfo;

    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) throws IOException {
        this.mainTierInfo = ((CHATEncoderInfo)encoderInfo).getMainTierInfo();
        this.dependentTierInfo = ((CHATEncoderInfo)encoderInfo).getDependentTierInfo();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
        out.write("@UTF8\n");
        out.write(BEGIN_LABEL + "\n");
        this.writeHeader(theTranscription, encoderInfo, out);
        this.writeBlocks(theTranscription, encoderInfo, out);
        out.write(END_LABEL + "\n");
        out.close();
    }

    private void writeHeader(Transcription theTranscription, EncoderInfo encoderInfo, OutputStreamWriter out) {
        try {
            int i;
            int i2;
            String langString = LANGUAGE_LABEL;
            HashSet<String> languages = new HashSet<String>();
            Vector tiers = theTranscription.getTiers();
            Locale loc = null;
            if (tiers != null) {
                for (i2 = 0; i2 < tiers.size(); ++i2) {
                    loc = ((TierImpl)tiers.elementAt(i2)).getDefaultLocale();
                    if (loc == null) continue;
                    languages.add(loc.getLanguage());
                }
            }
            for (i2 = 0; i2 < this.mainTierInfo[5].length; ++i2) {
                if (this.mainTierInfo[5][i2] == null || this.mainTierInfo[5][i2].length() <= 0) continue;
                languages.add(this.mainTierInfo[5][i2]);
            }
            int j = 0;
            Iterator langIter = languages.iterator();
            while (langIter.hasNext()) {
                if (j > 0) {
                    langString = langString + ", ";
                }
                langString = langString + (String)langIter.next();
                ++j;
            }
            if (langString != LANGUAGE_LABEL) {
                out.write(langString + "\n");
            }
            String participantsString = PARTICIPANTS_LABEL;
            for (i = 0; i < this.mainTierInfo[1].length; ++i) {
                if (this.mainTierInfo[1][i] == null) continue;
                if (i > 0) {
                    participantsString = participantsString + ", ";
                }
                participantsString = participantsString + this.mainTierInfo[1][i].substring(1);
                if (!this.mainTierInfo[2][i].equals("")) {
                    participantsString = participantsString + " " + this.mainTierInfo[2][i];
                }
                participantsString = !this.mainTierInfo[3][i].equals("") ? participantsString + " " + this.mainTierInfo[3][i] : participantsString + " Unidentified";
            }
            if (participantsString != PARTICIPANTS_LABEL) {
                out.write(participantsString + "\n");
            }
            for (i = 0; i < this.mainTierInfo[4].length; ++i) {
                String idString;
                if (this.mainTierInfo[4][i] == null) continue;
                if (!this.mainTierInfo[4][i].equals("")) {
                    idString = ID_LABEL + this.mainTierInfo[4][i];
                    out.write(idString + "\n");
                    continue;
                }
                idString = ID_LABEL + this.mainTierInfo[5][i] + "|" + this.mainTierInfo[1][i].substring(1) + "|||||" + "Unidentified" + "||";
                out.write(idString + "\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writeBlocks(Transcription theTranscription, EncoderInfo encoderInfo, OutputStreamWriter out) {
        Vector rootAnnotations = new Vector();
        try {
            Vector topTiers = ((TranscriptionImpl)theTranscription).getTopTiers();
            for (TierImpl t : topTiers) {
                Vector annots = t.getAnnotations();
                rootAnnotations.addAll(annots);
            }
            Collections.sort(rootAnnotations);
            for (Annotation ann : rootAnnotations) {
                String blockString = this.getBlock(theTranscription, encoderInfo, ann);
                out.write(blockString);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
    }

    private String getBlock(Transcription tr, EncoderInfo encoderInfo, Annotation ann) {
        boolean exportBlock = false;
        StringBuffer blockString = new StringBuffer("");
        String tierName = ann.getTier().getName();
        int tierIndex = -1;
        for (int i = 0; i < this.mainTierInfo[0].length; ++i) {
            if (this.mainTierInfo[0][i] == null || !this.mainTierInfo[0][i].equals(tierName)) continue;
            blockString.append(this.mainTierInfo[1][i] + ":\t" + ann.getValue().replaceAll("\t", "\n\t"));
            exportBlock = true;
            tierIndex = i;
            break;
        }
        if (!exportBlock) {
            return blockString.toString();
        }
        if (((AlignableAnnotation)ann).getBegin().isTimeAligned()) {
            this.lastAlignedBeginTime = ((AlignableAnnotation)ann).getBegin().getTime();
            if (((CHATEncoderInfo)encoderInfo).getCorrectAnnotationTimes()) {
                this.lastAlignedBeginTime += ((CHATEncoderInfo)encoderInfo).getMediaOffset();
            }
        }
        if (((AlignableAnnotation)ann).getEnd().isTimeAligned()) {
            long endTime = ann.getEndTimeBoundary();
            if (((CHATEncoderInfo)encoderInfo).getCorrectAnnotationTimes()) {
                endTime += ((CHATEncoderInfo)encoderInfo).getMediaOffset();
            }
            String mediaFileName = "";
            Vector mediaDescriptors = tr.getMediaDescriptors();
            String mediaLabel = SOUND_LABEL;
            if (mediaDescriptors != null && mediaDescriptors.size() > 0) {
                String mimeType;
                int index;
                mediaFileName = ((MediaDescriptor)mediaDescriptors.firstElement()).mediaURL;
                mediaFileName = mediaFileName.substring(mediaFileName.lastIndexOf("/") + 1);
                if (!((CHATEncoderInfo)encoderInfo).isTimesOnSeparateLine() && (index = mediaFileName.indexOf(46)) > 0) {
                    mediaFileName = mediaFileName.substring(0, index);
                }
                if ((mimeType = ((MediaDescriptor)mediaDescriptors.firstElement()).mimeType).startsWith("video")) {
                    mediaLabel = VIDEO_LABEL;
                }
                if (((CHATEncoderInfo)encoderInfo).isTimesOnSeparateLine()) {
                    blockString.append("\n\u0015" + mediaLabel + "\t" + "\"" + mediaFileName + "\" " + this.lastAlignedBeginTime + " " + endTime + '\u0015' + "\n");
                } else {
                    blockString.append(" \u0015" + mediaLabel + "\"" + mediaFileName + "\"" + "_" + this.lastAlignedBeginTime + "_" + endTime + '\u0015' + "\n");
                }
            }
        }
        if (((CHATEncoderInfo)encoderInfo).isIncludeLangLine() && tierIndex > -1 && this.mainTierInfo[5][tierIndex] != null && this.mainTierInfo[5][tierIndex].length() > 0) {
            blockString.append(LANG_LABEL + "\t$");
            blockString.append(this.mainTierInfo[5][tierIndex] + "\n");
        }
        Hashtable annotsPerTier = new Hashtable();
        Vector tierOrder = new Vector();
        this.getDependentLines(ann, tr, annotsPerTier, tierOrder);
        for (int i = 0; i < tierOrder.size(); ++i) {
            Tier t = (Tier)tierOrder.elementAt(i);
            Vector annots = (Vector)annotsPerTier.get(t);
            boolean exportTier = false;
            if (annots == null) continue;
            Collections.sort(annots);
            for (int j = 0; j < this.dependentTierInfo[0].length; ++j) {
                if (this.dependentTierInfo[0][j] == null || !this.dependentTierInfo[0][j].equals(t.getName())) continue;
                blockString.append(this.dependentTierInfo[1][j] + ":\t");
                exportTier = true;
                break;
            }
            if (!exportTier) continue;
            for (int k = 0; k < annots.size(); ++k) {
                if (k != 0) {
                    blockString.append(" ");
                }
                blockString.append(((Annotation)annots.elementAt(k)).getValue().replaceAll("\t", "\n\t"));
            }
            blockString.append("\n");
        }
        return blockString.toString();
    }

    private void getDependentLines(Annotation ann, Transcription tr, Hashtable annotsPerTier, Vector tierOrder) {
        Vector childAnnots = ((TranscriptionImpl)tr).getChildAnnotationsOf(ann);
        Vector<Annotation> annots = null;
        for (Annotation child : childAnnots) {
            annots = (Vector<Annotation>)annotsPerTier.get(child.getTier());
            if (annots == null) {
                annots = new Vector<Annotation>();
                annotsPerTier.put(child.getTier(), annots);
                tierOrder.add(child.getTier());
            }
            annots.add(child);
            this.getDependentLines(child, tr, annotsPerTier, tierOrder);
        }
    }
}

