/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.delimitedtext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVWrapped2EAF {
    private String filePath;
    private TranscriptionImpl trans;
    private String refLine = "Ikaan;";
    private final String delim = "\t";
    private final String delim2 = ";";
    private int phraseDur = 5000;
    Pattern pattern = Pattern.compile(";");

    public CSVWrapped2EAF(String filePath) {
        this.filePath = filePath;
        this.trans = new TranscriptionImpl();
        this.addTiers();
        this.parse();
    }

    private void parse() {
        try {
            String line;
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.filePath), "UTF-16");
            BufferedReader bufRead = new BufferedReader(fileReader);
            int numLines = 0;
            int blockIndex = 0;
            ArrayList<String> curLines = new ArrayList<String>(10);
            while ((line = bufRead.readLine()) != null) {
                if (line.length() <= 1) continue;
                if (++numLines == 1) {
                    int sind = line.indexOf(32);
                    int firstSC = line.indexOf("\t");
                    if (sind <= -1 || firstSC <= sind) continue;
                    String wavFile = line.substring(sind, firstSC).trim();
                    MediaDescriptor md = new MediaDescriptor(wavFile, "audio/x-wav");
                    md.relativeMediaURL = wavFile;
                    Vector<MediaDescriptor> mdc = new Vector<MediaDescriptor>(1);
                    mdc.add(md);
                    this.trans.setMediaDescriptors(mdc);
                    continue;
                }
                if ((line = line.replace("\t", ";")).startsWith(this.refLine)) {
                    if (curLines.size() > 0) {
                        this.convertCurLines(curLines, blockIndex);
                        ++blockIndex;
                        curLines.clear();
                    }
                    curLines.add(line);
                    continue;
                }
                curLines.add(line);
            }
            this.convertCurLines(curLines, ++blockIndex);
            String eafFile = this.filePath.substring(0, this.filePath.length() - 3) + "eaf";
            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(this.trans, null, new Vector(), eafFile, 0);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void convertCurLines(List<String> lines, int blockIndex) {
        if (lines == null || lines.size() == 0) {
            return;
        }
        ArrayList<String[]> lineArrs = new ArrayList<String[]>(lines.size());
        int maxNumSubs = 1;
        for (int i = 0; i < lines.size(); ++i) {
            String[] tokens = this.pattern.split(lines.get(i));
            int numtok = tokens.length;
            if (numtok > maxNumSubs && !tokens[0].equals("English translation") && !tokens[0].equals("Notes and comments")) {
                maxNumSubs = numtok;
            }
            if (tokens.length <= 0) continue;
            lineArrs.add(tokens);
        }
        if (maxNumSubs == 1) {
            return;
        }
        long bt = blockIndex * this.phraseDur;
        long perAnn = this.phraseDur / (maxNumSubs - 1);
        long et = bt + (long)this.phraseDur;
        et = bt + (long)(maxNumSubs - 1) * perAnn;
        String nm = "phrase";
        TierImpl topLevelTier = (TierImpl)this.trans.getTierWithId(nm);
        if (topLevelTier != null) {
            Annotation ann = topLevelTier.createAnnotation(bt, et);
            ann.setValue("" + blockIndex);
        }
        for (int i = 0; i < lineArrs.size(); ++i) {
            String[] curArr = (String[])lineArrs.get(i);
            nm = curArr[0];
            TierImpl curTier = (TierImpl)this.trans.getTierWithId(nm);
            if (curTier == null) continue;
            if (curTier.getParentTier() == topLevelTier) {
                if (curTier.getName().equals("Ikaan")) {
                    int j;
                    Annotation prevAnn = null;
                    Annotation nextAnn = null;
                    for (j = 1; j < curArr.length; ++j) {
                        if (j == 1) {
                            prevAnn = curTier.createAnnotation((bt + et) / 2L, (bt + et) / 2L);
                            prevAnn.setValue(curArr[j].trim());
                            continue;
                        }
                        nextAnn = curTier.createAnnotationAfter(prevAnn);
                        nextAnn.setValue(curArr[j].trim());
                        prevAnn = nextAnn;
                    }
                    if (curArr.length >= maxNumSubs) continue;
                    for (j = curArr.length; j < maxNumSubs; ++j) {
                        prevAnn = nextAnn = curTier.createAnnotationAfter(prevAnn);
                    }
                    continue;
                }
                if (curArr.length <= 1) continue;
                Annotation ann = curTier.createAnnotation((bt + et) / 2L, (bt + et) / 2L);
                ann.setValue(curArr[1].trim());
                if (curArr.length <= 2) continue;
                for (int j = 2; j < curArr.length; ++j) {
                    ann.setValue(ann.getValue() + " " + curArr[j]);
                }
                continue;
            }
            if (curArr.length == 1) continue;
            long step = this.phraseDur / (maxNumSubs - 1);
            for (int j = 1; j < curArr.length; ++j) {
                long time = bt + step / 2L + step * (long)(j - 1);
                Annotation ann = curTier.createAnnotation(time, time);
                if (ann == null) {
                    System.out.println("null");
                    Annotation exAnn = curTier.getAnnotationAtTime(time);
                    System.out.println(exAnn.getBeginTimeBoundary() + "-" + exAnn.getEndTimeBoundary());
                }
                ann.setValue(curArr[j].trim());
            }
        }
    }

    private void addTiers() {
        String name = "phrase";
        LinguisticType lt = new LinguisticType(name);
        lt.setTimeAlignable(true);
        this.trans.addLinguisticType(lt);
        TierImpl t = new TierImpl(name, "", this.trans, lt);
        this.trans.addTier(t);
        TierImpl topLevelTier = t;
        name = "Ikaan";
        lt = new LinguisticType(name);
        lt.setTimeAlignable(false);
        lt.addConstraint(new SymbolicSubdivision());
        this.trans.addLinguisticType(lt);
        TierImpl ikaTier = new TierImpl(name, "", this.trans, lt);
        ikaTier.setParentTier(topLevelTier);
        this.trans.addTier(ikaTier);
        lt = new LinguisticType("association");
        lt.setTimeAlignable(false);
        lt.addConstraint(new SymbolicAssociation());
        this.trans.addLinguisticType(lt);
        name = "Ikaan words";
        t = new TierImpl(name, "", this.trans, lt);
        t.setParentTier(ikaTier);
        this.trans.addTier(t);
        name = "Corrections";
        t = new TierImpl(name, "", this.trans, lt);
        t.setParentTier(ikaTier);
        this.trans.addTier(t);
        name = "Crude translation";
        t = new TierImpl(name, "", this.trans, lt);
        t.setParentTier(ikaTier);
        this.trans.addTier(t);
        name = "English translation";
        t = new TierImpl(name, "", this.trans, lt);
        t.setParentTier(topLevelTier);
        this.trans.addTier(t);
        name = "Notes and comments";
        t = new TierImpl(name, "", this.trans, lt);
        t.setParentTier(topLevelTier);
        this.trans.addTier(t);
    }

    public static void main(String[] args) {
        CSVWrapped2EAF csv2eaf = null;
        if (args != null && args.length > 0) {
            try {
                File dir = new File(args[0]);
                File[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith(".txt")) continue;
                    csv2eaf = new CSVWrapped2EAF(files[i].getAbsolutePath());
                    System.out.println("Processed: " + files[i].getAbsolutePath());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

