/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAF {
    public static final String TIME_UNIT_MILLISEC = "milliseconds";
    public static final String TIME_UNIT_NTSC = "NTSC-frames";
    public static final String TIME_UNIT_PAL = "PAL-frames";
    private Document doc;

    public final Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    public final Node appendChild(Node e) {
        return this.doc.appendChild(e);
    }

    public final Element newAnnotationDocument(String creationDate, String author, String version) {
        if (creationDate == null) {
            throw new RuntimeException("DAF");
        }
        if (author == null) {
            throw new RuntimeException("DAF");
        }
        if (version == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("ANNOTATION_DOCUMENT");
        result.setAttribute("DATE", creationDate);
        result.setAttribute("AUTHOR", author);
        result.setAttribute("VERSION", version);
        result.setAttribute("FORMAT", "1.0");
        return result;
    }

    public final Element newHeader(String mediaFile, String timeUnits) {
        if (mediaFile == null) {
            throw new RuntimeException("DAF");
        }
        if (timeUnits == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("HEADER");
        result.setAttribute("MEDIA_FILE", mediaFile);
        result.setAttribute("TIME_UNITS", timeUnits);
        return result;
    }

    public final Element newHeader(String mediaFile) {
        if (mediaFile == null) {
            throw new RuntimeException("DAF");
        }
        return this.newHeader(mediaFile, TIME_UNIT_MILLISEC);
    }

    public final Element newTimeOrder() {
        Element result = this.doc.createElement("TIME_ORDER");
        return result;
    }

    public final Element newTimeSlot(String id, long time) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        result.setAttribute("TIME_VALUE", time + "");
        return result;
    }

    public final Element newTimeSlot(String id) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        return result;
    }

    public final Element newTier(String id, String participant, String typeRef, Locale language, String parent) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        if (typeRef == null) {
            throw new RuntimeException("DAF");
        }
        if (language == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("TIER");
        result.setAttribute("TIER_ID", id);
        if (participant != null) {
            result.setAttribute("PARTICIPANT", participant);
        }
        result.setAttribute("LINGUISTIC_TYPE_REF", typeRef);
        result.setAttribute("DEFAULT_LOCALE", language.getLanguage());
        if (parent != null) {
            result.setAttribute("PARENT_REF", parent);
        }
        return result;
    }

    public final Element newAnnotation() {
        Element result = this.doc.createElement("ANNOTATION");
        return result;
    }

    public final Element newAlignableAnnotation(String id, String beginTimeSlot, String endTimeSlot) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("ALIGNABLE_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("TIME_SLOT_REF1", beginTimeSlot);
        result.setAttribute("TIME_SLOT_REF2", endTimeSlot);
        return result;
    }

    public final Element newRefAnnotation(String id, String annotationRef) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        if (annotationRef == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("REF_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("ANNOTATION_REF", annotationRef);
        return result;
    }

    public final Element newAnnotationValue(String value) {
        if (value == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("ANNOTATION_VALUE");
        result.appendChild(this.doc.createTextNode(value));
        return result;
    }

    public final Element newLinguisticType(String id) {
        if (id == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("LINGUISTIC_TYPE");
        result.setAttribute("LINGUISTIC_TYPE_ID", id);
        return result;
    }

    public final Element newLocale(Locale l) {
        if (l == null) {
            throw new RuntimeException("DAF");
        }
        Element result = this.doc.createElement("LOCALE");
        result.setAttribute("LANGUAGE_CODE", l.getLanguage());
        if (!l.getCountry().equals("")) {
            result.setAttribute("COUNTRY_CODE", l.getCountry());
        }
        if (!l.getVariant().equals("")) {
            result.setAttribute("VARIANT", l.getVariant());
        }
        return result;
    }

    public DAF() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
    }

    public DAF(boolean test) throws Exception {
        this();
        Element e = this.newAnnotationDocument(new Date() + "", "gregor", "version 1.0");
        this.appendChild(e);
        System.out.println("" + this.getDocumentElement());
    }

    public static void main(String[] a) throws Exception {
        new DAF(true);
    }
}

