/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TimeSlotImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.DAF;
import mpi.eudico.server.corpora.clomimpl.dobes.DAFParser;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAFTranscriptionStore
implements TranscriptionStore {
    private final File fileToWriteXMLinto = null;

    public PrintWriter addPrintln(File f) {
        try {
            FileWriter fileWriter1 = new FileWriter(f);
            return new PrintWriter((Writer)fileWriter1, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String pathName, int format) {
    }

    public void storeTranscription(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, int format) {
        String txt;
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, String> timeSlotIds = new Hashtable<TimeSlot, String>();
        Hashtable<Annotation, String> annotationIds = new Hashtable<Annotation, String>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            System.out.println("[[ASSERTION FAILED]] DAFTranscriptionStore/storeTranscription: theTranscription is null");
        }
        DAF dafFactory = null;
        try {
            dafFactory = new DAF();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm z");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        String version = "1.0";
        Element annotDocument = dafFactory.newAnnotationDocument(dateString, author, version);
        dafFactory.appendChild(annotDocument);
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = dafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Enumeration tsElements = timeOrder.elements();
        while (tsElements.hasMoreElements()) {
            TimeSlot ts = (TimeSlot)tsElements.nextElement();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? dafFactory.newTimeSlot(tsId, ts.getTime()) : dafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        Vector tiers = attisTr.getTiers();
        Vector<Tier> storeOrder = new Vector<Tier>(tierOrder);
        for (Tier t : tiers) {
            if (storeOrder.contains(t)) continue;
            storeOrder.add(t);
        }
        int annIndex = 1;
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String string = tierImpl.getName();
            String participant = (String)tierImpl.getMetadataValue("PARTICIPANT");
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = (Locale)tierImpl.getMetadataValue("DEFAULT_LOCALE")) == null) {
                lang = new Locale("not specified", "", "");
            }
            if (!usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            Element tierElement = dafFactory.newTier(string, participant, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                annotationIds.put(ann, "a" + annIndex);
                ++annIndex;
            }
        }
        for (TierImpl tierImpl : storeOrder) {
            Vector annotations = tierImpl.getAnnotations();
            for (Annotation ann : annotations) {
                Element annElement = dafFactory.newAnnotation();
                ((Element)tierElements.get(tierImpl.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(ann);
                if (ann instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)ann).getEnd());
                    annSubElement = dafFactory.newAlignableAnnotation(annId, beginTsId, endTsId);
                } else if (ann instanceof RefAnnotation) {
                    String refId = null;
                    Vector refs = ((RefAnnotation)ann).getReferences();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get((Annotation)refs.firstElement());
                    }
                    annSubElement = dafFactory.newRefAnnotation(annId, refId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = dafFactory.newAnnotationValue(ann.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        Vector vector = attisTr.getLinguisticTypes();
        if (vector != null) {
            for (LinguisticType lt : vector) {
                Element typeElement = dafFactory.newLinguisticType(lt.getLinguisticTypeName());
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = dafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        if (this.fileToWriteXMLinto != null) {
            System.out.println(this.fileToWriteXMLinto.getAbsolutePath() + " <----XML output SAVE AS!\n");
            PrintWriter printWriter1 = this.addPrintln(this.fileToWriteXMLinto);
            if (printWriter1 == null) {
                txt = "Sorry: unable to save this file.";
                JOptionPane.showMessageDialog(null, txt, txt, 0);
            } else {
                printWriter1.println(dafFactory.getDocumentElement());
            }
        } else {
            System.out.println(attisTr.getPathName() + " <----XML output!\n");
            try {
                if (("" + dafFactory.getDocumentElement()).length() == 0) {
                    String txt2 = "Sorry: unable to save this file (zero length).";
                    JOptionPane.showMessageDialog(null, txt2, txt2, 0);
                    return;
                }
                String filecontentToBeWritten = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE ANNOTATION_DOCUMENT>" + dafFactory.getDocumentElement();
                IoUtil.writeEncodedFile("UTF-8", attisTr.getPathName(), dafFactory.getDocumentElement());
                JOptionPane.showMessageDialog(null, "Your file has been written to " + attisTr.getPathName());
            }
            catch (Exception eee) {
                txt = "Sorry: unable to save this file. (" + eee.getMessage() + ")";
                JOptionPane.showMessageDialog(null, txt, txt, 0);
            }
        }
    }

    public void loadTranscription(Transcription theTranscription) {
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        String mediaFileName = DAFParser.Instance().getMediaFile(attisTr.getPathName());
        if (mediaFileName.startsWith("file:")) {
            mediaFileName = mediaFileName.substring(5);
        }
        attisTr.setMainMediaFile(mediaFileName);
        String author = DAFParser.Instance().getAuthor(attisTr.getPathName());
        if (attisTr.getAuthor().equals("")) {
            attisTr.setAuthor(author);
        }
        Vector linguisticTypes = DAFParser.Instance().getLinguisticTypes(attisTr.getPathName());
        attisTr.setLinguisticTypes(linguisticTypes);
        TimeOrder timeOrder = attisTr.getTimeOrder();
        Vector order = DAFParser.Instance().getTimeOrder(attisTr.getPathName());
        Hashtable slots = DAFParser.Instance().getTimeSlots(attisTr.getPathName());
        Hashtable<String, TimeSlotImpl> timeSlothash = new Hashtable<String, TimeSlotImpl>();
        Iterator orderedIter = order.iterator();
        while (orderedIter.hasNext()) {
            TimeSlotImpl ts = null;
            String key = (String)orderedIter.next();
            long time = Long.parseLong((String)slots.get(key));
            ts = time != -1L ? new TimeSlotImpl(time, timeOrder) : new TimeSlotImpl(timeOrder);
            timeOrder.insertTimeSlot(ts);
            timeSlothash.put(key, ts);
        }
        Hashtable<TierImpl, String> parentHash = new Hashtable<TierImpl, String>();
        if (!attisTr.isLoaded()) {
            for (String tierName : DAFParser.Instance().getTierNames(attisTr.getPathName())) {
                TierImpl tier = new TierImpl(null, tierName, null, attisTr, null);
                String participant = DAFParser.Instance().getParticipantOf(tierName, attisTr.getPathName());
                LinguisticType linguisticType = DAFParser.Instance().getLinguisticTypeOf(tierName, attisTr.getPathName());
                Locale defaultLanguage = DAFParser.Instance().getDefaultLanguageOf(tierName, attisTr.getPathName());
                tier.setMetadata("PARTICIPANT", participant);
                tier.setLinguisticType(linguisticType);
                tier.setMetadata("DEFAULT_LOCALE", defaultLanguage);
                String parentId = DAFParser.Instance().getParentNameOf(tierName, attisTr.getPathName());
                if (parentId != null) {
                    parentHash.put(tier, parentId);
                }
                attisTr.addTier(tier);
            }
        }
        for (TierImpl t : parentHash.keySet()) {
            t.setParentTier(attisTr.getTierWithId((String)parentHash.get(t)));
        }
        attisTr.setLoaded(true);
        Vector tiers = attisTr.getTiers();
        Hashtable<String, Annotation> idToAnnotation = new Hashtable<String, Annotation>();
        Hashtable<String, String> references = new Hashtable<String, String>();
        Hashtable<String, String> referenceChains = new Hashtable<String, String>();
        Hashtable tempAnnotationsForTiers = new Hashtable();
        for (Tier tier : tiers) {
            Vector annotationRecords = DAFParser.Instance().getAnnotationsOf(tier.getName(), attisTr.getPathName());
            Vector<Annotation> tempAnnotations = new Vector<Annotation>();
            Iterator it1 = annotationRecords.iterator();
            while (it1.hasNext()) {
                Annotation annotation = null;
                Vector annotationRecord = (Vector)it1.next();
                Iterator it2 = annotationRecord.iterator();
                int index = 0;
                String id = null;
                String annotType = null;
                String timeSlotId1 = null;
                String timeSlotId2 = null;
                String annotRefId = null;
                String annotValue = null;
                String prevRefId = null;
                while (it2.hasNext()) {
                    if (index == 0) {
                        id = (String)it2.next();
                    } else if (index == 1) {
                        annotType = (String)it2.next();
                    } else if (index == 2) {
                        if (annotType.equals("alignable")) {
                            timeSlotId1 = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            annotRefId = (String)it2.next();
                        }
                    } else if (index == 3) {
                        if (annotType.equals("alignable")) {
                            timeSlotId2 = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            prevRefId = (String)it2.next();
                        }
                    } else if (index == 4) {
                        if (annotType.equals("alignable")) {
                            annotValue = (String)it2.next();
                        } else if (annotType.equals("reference")) {
                            annotValue = (String)it2.next();
                        }
                    }
                    ++index;
                }
                if (annotType.equals("alignable")) {
                    annotation = new AlignableAnnotation((TimeSlot)timeSlothash.get(timeSlotId1), (TimeSlot)timeSlothash.get(timeSlotId2), tier);
                } else if (annotType.equals("reference")) {
                    annotation = new RefAnnotation(null, tier);
                    references.put(id, annotRefId);
                    if (!prevRefId.equals("")) {
                        referenceChains.put(id, prevRefId);
                    }
                }
                if (annotValue != null) {
                    annotation.setValue(annotValue);
                }
                idToAnnotation.put(id, annotation);
                tempAnnotations.add(annotation);
            }
            tempAnnotationsForTiers.put(tier, tempAnnotations);
        }
        for (String key : references.keySet()) {
            Annotation referedAnnotation = (Annotation)idToAnnotation.get(references.get(key));
            RefAnnotation refAnnotation = (RefAnnotation)idToAnnotation.get(key);
            refAnnotation.addReference(referedAnnotation);
        }
        for (String key : referenceChains.keySet()) {
            RefAnnotation previous = (RefAnnotation)idToAnnotation.get(referenceChains.get(key));
            RefAnnotation a = (RefAnnotation)idToAnnotation.get(key);
            if (previous == null) continue;
            previous.setNext(a);
        }
        for (TierImpl t : tempAnnotationsForTiers.keySet()) {
            Vector annots = (Vector)tempAnnotationsForTiers.get(t);
            Iterator aIter = annots.iterator();
            while (aIter.hasNext()) {
                t.insertAnnotation((Annotation)aIter.next());
            }
        }
        for (TierImpl t : tiers) {
            if (!t.isTimeAlignable() || !t.hasParentTier()) continue;
            for (Annotation a : t.getAnnotations()) {
                if (!(a instanceof AlignableAnnotation)) continue;
                ((AlignableAnnotation)a).registerWithParent();
            }
        }
    }

    public void loadTranscription(Transcription theTranscription, DecoderInfo decoderInfo) {
        this.loadTranscription(theTranscription);
    }

    public void storeTranscriptionAsTemplateIn(Transcription theTranscription, List tierOrder, String path) throws IOException {
    }

    public void storeTranscriptionIn(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path, int format) throws IOException {
        this.storeTranscription(theTranscription, encoderInfo, tierOrder, format);
    }
}

