/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class EAF20Parser {
    private static boolean verbose = false;
    private static EAF20Parser parser;
    private final SAXParser saxParser;
    private final Hashtable tiers = new Hashtable();
    private final Vector tierNames = new Vector();
    private final Hashtable tierAttributes = new Hashtable();
    private final Vector linguisticTypes = new Vector();
    private final Vector locales = new Vector();
    private final Hashtable timeSlots = new Hashtable();
    private final Vector timeOrder = new Vector();
    private String mediaFile;
    private String svgFile;
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private boolean parseError;

    private EAF20Parser() {
        this.saxParser = new SAXParser();
        try {
            this.saxParser.setFeature("http://xml.org/sax/features/validation", true);
            this.saxParser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            this.saxParser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)"http://www.mpi.nl/tools/elan/EAFv2.0.xsd");
            this.saxParser.setContentHandler((ContentHandler)new EAFContentHandler());
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public static EAF20Parser Instance() {
        if (parser == null) {
            parser = new EAF20Parser();
        }
        return parser;
    }

    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    public String getSVGFile(String fileName) {
        this.parse(fileName);
        return this.svgFile;
    }

    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    public Vector getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    public Vector getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    public Hashtable getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    public Vector getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        String part = "";
        if (((Hashtable)this.tierAttributes.get(tierName)).get("PARTICIPANT") != null) {
            part = (String)((Hashtable)this.tierAttributes.get(tierName)).get("PARTICIPANT");
        }
        return part;
    }

    public LinguisticType getLinguisticTypeOf(String tierName, String fileName) {
        LinguisticType lt = null;
        this.parse(fileName);
        String lType = "";
        if (((Hashtable)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF") != null) {
            lType = (String)((Hashtable)this.tierAttributes.get(tierName)).get("LINGUISTIC_TYPE_REF");
        }
        for (LinguisticType l : this.linguisticTypes) {
            if (!l.getLinguisticTypeName().equals(lType)) continue;
            lt = l;
            break;
        }
        return lt;
    }

    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = (String)((Hashtable)this.tierAttributes.get(tierName)).get("DEFAULT_LOCALE");
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return (String)((Hashtable)this.tierAttributes.get(tierName)).get("PARENT_REF");
    }

    public Vector getAnnotationsOf(String tierName, String fileName) {
        if (!this.lastParsed.equals(fileName)) {
            this.parse(fileName);
        }
        long start = System.currentTimeMillis();
        Vector annotationVector = new Vector();
        Hashtable annotations = (Hashtable)this.tiers.get(tierName);
        Iterator iter = annotations.keySet().iterator();
        while (iter.hasNext()) {
            Vector annotationRecord = new Vector();
            Object key = iter.next();
            annotationRecord.add(key);
            annotationRecord.addAll((Vector)annotations.get(key));
            annotationVector.add(annotationRecord);
        }
        long duration = System.currentTimeMillis() - start;
        return annotationVector;
    }

    private void parse(String fileName) {
        long start = System.currentTimeMillis();
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.tierAttributes.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            this.saxParser.parse(fileName);
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
        }
        long duration = System.currentTimeMillis() - start;
    }

    private void println(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
        System.out.println("Tier id " + this.currentTierId);
        System.out.println("Annotation id " + this.currentAnnotationId);
    }

    class EAFContentHandler
    implements ContentHandler {
        private Locator locator;

        EAFContentHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void startDocument() throws SAXException {
            EAF20Parser.this.parseError = false;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF20Parser.this.content = "";
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF20Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF20Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
                EAF20Parser.this.svgFile = attributes.getValue("SVG_FILE");
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF20Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF20Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF20Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF20Parser.this.tiers.containsKey(EAF20Parser.this.currentTierId)) {
                        EAF20Parser.this.tiers.put(EAF20Parser.this.currentTierId, new Hashtable());
                        EAF20Parser.this.tierAttributes.put(EAF20Parser.this.currentTierId, new Hashtable());
                        EAF20Parser.this.tierNames.add(EAF20Parser.this.currentTierId);
                    }
                    Hashtable attrHash = (Hashtable)EAF20Parser.this.tierAttributes.get(EAF20Parser.this.currentTierId);
                    if (attributes.getValue("PARTICIPANT") != null) {
                        attrHash.put("PARTICIPANT", attributes.getValue("PARTICIPANT"));
                    }
                    attrHash.put("LINGUISTIC_TYPE_REF", attributes.getValue("LINGUISTIC_TYPE_REF"));
                    if (attributes.getValue("DEFAULT_LOCALE") != null) {
                        attrHash.put("DEFAULT_LOCALE", attributes.getValue("DEFAULT_LOCALE"));
                    } else {
                        attrHash.put("DEFAULT_LOCALE", "en");
                    }
                    if (attributes.getValue("PARENT_REF") != null) {
                        attrHash.put("PARENT_REF", attributes.getValue("PARENT_REF"));
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF20Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    ((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).put(EAF20Parser.this.currentAnnotationId, new Vector());
                    String svg_ref = attributes.getValue("SVG_REF");
                    ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(svg_ref == null ? "alignable" : "alignable_svg");
                    ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF1"));
                    ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(attributes.getValue("TIME_SLOT_REF2"));
                    if (svg_ref != null) {
                        ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(svg_ref);
                    }
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF20Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    ((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).put(EAF20Parser.this.currentAnnotationId, new Vector());
                    ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add("reference");
                    ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add("");
                    }
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LinguisticType lt = new LinguisticType(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    boolean timeAlignable = true;
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = false;
                    }
                    lt.setTimeAlignable(timeAlignable);
                    boolean graphicReferences = false;
                    if (attributes.getValue("GRAPHIC_REFERENCES") != null && attributes.getValue("GRAPHIC_REFERENCES").equals("true")) {
                        graphicReferences = true;
                    }
                    lt.setGraphicReferences(graphicReferences);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ConstraintImpl c = null;
                    if (stereotype != null) {
                        if ((stereotype = stereotype.replace('_', ' ')).equals(Constraint.stereoTypes[0])) {
                            c = new TimeSubdivision();
                        } else if (stereotype.equals(Constraint.stereoTypes[3])) {
                            c = new SymbolicSubdivision();
                        } else if (stereotype.equals(Constraint.stereoTypes[4])) {
                            c = new SymbolicAssociation();
                        }
                    }
                    if (c != null) {
                        lt.addConstraint(c);
                    }
                    EAF20Parser.this.linguisticTypes.add(lt);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF20Parser.this.locales.add(l);
                }
            }
        }

        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("ANNOTATION_VALUE")) {
                ((Vector)((Hashtable)EAF20Parser.this.tiers.get(EAF20Parser.this.currentTierId)).get(EAF20Parser.this.currentAnnotationId)).add(EAF20Parser.this.content);
            }
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF20Parser.this.content = EAF20Parser.this.content + new String(ch, start, end);
        }
    }
}

