/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.util.Date;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF22 {
    public static final String TIME_UNIT_MILLISEC = "milliseconds";
    public static final String TIME_UNIT_NTSC = "NTSC-frames";
    public static final String TIME_UNIT_PAL = "PAL-frames";
    private Document doc;

    public final Element getDocumentElement() {
        return this.doc.getDocumentElement();
    }

    public final Node appendChild(Node e) {
        return this.doc.appendChild(e);
    }

    public final Element newAnnotationDocument(String creationDate, String author, String version) {
        if (creationDate == null) {
            throw new RuntimeException("EAF");
        }
        if (author == null) {
            throw new RuntimeException("EAF");
        }
        if (version == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_DOCUMENT");
        result.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        result.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.mpi.nl/tools/elan/EAFv2.2.xsd");
        result.setAttribute("DATE", creationDate);
        result.setAttribute("AUTHOR", author);
        result.setAttribute("VERSION", version);
        result.setAttribute("FORMAT", "2.2");
        return result;
    }

    public final Element newHeader(String mediaFile, String timeUnits) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        if (timeUnits == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("HEADER");
        result.setAttribute("MEDIA_FILE", mediaFile);
        result.setAttribute("TIME_UNITS", timeUnits);
        return result;
    }

    public final Element newHeader(String mediaFile) {
        if (mediaFile == null) {
            throw new RuntimeException("EAF");
        }
        return this.newHeader(mediaFile, TIME_UNIT_MILLISEC);
    }

    public final Element newMediaDescriptor(String mediaURL, String mimeType, String timeOrigin, String extractedFrom) {
        if (mediaURL == null) {
            throw new RuntimeException("EAF");
        }
        if (mimeType == null) {
            throw new RuntimeException("EAF");
        }
        Element mdElement = this.doc.createElement("MEDIA_DESCRIPTOR");
        mdElement.setAttribute("MEDIA_URL", mediaURL);
        mdElement.setAttribute("MIME_TYPE", mimeType);
        if (timeOrigin != null) {
            mdElement.setAttribute("TIME_ORIGIN", String.valueOf(timeOrigin));
        }
        if (extractedFrom != null) {
            mdElement.setAttribute("EXTRACTED_FROM", extractedFrom);
        }
        return mdElement;
    }

    public final Element newTimeOrder() {
        Element result = this.doc.createElement("TIME_ORDER");
        return result;
    }

    public final Element newTimeSlot(String id, long time) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        result.setAttribute("TIME_VALUE", time + "");
        return result;
    }

    public final Element newTimeSlot(String id) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIME_SLOT");
        result.setAttribute("TIME_SLOT_ID", id);
        return result;
    }

    public final Element newTier(String id, String participant, String typeRef, Locale language, String parent) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (typeRef == null) {
            throw new RuntimeException("EAF");
        }
        if (language == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("TIER");
        result.setAttribute("TIER_ID", id);
        if (participant != null) {
            result.setAttribute("PARTICIPANT", participant);
        }
        result.setAttribute("LINGUISTIC_TYPE_REF", typeRef);
        result.setAttribute("DEFAULT_LOCALE", language.getLanguage());
        if (parent != null) {
            result.setAttribute("PARENT_REF", parent);
        }
        return result;
    }

    public final Element newAnnotation() {
        Element result = this.doc.createElement("ANNOTATION");
        return result;
    }

    public final Element newAlignableAnnotation(String id, String beginTimeSlot, String endTimeSlot, String svgId) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ALIGNABLE_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("TIME_SLOT_REF1", beginTimeSlot);
        result.setAttribute("TIME_SLOT_REF2", endTimeSlot);
        if (svgId != null) {
            result.setAttribute("SVG_REF", svgId);
        }
        return result;
    }

    public final Element newRefAnnotation(String id, String annotationRef, String previousAnnotation) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        if (annotationRef == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("REF_ANNOTATION");
        result.setAttribute("ANNOTATION_ID", id);
        result.setAttribute("ANNOTATION_REF", annotationRef);
        if (previousAnnotation != null) {
            result.setAttribute("PREVIOUS_ANNOTATION", previousAnnotation);
        }
        return result;
    }

    public final Element newAnnotationValue(String value) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("ANNOTATION_VALUE");
        result.appendChild(this.doc.createTextNode(value));
        return result;
    }

    public final Element newLinguisticType(String id, boolean timeAlignable, boolean graphicReferences, String constraint, String controlledVocabularyName) {
        if (id == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LINGUISTIC_TYPE");
        result.setAttribute("LINGUISTIC_TYPE_ID", id);
        result.setAttribute("TIME_ALIGNABLE", timeAlignable ? "true" : "false");
        result.setAttribute("GRAPHIC_REFERENCES", graphicReferences ? "true" : "false");
        if (constraint != null) {
            result.setAttribute("CONSTRAINTS", constraint);
        }
        if (controlledVocabularyName != null) {
            result.setAttribute("CONTROLLED_VOCABULARY_REF", controlledVocabularyName);
        }
        return result;
    }

    public final Element newConstraint(String stereotype, String description) {
        if (stereotype == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONSTRAINT");
        result.setAttribute("STEREOTYPE", stereotype);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public final Element newLocale(Locale l) {
        if (l == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LOCALE");
        result.setAttribute("LANGUAGE_CODE", l.getLanguage());
        if (!l.getCountry().equals("")) {
            result.setAttribute("COUNTRY_CODE", l.getCountry());
        }
        if (!l.getVariant().equals("")) {
            result.setAttribute("VARIANT", l.getVariant());
        }
        return result;
    }

    public final Element newControlledVocabulary(String conVocId, String description) {
        if (conVocId == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CONTROLLED_VOCABULARY");
        result.setAttribute("CV_ID", conVocId);
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public final Element newCVEntry(String value, String description) {
        if (value == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("CV_ENTRY");
        result.appendChild(this.doc.createTextNode(value));
        if (description != null) {
            result.setAttribute("DESCRIPTION", description);
        }
        return result;
    }

    public EAF22() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
    }

    public EAF22(boolean test) throws Exception {
        this();
        Element e = this.newAnnotationDocument(new Date() + "", "gregor", "version 2.2");
        this.appendChild(e);
        System.out.println("" + this.getDocumentElement());
    }

    public static void main(String[] a) throws Exception {
        new EAF22(true);
    }
}

